"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNewSsoOidcToken = void 0;
const dist_node_1 = require("./client-sso-oidc-bundle/dist-node");
const getSsoOidcClient_1 = require("./getSsoOidcClient");
const getNewSsoOidcToken = (ssoToken, ssoRegion) => {
    const ssoOidcClient = (0, getSsoOidcClient_1.getSsoOidcClient)(ssoRegion);
    return ssoOidcClient.send(new dist_node_1.CreateTokenCommand({
        clientId: ssoToken.clientId,
        clientSecret: ssoToken.clientSecret,
        refreshToken: ssoToken.refreshToken,
        grantType: "refresh_token",
    }));
};
exports.getNewSsoOidcToken = getNewSsoOidcToken;
