"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSsoOidcClient = void 0;
const dist_node_1 = require("./client-sso-oidc-bundle/dist-node");
const ssoOidcClientsHash = {};
const getSsoOidcClient = (ssoRegion) => {
    if (ssoOidcClientsHash[ssoRegion]) {
        return ssoOidcClientsHash[ssoRegion];
    }
    const ssoOidcClient = new dist_node_1.SSOOIDCClient({ region: ssoRegion });
    ssoOidcClientsHash[ssoRegion] = ssoOidcClient;
    return ssoOidcClient;
};
exports.getSsoOidcClient = getSsoOidcClient;
