import { ChecksumConstructor } from "../checksum";
import { HashConstructor } from "../crypto";
/**
 * @internal
 */
export declare enum AlgorithmId {
    MD5 = "md5",
    CRC32 = "crc32",
    CRC32C = "crc32c",
    SHA1 = "sha1",
    SHA256 = "sha256"
}
/**
 * @internal
 */
export interface ChecksumAlgorithm {
    algorithmId(): AlgorithmId;
    checksumConstructor(): ChecksumConstructor | HashConstructor;
}
export interface ChecksumConfiguration {
    addChecksumAlgorithm(algo: ChecksumAlgorithm): void;
    checksumAlgorithms(): ChecksumAlgorithm[];
    [other: string | number | symbol]: any;
}
type GetChecksumConfigurationType = (runtimeConfig: Partial<{
    sha256: ChecksumConstructor | HashConstructor;
    md5: ChecksumConstructor | HashConstructor;
}>) => ChecksumConfiguration;
/**
 * @internal
 */
export declare const getChecksumConfiguration: GetChecksumConfigurationType;
type ResolveChecksumRuntimeConfigType = (clientConfig: ChecksumConfiguration) => any;
/**
 * @internal
 */
export declare const resolveChecksumRuntimeConfig: ResolveChecksumRuntimeConfigType;
export {};
