# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'AlertChannelConfigArgs',
    'AlertConditionTermArgs',
    'AlertMutingRuleConditionArgs',
    'AlertMutingRuleConditionConditionArgs',
    'DashboardFilterArgs',
    'DashboardWidgetArgs',
    'DashboardWidgetCompareWithArgs',
    'DashboardWidgetCompareWithPresentationArgs',
    'DashboardWidgetMetricArgs',
    'EntityTagsTagArgs',
    'InfraAlertConditionCriticalArgs',
    'InfraAlertConditionWarningArgs',
    'NrqlAlertConditionCriticalArgs',
    'NrqlAlertConditionNrqlArgs',
    'NrqlAlertConditionTermArgs',
    'NrqlAlertConditionWarningArgs',
    'OneDashboardPageArgs',
    'OneDashboardPageWidgetAreaArgs',
    'OneDashboardPageWidgetAreaNrqlQueryArgs',
    'OneDashboardPageWidgetBarArgs',
    'OneDashboardPageWidgetBarNrqlQueryArgs',
    'OneDashboardPageWidgetBillboardArgs',
    'OneDashboardPageWidgetBillboardNrqlQueryArgs',
    'OneDashboardPageWidgetLineArgs',
    'OneDashboardPageWidgetLineNrqlQueryArgs',
    'OneDashboardPageWidgetMarkdownArgs',
    'OneDashboardPageWidgetPyArgs',
    'OneDashboardPageWidgetPyNrqlQueryArgs',
    'OneDashboardPageWidgetTableArgs',
    'OneDashboardPageWidgetTableNrqlQueryArgs',
    'GetEntityTagArgs',
]

@pulumi.input_type
class AlertChannelConfigArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[str]] = None,
                 auth_password: Optional[pulumi.Input[str]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 auth_username: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 headers_string: Optional[pulumi.Input[str]] = None,
                 include_json_attachment: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 payload: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 payload_string: Optional[pulumi.Input[str]] = None,
                 payload_type: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route_key: Optional[pulumi.Input[str]] = None,
                 service_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[str]] = None,
                 teams: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] api_key: The API key for integrating with OpsGenie.
        :param pulumi.Input[str] auth_password: Specifies an authentication password for use with a channel.  Supported by the `webhook` channel type.
        :param pulumi.Input[str] auth_type: Specifies an authentication method for use with a channel.  Supported by the `webhook` channel type.  Only HTTP basic authentication is currently supported via the value `BASIC`.
        :param pulumi.Input[str] auth_username: Specifies an authentication username for use with a channel.  Supported by the `webhook` channel type.
        :param pulumi.Input[str] base_url: The base URL of the webhook destination.
        :param pulumi.Input[str] channel: The Slack channel to send notifications to.
               * `opsgenie`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] headers: A map of key/value pairs that represents extra HTTP headers to be sent along with the webhook payload.
        :param pulumi.Input[str] headers_string: Use instead of `headers` if the desired payload is more complex than a list of key/value pairs (e.g. a set of headers that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `headers`.
        :param pulumi.Input[str] include_json_attachment: `0` or `1`. Flag for whether or not to attach a JSON document containing information about the associated alert to the email that is sent to recipients.
               * `webhook`
        :param pulumi.Input[str] key: The key for integrating with VictorOps.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] payload: A map of key/value pairs that represents the webhook payload.  Must provide `payload_type` if setting this argument.
        :param pulumi.Input[str] payload_string: Use instead of `payload` if the desired payload is more complex than a list of key/value pairs (e.g. a payload that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `payload`.
        :param pulumi.Input[str] payload_type: Can either be `application/json` or `application/x-www-form-urlencoded`. The `payload_type` argument is _required_ if `payload` is set.
               * `pagerduty`
        :param pulumi.Input[str] recipients: A set of recipients for targeting notifications.  Multiple values are comma separated.
        :param pulumi.Input[str] region: The data center region to store your data.  Valid values are `US` and `EU`.  Default is `US`.
        :param pulumi.Input[str] route_key: The route key for integrating with VictorOps.
               * `slack`
        :param pulumi.Input[str] service_key: Specifies the service key for integrating with Pagerduty.
               * `victorops`
        :param pulumi.Input[str] tags: A set of tags for targeting notifications. Multiple values are comma separated.
        :param pulumi.Input[str] teams: A set of teams for targeting notifications. Multiple values are comma separated.
        :param pulumi.Input[str] url: [Slack Webhook URL](https://slack.com/intl/en-es/help/articles/115005265063-Incoming-webhooks-for-Slack).
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if headers_string is not None:
            pulumi.set(__self__, "headers_string", headers_string)
        if include_json_attachment is not None:
            pulumi.set(__self__, "include_json_attachment", include_json_attachment)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_string is not None:
            pulumi.set(__self__, "payload_string", payload_string)
        if payload_type is not None:
            pulumi.set(__self__, "payload_type", payload_type)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_key is not None:
            pulumi.set(__self__, "route_key", route_key)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        The API key for integrating with OpsGenie.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an authentication password for use with a channel.  Supported by the `webhook` channel type.
        """
        return pulumi.get(self, "auth_password")

    @auth_password.setter
    def auth_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_password", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an authentication method for use with a channel.  Supported by the `webhook` channel type.  Only HTTP basic authentication is currently supported via the value `BASIC`.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an authentication username for use with a channel.  Supported by the `webhook` channel type.
        """
        return pulumi.get(self, "auth_username")

    @auth_username.setter
    def auth_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_username", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        The base URL of the webhook destination.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack channel to send notifications to.
        * `opsgenie`
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of key/value pairs that represents extra HTTP headers to be sent along with the webhook payload.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="headersString")
    def headers_string(self) -> Optional[pulumi.Input[str]]:
        """
        Use instead of `headers` if the desired payload is more complex than a list of key/value pairs (e.g. a set of headers that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `headers`.
        """
        return pulumi.get(self, "headers_string")

    @headers_string.setter
    def headers_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "headers_string", value)

    @property
    @pulumi.getter(name="includeJsonAttachment")
    def include_json_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        `0` or `1`. Flag for whether or not to attach a JSON document containing information about the associated alert to the email that is sent to recipients.
        * `webhook`
        """
        return pulumi.get(self, "include_json_attachment")

    @include_json_attachment.setter
    def include_json_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "include_json_attachment", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key for integrating with VictorOps.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of key/value pairs that represents the webhook payload.  Must provide `payload_type` if setting this argument.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadString")
    def payload_string(self) -> Optional[pulumi.Input[str]]:
        """
        Use instead of `payload` if the desired payload is more complex than a list of key/value pairs (e.g. a payload that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `payload`.
        """
        return pulumi.get(self, "payload_string")

    @payload_string.setter
    def payload_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_string", value)

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> Optional[pulumi.Input[str]]:
        """
        Can either be `application/json` or `application/x-www-form-urlencoded`. The `payload_type` argument is _required_ if `payload` is set.
        * `pagerduty`
        """
        return pulumi.get(self, "payload_type")

    @payload_type.setter
    def payload_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_type", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[str]]:
        """
        A set of recipients for targeting notifications.  Multiple values are comma separated.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The data center region to store your data.  Valid values are `US` and `EU`.  Default is `US`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> Optional[pulumi.Input[str]]:
        """
        The route key for integrating with VictorOps.
        * `slack`
        """
        return pulumi.get(self, "route_key")

    @route_key.setter
    def route_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_key", value)

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the service key for integrating with Pagerduty.
        * `victorops`
        """
        return pulumi.get(self, "service_key")

    @service_key.setter
    def service_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[str]]:
        """
        A set of tags for targeting notifications. Multiple values are comma separated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[str]]:
        """
        A set of teams for targeting notifications. Multiple values are comma separated.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        [Slack Webhook URL](https://slack.com/intl/en-es/help/articles/115005265063-Incoming-webhooks-for-Slack).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class AlertConditionTermArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[int],
                 threshold: pulumi.Input[float],
                 time_function: pulumi.Input[str],
                 operator: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_function", time_function)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[int]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> pulumi.Input[str]:
        return pulumi.get(self, "time_function")

    @time_function.setter
    def time_function(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_function", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class AlertMutingRuleConditionArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['AlertMutingRuleConditionConditionArgs']]],
                 operator: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AlertMutingRuleConditionConditionArgs']]] conditions: The individual MutingRuleConditions within the group. See Nested conditions blocks below for details.
        :param pulumi.Input[str] operator: The operator used to combine all the MutingRuleConditions within the group.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "operator", operator)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['AlertMutingRuleConditionConditionArgs']]]:
        """
        The individual MutingRuleConditions within the group. See Nested conditions blocks below for details.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['AlertMutingRuleConditionConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        The operator used to combine all the MutingRuleConditions within the group.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)


@pulumi.input_type
class AlertMutingRuleConditionConditionArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[str],
                 operator: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] attribute: The attribute on a violation.
        :param pulumi.Input[str] operator: The operator used to compare the attribute's value with the supplied value(s)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The value(s) to compare against the attribute's value.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[str]:
        """
        The attribute on a violation.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        The operator used to compare the attribute's value with the supplied value(s)
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The value(s) to compare against the attribute's value.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class DashboardFilterArgs:
    def __init__(__self__, *,
                 event_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] event_types: (Optional) A list of event types to enable filtering for.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attributes: (Optional) A list of attributes belonging to the specified event types to enable filtering for.
        """
        pulumi.set(__self__, "event_types", event_types)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Optional) A list of event types to enable filtering for.
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "event_types", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Optional) A list of attributes belonging to the specified event types to enable filtering for.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)


@pulumi.input_type
class DashboardWidgetArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 visualization: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[int]] = None,
                 compare_withs: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetCompareWithArgs']]]] = None,
                 drilldown_dashboard_id: Optional[pulumi.Input[int]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 end_time: Optional[pulumi.Input[int]] = None,
                 entity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 facet: Optional[pulumi.Input[str]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 limit: Optional[pulumi.Input[int]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetMetricArgs']]]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 nrql: Optional[pulumi.Input[str]] = None,
                 order_by: Optional[pulumi.Input[str]] = None,
                 raw_metric_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 threshold_red: Optional[pulumi.Input[float]] = None,
                 threshold_yellow: Optional[pulumi.Input[float]] = None,
                 widget_id: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] visualization: (Required) How the widget visualizes data.  Valid values are `billboard`, `gauge`, `billboard_comparison`, `facet_bar_chart`, `faceted_line_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `heatmap`, `attribute_sheet`, `single_event`, `histogram`, `funnel`, `raw_json`, `event_feed`, `event_table`, `uniques_list`, `line_chart`, `comparison_line_chart`, `markdown`, and `metric_line_chart`.
        :param pulumi.Input[int] account_id: (Optional) The account ID to use when querying data. If `account_id` is omitted, the widget will use the account ID associated with the API key used in your provider configuration. You can also use `account_id` to configure cross-account widgets or simply to be explicit about which account the widget will be pulling data from.
        :param pulumi.Input[int] drilldown_dashboard_id: (Optional) The ID of a dashboard to link to from the widget's facets.
               * `attribute_sheet`, `comparison_line_chart`, `event_feed`, `event_table`, `funnel`, `histogram`, `line_chart`, `raw_json`, `single_event`, or `uniques_list`:
        :param pulumi.Input[int] duration: (Required) The duration, in ms, of the time window represented in the chart.
        :param pulumi.Input[int] end_time: (Optional) The end time of the time window represented in the chart in epoch time.  When not set, the time window will end at the current time.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] entity_ids: (Required) A collection of entity IDs to display data. These are typically application IDs.
        :param pulumi.Input[str] facet: (Optional) Can be set to "host" to facet the metric data by host.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        :param pulumi.Input[int] limit: (Optional) The limit of distinct data series to display.  Requires `order_by` to be set.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardWidgetMetricArgs']]] metrics: (Required) A nested block that describes a metric.  Nested `metric` blocks support the following arguments:
        :param pulumi.Input[str] notes: (Optional) Description of the widget.
        :param pulumi.Input[str] nrql: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
               * `markdown`:
        :param pulumi.Input[str] order_by: (Optional) Set the order of the results.  Required when using `limit`.
               * `application_breakdown`:
        :param pulumi.Input[str] source: (Required) The markdown source to be rendered in the widget.
               * `metric_line_chart`:
        :param pulumi.Input[float] threshold_red: (Required) Threshold above which the displayed value will be styled with a red color.
        :param pulumi.Input[float] threshold_yellow: (Optional) Threshold above which the displayed value will be styled with a yellow color.
               * `facet_bar_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `faceted_line_chart`, or `heatmap`:
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "visualization", visualization)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if compare_withs is not None:
            pulumi.set(__self__, "compare_withs", compare_withs)
        if drilldown_dashboard_id is not None:
            pulumi.set(__self__, "drilldown_dashboard_id", drilldown_dashboard_id)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if entity_ids is not None:
            pulumi.set(__self__, "entity_ids", entity_ids)
        if facet is not None:
            pulumi.set(__self__, "facet", facet)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if nrql is not None:
            pulumi.set(__self__, "nrql", nrql)
        if order_by is not None:
            pulumi.set(__self__, "order_by", order_by)
        if raw_metric_name is not None:
            pulumi.set(__self__, "raw_metric_name", raw_metric_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if threshold_red is not None:
            pulumi.set(__self__, "threshold_red", threshold_red)
        if threshold_yellow is not None:
            pulumi.set(__self__, "threshold_yellow", threshold_yellow)
        if widget_id is not None:
            pulumi.set(__self__, "widget_id", widget_id)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def visualization(self) -> pulumi.Input[str]:
        """
        (Required) How the widget visualizes data.  Valid values are `billboard`, `gauge`, `billboard_comparison`, `facet_bar_chart`, `faceted_line_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `heatmap`, `attribute_sheet`, `single_event`, `histogram`, `funnel`, `raw_json`, `event_feed`, `event_table`, `uniques_list`, `line_chart`, `comparison_line_chart`, `markdown`, and `metric_line_chart`.
        """
        return pulumi.get(self, "visualization")

    @visualization.setter
    def visualization(self, value: pulumi.Input[str]):
        pulumi.set(self, "visualization", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) The account ID to use when querying data. If `account_id` is omitted, the widget will use the account ID associated with the API key used in your provider configuration. You can also use `account_id` to configure cross-account widgets or simply to be explicit about which account the widget will be pulling data from.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="compareWiths")
    def compare_withs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetCompareWithArgs']]]]:
        return pulumi.get(self, "compare_withs")

    @compare_withs.setter
    def compare_withs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetCompareWithArgs']]]]):
        pulumi.set(self, "compare_withs", value)

    @property
    @pulumi.getter(name="drilldownDashboardId")
    def drilldown_dashboard_id(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) The ID of a dashboard to link to from the widget's facets.
        * `attribute_sheet`, `comparison_line_chart`, `event_feed`, `event_table`, `funnel`, `histogram`, `line_chart`, `raw_json`, `single_event`, or `uniques_list`:
        """
        return pulumi.get(self, "drilldown_dashboard_id")

    @drilldown_dashboard_id.setter
    def drilldown_dashboard_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "drilldown_dashboard_id", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Required) The duration, in ms, of the time window represented in the chart.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) The end time of the time window represented in the chart in epoch time.  When not set, the time window will end at the current time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="entityIds")
    def entity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        (Required) A collection of entity IDs to display data. These are typically application IDs.
        """
        return pulumi.get(self, "entity_ids")

    @entity_ids.setter
    def entity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "entity_ids", value)

    @property
    @pulumi.getter
    def facet(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Can be set to "host" to facet the metric data by host.
        """
        return pulumi.get(self, "facet")

    @facet.setter
    def facet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "facet", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) The limit of distinct data series to display.  Requires `order_by` to be set.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetMetricArgs']]]]:
        """
        (Required) A nested block that describes a metric.  Nested `metric` blocks support the following arguments:
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Description of the widget.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter
    def nrql(self) -> Optional[pulumi.Input[str]]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        * `markdown`:
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nrql", value)

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Set the order of the results.  Required when using `limit`.
        * `application_breakdown`:
        """
        return pulumi.get(self, "order_by")

    @order_by.setter
    def order_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_by", value)

    @property
    @pulumi.getter(name="rawMetricName")
    def raw_metric_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "raw_metric_name")

    @raw_metric_name.setter
    def raw_metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_metric_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        (Required) The markdown source to be rendered in the widget.
        * `metric_line_chart`:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="thresholdRed")
    def threshold_red(self) -> Optional[pulumi.Input[float]]:
        """
        (Required) Threshold above which the displayed value will be styled with a red color.
        """
        return pulumi.get(self, "threshold_red")

    @threshold_red.setter
    def threshold_red(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_red", value)

    @property
    @pulumi.getter(name="thresholdYellow")
    def threshold_yellow(self) -> Optional[pulumi.Input[float]]:
        """
        (Optional) Threshold above which the displayed value will be styled with a yellow color.
        * `facet_bar_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `faceted_line_chart`, or `heatmap`:
        """
        return pulumi.get(self, "threshold_yellow")

    @threshold_yellow.setter
    def threshold_yellow(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_yellow", value)

    @property
    @pulumi.getter(name="widgetId")
    def widget_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "widget_id")

    @widget_id.setter
    def widget_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "widget_id", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class DashboardWidgetCompareWithArgs:
    def __init__(__self__, *,
                 offset_duration: pulumi.Input[str],
                 presentation: pulumi.Input['DashboardWidgetCompareWithPresentationArgs']):
        pulumi.set(__self__, "offset_duration", offset_duration)
        pulumi.set(__self__, "presentation", presentation)

    @property
    @pulumi.getter(name="offsetDuration")
    def offset_duration(self) -> pulumi.Input[str]:
        return pulumi.get(self, "offset_duration")

    @offset_duration.setter
    def offset_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "offset_duration", value)

    @property
    @pulumi.getter
    def presentation(self) -> pulumi.Input['DashboardWidgetCompareWithPresentationArgs']:
        return pulumi.get(self, "presentation")

    @presentation.setter
    def presentation(self, value: pulumi.Input['DashboardWidgetCompareWithPresentationArgs']):
        pulumi.set(self, "presentation", value)


@pulumi.input_type
class DashboardWidgetCompareWithPresentationArgs:
    def __init__(__self__, *,
                 color: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: (Required) The metric name to display.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Input[str]:
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: pulumi.Input[str]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Required) The metric name to display.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DashboardWidgetMetricArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 scope: Optional[pulumi.Input[str]] = None,
                 units: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: (Required) The metric name to display.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: (Required) The metric values to display.
        """
        pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if units is not None:
            pulumi.set(__self__, "units", units)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Required) The metric name to display.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Required) The metric values to display.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class EntityTagsTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] key: The tag key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The tag values.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The tag values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class InfraAlertConditionCriticalArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[int],
                 time_function: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        pulumi.set(__self__, "duration", duration)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[int]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_function")

    @time_function.setter
    def time_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_function", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class InfraAlertConditionWarningArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[int],
                 time_function: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        pulumi.set(__self__, "duration", duration)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[int]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_function")

    @time_function.setter
    def time_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_function", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NrqlAlertConditionCriticalArgs:
    def __init__(__self__, *,
                 threshold: pulumi.Input[float],
                 duration: Optional[pulumi.Input[int]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 threshold_duration: Optional[pulumi.Input[int]] = None,
                 threshold_occurrences: Optional[pulumi.Input[str]] = None,
                 time_function: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "threshold", threshold)
        if duration is not None:
            warnings.warn("""use `threshold_duration` attribute instead""", DeprecationWarning)
            pulumi.log.warn("duration is deprecated: use `threshold_duration` attribute instead")
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold_duration is not None:
            pulumi.set(__self__, "threshold_duration", threshold_duration)
        if threshold_occurrences is not None:
            pulumi.set(__self__, "threshold_occurrences", threshold_occurrences)
        if time_function is not None:
            warnings.warn("""use `threshold_occurrences` attribute instead""", DeprecationWarning)
            pulumi.log.warn("time_function is deprecated: use `threshold_occurrences` attribute instead")
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="thresholdDuration")
    def threshold_duration(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "threshold_duration")

    @threshold_duration.setter
    def threshold_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold_duration", value)

    @property
    @pulumi.getter(name="thresholdOccurrences")
    def threshold_occurrences(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "threshold_occurrences")

    @threshold_occurrences.setter
    def threshold_occurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold_occurrences", value)

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_function")

    @time_function.setter
    def time_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_function", value)


@pulumi.input_type
class NrqlAlertConditionNrqlArgs:
    def __init__(__self__, *,
                 query: pulumi.Input[str],
                 evaluation_offset: Optional[pulumi.Input[int]] = None,
                 since_value: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "query", query)
        if evaluation_offset is not None:
            pulumi.set(__self__, "evaluation_offset", evaluation_offset)
        if since_value is not None:
            warnings.warn("""use `evaluation_offset` attribute instead""", DeprecationWarning)
            pulumi.log.warn("since_value is deprecated: use `evaluation_offset` attribute instead")
        if since_value is not None:
            pulumi.set(__self__, "since_value", since_value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="evaluationOffset")
    def evaluation_offset(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "evaluation_offset")

    @evaluation_offset.setter
    def evaluation_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_offset", value)

    @property
    @pulumi.getter(name="sinceValue")
    def since_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "since_value")

    @since_value.setter
    def since_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "since_value", value)


@pulumi.input_type
class NrqlAlertConditionTermArgs:
    def __init__(__self__, *,
                 threshold: pulumi.Input[float],
                 duration: Optional[pulumi.Input[int]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 threshold_duration: Optional[pulumi.Input[int]] = None,
                 threshold_occurrences: Optional[pulumi.Input[str]] = None,
                 time_function: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "threshold", threshold)
        if duration is not None:
            warnings.warn("""use `threshold_duration` attribute instead""", DeprecationWarning)
            pulumi.log.warn("duration is deprecated: use `threshold_duration` attribute instead")
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if threshold_duration is not None:
            pulumi.set(__self__, "threshold_duration", threshold_duration)
        if threshold_occurrences is not None:
            pulumi.set(__self__, "threshold_occurrences", threshold_occurrences)
        if time_function is not None:
            warnings.warn("""use `threshold_occurrences` attribute instead""", DeprecationWarning)
            pulumi.log.warn("time_function is deprecated: use `threshold_occurrences` attribute instead")
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="thresholdDuration")
    def threshold_duration(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "threshold_duration")

    @threshold_duration.setter
    def threshold_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold_duration", value)

    @property
    @pulumi.getter(name="thresholdOccurrences")
    def threshold_occurrences(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "threshold_occurrences")

    @threshold_occurrences.setter
    def threshold_occurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold_occurrences", value)

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_function")

    @time_function.setter
    def time_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_function", value)


@pulumi.input_type
class NrqlAlertConditionWarningArgs:
    def __init__(__self__, *,
                 threshold: pulumi.Input[float],
                 duration: Optional[pulumi.Input[int]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 threshold_duration: Optional[pulumi.Input[int]] = None,
                 threshold_occurrences: Optional[pulumi.Input[str]] = None,
                 time_function: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "threshold", threshold)
        if duration is not None:
            warnings.warn("""use `threshold_duration` attribute instead""", DeprecationWarning)
            pulumi.log.warn("duration is deprecated: use `threshold_duration` attribute instead")
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold_duration is not None:
            pulumi.set(__self__, "threshold_duration", threshold_duration)
        if threshold_occurrences is not None:
            pulumi.set(__self__, "threshold_occurrences", threshold_occurrences)
        if time_function is not None:
            warnings.warn("""use `threshold_occurrences` attribute instead""", DeprecationWarning)
            pulumi.log.warn("time_function is deprecated: use `threshold_occurrences` attribute instead")
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="thresholdDuration")
    def threshold_duration(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "threshold_duration")

    @threshold_duration.setter
    def threshold_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold_duration", value)

    @property
    @pulumi.getter(name="thresholdOccurrences")
    def threshold_occurrences(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "threshold_occurrences")

    @threshold_occurrences.setter
    def threshold_occurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold_occurrences", value)

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_function")

    @time_function.setter
    def time_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_function", value)


@pulumi.input_type
class OneDashboardPageArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 guid: Optional[pulumi.Input[str]] = None,
                 widget_areas: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaArgs']]]] = None,
                 widget_bars: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarArgs']]]] = None,
                 widget_billboards: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardArgs']]]] = None,
                 widget_lines: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineArgs']]]] = None,
                 widget_markdowns: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetMarkdownArgs']]]] = None,
                 widget_pies: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyArgs']]]] = None,
                 widget_tables: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableArgs']]]] = None):
        """
        :param pulumi.Input[str] name: The title of the dashboard.
        :param pulumi.Input[str] description: Brief text describing the dashboard.
        :param pulumi.Input[str] guid: The unique entity identifier of the dashboard page in New Relic.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaArgs']]] widget_areas: (Optional) A nested block that describes an Area widget.  See Nested widget blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarArgs']]] widget_bars: (Optional) A nested block that describes a Bar widget.  See Nested widget blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardArgs']]] widget_billboards: (Optional) A nested block that describes a Billboard widget.  See Nested widget blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineArgs']]] widget_lines: (Optional) A nested block that describes a Line widget.  See Nested widget blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetMarkdownArgs']]] widget_markdowns: (Optional) A nested block that describes a Markdown widget.  See Nested widget blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyArgs']]] widget_pies: (Optional) A nested block that describes a Pie widget.  See Nested widget blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableArgs']]] widget_tables: (Optional) A nested block that describes a Table widget.  See Nested widget blocks below for details.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if widget_areas is not None:
            pulumi.set(__self__, "widget_areas", widget_areas)
        if widget_bars is not None:
            pulumi.set(__self__, "widget_bars", widget_bars)
        if widget_billboards is not None:
            pulumi.set(__self__, "widget_billboards", widget_billboards)
        if widget_lines is not None:
            pulumi.set(__self__, "widget_lines", widget_lines)
        if widget_markdowns is not None:
            pulumi.set(__self__, "widget_markdowns", widget_markdowns)
        if widget_pies is not None:
            pulumi.set(__self__, "widget_pies", widget_pies)
        if widget_tables is not None:
            pulumi.set(__self__, "widget_tables", widget_tables)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Brief text describing the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique entity identifier of the dashboard page in New Relic.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guid", value)

    @property
    @pulumi.getter(name="widgetAreas")
    def widget_areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaArgs']]]]:
        """
        (Optional) A nested block that describes an Area widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_areas")

    @widget_areas.setter
    def widget_areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaArgs']]]]):
        pulumi.set(self, "widget_areas", value)

    @property
    @pulumi.getter(name="widgetBars")
    def widget_bars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarArgs']]]]:
        """
        (Optional) A nested block that describes a Bar widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_bars")

    @widget_bars.setter
    def widget_bars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarArgs']]]]):
        pulumi.set(self, "widget_bars", value)

    @property
    @pulumi.getter(name="widgetBillboards")
    def widget_billboards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardArgs']]]]:
        """
        (Optional) A nested block that describes a Billboard widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_billboards")

    @widget_billboards.setter
    def widget_billboards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardArgs']]]]):
        pulumi.set(self, "widget_billboards", value)

    @property
    @pulumi.getter(name="widgetLines")
    def widget_lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineArgs']]]]:
        """
        (Optional) A nested block that describes a Line widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_lines")

    @widget_lines.setter
    def widget_lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineArgs']]]]):
        pulumi.set(self, "widget_lines", value)

    @property
    @pulumi.getter(name="widgetMarkdowns")
    def widget_markdowns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetMarkdownArgs']]]]:
        """
        (Optional) A nested block that describes a Markdown widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_markdowns")

    @widget_markdowns.setter
    def widget_markdowns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetMarkdownArgs']]]]):
        pulumi.set(self, "widget_markdowns", value)

    @property
    @pulumi.getter(name="widgetPies")
    def widget_pies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyArgs']]]]:
        """
        (Optional) A nested block that describes a Pie widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_pies")

    @widget_pies.setter
    def widget_pies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyArgs']]]]):
        pulumi.set(self, "widget_pies", value)

    @property
    @pulumi.getter(name="widgetTables")
    def widget_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableArgs']]]]:
        """
        (Optional) A nested block that describes a Table widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_tables")

    @widget_tables.setter
    def widget_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableArgs']]]]):
        pulumi.set(self, "widget_tables", value)


@pulumi.input_type
class OneDashboardPageWidgetAreaArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 nrql_queries: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaNrqlQueryArgs']]],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaNrqlQueryArgs']]] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaNrqlQueryArgs']]]:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @nrql_queries.setter
    def nrql_queries(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetAreaNrqlQueryArgs']]]):
        pulumi.set(self, "nrql_queries", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetAreaNrqlQueryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[int],
                 query: pulumi.Input[str]):
        """
        :param pulumi.Input[int] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[str] query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[int]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class OneDashboardPageWidgetBarArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 nrql_queries: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarNrqlQueryArgs']]],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 linked_entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarNrqlQueryArgs']]] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linked_entity_guids is not None:
            pulumi.set(__self__, "linked_entity_guids", linked_entity_guids)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarNrqlQueryArgs']]]:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @nrql_queries.setter
    def nrql_queries(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBarNrqlQueryArgs']]]):
        pulumi.set(self, "nrql_queries", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="linkedEntityGuids")
    def linked_entity_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "linked_entity_guids")

    @linked_entity_guids.setter
    def linked_entity_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "linked_entity_guids", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetBarNrqlQueryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[int],
                 query: pulumi.Input[str]):
        """
        :param pulumi.Input[int] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[str] query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[int]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class OneDashboardPageWidgetBillboardArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 nrql_queries: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardNrqlQueryArgs']]],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 critical: Optional[pulumi.Input[float]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 warning: Optional[pulumi.Input[float]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardNrqlQueryArgs']]] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[float] critical: (Optional) Threshold above which the displayed value will be styled with a red color.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[float] warning: (Optional) Threshold above which the displayed value will be styled with a yellow color.
               * `widget_markdown`:
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardNrqlQueryArgs']]]:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @nrql_queries.setter
    def nrql_queries(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetBillboardNrqlQueryArgs']]]):
        pulumi.set(self, "nrql_queries", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input[float]]:
        """
        (Optional) Threshold above which the displayed value will be styled with a red color.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "critical", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input[float]]:
        """
        (Optional) Threshold above which the displayed value will be styled with a yellow color.
        * `widget_markdown`:
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warning", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetBillboardNrqlQueryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[int],
                 query: pulumi.Input[str]):
        """
        :param pulumi.Input[int] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[str] query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[int]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class OneDashboardPageWidgetLineArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 nrql_queries: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineNrqlQueryArgs']]],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 linked_entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineNrqlQueryArgs']]] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linked_entity_guids is not None:
            pulumi.set(__self__, "linked_entity_guids", linked_entity_guids)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineNrqlQueryArgs']]]:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @nrql_queries.setter
    def nrql_queries(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetLineNrqlQueryArgs']]]):
        pulumi.set(self, "nrql_queries", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="linkedEntityGuids")
    def linked_entity_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "linked_entity_guids")

    @linked_entity_guids.setter
    def linked_entity_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "linked_entity_guids", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetLineNrqlQueryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[int],
                 query: pulumi.Input[str]):
        """
        :param pulumi.Input[int] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[str] query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[int]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class OneDashboardPageWidgetMarkdownArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[str] text: (Required) The markdown source to be rendered in the widget.
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        (Required) The markdown source to be rendered in the widget.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetPyArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 nrql_queries: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyNrqlQueryArgs']]],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 linked_entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyNrqlQueryArgs']]] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linked_entity_guids is not None:
            pulumi.set(__self__, "linked_entity_guids", linked_entity_guids)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyNrqlQueryArgs']]]:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @nrql_queries.setter
    def nrql_queries(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetPyNrqlQueryArgs']]]):
        pulumi.set(self, "nrql_queries", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="linkedEntityGuids")
    def linked_entity_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "linked_entity_guids")

    @linked_entity_guids.setter
    def linked_entity_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "linked_entity_guids", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetPyNrqlQueryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[int],
                 query: pulumi.Input[str]):
        """
        :param pulumi.Input[int] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[str] query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[int]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class OneDashboardPageWidgetTableArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[int],
                 nrql_queries: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableNrqlQueryArgs']]],
                 row: pulumi.Input[int],
                 title: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] column: (Required) Column position of widget from top left, starting at `1`.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableNrqlQueryArgs']]] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param pulumi.Input[int] row: (Required) Row position of widget from top left, starting at `1`.
        :param pulumi.Input[str] title: (Required) A title for the widget.
        :param pulumi.Input[int] height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param pulumi.Input[int] width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[int]:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[int]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableNrqlQueryArgs']]]:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @nrql_queries.setter
    def nrql_queries(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardPageWidgetTableNrqlQueryArgs']]]):
        pulumi.set(self, "nrql_queries", value)

    @property
    @pulumi.getter
    def row(self) -> pulumi.Input[int]:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @row.setter
    def row(self, value: pulumi.Input[int]):
        pulumi.set(self, "row", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class OneDashboardPageWidgetTableNrqlQueryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[int],
                 query: pulumi.Input[str]):
        """
        :param pulumi.Input[int] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[str] query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[int]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class GetEntityTagArgs:
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)


