# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['AlertPolicy']


class AlertPolicy(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[int]] = None,
                 channel_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 incident_preference: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to create and manage New Relic alert policies.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", incident_preference="PER_POLICY")
        ```
        ### Provision multiple notification channels and add those channels to a policy

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        # Provision a Slack notification channel.
        slack_channel = newrelic.AlertChannel("slackChannel",
            type="slack",
            config=newrelic.AlertChannelConfigArgs(
                url="https://hooks.slack.com/services/xxxxxxx/yyyyyyyy",
                channel="example-alerts-channel",
            ))
        # Provision an email notification channel.
        email_channel = newrelic.AlertChannel("emailChannel",
            type="email",
            config=newrelic.AlertChannelConfigArgs(
                recipients="example@testing.com",
                include_json_attachment="1",
            ))
        # Provision the alert policy.
        policy_with_channels = newrelic.AlertPolicy("policyWithChannels",
            incident_preference="PER_CONDITION",
            channel_ids=[
                slack_channel.id,
                email_channel.id,
            ])
        ```
        ### Reference existing notification channels and add those channel to a policy
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        slack_channel = newrelic.get_alert_channel(name="slack-channel-notification")
        email_channel = newrelic.get_alert_channel(name="test@example.com")
        # Provision the alert policy.
        policy_with_channels = newrelic.AlertPolicy("policyWithChannels",
            incident_preference="PER_CONDITION",
            channel_ids=[
                slack_channel.id,
                email_channel.id,
            ])
        ```

        ## Import

        Alert policies can be imported using a composite ID of `<id>:<account_id>`, where `account_id` is the account number scoped to the alert policy resource. Example import

        ```sh
         $ pulumi import newrelic:index/alertPolicy:AlertPolicy foo 23423556:4593020
        ```

         Please note that channel IDs (`channel_ids`) _cannot_ be imported due channels being a separate resource. However, to add channels to an imported alert policy, you can import the policy, add the `channel_ids` attribute with the associated channel IDs, then run `terraform apply`. This will result in the original alert policy being destroyed and a new alert policy being created along with the channels being added to the policy.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] channel_ids: An array of channel IDs (integers) to assign to the policy. Adding or removing channel IDs from this array will result in a new alert policy resource being created and the old one being destroyed. Also note that channel IDs _cannot_ be imported.
        :param pulumi.Input[str] incident_preference: The rollup strategy for the policy.  Options include: `PER_POLICY`, `PER_CONDITION`, or `PER_CONDITION_AND_TARGET`.  The default is `PER_POLICY`.
        :param pulumi.Input[str] name: The name of the policy.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_id'] = account_id
            __props__['channel_ids'] = channel_ids
            __props__['incident_preference'] = incident_preference
            __props__['name'] = name
        super(AlertPolicy, __self__).__init__(
            'newrelic:index/alertPolicy:AlertPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[int]] = None,
            channel_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            incident_preference: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'AlertPolicy':
        """
        Get an existing AlertPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] channel_ids: An array of channel IDs (integers) to assign to the policy. Adding or removing channel IDs from this array will result in a new alert policy resource being created and the old one being destroyed. Also note that channel IDs _cannot_ be imported.
        :param pulumi.Input[str] incident_preference: The rollup strategy for the policy.  Options include: `PER_POLICY`, `PER_CONDITION`, or `PER_CONDITION_AND_TARGET`.  The default is `PER_POLICY`.
        :param pulumi.Input[str] name: The name of the policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["channel_ids"] = channel_ids
        __props__["incident_preference"] = incident_preference
        __props__["name"] = name
        return AlertPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[int]:
        """
        The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="channelIds")
    def channel_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        An array of channel IDs (integers) to assign to the policy. Adding or removing channel IDs from this array will result in a new alert policy resource being created and the old one being destroyed. Also note that channel IDs _cannot_ be imported.
        """
        return pulumi.get(self, "channel_ids")

    @property
    @pulumi.getter(name="incidentPreference")
    def incident_preference(self) -> pulumi.Output[Optional[str]]:
        """
        The rollup strategy for the policy.  Options include: `PER_POLICY`, `PER_CONDITION`, or `PER_CONDITION_AND_TARGET`.  The default is `PER_POLICY`.
        """
        return pulumi.get(self, "incident_preference")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

