# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['AlertPolicyChannel']


class AlertPolicyChannel(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 policy_id: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to map alert policies to alert channels in New Relic.

        ## Example Usage

        The example below will apply multiple alert channels to an existing New Relic alert policy.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        example_policy = newrelic.get_alert_policy(name="my-alert-policy")
        # Creates an email alert channel.
        email_channel = newrelic.AlertChannel("emailChannel",
            type="email",
            config=newrelic.AlertChannelConfigArgs(
                recipients="foo@example.com",
                include_json_attachment="1",
            ))
        # Creates a Slack alert channel.
        slack_channel = newrelic.AlertChannel("slackChannel",
            type="slack",
            config=newrelic.AlertChannelConfigArgs(
                channel="#example-channel",
                url="http://example-org.slack.com",
            ))
        # Applies the created channels above to the alert policy
        # referenced at the top of the config.
        foo = newrelic.AlertPolicyChannel("foo",
            policy_id=newrelic_alert_policy["example_policy"]["id"],
            channel_ids=[
                email_channel.id,
                slack_channel.id,
            ])
        ```

        ## Import

        Alert policy channels can be imported using the following notation`<policyID>:<channelID>:<channelID>`, e.g.

        ```sh
         $ pulumi import newrelic:index/alertPolicyChannel:AlertPolicyChannel foo 123456:3462754:2938324
        ```

         When importing `newrelic_alert_policy_channel` resource, the attribute `channel_ids`\* will be set in your Terraform state. You can import multiple channels as long as those channel IDs are included as part of the import ID hash.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] channel_ids: Array of channel IDs to apply to the specified policy. We recommended sorting channel IDs in ascending order to avoid drift in your state.
        :param pulumi.Input[int] policy_id: The ID of the policy.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if channel_ids is None and not opts.urn:
                raise TypeError("Missing required property 'channel_ids'")
            __props__['channel_ids'] = channel_ids
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__['policy_id'] = policy_id
        super(AlertPolicyChannel, __self__).__init__(
            'newrelic:index/alertPolicyChannel:AlertPolicyChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            policy_id: Optional[pulumi.Input[int]] = None) -> 'AlertPolicyChannel':
        """
        Get an existing AlertPolicyChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] channel_ids: Array of channel IDs to apply to the specified policy. We recommended sorting channel IDs in ascending order to avoid drift in your state.
        :param pulumi.Input[int] policy_id: The ID of the policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["channel_ids"] = channel_ids
        __props__["policy_id"] = policy_id
        return AlertPolicyChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="channelIds")
    def channel_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        Array of channel IDs to apply to the specified policy. We recommended sorting channel IDs in ascending order to avoid drift in your state.
        """
        return pulumi.get(self, "channel_ids")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[int]:
        """
        The ID of the policy.
        """
        return pulumi.get(self, "policy_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

