# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Dashboard']


class Dashboard(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 editable: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[pulumi.InputType['DashboardFilterArgs']]] = None,
                 grid_column_count: Optional[pulumi.Input[int]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to create and manage New Relic dashboards.

        ## Example Usage
        ### Create A New Relic Dashboard

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        my_application = newrelic.get_entity(name="My Application",
            type="APPLICATION",
            domain="APM")
        exampledash = newrelic.Dashboard("exampledash",
            title="New Relic Terraform Example",
            filter=newrelic.DashboardFilterArgs(
                event_types=["Transaction"],
                attributes=[
                    "appName",
                    "name",
                ],
            ),
            widgets=[
                newrelic.DashboardWidgetArgs(
                    title="Requests per minute",
                    visualization="billboard",
                    nrql="SELECT rate(count(*), 1 minute) FROM Transaction",
                    row=1,
                    column=1,
                ),
                newrelic.DashboardWidgetArgs(
                    title="Error rate",
                    visualization="gauge",
                    nrql="SELECT percentage(count(*), WHERE error IS True) FROM Transaction",
                    threshold_red=2.5,
                    row=1,
                    column=2,
                ),
                newrelic.DashboardWidgetArgs(
                    title="Average transaction duration, by application",
                    visualization="facet_bar_chart",
                    nrql="SELECT average(duration) FROM Transaction FACET appName",
                    row=1,
                    column=3,
                ),
                newrelic.DashboardWidgetArgs(
                    title="Apdex, top 5 by host",
                    duration=1800000,
                    visualization="metric_line_chart",
                    entity_ids=[my_application.application_id],
                    metrics=[newrelic.DashboardWidgetMetricArgs(
                        name="Apdex",
                        values=["score"],
                    )],
                    facet="host",
                    limit=5,
                    order_by="score",
                    row=2,
                    column=1,
                ),
                newrelic.DashboardWidgetArgs(
                    title="Requests per minute, by transaction",
                    visualization="facet_table",
                    nrql="SELECT rate(count(*), 1 minute) FROM Transaction FACET name",
                    row=2,
                    column=2,
                ),
                newrelic.DashboardWidgetArgs(
                    title="Dashboard Note",
                    visualization="markdown",
                    source=\"\"\"### Helpful Links

        * [New Relic One](https://one.newrelic.com)
        * [Developer Portal](https://developer.newrelic.com)\"\"\",
                    row=2,
                    column=3,
                ),
            ])
        ```
        See additional examples.
        ## Additional Examples

        ### Create cross-account widgets in your dashboard.

        The example below shows how you can display data for an application from a primary account and an application from a subaccount. In order to create cross-account widgets, you must use an API key from a user with admin permissions in the primary account. Please see the `widget` attribute documentation for more details.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        primary_account_application = newrelic.get_entity(name="Main Account Application Name",
            type="APPLICATION",
            domain="APM")
        subaccount_application = newrelic.get_entity(name="Subaccount Application Name",
            type="APPLICATION",
            domain="APM")
        cross_account_widget_example = newrelic.Dashboard("crossAccountWidgetExample",
            title="tf-test-cross-account-widget-dashboard",
            filter=newrelic.DashboardFilterArgs(
                event_types=["Transaction"],
                attributes=[
                    "appName",
                    "envName",
                ],
            ),
            grid_column_count=12,
            widgets=[
                newrelic.DashboardWidgetArgs(
                    title="Apdex (primary account)",
                    row=1,
                    column=1,
                    width=6,
                    height=3,
                    visualization="metric_line_chart",
                    duration=1800000,
                    metrics=[newrelic.DashboardWidgetMetricArgs(
                        name="Apdex",
                        values=["score"],
                    )],
                    entity_ids=[primary_account_application.application_id],
                ),
                newrelic.DashboardWidgetArgs(
                    account_id=var["subaccount_id"],
                    title="Apdex (subaccount)",
                    row=1,
                    column=7,
                    width=6,
                    height=3,
                    visualization="metric_line_chart",
                    duration=1800000,
                    metrics=[newrelic.DashboardWidgetMetricArgs(
                        name="Apdex",
                        values=["score"],
                    )],
                    entity_ids=[subaccount_application.application_id],
                ),
            ])
        ```

        ## Import

        New Relic dashboards can be imported using their ID, e.g.

        ```sh
         $ pulumi import newrelic:index/dashboard:Dashboard my_dashboard 8675309
        ```

         ~> **NOTE** Due to API restrictions, importing a dashboard resource will set the `grid_column_count` attribute to `3`. If your dashboard is a New Relic One dashboard _and_ uses a 12 column grid, you will need to make sure `grid_column_count` is set to `12` in your configuration, then run `terraform apply` after importing to sync remote state with Terraform state. Also note, cross-account widgets cannot be imported due to API restrictions.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] editable: Determines who can edit the dashboard in an account. Valid values are `all`,  `editable_by_all`, `editable_by_owner`, or `read_only`.  Defaults to `editable_by_all`.
        :param pulumi.Input[pulumi.InputType['DashboardFilterArgs']] filter: A nested block that describes a dashboard filter.  Exactly one nested `filter` block is allowed. See Nested filter block below for details.
        :param pulumi.Input[int] grid_column_count: The number of columns to use when organizing and displaying widgets. New Relic One supports a 3 column grid and a 12 column grid. New Relic Insights supports a 3 column grid.
        :param pulumi.Input[str] icon: The icon for the dashboard.  Valid values are `adjust`, `archive`, `bar-chart`, `bell`, `bolt`, `bug`, `bullhorn`, `bullseye`, `clock-o`, `cloud`, `cog`, `comments-o`, `crosshairs`, `dashboard`, `envelope`, `fire`, `flag`, `flask`, `globe`, `heart`, `leaf`, `legal`, `life-ring`, `line-chart`, `magic`, `mobile`, `money`, `none`, `paper-plane`, `pie-chart`, `puzzle-piece`, `road`, `rocket`, `shopping-cart`, `sitemap`, `sliders`, `tablet`, `thumbs-down`, `thumbs-up`, `trophy`, `usd`, `user`, and `users`.  Defaults to `bar-chart`.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] visibility: Determines who can see the dashboard in an account. Valid values are `all` or `owner`.  Defaults to `all`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]] widgets: A nested block that describes a visualization.  Up to 300 `widget` blocks are allowed in a dashboard definition. See Nested widget blocks below for details.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['editable'] = editable
            __props__['filter'] = filter
            __props__['grid_column_count'] = grid_column_count
            __props__['icon'] = icon
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__['title'] = title
            __props__['visibility'] = visibility
            __props__['widgets'] = widgets
            __props__['dashboard_url'] = None
        super(Dashboard, __self__).__init__(
            'newrelic:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_url: Optional[pulumi.Input[str]] = None,
            editable: Optional[pulumi.Input[str]] = None,
            filter: Optional[pulumi.Input[pulumi.InputType['DashboardFilterArgs']]] = None,
            grid_column_count: Optional[pulumi.Input[int]] = None,
            icon: Optional[pulumi.Input[str]] = None,
            title: Optional[pulumi.Input[str]] = None,
            visibility: Optional[pulumi.Input[str]] = None,
            widgets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dashboard_url: The URL for viewing the dashboard.
        :param pulumi.Input[str] editable: Determines who can edit the dashboard in an account. Valid values are `all`,  `editable_by_all`, `editable_by_owner`, or `read_only`.  Defaults to `editable_by_all`.
        :param pulumi.Input[pulumi.InputType['DashboardFilterArgs']] filter: A nested block that describes a dashboard filter.  Exactly one nested `filter` block is allowed. See Nested filter block below for details.
        :param pulumi.Input[int] grid_column_count: The number of columns to use when organizing and displaying widgets. New Relic One supports a 3 column grid and a 12 column grid. New Relic Insights supports a 3 column grid.
        :param pulumi.Input[str] icon: The icon for the dashboard.  Valid values are `adjust`, `archive`, `bar-chart`, `bell`, `bolt`, `bug`, `bullhorn`, `bullseye`, `clock-o`, `cloud`, `cog`, `comments-o`, `crosshairs`, `dashboard`, `envelope`, `fire`, `flag`, `flask`, `globe`, `heart`, `leaf`, `legal`, `life-ring`, `line-chart`, `magic`, `mobile`, `money`, `none`, `paper-plane`, `pie-chart`, `puzzle-piece`, `road`, `rocket`, `shopping-cart`, `sitemap`, `sliders`, `tablet`, `thumbs-down`, `thumbs-up`, `trophy`, `usd`, `user`, and `users`.  Defaults to `bar-chart`.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] visibility: Determines who can see the dashboard in an account. Valid values are `all` or `owner`.  Defaults to `all`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]] widgets: A nested block that describes a visualization.  Up to 300 `widget` blocks are allowed in a dashboard definition. See Nested widget blocks below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["dashboard_url"] = dashboard_url
        __props__["editable"] = editable
        __props__["filter"] = filter
        __props__["grid_column_count"] = grid_column_count
        __props__["icon"] = icon
        __props__["title"] = title
        __props__["visibility"] = visibility
        __props__["widgets"] = widgets
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> pulumi.Output[str]:
        """
        The URL for viewing the dashboard.
        """
        return pulumi.get(self, "dashboard_url")

    @property
    @pulumi.getter
    def editable(self) -> pulumi.Output[Optional[str]]:
        """
        Determines who can edit the dashboard in an account. Valid values are `all`,  `editable_by_all`, `editable_by_owner`, or `read_only`.  Defaults to `editable_by_all`.
        """
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.DashboardFilter']]:
        """
        A nested block that describes a dashboard filter.  Exactly one nested `filter` block is allowed. See Nested filter block below for details.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="gridColumnCount")
    def grid_column_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of columns to use when organizing and displaying widgets. New Relic One supports a 3 column grid and a 12 column grid. New Relic Insights supports a 3 column grid.
        """
        return pulumi.get(self, "grid_column_count")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[Optional[str]]:
        """
        The icon for the dashboard.  Valid values are `adjust`, `archive`, `bar-chart`, `bell`, `bolt`, `bug`, `bullhorn`, `bullseye`, `clock-o`, `cloud`, `cog`, `comments-o`, `crosshairs`, `dashboard`, `envelope`, `fire`, `flag`, `flask`, `globe`, `heart`, `leaf`, `legal`, `life-ring`, `line-chart`, `magic`, `mobile`, `money`, `none`, `paper-plane`, `pie-chart`, `puzzle-piece`, `road`, `rocket`, `shopping-cart`, `sitemap`, `sliders`, `tablet`, `thumbs-down`, `thumbs-up`, `trophy`, `usd`, `user`, and `users`.  Defaults to `bar-chart`.
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[str]]:
        """
        Determines who can see the dashboard in an account. Valid values are `all` or `owner`.  Defaults to `all`.
        """
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter
    def widgets(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardWidget']]]:
        """
        A nested block that describes a visualization.  Up to 300 `widget` blocks are allowed in a dashboard definition. See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widgets")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

