# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['EventsToMetricsRule']


class EventsToMetricsRule(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nrql: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to create, update, and delete New Relic Events to Metrics rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.EventsToMetricsRule("foo",
            account_id=12345,
            description="Example description",
            nrql="SELECT uniqueCount(account_id) AS ``Transaction.account_id`` FROM Transaction FACET appName, name")
        ```

        ## Import

        New Relic Events to Metrics rules can be imported using a concatenated string of the format

        `<account_id>:<rule_id>`, e.g. bash

        ```sh
         $ pulumi import newrelic:index/eventsToMetricsRule:EventsToMetricsRule foo 12345:34567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: Account with the event and where the metrics will be put.
        :param pulumi.Input[str] description: Provides additional information about the rule.
        :param pulumi.Input[bool] enabled: True means this rule is enabled. False means the rule is currently not creating metrics.
        :param pulumi.Input[str] name: The name of the rule. This must be unique within an account.
        :param pulumi.Input[str] nrql: Explains how to create metrics from events.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_id'] = account_id
            __props__['description'] = description
            __props__['enabled'] = enabled
            __props__['name'] = name
            if nrql is None and not opts.urn:
                raise TypeError("Missing required property 'nrql'")
            __props__['nrql'] = nrql
            __props__['rule_id'] = None
        super(EventsToMetricsRule, __self__).__init__(
            'newrelic:index/eventsToMetricsRule:EventsToMetricsRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nrql: Optional[pulumi.Input[str]] = None,
            rule_id: Optional[pulumi.Input[str]] = None) -> 'EventsToMetricsRule':
        """
        Get an existing EventsToMetricsRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: Account with the event and where the metrics will be put.
        :param pulumi.Input[str] description: Provides additional information about the rule.
        :param pulumi.Input[bool] enabled: True means this rule is enabled. False means the rule is currently not creating metrics.
        :param pulumi.Input[str] name: The name of the rule. This must be unique within an account.
        :param pulumi.Input[str] nrql: Explains how to create metrics from events.
        :param pulumi.Input[str] rule_id: The id, uniquely identifying the rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["description"] = description
        __props__["enabled"] = enabled
        __props__["name"] = name
        __props__["nrql"] = nrql
        __props__["rule_id"] = rule_id
        return EventsToMetricsRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[int]:
        """
        Account with the event and where the metrics will be put.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Provides additional information about the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        True means this rule is enabled. False means the rule is currently not creating metrics.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the rule. This must be unique within an account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nrql(self) -> pulumi.Output[str]:
        """
        Explains how to create metrics from events.
        """
        return pulumi.get(self, "nrql")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        The id, uniquely identifying the rule.
        """
        return pulumi.get(self, "rule_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

