# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InfraAlertCondition']


class InfraAlertCondition(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison: Optional[pulumi.Input[str]] = None,
                 critical: Optional[pulumi.Input[pulumi.InputType['InfraAlertConditionCriticalArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event: Optional[pulumi.Input[str]] = None,
                 integration_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[int]] = None,
                 process_where: Optional[pulumi.Input[str]] = None,
                 runbook_url: Optional[pulumi.Input[str]] = None,
                 select: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 violation_close_timer: Optional[pulumi.Input[int]] = None,
                 warning: Optional[pulumi.Input[pulumi.InputType['InfraAlertConditionWarningArgs']]] = None,
                 where: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to create and manage Infrastructure alert conditions in New Relic.

        > **NOTE:** The NrqlAlertCondition resource is preferred for configuring alerts conditions. In most cases feature parity can be achieved with a NRQL query. Other condition types may be deprecated in the future and receive fewer product updates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo")
        high_disk_usage = newrelic.InfraAlertCondition("highDiskUsage",
            policy_id=foo.id,
            type="infra_metric",
            event="StorageSample",
            select="diskUsedPercent",
            comparison="above",
            where="(hostname LIKE '%frontend%')",
            critical=newrelic.InfraAlertConditionCriticalArgs(
                duration=25,
                value=90,
                time_function="all",
            ),
            warning=newrelic.InfraAlertConditionWarningArgs(
                duration=10,
                value=80,
                time_function="all",
            ))
        high_db_conn_count = newrelic.InfraAlertCondition("highDbConnCount",
            policy_id=foo.id,
            type="infra_metric",
            event="DatastoreSample",
            select="provider.databaseConnections.Average",
            comparison="above",
            where="(hostname LIKE '%db%')",
            integration_provider="RdsDbInstance",
            critical=newrelic.InfraAlertConditionCriticalArgs(
                duration=25,
                value=90,
                time_function="all",
            ))
        process_not_running = newrelic.InfraAlertCondition("processNotRunning",
            policy_id=foo.id,
            type="infra_process_running",
            comparison="equal",
            where="hostname = 'web01'",
            process_where="commandName = '/usr/bin/ruby'",
            critical=newrelic.InfraAlertConditionCriticalArgs(
                duration=5,
                value=0,
            ))
        host_not_reporting = newrelic.InfraAlertCondition("hostNotReporting",
            policy_id=foo.id,
            type="infra_host_not_reporting",
            where="(hostname LIKE '%frontend%')",
            critical=newrelic.InfraAlertConditionCriticalArgs(
                duration=5,
            ))
        ```
        ## Thresholds

        The `critical` and `warning` threshold mapping supports the following arguments:

          * `duration` - (Required) Identifies the number of minutes the threshold must be passed or met for the alert to trigger. Threshold durations must be between 1 and 60 minutes (inclusive).
          * `value` - (Optional) Threshold value, computed against the `comparison` operator. Supported by `infra_metric` and `infra_process_running` alert condition types.
          * `time_function` - (Optional) Indicates if the condition needs to be sustained or to just break the threshold once; `all` or `any`. Supported by the `infra_metric` alert condition type.

        ## Import

        Infrastructure alert conditions can be imported using a composite ID of `<policy_id>:<condition_id>`, e.g.

        ```sh
         $ pulumi import newrelic:index/infraAlertCondition:InfraAlertCondition main 12345:67890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comparison: The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        :param pulumi.Input[pulumi.InputType['InfraAlertConditionCriticalArgs']] critical: Identifies the threshold parameters for opening a critical alert violation. See Thresholds below for details.
        :param pulumi.Input[str] description: The description of the Infrastructure alert condition.
        :param pulumi.Input[bool] enabled: Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        :param pulumi.Input[str] event: The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[str] integration_provider: For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[str] name: The Infrastructure alert condition's name.
        :param pulumi.Input[int] policy_id: The ID of the alert policy where this condition should be used.
        :param pulumi.Input[str] process_where: Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        :param pulumi.Input[str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[str] select: The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[str] type: The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        :param pulumi.Input[int] violation_close_timer: Determines how much time will pass before a violation is automatically closed. Setting the time limit to 0 prevents a violation from being force-closed.
        :param pulumi.Input[pulumi.InputType['InfraAlertConditionWarningArgs']] warning: Identifies the threshold parameters for opening a warning alert violation. See Thresholds below for details.
        :param pulumi.Input[str] where: If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['comparison'] = comparison
            __props__['critical'] = critical
            __props__['description'] = description
            __props__['enabled'] = enabled
            __props__['event'] = event
            __props__['integration_provider'] = integration_provider
            __props__['name'] = name
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__['policy_id'] = policy_id
            __props__['process_where'] = process_where
            __props__['runbook_url'] = runbook_url
            __props__['select'] = select
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['violation_close_timer'] = violation_close_timer
            __props__['warning'] = warning
            __props__['where'] = where
            __props__['created_at'] = None
            __props__['updated_at'] = None
        super(InfraAlertCondition, __self__).__init__(
            'newrelic:index/infraAlertCondition:InfraAlertCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comparison: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[int]] = None,
            critical: Optional[pulumi.Input[pulumi.InputType['InfraAlertConditionCriticalArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            event: Optional[pulumi.Input[str]] = None,
            integration_provider: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[int]] = None,
            process_where: Optional[pulumi.Input[str]] = None,
            runbook_url: Optional[pulumi.Input[str]] = None,
            select: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[int]] = None,
            violation_close_timer: Optional[pulumi.Input[int]] = None,
            warning: Optional[pulumi.Input[pulumi.InputType['InfraAlertConditionWarningArgs']]] = None,
            where: Optional[pulumi.Input[str]] = None) -> 'InfraAlertCondition':
        """
        Get an existing InfraAlertCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comparison: The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        :param pulumi.Input[int] created_at: The timestamp the alert condition was created.
        :param pulumi.Input[pulumi.InputType['InfraAlertConditionCriticalArgs']] critical: Identifies the threshold parameters for opening a critical alert violation. See Thresholds below for details.
        :param pulumi.Input[str] description: The description of the Infrastructure alert condition.
        :param pulumi.Input[bool] enabled: Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        :param pulumi.Input[str] event: The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[str] integration_provider: For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[str] name: The Infrastructure alert condition's name.
        :param pulumi.Input[int] policy_id: The ID of the alert policy where this condition should be used.
        :param pulumi.Input[str] process_where: Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        :param pulumi.Input[str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[str] select: The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[str] type: The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        :param pulumi.Input[int] updated_at: The timestamp the alert condition was last updated.
        :param pulumi.Input[int] violation_close_timer: Determines how much time will pass before a violation is automatically closed. Setting the time limit to 0 prevents a violation from being force-closed.
        :param pulumi.Input[pulumi.InputType['InfraAlertConditionWarningArgs']] warning: Identifies the threshold parameters for opening a warning alert violation. See Thresholds below for details.
        :param pulumi.Input[str] where: If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["comparison"] = comparison
        __props__["created_at"] = created_at
        __props__["critical"] = critical
        __props__["description"] = description
        __props__["enabled"] = enabled
        __props__["event"] = event
        __props__["integration_provider"] = integration_provider
        __props__["name"] = name
        __props__["policy_id"] = policy_id
        __props__["process_where"] = process_where
        __props__["runbook_url"] = runbook_url
        __props__["select"] = select
        __props__["type"] = type
        __props__["updated_at"] = updated_at
        __props__["violation_close_timer"] = violation_close_timer
        __props__["warning"] = warning
        __props__["where"] = where
        return InfraAlertCondition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comparison(self) -> pulumi.Output[Optional[str]]:
        """
        The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[int]:
        """
        The timestamp the alert condition was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def critical(self) -> pulumi.Output[Optional['outputs.InfraAlertConditionCritical']]:
        """
        Identifies the threshold parameters for opening a critical alert violation. See Thresholds below for details.
        """
        return pulumi.get(self, "critical")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Infrastructure alert condition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def event(self) -> pulumi.Output[str]:
        """
        The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter(name="integrationProvider")
    def integration_provider(self) -> pulumi.Output[Optional[str]]:
        """
        For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "integration_provider")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Infrastructure alert condition's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[int]:
        """
        The ID of the alert policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="processWhere")
    def process_where(self) -> pulumi.Output[Optional[str]]:
        """
        Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        """
        return pulumi.get(self, "process_where")

    @property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> pulumi.Output[Optional[str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @property
    @pulumi.getter
    def select(self) -> pulumi.Output[Optional[str]]:
        """
        The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "select")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[int]:
        """
        The timestamp the alert condition was last updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> pulumi.Output[Optional[int]]:
        """
        Determines how much time will pass before a violation is automatically closed. Setting the time limit to 0 prevents a violation from being force-closed.
        """
        return pulumi.get(self, "violation_close_timer")

    @property
    @pulumi.getter
    def warning(self) -> pulumi.Output[Optional['outputs.InfraAlertConditionWarning']]:
        """
        Identifies the threshold parameters for opening a warning alert violation. See Thresholds below for details.
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter
    def where(self) -> pulumi.Output[Optional[str]]:
        """
        If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        return pulumi.get(self, "where")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

