# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Event']


class Event(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventEventArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to create one or more Insights events.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.insights.Event("foo", events=[newrelic.insights.EventEventArgs(
            attributes=[
                newrelic.insights.EventEventAttributeArgs(
                    key="a_string_attribute",
                    value="a string",
                ),
                newrelic.insights.EventEventAttributeArgs(
                    key="an_integer_attribute",
                    type="int",
                    value="42",
                ),
                newrelic.insights.EventEventAttributeArgs(
                    key="a_float_attribute",
                    type="float",
                    value="101.1",
                ),
            ],
            timestamp=1232471100,
            type="MyEvent",
        )])
        ```
        ## Events

        The `event` mapping supports the following arguments:

          * `type` - (Required) The event's name. Can be a combination of alphanumeric characters, underscores, and colons.
          * `timestamp` - (Optional) Must be a Unix epoch timestamp. You can define timestamps either in seconds or in milliseconds.
          * `attribute` - (Required) An attribute to include in your event payload. Multiple attribute blocks can be defined for an event. See Attributes below for details.

        ### Attributes

        The `attribute` mapping supports the following arguments:

          * `key` - (Required) The name of the attribute.
          * `value` - (Required) The value of the attribute.
          * `type` - (Optional) Specify the type for the attribute value. This is useful when passing integer or float values to Insights. Allowed values are `string`, `int`, or `float`. Defaults to `string`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventEventArgs']]]] events: An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if events is None and not opts.urn:
                raise TypeError("Missing required property 'events'")
            __props__['events'] = events
        super(Event, __self__).__init__(
            'newrelic:insights/event:Event',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            events: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventEventArgs']]]]] = None) -> 'Event':
        """
        Get an existing Event resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventEventArgs']]]] events: An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["events"] = events
        return Event(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Output[Sequence['outputs.EventEvent']]:
        """
        An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        return pulumi.get(self, "events")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

