# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs

__all__ = [
    'AlertChannelConfig',
    'AlertConditionTerm',
    'AlertMutingRuleCondition',
    'AlertMutingRuleConditionCondition',
    'DashboardFilter',
    'DashboardWidget',
    'DashboardWidgetCompareWith',
    'DashboardWidgetCompareWithPresentation',
    'DashboardWidgetMetric',
    'EntityTagsTag',
    'InfraAlertConditionCritical',
    'InfraAlertConditionWarning',
    'NrqlAlertConditionCritical',
    'NrqlAlertConditionNrql',
    'NrqlAlertConditionTerm',
    'NrqlAlertConditionWarning',
    'OneDashboardPage',
    'OneDashboardPageWidgetArea',
    'OneDashboardPageWidgetAreaNrqlQuery',
    'OneDashboardPageWidgetBar',
    'OneDashboardPageWidgetBarNrqlQuery',
    'OneDashboardPageWidgetBillboard',
    'OneDashboardPageWidgetBillboardNrqlQuery',
    'OneDashboardPageWidgetLine',
    'OneDashboardPageWidgetLineNrqlQuery',
    'OneDashboardPageWidgetMarkdown',
    'OneDashboardPageWidgetPy',
    'OneDashboardPageWidgetPyNrqlQuery',
    'OneDashboardPageWidgetTable',
    'OneDashboardPageWidgetTableNrqlQuery',
    'GetAlertChannelConfigResult',
    'GetEntityTagResult',
]

@pulumi.output_type
class AlertChannelConfig(dict):
    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 auth_password: Optional[str] = None,
                 auth_type: Optional[str] = None,
                 auth_username: Optional[str] = None,
                 base_url: Optional[str] = None,
                 channel: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 headers_string: Optional[str] = None,
                 include_json_attachment: Optional[str] = None,
                 key: Optional[str] = None,
                 payload: Optional[Mapping[str, str]] = None,
                 payload_string: Optional[str] = None,
                 payload_type: Optional[str] = None,
                 recipients: Optional[str] = None,
                 region: Optional[str] = None,
                 route_key: Optional[str] = None,
                 service_key: Optional[str] = None,
                 tags: Optional[str] = None,
                 teams: Optional[str] = None,
                 url: Optional[str] = None,
                 user_id: Optional[str] = None):
        """
        :param str api_key: The API key for integrating with OpsGenie.
        :param str auth_password: Specifies an authentication password for use with a channel.  Supported by the `webhook` channel type.
        :param str auth_type: Specifies an authentication method for use with a channel.  Supported by the `webhook` channel type.  Only HTTP basic authentication is currently supported via the value `BASIC`.
        :param str auth_username: Specifies an authentication username for use with a channel.  Supported by the `webhook` channel type.
        :param str base_url: The base URL of the webhook destination.
        :param str channel: The Slack channel to send notifications to.
               * `opsgenie`
        :param Mapping[str, str] headers: A map of key/value pairs that represents extra HTTP headers to be sent along with the webhook payload.
        :param str headers_string: Use instead of `headers` if the desired payload is more complex than a list of key/value pairs (e.g. a set of headers that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `headers`.
        :param str include_json_attachment: `0` or `1`. Flag for whether or not to attach a JSON document containing information about the associated alert to the email that is sent to recipients.
               * `webhook`
        :param str key: The key for integrating with VictorOps.
        :param Mapping[str, str] payload: A map of key/value pairs that represents the webhook payload.  Must provide `payload_type` if setting this argument.
        :param str payload_string: Use instead of `payload` if the desired payload is more complex than a list of key/value pairs (e.g. a payload that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `payload`.
        :param str payload_type: Can either be `application/json` or `application/x-www-form-urlencoded`. The `payload_type` argument is _required_ if `payload` is set.
               * `pagerduty`
        :param str recipients: A set of recipients for targeting notifications.  Multiple values are comma separated.
        :param str region: The data center region to store your data.  Valid values are `US` and `EU`.  Default is `US`.
        :param str route_key: The route key for integrating with VictorOps.
               * `slack`
        :param str service_key: Specifies the service key for integrating with Pagerduty.
               * `victorops`
        :param str tags: A set of tags for targeting notifications. Multiple values are comma separated.
        :param str teams: A set of teams for targeting notifications. Multiple values are comma separated.
        :param str url: [Slack Webhook URL](https://slack.com/intl/en-es/help/articles/115005265063-Incoming-webhooks-for-Slack).
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if headers_string is not None:
            pulumi.set(__self__, "headers_string", headers_string)
        if include_json_attachment is not None:
            pulumi.set(__self__, "include_json_attachment", include_json_attachment)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_string is not None:
            pulumi.set(__self__, "payload_string", payload_string)
        if payload_type is not None:
            pulumi.set(__self__, "payload_type", payload_type)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_key is not None:
            pulumi.set(__self__, "route_key", route_key)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        The API key for integrating with OpsGenie.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[str]:
        """
        Specifies an authentication password for use with a channel.  Supported by the `webhook` channel type.
        """
        return pulumi.get(self, "auth_password")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[str]:
        """
        Specifies an authentication method for use with a channel.  Supported by the `webhook` channel type.  Only HTTP basic authentication is currently supported via the value `BASIC`.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[str]:
        """
        Specifies an authentication username for use with a channel.  Supported by the `webhook` channel type.
        """
        return pulumi.get(self, "auth_username")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[str]:
        """
        The base URL of the webhook destination.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def channel(self) -> Optional[str]:
        """
        The Slack channel to send notifications to.
        * `opsgenie`
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        A map of key/value pairs that represents extra HTTP headers to be sent along with the webhook payload.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="headersString")
    def headers_string(self) -> Optional[str]:
        """
        Use instead of `headers` if the desired payload is more complex than a list of key/value pairs (e.g. a set of headers that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `headers`.
        """
        return pulumi.get(self, "headers_string")

    @property
    @pulumi.getter(name="includeJsonAttachment")
    def include_json_attachment(self) -> Optional[str]:
        """
        `0` or `1`. Flag for whether or not to attach a JSON document containing information about the associated alert to the email that is sent to recipients.
        * `webhook`
        """
        return pulumi.get(self, "include_json_attachment")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key for integrating with VictorOps.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def payload(self) -> Optional[Mapping[str, str]]:
        """
        A map of key/value pairs that represents the webhook payload.  Must provide `payload_type` if setting this argument.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadString")
    def payload_string(self) -> Optional[str]:
        """
        Use instead of `payload` if the desired payload is more complex than a list of key/value pairs (e.g. a payload that makes use of nested objects).  The value provided should be a valid JSON string with escaped double quotes. Conflicts with `payload`.
        """
        return pulumi.get(self, "payload_string")

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> Optional[str]:
        """
        Can either be `application/json` or `application/x-www-form-urlencoded`. The `payload_type` argument is _required_ if `payload` is set.
        * `pagerduty`
        """
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter
    def recipients(self) -> Optional[str]:
        """
        A set of recipients for targeting notifications.  Multiple values are comma separated.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The data center region to store your data.  Valid values are `US` and `EU`.  Default is `US`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> Optional[str]:
        """
        The route key for integrating with VictorOps.
        * `slack`
        """
        return pulumi.get(self, "route_key")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[str]:
        """
        Specifies the service key for integrating with Pagerduty.
        * `victorops`
        """
        return pulumi.get(self, "service_key")

    @property
    @pulumi.getter
    def tags(self) -> Optional[str]:
        """
        A set of tags for targeting notifications. Multiple values are comma separated.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def teams(self) -> Optional[str]:
        """
        A set of teams for targeting notifications. Multiple values are comma separated.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        [Slack Webhook URL](https://slack.com/intl/en-es/help/articles/115005265063-Incoming-webhooks-for-Slack).
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        return pulumi.get(self, "user_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AlertConditionTerm(dict):
    def __init__(__self__, *,
                 duration: int,
                 threshold: float,
                 time_function: str,
                 operator: Optional[str] = None,
                 priority: Optional[str] = None):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_function", time_function)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> str:
        return pulumi.get(self, "time_function")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        return pulumi.get(self, "priority")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AlertMutingRuleCondition(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.AlertMutingRuleConditionCondition'],
                 operator: str):
        """
        :param Sequence['AlertMutingRuleConditionConditionArgs'] conditions: The individual MutingRuleConditions within the group. See Nested conditions blocks below for details.
        :param str operator: The operator used to combine all the MutingRuleConditions within the group.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "operator", operator)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.AlertMutingRuleConditionCondition']:
        """
        The individual MutingRuleConditions within the group. See Nested conditions blocks below for details.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator used to combine all the MutingRuleConditions within the group.
        """
        return pulumi.get(self, "operator")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AlertMutingRuleConditionCondition(dict):
    def __init__(__self__, *,
                 attribute: str,
                 operator: str,
                 values: Sequence[str]):
        """
        :param str attribute: The attribute on a violation.
        :param str operator: The operator used to compare the attribute's value with the supplied value(s)
        :param Sequence[str] values: The value(s) to compare against the attribute's value.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The attribute on a violation.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator used to compare the attribute's value with the supplied value(s)
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value(s) to compare against the attribute's value.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DashboardFilter(dict):
    def __init__(__self__, *,
                 event_types: Sequence[str],
                 attributes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] event_types: (Optional) A list of event types to enable filtering for.
        :param Sequence[str] attributes: (Optional) A list of attributes belonging to the specified event types to enable filtering for.
        """
        pulumi.set(__self__, "event_types", event_types)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Sequence[str]:
        """
        (Optional) A list of event types to enable filtering for.
        """
        return pulumi.get(self, "event_types")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Sequence[str]]:
        """
        (Optional) A list of attributes belonging to the specified event types to enable filtering for.
        """
        return pulumi.get(self, "attributes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DashboardWidget(dict):
    def __init__(__self__, *,
                 column: int,
                 row: int,
                 title: str,
                 visualization: str,
                 account_id: Optional[int] = None,
                 compare_withs: Optional[Sequence['outputs.DashboardWidgetCompareWith']] = None,
                 drilldown_dashboard_id: Optional[int] = None,
                 duration: Optional[int] = None,
                 end_time: Optional[int] = None,
                 entity_ids: Optional[Sequence[int]] = None,
                 facet: Optional[str] = None,
                 height: Optional[int] = None,
                 limit: Optional[int] = None,
                 metrics: Optional[Sequence['outputs.DashboardWidgetMetric']] = None,
                 notes: Optional[str] = None,
                 nrql: Optional[str] = None,
                 order_by: Optional[str] = None,
                 raw_metric_name: Optional[str] = None,
                 source: Optional[str] = None,
                 threshold_red: Optional[float] = None,
                 threshold_yellow: Optional[float] = None,
                 widget_id: Optional[int] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: The title of the dashboard.
        :param str visualization: (Required) How the widget visualizes data.  Valid values are `billboard`, `gauge`, `billboard_comparison`, `facet_bar_chart`, `faceted_line_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `heatmap`, `attribute_sheet`, `single_event`, `histogram`, `funnel`, `raw_json`, `event_feed`, `event_table`, `uniques_list`, `line_chart`, `comparison_line_chart`, `markdown`, and `metric_line_chart`.
        :param int account_id: (Optional) The account ID to use when querying data. If `account_id` is omitted, the widget will use the account ID associated with the API key used in your provider configuration. You can also use `account_id` to configure cross-account widgets or simply to be explicit about which account the widget will be pulling data from.
        :param int drilldown_dashboard_id: (Optional) The ID of a dashboard to link to from the widget's facets.
               * `attribute_sheet`, `comparison_line_chart`, `event_feed`, `event_table`, `funnel`, `histogram`, `line_chart`, `raw_json`, `single_event`, or `uniques_list`:
        :param int duration: (Required) The duration, in ms, of the time window represented in the chart.
        :param int end_time: (Optional) The end time of the time window represented in the chart in epoch time.  When not set, the time window will end at the current time.
        :param Sequence[int] entity_ids: (Required) A collection of entity IDs to display data. These are typically application IDs.
        :param str facet: (Optional) Can be set to "host" to facet the metric data by host.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        :param int limit: (Optional) The limit of distinct data series to display.  Requires `order_by` to be set.
        :param Sequence['DashboardWidgetMetricArgs'] metrics: (Required) A nested block that describes a metric.  Nested `metric` blocks support the following arguments:
        :param str notes: (Optional) Description of the widget.
        :param str nrql: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
               * `markdown`:
        :param str order_by: (Optional) Set the order of the results.  Required when using `limit`.
               * `application_breakdown`:
        :param str source: (Required) The markdown source to be rendered in the widget.
               * `metric_line_chart`:
        :param float threshold_red: (Required) Threshold above which the displayed value will be styled with a red color.
        :param float threshold_yellow: (Optional) Threshold above which the displayed value will be styled with a yellow color.
               * `facet_bar_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `faceted_line_chart`, or `heatmap`:
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "visualization", visualization)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if compare_withs is not None:
            pulumi.set(__self__, "compare_withs", compare_withs)
        if drilldown_dashboard_id is not None:
            pulumi.set(__self__, "drilldown_dashboard_id", drilldown_dashboard_id)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if entity_ids is not None:
            pulumi.set(__self__, "entity_ids", entity_ids)
        if facet is not None:
            pulumi.set(__self__, "facet", facet)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if nrql is not None:
            pulumi.set(__self__, "nrql", nrql)
        if order_by is not None:
            pulumi.set(__self__, "order_by", order_by)
        if raw_metric_name is not None:
            pulumi.set(__self__, "raw_metric_name", raw_metric_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if threshold_red is not None:
            pulumi.set(__self__, "threshold_red", threshold_red)
        if threshold_yellow is not None:
            pulumi.set(__self__, "threshold_yellow", threshold_yellow)
        if widget_id is not None:
            pulumi.set(__self__, "widget_id", widget_id)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def visualization(self) -> str:
        """
        (Required) How the widget visualizes data.  Valid values are `billboard`, `gauge`, `billboard_comparison`, `facet_bar_chart`, `faceted_line_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `heatmap`, `attribute_sheet`, `single_event`, `histogram`, `funnel`, `raw_json`, `event_feed`, `event_table`, `uniques_list`, `line_chart`, `comparison_line_chart`, `markdown`, and `metric_line_chart`.
        """
        return pulumi.get(self, "visualization")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[int]:
        """
        (Optional) The account ID to use when querying data. If `account_id` is omitted, the widget will use the account ID associated with the API key used in your provider configuration. You can also use `account_id` to configure cross-account widgets or simply to be explicit about which account the widget will be pulling data from.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="compareWiths")
    def compare_withs(self) -> Optional[Sequence['outputs.DashboardWidgetCompareWith']]:
        return pulumi.get(self, "compare_withs")

    @property
    @pulumi.getter(name="drilldownDashboardId")
    def drilldown_dashboard_id(self) -> Optional[int]:
        """
        (Optional) The ID of a dashboard to link to from the widget's facets.
        * `attribute_sheet`, `comparison_line_chart`, `event_feed`, `event_table`, `funnel`, `histogram`, `line_chart`, `raw_json`, `single_event`, or `uniques_list`:
        """
        return pulumi.get(self, "drilldown_dashboard_id")

    @property
    @pulumi.getter
    def duration(self) -> Optional[int]:
        """
        (Required) The duration, in ms, of the time window represented in the chart.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[int]:
        """
        (Optional) The end time of the time window represented in the chart in epoch time.  When not set, the time window will end at the current time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="entityIds")
    def entity_ids(self) -> Optional[Sequence[int]]:
        """
        (Required) A collection of entity IDs to display data. These are typically application IDs.
        """
        return pulumi.get(self, "entity_ids")

    @property
    @pulumi.getter
    def facet(self) -> Optional[str]:
        """
        (Optional) Can be set to "host" to facet the metric data by host.
        """
        return pulumi.get(self, "facet")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        """
        (Optional) The limit of distinct data series to display.  Requires `order_by` to be set.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.DashboardWidgetMetric']]:
        """
        (Required) A nested block that describes a metric.  Nested `metric` blocks support the following arguments:
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        (Optional) Description of the widget.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def nrql(self) -> Optional[str]:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        * `markdown`:
        """
        return pulumi.get(self, "nrql")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[str]:
        """
        (Optional) Set the order of the results.  Required when using `limit`.
        * `application_breakdown`:
        """
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter(name="rawMetricName")
    def raw_metric_name(self) -> Optional[str]:
        return pulumi.get(self, "raw_metric_name")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        (Required) The markdown source to be rendered in the widget.
        * `metric_line_chart`:
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="thresholdRed")
    def threshold_red(self) -> Optional[float]:
        """
        (Required) Threshold above which the displayed value will be styled with a red color.
        """
        return pulumi.get(self, "threshold_red")

    @property
    @pulumi.getter(name="thresholdYellow")
    def threshold_yellow(self) -> Optional[float]:
        """
        (Optional) Threshold above which the displayed value will be styled with a yellow color.
        * `facet_bar_chart`, `facet_pie_chart`, `facet_table`, `faceted_area_chart`, `faceted_line_chart`, or `heatmap`:
        """
        return pulumi.get(self, "threshold_yellow")

    @property
    @pulumi.getter(name="widgetId")
    def widget_id(self) -> Optional[int]:
        return pulumi.get(self, "widget_id")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `3` inclusive.  Defaults to `1`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DashboardWidgetCompareWith(dict):
    def __init__(__self__, *,
                 offset_duration: str,
                 presentation: 'outputs.DashboardWidgetCompareWithPresentation'):
        pulumi.set(__self__, "offset_duration", offset_duration)
        pulumi.set(__self__, "presentation", presentation)

    @property
    @pulumi.getter(name="offsetDuration")
    def offset_duration(self) -> str:
        return pulumi.get(self, "offset_duration")

    @property
    @pulumi.getter
    def presentation(self) -> 'outputs.DashboardWidgetCompareWithPresentation':
        return pulumi.get(self, "presentation")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DashboardWidgetCompareWithPresentation(dict):
    def __init__(__self__, *,
                 color: str,
                 name: str):
        """
        :param str name: (Required) The metric name to display.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def color(self) -> str:
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Required) The metric name to display.
        """
        return pulumi.get(self, "name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DashboardWidgetMetric(dict):
    def __init__(__self__, *,
                 name: str,
                 scope: Optional[str] = None,
                 units: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str name: (Required) The metric name to display.
        :param Sequence[str] values: (Required) The metric values to display.
        """
        pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if units is not None:
            pulumi.set(__self__, "units", units)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Required) The metric name to display.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def units(self) -> Optional[str]:
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        (Required) The metric values to display.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EntityTagsTag(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: The tag key.
        :param Sequence[str] values: The tag values.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The tag values.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InfraAlertConditionCritical(dict):
    def __init__(__self__, *,
                 duration: int,
                 time_function: Optional[str] = None,
                 value: Optional[float] = None):
        pulumi.set(__self__, "duration", duration)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[str]:
        return pulumi.get(self, "time_function")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InfraAlertConditionWarning(dict):
    def __init__(__self__, *,
                 duration: int,
                 time_function: Optional[str] = None,
                 value: Optional[float] = None):
        pulumi.set(__self__, "duration", duration)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[str]:
        return pulumi.get(self, "time_function")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NrqlAlertConditionCritical(dict):
    def __init__(__self__, *,
                 threshold: float,
                 duration: Optional[int] = None,
                 operator: Optional[str] = None,
                 threshold_duration: Optional[int] = None,
                 threshold_occurrences: Optional[str] = None,
                 time_function: Optional[str] = None):
        pulumi.set(__self__, "threshold", threshold)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold_duration is not None:
            pulumi.set(__self__, "threshold_duration", threshold_duration)
        if threshold_occurrences is not None:
            pulumi.set(__self__, "threshold_occurrences", threshold_occurrences)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def duration(self) -> Optional[int]:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="thresholdDuration")
    def threshold_duration(self) -> Optional[int]:
        return pulumi.get(self, "threshold_duration")

    @property
    @pulumi.getter(name="thresholdOccurrences")
    def threshold_occurrences(self) -> Optional[str]:
        return pulumi.get(self, "threshold_occurrences")

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[str]:
        return pulumi.get(self, "time_function")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NrqlAlertConditionNrql(dict):
    def __init__(__self__, *,
                 query: str,
                 evaluation_offset: Optional[int] = None,
                 since_value: Optional[str] = None):
        pulumi.set(__self__, "query", query)
        if evaluation_offset is not None:
            pulumi.set(__self__, "evaluation_offset", evaluation_offset)
        if since_value is not None:
            pulumi.set(__self__, "since_value", since_value)

    @property
    @pulumi.getter
    def query(self) -> str:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="evaluationOffset")
    def evaluation_offset(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_offset")

    @property
    @pulumi.getter(name="sinceValue")
    def since_value(self) -> Optional[str]:
        return pulumi.get(self, "since_value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NrqlAlertConditionTerm(dict):
    def __init__(__self__, *,
                 threshold: float,
                 duration: Optional[int] = None,
                 operator: Optional[str] = None,
                 priority: Optional[str] = None,
                 threshold_duration: Optional[int] = None,
                 threshold_occurrences: Optional[str] = None,
                 time_function: Optional[str] = None):
        pulumi.set(__self__, "threshold", threshold)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if threshold_duration is not None:
            pulumi.set(__self__, "threshold_duration", threshold_duration)
        if threshold_occurrences is not None:
            pulumi.set(__self__, "threshold_occurrences", threshold_occurrences)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def duration(self) -> Optional[int]:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="thresholdDuration")
    def threshold_duration(self) -> Optional[int]:
        return pulumi.get(self, "threshold_duration")

    @property
    @pulumi.getter(name="thresholdOccurrences")
    def threshold_occurrences(self) -> Optional[str]:
        return pulumi.get(self, "threshold_occurrences")

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[str]:
        return pulumi.get(self, "time_function")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NrqlAlertConditionWarning(dict):
    def __init__(__self__, *,
                 threshold: float,
                 duration: Optional[int] = None,
                 operator: Optional[str] = None,
                 threshold_duration: Optional[int] = None,
                 threshold_occurrences: Optional[str] = None,
                 time_function: Optional[str] = None):
        pulumi.set(__self__, "threshold", threshold)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold_duration is not None:
            pulumi.set(__self__, "threshold_duration", threshold_duration)
        if threshold_occurrences is not None:
            pulumi.set(__self__, "threshold_occurrences", threshold_occurrences)
        if time_function is not None:
            pulumi.set(__self__, "time_function", time_function)

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def duration(self) -> Optional[int]:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="thresholdDuration")
    def threshold_duration(self) -> Optional[int]:
        return pulumi.get(self, "threshold_duration")

    @property
    @pulumi.getter(name="thresholdOccurrences")
    def threshold_occurrences(self) -> Optional[str]:
        return pulumi.get(self, "threshold_occurrences")

    @property
    @pulumi.getter(name="timeFunction")
    def time_function(self) -> Optional[str]:
        return pulumi.get(self, "time_function")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPage(dict):
    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 guid: Optional[str] = None,
                 widget_areas: Optional[Sequence['outputs.OneDashboardPageWidgetArea']] = None,
                 widget_bars: Optional[Sequence['outputs.OneDashboardPageWidgetBar']] = None,
                 widget_billboards: Optional[Sequence['outputs.OneDashboardPageWidgetBillboard']] = None,
                 widget_lines: Optional[Sequence['outputs.OneDashboardPageWidgetLine']] = None,
                 widget_markdowns: Optional[Sequence['outputs.OneDashboardPageWidgetMarkdown']] = None,
                 widget_pies: Optional[Sequence['outputs.OneDashboardPageWidgetPy']] = None,
                 widget_tables: Optional[Sequence['outputs.OneDashboardPageWidgetTable']] = None):
        """
        :param str name: The title of the dashboard.
        :param str description: Brief text describing the dashboard.
        :param str guid: The unique entity identifier of the dashboard page in New Relic.
        :param Sequence['OneDashboardPageWidgetAreaArgs'] widget_areas: (Optional) A nested block that describes an Area widget.  See Nested widget blocks below for details.
        :param Sequence['OneDashboardPageWidgetBarArgs'] widget_bars: (Optional) A nested block that describes a Bar widget.  See Nested widget blocks below for details.
        :param Sequence['OneDashboardPageWidgetBillboardArgs'] widget_billboards: (Optional) A nested block that describes a Billboard widget.  See Nested widget blocks below for details.
        :param Sequence['OneDashboardPageWidgetLineArgs'] widget_lines: (Optional) A nested block that describes a Line widget.  See Nested widget blocks below for details.
        :param Sequence['OneDashboardPageWidgetMarkdownArgs'] widget_markdowns: (Optional) A nested block that describes a Markdown widget.  See Nested widget blocks below for details.
        :param Sequence['OneDashboardPageWidgetPyArgs'] widget_pies: (Optional) A nested block that describes a Pie widget.  See Nested widget blocks below for details.
        :param Sequence['OneDashboardPageWidgetTableArgs'] widget_tables: (Optional) A nested block that describes a Table widget.  See Nested widget blocks below for details.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if widget_areas is not None:
            pulumi.set(__self__, "widget_areas", widget_areas)
        if widget_bars is not None:
            pulumi.set(__self__, "widget_bars", widget_bars)
        if widget_billboards is not None:
            pulumi.set(__self__, "widget_billboards", widget_billboards)
        if widget_lines is not None:
            pulumi.set(__self__, "widget_lines", widget_lines)
        if widget_markdowns is not None:
            pulumi.set(__self__, "widget_markdowns", widget_markdowns)
        if widget_pies is not None:
            pulumi.set(__self__, "widget_pies", widget_pies)
        if widget_tables is not None:
            pulumi.set(__self__, "widget_tables", widget_tables)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Brief text describing the dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def guid(self) -> Optional[str]:
        """
        The unique entity identifier of the dashboard page in New Relic.
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter(name="widgetAreas")
    def widget_areas(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetArea']]:
        """
        (Optional) A nested block that describes an Area widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_areas")

    @property
    @pulumi.getter(name="widgetBars")
    def widget_bars(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetBar']]:
        """
        (Optional) A nested block that describes a Bar widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_bars")

    @property
    @pulumi.getter(name="widgetBillboards")
    def widget_billboards(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetBillboard']]:
        """
        (Optional) A nested block that describes a Billboard widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_billboards")

    @property
    @pulumi.getter(name="widgetLines")
    def widget_lines(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetLine']]:
        """
        (Optional) A nested block that describes a Line widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_lines")

    @property
    @pulumi.getter(name="widgetMarkdowns")
    def widget_markdowns(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetMarkdown']]:
        """
        (Optional) A nested block that describes a Markdown widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_markdowns")

    @property
    @pulumi.getter(name="widgetPies")
    def widget_pies(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetPy']]:
        """
        (Optional) A nested block that describes a Pie widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_pies")

    @property
    @pulumi.getter(name="widgetTables")
    def widget_tables(self) -> Optional[Sequence['outputs.OneDashboardPageWidgetTable']]:
        """
        (Optional) A nested block that describes a Table widget.  See Nested widget blocks below for details.
        """
        return pulumi.get(self, "widget_tables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetArea(dict):
    def __init__(__self__, *,
                 column: int,
                 nrql_queries: Sequence['outputs.OneDashboardPageWidgetAreaNrqlQuery'],
                 row: int,
                 title: str,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param Sequence['OneDashboardPageWidgetAreaNrqlQueryArgs'] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> Sequence['outputs.OneDashboardPageWidgetAreaNrqlQuery']:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetAreaNrqlQuery(dict):
    def __init__(__self__, *,
                 account_id: int,
                 query: str):
        """
        :param int account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param str query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetBar(dict):
    def __init__(__self__, *,
                 column: int,
                 nrql_queries: Sequence['outputs.OneDashboardPageWidgetBarNrqlQuery'],
                 row: int,
                 title: str,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 linked_entity_guids: Optional[Sequence[str]] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param Sequence['OneDashboardPageWidgetBarNrqlQueryArgs'] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linked_entity_guids is not None:
            pulumi.set(__self__, "linked_entity_guids", linked_entity_guids)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> Sequence['outputs.OneDashboardPageWidgetBarNrqlQuery']:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkedEntityGuids")
    def linked_entity_guids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "linked_entity_guids")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetBarNrqlQuery(dict):
    def __init__(__self__, *,
                 account_id: int,
                 query: str):
        """
        :param int account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param str query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetBillboard(dict):
    def __init__(__self__, *,
                 column: int,
                 nrql_queries: Sequence['outputs.OneDashboardPageWidgetBillboardNrqlQuery'],
                 row: int,
                 title: str,
                 critical: Optional[float] = None,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 warning: Optional[float] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param Sequence['OneDashboardPageWidgetBillboardNrqlQueryArgs'] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param float critical: (Optional) Threshold above which the displayed value will be styled with a red color.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param float warning: (Optional) Threshold above which the displayed value will be styled with a yellow color.
               * `widget_markdown`:
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> Sequence['outputs.OneDashboardPageWidgetBillboardNrqlQuery']:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def critical(self) -> Optional[float]:
        """
        (Optional) Threshold above which the displayed value will be styled with a red color.
        """
        return pulumi.get(self, "critical")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def warning(self) -> Optional[float]:
        """
        (Optional) Threshold above which the displayed value will be styled with a yellow color.
        * `widget_markdown`:
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetBillboardNrqlQuery(dict):
    def __init__(__self__, *,
                 account_id: int,
                 query: str):
        """
        :param int account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param str query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetLine(dict):
    def __init__(__self__, *,
                 column: int,
                 nrql_queries: Sequence['outputs.OneDashboardPageWidgetLineNrqlQuery'],
                 row: int,
                 title: str,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 linked_entity_guids: Optional[Sequence[str]] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param Sequence['OneDashboardPageWidgetLineNrqlQueryArgs'] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linked_entity_guids is not None:
            pulumi.set(__self__, "linked_entity_guids", linked_entity_guids)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> Sequence['outputs.OneDashboardPageWidgetLineNrqlQuery']:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkedEntityGuids")
    def linked_entity_guids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "linked_entity_guids")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetLineNrqlQuery(dict):
    def __init__(__self__, *,
                 account_id: int,
                 query: str):
        """
        :param int account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param str query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetMarkdown(dict):
    def __init__(__self__, *,
                 column: int,
                 row: int,
                 title: str,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 text: Optional[str] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param str text: (Required) The markdown source to be rendered in the widget.
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def text(self) -> Optional[str]:
        """
        (Required) The markdown source to be rendered in the widget.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetPy(dict):
    def __init__(__self__, *,
                 column: int,
                 nrql_queries: Sequence['outputs.OneDashboardPageWidgetPyNrqlQuery'],
                 row: int,
                 title: str,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 linked_entity_guids: Optional[Sequence[str]] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param Sequence['OneDashboardPageWidgetPyNrqlQueryArgs'] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linked_entity_guids is not None:
            pulumi.set(__self__, "linked_entity_guids", linked_entity_guids)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> Sequence['outputs.OneDashboardPageWidgetPyNrqlQuery']:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkedEntityGuids")
    def linked_entity_guids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "linked_entity_guids")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetPyNrqlQuery(dict):
    def __init__(__self__, *,
                 account_id: int,
                 query: str):
        """
        :param int account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param str query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetTable(dict):
    def __init__(__self__, *,
                 column: int,
                 nrql_queries: Sequence['outputs.OneDashboardPageWidgetTableNrqlQuery'],
                 row: int,
                 title: str,
                 height: Optional[int] = None,
                 id: Optional[str] = None,
                 width: Optional[int] = None):
        """
        :param int column: (Required) Column position of widget from top left, starting at `1`.
        :param Sequence['OneDashboardPageWidgetTableNrqlQueryArgs'] nrql_queries: (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        :param int row: (Required) Row position of widget from top left, starting at `1`.
        :param str title: (Required) A title for the widget.
        :param int height: (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        :param int width: (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "nrql_queries", nrql_queries)
        pulumi.set(__self__, "row", row)
        pulumi.set(__self__, "title", title)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def column(self) -> int:
        """
        (Required) Column position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="nrqlQueries")
    def nrql_queries(self) -> Sequence['outputs.OneDashboardPageWidgetTableNrqlQuery']:
        """
        (Required) A nested block that describes a NRQL Query. See Nested nrql\_query blocks below for details.
        """
        return pulumi.get(self, "nrql_queries")

    @property
    @pulumi.getter
    def row(self) -> int:
        """
        (Required) Row position of widget from top left, starting at `1`.
        """
        return pulumi.get(self, "row")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        (Required) A title for the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        (Optional) Height of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `3`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        (Optional) Width of the widget.  Valid values are `1` to `12` inclusive.  Defaults to `4`.
        """
        return pulumi.get(self, "width")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneDashboardPageWidgetTableNrqlQuery(dict):
    def __init__(__self__, *,
                 account_id: int,
                 query: str):
        """
        :param int account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param str query: (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        (Required) Valid NRQL query string. See [Writing NRQL Queries](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/using-nrql/introduction-nrql) for help.
        """
        return pulumi.get(self, "query")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetAlertChannelConfigResult(dict):
    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 auth_password: Optional[str] = None,
                 auth_type: Optional[str] = None,
                 auth_username: Optional[str] = None,
                 base_url: Optional[str] = None,
                 channel: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 include_json_attachment: Optional[str] = None,
                 key: Optional[str] = None,
                 payload: Optional[Mapping[str, str]] = None,
                 payload_type: Optional[str] = None,
                 recipients: Optional[str] = None,
                 region: Optional[str] = None,
                 route_key: Optional[str] = None,
                 service_key: Optional[str] = None,
                 tags: Optional[str] = None,
                 teams: Optional[str] = None,
                 url: Optional[str] = None,
                 user_id: Optional[str] = None):
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if include_json_attachment is not None:
            pulumi.set(__self__, "include_json_attachment", include_json_attachment)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_type is not None:
            pulumi.set(__self__, "payload_type", payload_type)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_key is not None:
            pulumi.set(__self__, "route_key", route_key)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[str]:
        return pulumi.get(self, "auth_password")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[str]:
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[str]:
        return pulumi.get(self, "auth_username")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[str]:
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def channel(self) -> Optional[str]:
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="includeJsonAttachment")
    def include_json_attachment(self) -> Optional[str]:
        return pulumi.get(self, "include_json_attachment")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def payload(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> Optional[str]:
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter
    def recipients(self) -> Optional[str]:
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> Optional[str]:
        return pulumi.get(self, "route_key")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[str]:
        return pulumi.get(self, "service_key")

    @property
    @pulumi.getter
    def tags(self) -> Optional[str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def teams(self) -> Optional[str]:
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetEntityTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


