# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'GetPluginResult',
    'AwaitableGetPluginResult',
    'get_plugin',
]

@pulumi.output_type
class GetPluginResult:
    """
    A collection of values returned by getPlugin.
    """
    def __init__(__self__, guid=None, id=None):
        if guid and not isinstance(guid, str):
            raise TypeError("Expected argument 'guid' to be a str")
        pulumi.set(__self__, "guid", guid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def guid(self) -> str:
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the installed plugin instance.
        """
        return pulumi.get(self, "id")


class AwaitableGetPluginResult(GetPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluginResult(
            guid=self.guid,
            id=self.id)


def get_plugin(guid: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluginResult:
    """
    Use this data source to get information about a specific installed plugin in New Relic.

    Each plugin published to New Relic's Plugin Central is assigned a [GUID](https://docs.newrelic.com/docs/plugins/plugin-developer-resources/planning-your-plugin/parts-plugin#guid). Once you have installed a plugin into your account it is assigned an ID. This account-specific ID is required when creating Plugins alert conditions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo_plugin = newrelic.plugins.get_plugin(guid="com.example.my-plugin")
    foo_alert_policy = newrelic.AlertPolicy("fooAlertPolicy")
    foo_alert_condition = newrelic.plugins.AlertCondition("fooAlertCondition",
        policy_id=foo_alert_policy.id,
        metric="Component/Summary/Consumers[consumers]",
        plugin_id=foo_plugin.id,
        plugin_guid=foo_plugin.guid,
        value_function="average",
        metric_description="Queue consumers",
        terms=[newrelic.plugins.AlertConditionTermArgs(
            duration=5,
            operator="below",
            priority="critical",
            threshold=0.75,
            time_function="all",
        )])
    ```


    :param str guid: The GUID of the plugin in New Relic.
    """
    __args__ = dict()
    __args__['guid'] = guid
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('newrelic:plugins/getPlugin:getPlugin', __args__, opts=opts, typ=GetPluginResult).value

    return AwaitableGetPluginResult(
        guid=__ret__.guid,
        id=__ret__.id)
