# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Monitor']


class Monitor(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_head_request: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sla_threshold: Optional[pulumi.Input[float]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 treat_redirect_as_failure: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 validation_string: Optional[pulumi.Input[str]] = None,
                 verify_ssl: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to create, update, and delete a synthetics monitor in New Relic.

        ## Example Usage

        ##### Type: `SIMPLE`
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.Monitor("foo",
            frequency=5,
            locations=[
                "AWS_US_EAST_1",
                "AWS_US_EAST_2",
            ],
            status="ENABLED",
            type="SIMPLE",
            uri="https://example.com",
            validation_string="add example validation check here",
            verify_ssl=True)
        # Optional for type "SIMPLE" and "BROWSER"
        ```

        ##### Type: `BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.Monitor("foo",
            bypass_head_request=True,
            frequency=5,
            locations=["AWS_US_EAST_1"],
            status="ENABLED",
            treat_redirect_as_failure=True,
            type="BROWSER",
            uri="https://example.com",
            validation_string="add example validation check here",
            verify_ssl=True)
        # optional for type "SIMPLE" and "BROWSER"
        ```

        ##### Type: `SCRIPT_BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.Monitor("foo",
            frequency=5,
            locations=["AWS_US_EAST_1"],
            status="ENABLED",
            type="SCRIPT_BROWSER")
        ```

        ##### Type: `SCRIPT_API`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.Monitor("foo",
            frequency=5,
            locations=["AWS_US_EAST_1"],
            status="ENABLED",
            type="SCRIPT_API")
        ```

        ## Import

        Synthetics monitors can be imported using the `id`, e.g. bash

        ```sh
         $ pulumi import newrelic:synthetics/monitor:Monitor main <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] bypass_head_request: Bypass HEAD request.
        :param pulumi.Input[int] frequency: The interval (in minutes) at which this monitor should run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The locations in which this monitor should be run.
        :param pulumi.Input[str] name: The title of this monitor.
        :param pulumi.Input[float] sla_threshold: The base threshold for the SLA report.
        :param pulumi.Input[str] status: The monitor status (i.e. `ENABLED`, `MUTED`, `DISABLED`).
        :param pulumi.Input[bool] treat_redirect_as_failure: Fail the monitor check if redirected.
        :param pulumi.Input[str] type: The monitor type. Valid values are `SIMPLE`, `BROWSER`, `SCRIPT_BROWSER`, and `SCRIPT_API`.
        :param pulumi.Input[str] uri: The URI for the monitor to hit.
        :param pulumi.Input[str] validation_string: The string to validate against in the response.
        :param pulumi.Input[bool] verify_ssl: Verify SSL.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['bypass_head_request'] = bypass_head_request
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__['frequency'] = frequency
            if locations is None and not opts.urn:
                raise TypeError("Missing required property 'locations'")
            __props__['locations'] = locations
            __props__['name'] = name
            __props__['sla_threshold'] = sla_threshold
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__['status'] = status
            __props__['treat_redirect_as_failure'] = treat_redirect_as_failure
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['uri'] = uri
            __props__['validation_string'] = validation_string
            __props__['verify_ssl'] = verify_ssl
        super(Monitor, __self__).__init__(
            'newrelic:synthetics/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass_head_request: Optional[pulumi.Input[bool]] = None,
            frequency: Optional[pulumi.Input[int]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            sla_threshold: Optional[pulumi.Input[float]] = None,
            status: Optional[pulumi.Input[str]] = None,
            treat_redirect_as_failure: Optional[pulumi.Input[bool]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uri: Optional[pulumi.Input[str]] = None,
            validation_string: Optional[pulumi.Input[str]] = None,
            verify_ssl: Optional[pulumi.Input[bool]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] bypass_head_request: Bypass HEAD request.
        :param pulumi.Input[int] frequency: The interval (in minutes) at which this monitor should run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The locations in which this monitor should be run.
        :param pulumi.Input[str] name: The title of this monitor.
        :param pulumi.Input[float] sla_threshold: The base threshold for the SLA report.
        :param pulumi.Input[str] status: The monitor status (i.e. `ENABLED`, `MUTED`, `DISABLED`).
        :param pulumi.Input[bool] treat_redirect_as_failure: Fail the monitor check if redirected.
        :param pulumi.Input[str] type: The monitor type. Valid values are `SIMPLE`, `BROWSER`, `SCRIPT_BROWSER`, and `SCRIPT_API`.
        :param pulumi.Input[str] uri: The URI for the monitor to hit.
        :param pulumi.Input[str] validation_string: The string to validate against in the response.
        :param pulumi.Input[bool] verify_ssl: Verify SSL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["bypass_head_request"] = bypass_head_request
        __props__["frequency"] = frequency
        __props__["locations"] = locations
        __props__["name"] = name
        __props__["sla_threshold"] = sla_threshold
        __props__["status"] = status
        __props__["treat_redirect_as_failure"] = treat_redirect_as_failure
        __props__["type"] = type
        __props__["uri"] = uri
        __props__["validation_string"] = validation_string
        __props__["verify_ssl"] = verify_ssl
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bypassHeadRequest")
    def bypass_head_request(self) -> pulumi.Output[Optional[bool]]:
        """
        Bypass HEAD request.
        """
        return pulumi.get(self, "bypass_head_request")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[int]:
        """
        The interval (in minutes) at which this monitor should run.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence[str]]:
        """
        The locations in which this monitor should be run.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The title of this monitor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="slaThreshold")
    def sla_threshold(self) -> pulumi.Output[Optional[float]]:
        """
        The base threshold for the SLA report.
        """
        return pulumi.get(self, "sla_threshold")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The monitor status (i.e. `ENABLED`, `MUTED`, `DISABLED`).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="treatRedirectAsFailure")
    def treat_redirect_as_failure(self) -> pulumi.Output[Optional[bool]]:
        """
        Fail the monitor check if redirected.
        """
        return pulumi.get(self, "treat_redirect_as_failure")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The monitor type. Valid values are `SIMPLE`, `BROWSER`, `SCRIPT_BROWSER`, and `SCRIPT_API`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[Optional[str]]:
        """
        The URI for the monitor to hit.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="validationString")
    def validation_string(self) -> pulumi.Output[Optional[str]]:
        """
        The string to validate against in the response.
        """
        return pulumi.get(self, "validation_string")

    @property
    @pulumi.getter(name="verifySsl")
    def verify_ssl(self) -> pulumi.Output[Optional[bool]]:
        """
        Verify SSL.
        """
        return pulumi.get(self, "verify_ssl")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

