# mypy-boto3-greengrass

[![PyPI - mypy-boto3-greengrass](https://img.shields.io/pypi/v/mypy-boto3-greengrass.svg?color=blue)](https://pypi.org/project/mypy-boto3-greengrass)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-greengrass.svg?color=blue)](https://pypi.org/project/mypy-boto3-greengrass)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Greengrass 1.17.20](https://boto3.amazonaws.com/v1/documentation/api/1.17.20/reference/services/greengrass.html#Greengrass) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-greengrass](#mypy-boto3-greengrass)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Greengrass` service.

```bash
python -m pip install boto3-stubs[greengrass]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[greengrass]` in your environment: `python -m pip install 'boto3-stubs[greengrass]'`

Both type checking and auto-complete should work for `Greengrass` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[greengrass]` in your environment: `python -m pip install 'boto3-stubs[greengrass]'`

Both type checking and auto-complete should work for `Greengrass` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[greengrass]` in your environment: `python -m pip install 'boto3-stubs[greengrass]'`
- Run `mypy` as usual

Type checking should work for `Greengrass` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[greengrass]` in your environment: `python -m pip install 'boto3-stubs[greengrass]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Greengrass` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`GreengrassClient` provides annotations for `boto3.client("greengrass")`.

```python
import boto3

from mypy_boto3_greengrass import GreengrassClient

client: GreengrassClient = boto3.client("greengrass")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GreengrassClient = session.client("greengrass")
```

### Paginators annotations

`mypy_boto3_greengrass.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_greengrass import GreengrassClient
from mypy_boto3_greengrass.paginator import (
    ListBulkDeploymentDetailedReportsPaginator,
    ListBulkDeploymentsPaginator,
    ListConnectorDefinitionVersionsPaginator,
    ListConnectorDefinitionsPaginator,
    ListCoreDefinitionVersionsPaginator,
    ListCoreDefinitionsPaginator,
    ListDeploymentsPaginator,
    ListDeviceDefinitionVersionsPaginator,
    ListDeviceDefinitionsPaginator,
    ListFunctionDefinitionVersionsPaginator,
    ListFunctionDefinitionsPaginator,
    ListGroupVersionsPaginator,
    ListGroupsPaginator,
    ListLoggerDefinitionVersionsPaginator,
    ListLoggerDefinitionsPaginator,
    ListResourceDefinitionVersionsPaginator,
    ListResourceDefinitionsPaginator,
    ListSubscriptionDefinitionVersionsPaginator,
    ListSubscriptionDefinitionsPaginator,
)

client: GreengrassClient = boto3.client("greengrass")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_bulk_deployment_detailed_reports_paginator: ListBulkDeploymentDetailedReportsPaginator = client.get_paginator("list_bulk_deployment_detailed_reports")
list_bulk_deployments_paginator: ListBulkDeploymentsPaginator = client.get_paginator("list_bulk_deployments")
list_connector_definition_versions_paginator: ListConnectorDefinitionVersionsPaginator = client.get_paginator("list_connector_definition_versions")
list_connector_definitions_paginator: ListConnectorDefinitionsPaginator = client.get_paginator("list_connector_definitions")
list_core_definition_versions_paginator: ListCoreDefinitionVersionsPaginator = client.get_paginator("list_core_definition_versions")
list_core_definitions_paginator: ListCoreDefinitionsPaginator = client.get_paginator("list_core_definitions")
list_deployments_paginator: ListDeploymentsPaginator = client.get_paginator("list_deployments")
list_device_definition_versions_paginator: ListDeviceDefinitionVersionsPaginator = client.get_paginator("list_device_definition_versions")
list_device_definitions_paginator: ListDeviceDefinitionsPaginator = client.get_paginator("list_device_definitions")
list_function_definition_versions_paginator: ListFunctionDefinitionVersionsPaginator = client.get_paginator("list_function_definition_versions")
list_function_definitions_paginator: ListFunctionDefinitionsPaginator = client.get_paginator("list_function_definitions")
list_group_versions_paginator: ListGroupVersionsPaginator = client.get_paginator("list_group_versions")
list_groups_paginator: ListGroupsPaginator = client.get_paginator("list_groups")
list_logger_definition_versions_paginator: ListLoggerDefinitionVersionsPaginator = client.get_paginator("list_logger_definition_versions")
list_logger_definitions_paginator: ListLoggerDefinitionsPaginator = client.get_paginator("list_logger_definitions")
list_resource_definition_versions_paginator: ListResourceDefinitionVersionsPaginator = client.get_paginator("list_resource_definition_versions")
list_resource_definitions_paginator: ListResourceDefinitionsPaginator = client.get_paginator("list_resource_definitions")
list_subscription_definition_versions_paginator: ListSubscriptionDefinitionVersionsPaginator = client.get_paginator("list_subscription_definition_versions")
list_subscription_definitions_paginator: ListSubscriptionDefinitionsPaginator = client.get_paginator("list_subscription_definitions")
```







### Typed dictionations

`mypy_boto3_greengrass.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_greengrass.type_defs import (
    BulkDeploymentMetricsTypeDef,
    BulkDeploymentResultTypeDef,
    BulkDeploymentTypeDef,
    ConnectivityInfoTypeDef,
    ConnectorDefinitionVersionTypeDef,
    ConnectorTypeDef,
    CoreDefinitionVersionTypeDef,
    CoreTypeDef,
    DefinitionInformationTypeDef,
    DeploymentTypeDef,
    DeviceDefinitionVersionTypeDef,
    DeviceTypeDef,
    ErrorDetailTypeDef,
    FunctionConfigurationEnvironmentTypeDef,
    FunctionConfigurationTypeDef,
    FunctionDefaultConfigTypeDef,
    FunctionDefaultExecutionConfigTypeDef,
    FunctionDefinitionVersionTypeDef,
    FunctionExecutionConfigTypeDef,
    FunctionRunAsConfigTypeDef,
    FunctionTypeDef,
    GroupCertificateAuthorityPropertiesTypeDef,
    GroupInformationTypeDef,
    GroupOwnerSettingTypeDef,
    GroupVersionTypeDef,
    LocalDeviceResourceDataTypeDef,
    LocalVolumeResourceDataTypeDef,
    LoggerDefinitionVersionTypeDef,
    LoggerTypeDef,
    ResourceAccessPolicyTypeDef,
    ResourceDataContainerTypeDef,
    ResourceDefinitionVersionTypeDef,
    ResourceDownloadOwnerSettingTypeDef,
    ResourceTypeDef,
    RuntimeConfigurationTypeDef,
    S3MachineLearningModelResourceDataTypeDef,
    SageMakerMachineLearningModelResourceDataTypeDef,
    SecretsManagerSecretResourceDataTypeDef,
    SubscriptionDefinitionVersionTypeDef,
    SubscriptionTypeDef,
    TelemetryConfigurationTypeDef,
    VersionInformationTypeDef,
    AssociateRoleToGroupResponseTypeDef,
    AssociateServiceRoleToAccountResponseTypeDef,
    CreateConnectorDefinitionResponseTypeDef,
    CreateConnectorDefinitionVersionResponseTypeDef,
    CreateCoreDefinitionResponseTypeDef,
    CreateCoreDefinitionVersionResponseTypeDef,
    CreateDeploymentResponseTypeDef,
    CreateDeviceDefinitionResponseTypeDef,
    CreateDeviceDefinitionVersionResponseTypeDef,
    CreateFunctionDefinitionResponseTypeDef,
    CreateFunctionDefinitionVersionResponseTypeDef,
    CreateGroupCertificateAuthorityResponseTypeDef,
    CreateGroupResponseTypeDef,
    CreateGroupVersionResponseTypeDef,
    CreateLoggerDefinitionResponseTypeDef,
    CreateLoggerDefinitionVersionResponseTypeDef,
    CreateResourceDefinitionResponseTypeDef,
    CreateResourceDefinitionVersionResponseTypeDef,
    CreateSoftwareUpdateJobResponseTypeDef,
    CreateSubscriptionDefinitionResponseTypeDef,
    CreateSubscriptionDefinitionVersionResponseTypeDef,
    DisassociateRoleFromGroupResponseTypeDef,
    DisassociateServiceRoleFromAccountResponseTypeDef,
    GetAssociatedRoleResponseTypeDef,
    GetBulkDeploymentStatusResponseTypeDef,
    GetConnectivityInfoResponseTypeDef,
    GetConnectorDefinitionResponseTypeDef,
    GetConnectorDefinitionVersionResponseTypeDef,
    GetCoreDefinitionResponseTypeDef,
    GetCoreDefinitionVersionResponseTypeDef,
    GetDeploymentStatusResponseTypeDef,
    GetDeviceDefinitionResponseTypeDef,
    GetDeviceDefinitionVersionResponseTypeDef,
    GetFunctionDefinitionResponseTypeDef,
    GetFunctionDefinitionVersionResponseTypeDef,
    GetGroupCertificateAuthorityResponseTypeDef,
    GetGroupCertificateConfigurationResponseTypeDef,
    GetGroupResponseTypeDef,
    GetGroupVersionResponseTypeDef,
    GetLoggerDefinitionResponseTypeDef,
    GetLoggerDefinitionVersionResponseTypeDef,
    GetResourceDefinitionResponseTypeDef,
    GetResourceDefinitionVersionResponseTypeDef,
    GetServiceRoleForAccountResponseTypeDef,
    GetSubscriptionDefinitionResponseTypeDef,
    GetSubscriptionDefinitionVersionResponseTypeDef,
    GetThingRuntimeConfigurationResponseTypeDef,
    ListBulkDeploymentDetailedReportsResponseTypeDef,
    ListBulkDeploymentsResponseTypeDef,
    ListConnectorDefinitionVersionsResponseTypeDef,
    ListConnectorDefinitionsResponseTypeDef,
    ListCoreDefinitionVersionsResponseTypeDef,
    ListCoreDefinitionsResponseTypeDef,
    ListDeploymentsResponseTypeDef,
    ListDeviceDefinitionVersionsResponseTypeDef,
    ListDeviceDefinitionsResponseTypeDef,
    ListFunctionDefinitionVersionsResponseTypeDef,
    ListFunctionDefinitionsResponseTypeDef,
    ListGroupCertificateAuthoritiesResponseTypeDef,
    ListGroupVersionsResponseTypeDef,
    ListGroupsResponseTypeDef,
    ListLoggerDefinitionVersionsResponseTypeDef,
    ListLoggerDefinitionsResponseTypeDef,
    ListResourceDefinitionVersionsResponseTypeDef,
    ListResourceDefinitionsResponseTypeDef,
    ListSubscriptionDefinitionVersionsResponseTypeDef,
    ListSubscriptionDefinitionsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    ResetDeploymentsResponseTypeDef,
    StartBulkDeploymentResponseTypeDef,
    TelemetryConfigurationUpdateTypeDef,
    UpdateConnectivityInfoResponseTypeDef,
    UpdateGroupCertificateConfigurationResponseTypeDef,
)

def get_structure() -> BulkDeploymentMetricsTypeDef:
    return {
      ...
    }
```
