# Generated by Django 5.0.6 on 2024-06-05 08:07

from decimal import Decimal

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("currency", "0001_initial"),
        ("directory", "0007_alter_bankingcontact_options"),
        ("io", "0007_alter_exportsource_query_params"),
        ("wbaccounting", "0010_alter_bookingentry_options"),
    ]

    operations = [
        migrations.CreateModel(
            name="Transaction",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("booking_date", models.DateField(verbose_name="Booking Date")),
                ("value_date", models.DateField(verbose_name="Value Date")),
                (
                    "fx_rate",
                    models.DecimalField(decimal_places=4, default=Decimal("1"), max_digits=10, verbose_name="FX Rate"),
                ),
                (
                    "value_local_ccy",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=19, null=True, verbose_name="Value (Local Currency)"
                    ),
                ),
                (
                    "value",
                    models.DecimalField(blank=True, decimal_places=2, max_digits=19, null=True, verbose_name="Value"),
                ),
                ("description", models.TextField(default="")),
                (
                    "prenotification",
                    models.BooleanField(
                        default=False,
                        help_text="This field indicates that this transaction will happen sometime in the future.",
                        verbose_name="Prenotification",
                    ),
                ),
                ("_hash", models.CharField(blank=True, max_length=64, null=True)),
                (
                    "bank_account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="wbaccounting_transactions",
                        to="directory.bankingcontact",
                        verbose_name="Linked Bank Account",
                    ),
                ),
                (
                    "currency",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="currency.currency",
                        verbose_name="Currency",
                    ),
                ),
                (
                    "from_bank_account",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="directory.bankingcontact",
                        verbose_name="Source Bank Account",
                    ),
                ),
                (
                    "import_source",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
                    ),
                ),
                (
                    "to_bank_account",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="directory.bankingcontact",
                        verbose_name="Target Bank Account",
                    ),
                ),
            ],
            options={
                "verbose_name": "Transaction",
                "verbose_name_plural": "Transactions",
                "default_related_name": "transactions",
            },
        ),
    ]
