"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefitcustomcreateproperties import (
    BenefitCustomCreateProperties,
    BenefitCustomCreatePropertiesTypedDict,
)
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class BenefitCustomCreateType(str, Enum):
    CUSTOM = "custom"


class BenefitCustomCreateTypedDict(TypedDict):
    r"""Schema to create a benefit of type `custom`."""

    description: str
    r"""The description of the benefit. Will be displayed on products having this benefit."""
    properties: BenefitCustomCreatePropertiesTypedDict
    r"""Properties for creating a benefit of type `custom`."""
    type: BenefitCustomCreateType
    organization_id: NotRequired[Nullable[str]]
    r"""The ID of the organization owning the benefit. **Required unless you use an organization token.**"""


class BenefitCustomCreate(BaseModel):
    r"""Schema to create a benefit of type `custom`."""

    description: str
    r"""The description of the benefit. Will be displayed on products having this benefit."""

    properties: BenefitCustomCreateProperties
    r"""Properties for creating a benefit of type `custom`."""

    TYPE: Annotated[
        Annotated[
            BenefitCustomCreateType,
            AfterValidator(validate_const(BenefitCustomCreateType.CUSTOM)),
        ],
        pydantic.Field(alias="type"),
    ] = BenefitCustomCreateType.CUSTOM

    organization_id: OptionalNullable[str] = UNSET
    r"""The ID of the organization owning the benefit. **Required unless you use an organization token.**"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["organization_id"]
        nullable_fields = ["organization_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
