"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefitlicensekeyscreateproperties import (
    BenefitLicenseKeysCreateProperties,
    BenefitLicenseKeysCreatePropertiesTypedDict,
)
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class BenefitLicenseKeysUpdateType(str, Enum):
    LICENSE_KEYS = "license_keys"


class BenefitLicenseKeysUpdateTypedDict(TypedDict):
    description: NotRequired[Nullable[str]]
    r"""The description of the benefit. Will be displayed on products having this benefit."""
    type: BenefitLicenseKeysUpdateType
    properties: NotRequired[Nullable[BenefitLicenseKeysCreatePropertiesTypedDict]]


class BenefitLicenseKeysUpdate(BaseModel):
    description: OptionalNullable[str] = UNSET
    r"""The description of the benefit. Will be displayed on products having this benefit."""

    TYPE: Annotated[
        Annotated[
            BenefitLicenseKeysUpdateType,
            AfterValidator(validate_const(BenefitLicenseKeysUpdateType.LICENSE_KEYS)),
        ],
        pydantic.Field(alias="type"),
    ] = BenefitLicenseKeysUpdateType.LICENSE_KEYS

    properties: OptionalNullable[BenefitLicenseKeysCreateProperties] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "properties"]
        nullable_fields = ["description", "properties"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
