"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class CheckoutConfirmStripeCustomFieldDataTypedDict(TypedDict):
    pass


class CheckoutConfirmStripeCustomFieldData(BaseModel):
    pass


class CheckoutConfirmStripeTypedDict(TypedDict):
    r"""Confirm a checkout session using a Stripe confirmation token."""

    custom_field_data: NotRequired[
        Nullable[CheckoutConfirmStripeCustomFieldDataTypedDict]
    ]
    r"""Key-value object storing custom field values."""
    product_price_id: NotRequired[Nullable[str]]
    r"""ID of the product price to checkout. Must correspond to a price linked to the same product."""
    amount: NotRequired[Nullable[int]]
    customer_name: NotRequired[Nullable[str]]
    customer_email: NotRequired[Nullable[str]]
    customer_billing_address: NotRequired[Nullable[AddressTypedDict]]
    customer_tax_id: NotRequired[Nullable[str]]
    discount_code: NotRequired[Nullable[str]]
    r"""Discount code to apply to the checkout."""
    confirmation_token_id: NotRequired[Nullable[str]]
    r"""ID of the Stripe confirmation token. Required for fixed prices and custom prices."""


class CheckoutConfirmStripe(BaseModel):
    r"""Confirm a checkout session using a Stripe confirmation token."""

    custom_field_data: OptionalNullable[CheckoutConfirmStripeCustomFieldData] = UNSET
    r"""Key-value object storing custom field values."""

    product_price_id: OptionalNullable[str] = UNSET
    r"""ID of the product price to checkout. Must correspond to a price linked to the same product."""

    amount: OptionalNullable[int] = UNSET

    customer_name: OptionalNullable[str] = UNSET

    customer_email: OptionalNullable[str] = UNSET

    customer_billing_address: OptionalNullable[Address] = UNSET

    customer_tax_id: OptionalNullable[str] = UNSET

    discount_code: OptionalNullable[str] = UNSET
    r"""Discount code to apply to the checkout."""

    confirmation_token_id: OptionalNullable[str] = UNSET
    r"""ID of the Stripe confirmation token. Required for fixed prices and custom prices."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "custom_field_data",
            "product_price_id",
            "amount",
            "customer_name",
            "customer_email",
            "customer_billing_address",
            "customer_tax_id",
            "discount_code",
            "confirmation_token_id",
        ]
        nullable_fields = [
            "custom_field_data",
            "product_price_id",
            "amount",
            "customer_name",
            "customer_email",
            "customer_billing_address",
            "customer_tax_id",
            "discount_code",
            "confirmation_token_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
