"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .checkoutproduct import CheckoutProduct, CheckoutProductTypedDict
from .productprice import ProductPrice, ProductPriceTypedDict
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class CheckoutLegacyTypedDict(TypedDict):
    r"""A checkout session."""

    id: str
    r"""The ID of the checkout."""
    customer_email: Nullable[str]
    customer_name: Nullable[str]
    product: CheckoutProductTypedDict
    r"""Product data for a checkout session."""
    product_price: ProductPriceTypedDict
    url: NotRequired[Nullable[str]]
    r"""URL the customer should be redirected to complete the purchase."""


class CheckoutLegacy(BaseModel):
    r"""A checkout session."""

    id: str
    r"""The ID of the checkout."""

    customer_email: Nullable[str]

    customer_name: Nullable[str]

    product: CheckoutProduct
    r"""Product data for a checkout session."""

    product_price: ProductPrice

    url: OptionalNullable[str] = UNSET
    r"""URL the customer should be redirected to complete the purchase."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["url"]
        nullable_fields = ["customer_email", "customer_name", "url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
