"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class CheckoutLegacyCreateTypedDict(TypedDict):
    product_price_id: str
    r"""ID of the product price to subscribe to."""
    success_url: str
    r"""URL where the customer will be redirected after a successful subscription. You can add the `session_id={CHECKOUT_SESSION_ID}` query parameter to retrieve the checkout session id."""
    customer_email: NotRequired[Nullable[str]]
    r"""If you already know the email of your customer, you can set it. It'll be pre-filled on the checkout page."""
    subscription_id: NotRequired[Nullable[str]]
    r"""ID of the subscription to update. If not provided, a new subscription will be created."""


class CheckoutLegacyCreate(BaseModel):
    product_price_id: str
    r"""ID of the product price to subscribe to."""

    success_url: str
    r"""URL where the customer will be redirected after a successful subscription. You can add the `session_id={CHECKOUT_SESSION_ID}` query parameter to retrieve the checkout session id."""

    customer_email: OptionalNullable[str] = UNSET
    r"""If you already know the email of your customer, you can set it. It'll be pre-filled on the checkout page."""

    subscription_id: OptionalNullable[str] = UNSET
    r"""ID of the subscription to update. If not provided, a new subscription will be created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["customer_email", "subscription_id"]
        nullable_fields = ["customer_email", "subscription_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
