"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


CheckoutLinkProductCreateMetadataTypedDict = TypeAliasType(
    "CheckoutLinkProductCreateMetadataTypedDict", Union[str, int, bool]
)


CheckoutLinkProductCreateMetadata = TypeAliasType(
    "CheckoutLinkProductCreateMetadata", Union[str, int, bool]
)


class CheckoutLinkProductCreatePaymentProcessor(str, Enum):
    r"""Payment processor to use. Currently only Stripe is supported."""

    STRIPE = "stripe"


class CheckoutLinkProductCreateTypedDict(TypedDict):
    product_id: str
    r"""ID of the product to checkout. First available price will be selected."""
    metadata: NotRequired[Dict[str, CheckoutLinkProductCreateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    payment_processor: CheckoutLinkProductCreatePaymentProcessor
    r"""Payment processor to use. Currently only Stripe is supported."""
    label: NotRequired[Nullable[str]]
    r"""Optional label to distinguish links internally"""
    allow_discount_codes: NotRequired[bool]
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""
    discount_id: NotRequired[Nullable[str]]
    r"""ID of the discount to apply to the checkout. If the discount is not applicable anymore when opening the checkout link, it'll be ignored."""
    success_url: NotRequired[Nullable[str]]
    r"""URL where the customer will be redirected after a successful payment.You can add the `checkout_id={CHECKOUT_ID}` query parameter to retrieve the checkout session id."""


class CheckoutLinkProductCreate(BaseModel):
    product_id: str
    r"""ID of the product to checkout. First available price will be selected."""

    metadata: Optional[Dict[str, CheckoutLinkProductCreateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    PAYMENT_PROCESSOR: Annotated[
        Annotated[
            CheckoutLinkProductCreatePaymentProcessor,
            AfterValidator(
                validate_const(CheckoutLinkProductCreatePaymentProcessor.STRIPE)
            ),
        ],
        pydantic.Field(alias="payment_processor"),
    ] = CheckoutLinkProductCreatePaymentProcessor.STRIPE
    r"""Payment processor to use. Currently only Stripe is supported."""

    label: OptionalNullable[str] = UNSET
    r"""Optional label to distinguish links internally"""

    allow_discount_codes: Optional[bool] = True
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""

    discount_id: OptionalNullable[str] = UNSET
    r"""ID of the discount to apply to the checkout. If the discount is not applicable anymore when opening the checkout link, it'll be ignored."""

    success_url: OptionalNullable[str] = UNSET
    r"""URL where the customer will be redirected after a successful payment.You can add the `checkout_id={CHECKOUT_ID}` query parameter to retrieve the checkout session id."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "metadata",
            "label",
            "allow_discount_codes",
            "discount_id",
            "success_url",
        ]
        nullable_fields = ["label", "discount_id", "success_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
