"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .attachedcustomfield import AttachedCustomField, AttachedCustomFieldTypedDict
from .checkoutdiscountfixedonceforeverduration import (
    CheckoutDiscountFixedOnceForeverDuration,
    CheckoutDiscountFixedOnceForeverDurationTypedDict,
)
from .checkoutdiscountfixedrepeatduration import (
    CheckoutDiscountFixedRepeatDuration,
    CheckoutDiscountFixedRepeatDurationTypedDict,
)
from .checkoutdiscountpercentageonceforeverduration import (
    CheckoutDiscountPercentageOnceForeverDuration,
    CheckoutDiscountPercentageOnceForeverDurationTypedDict,
)
from .checkoutdiscountpercentagerepeatduration import (
    CheckoutDiscountPercentageRepeatDuration,
    CheckoutDiscountPercentageRepeatDurationTypedDict,
)
from .checkoutproduct import CheckoutProduct, CheckoutProductTypedDict
from .organization import Organization, OrganizationTypedDict
from .paymentprocessor import PaymentProcessor
from .productprice import ProductPrice, ProductPriceTypedDict
from datetime import datetime
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CheckoutPublicConfirmedCustomFieldDataTypedDict(TypedDict):
    r"""Key-value object storing custom field values."""


class CheckoutPublicConfirmedCustomFieldData(BaseModel):
    r"""Key-value object storing custom field values."""


class Status(str, Enum):
    CONFIRMED = "confirmed"


class CheckoutPublicConfirmedPaymentProcessorMetadataTypedDict(TypedDict):
    pass


class CheckoutPublicConfirmedPaymentProcessorMetadata(BaseModel):
    pass


CheckoutPublicConfirmedDiscountTypedDict = TypeAliasType(
    "CheckoutPublicConfirmedDiscountTypedDict",
    Union[
        CheckoutDiscountPercentageOnceForeverDurationTypedDict,
        CheckoutDiscountFixedOnceForeverDurationTypedDict,
        CheckoutDiscountPercentageRepeatDurationTypedDict,
        CheckoutDiscountFixedRepeatDurationTypedDict,
    ],
)


CheckoutPublicConfirmedDiscount = TypeAliasType(
    "CheckoutPublicConfirmedDiscount",
    Union[
        CheckoutDiscountPercentageOnceForeverDuration,
        CheckoutDiscountFixedOnceForeverDuration,
        CheckoutDiscountPercentageRepeatDuration,
        CheckoutDiscountFixedRepeatDuration,
    ],
)


class CheckoutPublicConfirmedTypedDict(TypedDict):
    r"""Checkout session data retrieved using the client secret after confirmation.

    It contains a customer session token to retrieve order information
    right after the checkout.
    """

    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    client_secret: str
    r"""Client secret used to update and complete the checkout session from the client."""
    url: str
    r"""URL where the customer can access the checkout session."""
    expires_at: datetime
    r"""Expiration date and time of the checkout session."""
    success_url: str
    r"""URL where the customer will be redirected after a successful payment."""
    embed_origin: Nullable[str]
    r"""When checkout is embedded, represents the Origin of the page embedding the checkout. Used as a security measure to send messages only to the embedding page."""
    amount: Nullable[int]
    tax_amount: Nullable[int]
    r"""Computed tax amount to pay in cents."""
    currency: Nullable[str]
    r"""Currency code of the checkout session."""
    subtotal_amount: Nullable[int]
    r"""Subtotal amount in cents, including discounts and before tax."""
    total_amount: Nullable[int]
    r"""Total amount to pay in cents, including discounts and after tax."""
    product_id: str
    r"""ID of the product to checkout."""
    product_price_id: str
    r"""ID of the product price to checkout."""
    discount_id: Nullable[str]
    r"""ID of the discount applied to the checkout."""
    allow_discount_codes: bool
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""
    is_discount_applicable: bool
    r"""Whether the discount is applicable to the checkout. Typically, free and custom prices are not discountable."""
    is_free_product_price: bool
    r"""Whether the product price is free, regardless of discounts."""
    is_payment_required: bool
    r"""Whether the checkout requires payment, e.g. in case of free products or discounts that cover the total amount."""
    is_payment_setup_required: bool
    r"""Whether the checkout requires setting up a payment method, regardless of the amount, e.g. subscriptions that have first free cycles."""
    is_payment_form_required: bool
    r"""Whether the checkout requires a payment form, whether because of a payment or payment method setup."""
    customer_id: Nullable[str]
    customer_name: Nullable[str]
    customer_email: Nullable[str]
    customer_ip_address: Nullable[str]
    customer_billing_address: Nullable[AddressTypedDict]
    customer_tax_id: Nullable[str]
    payment_processor_metadata: CheckoutPublicConfirmedPaymentProcessorMetadataTypedDict
    product: CheckoutProductTypedDict
    r"""Product data for a checkout session."""
    product_price: ProductPriceTypedDict
    discount: Nullable[CheckoutPublicConfirmedDiscountTypedDict]
    organization: OrganizationTypedDict
    attached_custom_fields: List[AttachedCustomFieldTypedDict]
    customer_session_token: str
    custom_field_data: NotRequired[CheckoutPublicConfirmedCustomFieldDataTypedDict]
    r"""Key-value object storing custom field values."""
    payment_processor: PaymentProcessor
    status: Status


class CheckoutPublicConfirmed(BaseModel):
    r"""Checkout session data retrieved using the client secret after confirmation.

    It contains a customer session token to retrieve order information
    right after the checkout.
    """

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    client_secret: str
    r"""Client secret used to update and complete the checkout session from the client."""

    url: str
    r"""URL where the customer can access the checkout session."""

    expires_at: datetime
    r"""Expiration date and time of the checkout session."""

    success_url: str
    r"""URL where the customer will be redirected after a successful payment."""

    embed_origin: Nullable[str]
    r"""When checkout is embedded, represents the Origin of the page embedding the checkout. Used as a security measure to send messages only to the embedding page."""

    amount: Nullable[int]

    tax_amount: Nullable[int]
    r"""Computed tax amount to pay in cents."""

    currency: Nullable[str]
    r"""Currency code of the checkout session."""

    subtotal_amount: Nullable[int]
    r"""Subtotal amount in cents, including discounts and before tax."""

    total_amount: Nullable[int]
    r"""Total amount to pay in cents, including discounts and after tax."""

    product_id: str
    r"""ID of the product to checkout."""

    product_price_id: str
    r"""ID of the product price to checkout."""

    discount_id: Nullable[str]
    r"""ID of the discount applied to the checkout."""

    allow_discount_codes: bool
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""

    is_discount_applicable: bool
    r"""Whether the discount is applicable to the checkout. Typically, free and custom prices are not discountable."""

    is_free_product_price: bool
    r"""Whether the product price is free, regardless of discounts."""

    is_payment_required: bool
    r"""Whether the checkout requires payment, e.g. in case of free products or discounts that cover the total amount."""

    is_payment_setup_required: bool
    r"""Whether the checkout requires setting up a payment method, regardless of the amount, e.g. subscriptions that have first free cycles."""

    is_payment_form_required: bool
    r"""Whether the checkout requires a payment form, whether because of a payment or payment method setup."""

    customer_id: Nullable[str]

    customer_name: Nullable[str]

    customer_email: Nullable[str]

    customer_ip_address: Nullable[str]

    customer_billing_address: Nullable[Address]

    customer_tax_id: Nullable[str]

    payment_processor_metadata: CheckoutPublicConfirmedPaymentProcessorMetadata

    product: CheckoutProduct
    r"""Product data for a checkout session."""

    product_price: ProductPrice

    discount: Nullable[CheckoutPublicConfirmedDiscount]

    organization: Organization

    attached_custom_fields: List[AttachedCustomField]

    customer_session_token: str

    custom_field_data: Optional[CheckoutPublicConfirmedCustomFieldData] = None
    r"""Key-value object storing custom field values."""

    PAYMENT_PROCESSOR: Annotated[
        Annotated[
            PaymentProcessor, AfterValidator(validate_const(PaymentProcessor.STRIPE))
        ],
        pydantic.Field(alias="payment_processor"),
    ] = PaymentProcessor.STRIPE

    STATUS: Annotated[
        Annotated[Status, AfterValidator(validate_const(Status.CONFIRMED))],
        pydantic.Field(alias="status"),
    ] = Status.CONFIRMED

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["custom_field_data"]
        nullable_fields = [
            "modified_at",
            "embed_origin",
            "amount",
            "tax_amount",
            "currency",
            "subtotal_amount",
            "total_amount",
            "discount_id",
            "customer_id",
            "customer_name",
            "customer_email",
            "customer_ip_address",
            "customer_billing_address",
            "customer_tax_id",
            "discount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
