"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


class CustomFieldDataTypedDict(TypedDict):
    pass


class CustomFieldData(BaseModel):
    pass


CheckoutUpdateMetadataTypedDict = TypeAliasType(
    "CheckoutUpdateMetadataTypedDict", Union[str, int, bool]
)


CheckoutUpdateMetadata = TypeAliasType("CheckoutUpdateMetadata", Union[str, int, bool])


CheckoutUpdateCustomerMetadataTypedDict = TypeAliasType(
    "CheckoutUpdateCustomerMetadataTypedDict", Union[str, int, bool]
)


CheckoutUpdateCustomerMetadata = TypeAliasType(
    "CheckoutUpdateCustomerMetadata", Union[str, int, bool]
)


class CheckoutUpdateTypedDict(TypedDict):
    r"""Update an existing checkout session using an access token."""

    custom_field_data: NotRequired[Nullable[CustomFieldDataTypedDict]]
    r"""Key-value object storing custom field values."""
    product_price_id: NotRequired[Nullable[str]]
    r"""ID of the product price to checkout. Must correspond to a price linked to the same product."""
    amount: NotRequired[Nullable[int]]
    customer_name: NotRequired[Nullable[str]]
    customer_email: NotRequired[Nullable[str]]
    customer_billing_address: NotRequired[Nullable[AddressTypedDict]]
    customer_tax_id: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[Dict[str, CheckoutUpdateMetadataTypedDict]]]
    discount_id: NotRequired[Nullable[str]]
    r"""ID of the discount to apply to the checkout."""
    allow_discount_codes: NotRequired[Nullable[bool]]
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""
    customer_ip_address: NotRequired[Nullable[str]]
    customer_metadata: NotRequired[
        Nullable[Dict[str, CheckoutUpdateCustomerMetadataTypedDict]]
    ]
    r"""Key-value object allowing you to store additional information that'll be copied to the created customer.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    success_url: NotRequired[Nullable[str]]
    r"""URL where the customer will be redirected after a successful payment.You can add the `checkout_id={CHECKOUT_ID}` query parameter to retrieve the checkout session id."""
    embed_origin: NotRequired[Nullable[str]]
    r"""If you plan to embed the checkout session, set this to the Origin of the embedding page. It'll allow the Polar iframe to communicate with the parent page."""


class CheckoutUpdate(BaseModel):
    r"""Update an existing checkout session using an access token."""

    custom_field_data: OptionalNullable[CustomFieldData] = UNSET
    r"""Key-value object storing custom field values."""

    product_price_id: OptionalNullable[str] = UNSET
    r"""ID of the product price to checkout. Must correspond to a price linked to the same product."""

    amount: OptionalNullable[int] = UNSET

    customer_name: OptionalNullable[str] = UNSET

    customer_email: OptionalNullable[str] = UNSET

    customer_billing_address: OptionalNullable[Address] = UNSET

    customer_tax_id: OptionalNullable[str] = UNSET

    metadata: OptionalNullable[Dict[str, CheckoutUpdateMetadata]] = UNSET

    discount_id: OptionalNullable[str] = UNSET
    r"""ID of the discount to apply to the checkout."""

    allow_discount_codes: OptionalNullable[bool] = UNSET
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""

    customer_ip_address: OptionalNullable[str] = UNSET

    customer_metadata: OptionalNullable[Dict[str, CheckoutUpdateCustomerMetadata]] = (
        UNSET
    )
    r"""Key-value object allowing you to store additional information that'll be copied to the created customer.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    success_url: OptionalNullable[str] = UNSET
    r"""URL where the customer will be redirected after a successful payment.You can add the `checkout_id={CHECKOUT_ID}` query parameter to retrieve the checkout session id."""

    embed_origin: OptionalNullable[str] = UNSET
    r"""If you plan to embed the checkout session, set this to the Origin of the embedding page. It'll allow the Polar iframe to communicate with the parent page."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "custom_field_data",
            "product_price_id",
            "amount",
            "customer_name",
            "customer_email",
            "customer_billing_address",
            "customer_tax_id",
            "metadata",
            "discount_id",
            "allow_discount_codes",
            "customer_ip_address",
            "customer_metadata",
            "success_url",
            "embed_origin",
        ]
        nullable_fields = [
            "custom_field_data",
            "product_price_id",
            "amount",
            "customer_name",
            "customer_email",
            "customer_billing_address",
            "customer_tax_id",
            "metadata",
            "discount_id",
            "allow_discount_codes",
            "customer_ip_address",
            "customer_metadata",
            "success_url",
            "embed_origin",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
