"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .customerportaloauthaccount import (
    CustomerPortalOAuthAccount,
    CustomerPortalOAuthAccountTypedDict,
)
from .taxidformat import TaxIDFormat
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Union
from typing_extensions import TypeAliasType, TypedDict


CustomerPortalCustomerTaxIDTypedDict = TypeAliasType(
    "CustomerPortalCustomerTaxIDTypedDict", Union[str, TaxIDFormat]
)


CustomerPortalCustomerTaxID = TypeAliasType(
    "CustomerPortalCustomerTaxID", Union[str, TaxIDFormat]
)


class CustomerPortalCustomerTypedDict(TypedDict):
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    email: str
    email_verified: bool
    name: Nullable[str]
    billing_address: Nullable[AddressTypedDict]
    tax_id: Nullable[List[CustomerPortalCustomerTaxIDTypedDict]]
    oauth_accounts: Dict[str, CustomerPortalOAuthAccountTypedDict]


class CustomerPortalCustomer(BaseModel):
    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    email: str

    email_verified: bool

    name: Nullable[str]

    billing_address: Nullable[Address]

    tax_id: Nullable[List[CustomerPortalCustomerTaxID]]

    oauth_accounts: Dict[str, CustomerPortalOAuthAccount]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["modified_at", "name", "billing_address", "tax_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
