"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .taxidformat import TaxIDFormat
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


CustomerUpdateTaxIDTypedDict = TypeAliasType(
    "CustomerUpdateTaxIDTypedDict", Union[str, TaxIDFormat]
)


CustomerUpdateTaxID = TypeAliasType("CustomerUpdateTaxID", Union[str, TaxIDFormat])


class CustomerUpdateTypedDict(TypedDict):
    email: NotRequired[Nullable[str]]
    name: NotRequired[Nullable[str]]
    billing_address: NotRequired[Nullable[AddressTypedDict]]
    tax_id: NotRequired[Nullable[List[CustomerUpdateTaxIDTypedDict]]]


class CustomerUpdate(BaseModel):
    email: OptionalNullable[str] = UNSET

    name: OptionalNullable[str] = UNSET

    billing_address: OptionalNullable[Address] = UNSET

    tax_id: OptionalNullable[List[CustomerUpdateTaxID]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email", "name", "billing_address", "tax_id"]
        nullable_fields = ["email", "name", "billing_address", "tax_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
