"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .downloadablefileread import DownloadableFileRead, DownloadableFileReadTypedDict
from .fileuploadcompleted import FileUploadCompleted, FileUploadCompletedTypedDict
from .organizationavatarfileread import (
    OrganizationAvatarFileRead,
    OrganizationAvatarFileReadTypedDict,
)
from .productmediafileread import ProductMediaFileRead, ProductMediaFileReadTypedDict
from polar_sdk.types import BaseModel
from polar_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
    get_discriminator,
)
from pydantic import Discriminator, Tag
from typing import Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class FilesUploadedRequestTypedDict(TypedDict):
    id: str
    r"""The file ID."""
    file_upload_completed: FileUploadCompletedTypedDict


class FilesUploadedRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The file ID."""

    file_upload_completed: Annotated[
        FileUploadCompleted,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


FilesUploadedResponseFilesUploadedTypedDict = TypeAliasType(
    "FilesUploadedResponseFilesUploadedTypedDict",
    Union[
        DownloadableFileReadTypedDict,
        ProductMediaFileReadTypedDict,
        OrganizationAvatarFileReadTypedDict,
    ],
)
r"""File upload completed."""


FilesUploadedResponseFilesUploaded = Annotated[
    Union[
        Annotated[DownloadableFileRead, Tag("downloadable")],
        Annotated[ProductMediaFileRead, Tag("product_media")],
        Annotated[OrganizationAvatarFileRead, Tag("organization_avatar")],
    ],
    Discriminator(lambda m: get_discriminator(m, "service", "service")),
]
r"""File upload completed."""
