"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk import utils
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated


class NotPermittedError(str, Enum):
    NOT_PERMITTED = "NotPermitted"


class NotPermittedData(BaseModel):
    detail: str

    ERROR: Annotated[
        Annotated[
            NotPermittedError,
            AfterValidator(validate_const(NotPermittedError.NOT_PERMITTED)),
        ],
        pydantic.Field(alias="error"),
    ] = NotPermittedError.NOT_PERMITTED


class NotPermitted(Exception):
    data: NotPermittedData

    def __init__(self, data: NotPermittedData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, NotPermittedData)
