"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .discountfixedonceforeverdurationbase import (
    DiscountFixedOnceForeverDurationBase,
    DiscountFixedOnceForeverDurationBaseTypedDict,
)
from .discountfixedrepeatdurationbase import (
    DiscountFixedRepeatDurationBase,
    DiscountFixedRepeatDurationBaseTypedDict,
)
from .discountpercentageonceforeverdurationbase import (
    DiscountPercentageOnceForeverDurationBase,
    DiscountPercentageOnceForeverDurationBaseTypedDict,
)
from .discountpercentagerepeatdurationbase import (
    DiscountPercentageRepeatDurationBase,
    DiscountPercentageRepeatDurationBaseTypedDict,
)
from .orderbillingreason import OrderBillingReason
from .ordercustomer import OrderCustomer, OrderCustomerTypedDict
from .orderproduct import OrderProduct, OrderProductTypedDict
from .ordersubscription import OrderSubscription, OrderSubscriptionTypedDict
from .orderuser import OrderUser, OrderUserTypedDict
from .productprice import ProductPrice, ProductPriceTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OrderMetadataTypedDict = TypeAliasType("OrderMetadataTypedDict", Union[str, int, bool])


OrderMetadata = TypeAliasType("OrderMetadata", Union[str, int, bool])


class OrderCustomFieldDataTypedDict(TypedDict):
    r"""Key-value object storing custom field values."""


class OrderCustomFieldData(BaseModel):
    r"""Key-value object storing custom field values."""


OrderDiscountTypedDict = TypeAliasType(
    "OrderDiscountTypedDict",
    Union[
        DiscountPercentageOnceForeverDurationBaseTypedDict,
        DiscountFixedOnceForeverDurationBaseTypedDict,
        DiscountPercentageRepeatDurationBaseTypedDict,
        DiscountFixedRepeatDurationBaseTypedDict,
    ],
)


OrderDiscount = TypeAliasType(
    "OrderDiscount",
    Union[
        DiscountPercentageOnceForeverDurationBase,
        DiscountFixedOnceForeverDurationBase,
        DiscountPercentageRepeatDurationBase,
        DiscountFixedRepeatDurationBase,
    ],
)


class OrderTypedDict(TypedDict):
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    metadata: Dict[str, OrderMetadataTypedDict]
    amount: int
    tax_amount: int
    currency: str
    billing_reason: OrderBillingReason
    billing_address: Nullable[AddressTypedDict]
    customer_id: str
    product_id: str
    product_price_id: str
    discount_id: Nullable[str]
    subscription_id: Nullable[str]
    checkout_id: Nullable[str]
    customer: OrderCustomerTypedDict
    user_id: str
    user: OrderUserTypedDict
    product: OrderProductTypedDict
    product_price: ProductPriceTypedDict
    discount: Nullable[OrderDiscountTypedDict]
    subscription: Nullable[OrderSubscriptionTypedDict]
    custom_field_data: NotRequired[OrderCustomFieldDataTypedDict]
    r"""Key-value object storing custom field values."""


class Order(BaseModel):
    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    metadata: Dict[str, OrderMetadata]

    amount: int

    tax_amount: int

    currency: str

    billing_reason: OrderBillingReason

    billing_address: Nullable[Address]

    customer_id: str

    product_id: str

    product_price_id: str

    discount_id: Nullable[str]

    subscription_id: Nullable[str]

    checkout_id: Nullable[str]

    customer: OrderCustomer

    user_id: Annotated[
        str,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]

    user: OrderUser

    product: OrderProduct

    product_price: ProductPrice

    discount: Nullable[OrderDiscount]

    subscription: Nullable[OrderSubscription]

    custom_field_data: Optional[OrderCustomFieldData] = None
    r"""Key-value object storing custom field values."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["custom_field_data"]
        nullable_fields = [
            "modified_at",
            "billing_address",
            "discount_id",
            "subscription_id",
            "checkout_id",
            "discount",
            "subscription",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
