"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .organizationsubscribepromotesettings import (
    OrganizationSubscribePromoteSettings,
    OrganizationSubscribePromoteSettingsTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class OrganizationProfileSettingsTypedDict(TypedDict):
    enabled: NotRequired[Nullable[bool]]
    r"""If this organization has a profile enabled"""
    description: NotRequired[Nullable[str]]
    r"""A description of the organization"""
    featured_projects: NotRequired[Nullable[List[str]]]
    r"""A list of featured projects"""
    featured_organizations: NotRequired[Nullable[List[str]]]
    r"""A list of featured organizations"""
    links: NotRequired[Nullable[List[str]]]
    r"""A list of links associated with the organization"""
    subscribe: NotRequired[Nullable[OrganizationSubscribePromoteSettingsTypedDict]]
    r"""Subscription promotion settings"""
    accent_color: NotRequired[Nullable[str]]
    r"""Accent color for the organization"""


class OrganizationProfileSettings(BaseModel):
    enabled: OptionalNullable[bool] = UNSET
    r"""If this organization has a profile enabled"""

    description: OptionalNullable[str] = UNSET
    r"""A description of the organization"""

    featured_projects: OptionalNullable[List[str]] = UNSET
    r"""A list of featured projects"""

    featured_organizations: OptionalNullable[List[str]] = UNSET
    r"""A list of featured organizations"""

    links: OptionalNullable[List[str]] = UNSET
    r"""A list of links associated with the organization"""

    subscribe: OptionalNullable[OrganizationSubscribePromoteSettings] = UNSET
    r"""Subscription promotion settings"""

    accent_color: OptionalNullable[str] = UNSET
    r"""Accent color for the organization"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "enabled",
            "description",
            "featured_projects",
            "featured_organizations",
            "links",
            "subscribe",
            "accent_color",
        ]
        nullable_fields = [
            "enabled",
            "description",
            "featured_projects",
            "featured_organizations",
            "links",
            "subscribe",
            "accent_color",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
