"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .organizationfeaturesettings import (
    OrganizationFeatureSettings,
    OrganizationFeatureSettingsTypedDict,
)
from .organizationprofilesettings import (
    OrganizationProfileSettings,
    OrganizationProfileSettingsTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class OrganizationUpdateTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    avatar_url: NotRequired[Nullable[str]]
    default_upfront_split_to_contributors: NotRequired[Nullable[int]]
    pledge_badge_show_amount: NotRequired[bool]
    billing_email: NotRequired[Nullable[str]]
    default_badge_custom_content: NotRequired[Nullable[str]]
    pledge_minimum_amount: NotRequired[int]
    total_monthly_spending_limit: NotRequired[Nullable[int]]
    per_user_monthly_spending_limit: NotRequired[Nullable[int]]
    profile_settings: NotRequired[Nullable[OrganizationProfileSettingsTypedDict]]
    feature_settings: NotRequired[Nullable[OrganizationFeatureSettingsTypedDict]]


class OrganizationUpdate(BaseModel):
    name: OptionalNullable[str] = UNSET

    avatar_url: OptionalNullable[str] = UNSET

    default_upfront_split_to_contributors: OptionalNullable[int] = UNSET

    pledge_badge_show_amount: Optional[bool] = False

    billing_email: OptionalNullable[str] = UNSET

    default_badge_custom_content: OptionalNullable[str] = UNSET

    pledge_minimum_amount: Optional[int] = 2000

    total_monthly_spending_limit: OptionalNullable[int] = UNSET

    per_user_monthly_spending_limit: OptionalNullable[int] = UNSET

    profile_settings: OptionalNullable[OrganizationProfileSettings] = UNSET

    feature_settings: OptionalNullable[OrganizationFeatureSettings] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "avatar_url",
            "default_upfront_split_to_contributors",
            "pledge_badge_show_amount",
            "billing_email",
            "default_badge_custom_content",
            "pledge_minimum_amount",
            "total_monthly_spending_limit",
            "per_user_monthly_spending_limit",
            "profile_settings",
            "feature_settings",
        ]
        nullable_fields = [
            "name",
            "avatar_url",
            "default_upfront_split_to_contributors",
            "billing_email",
            "default_badge_custom_content",
            "total_monthly_spending_limit",
            "per_user_monthly_spending_limit",
            "profile_settings",
            "feature_settings",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
