"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .issue import Issue, IssueTypedDict
from .pledger import Pledger, PledgerTypedDict
from .pledgestate import PledgeState
from .pledgetype import PledgeType
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class PledgeTypedDict(TypedDict):
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    amount: int
    r"""Amount pledged towards the issue"""
    currency: str
    state: PledgeState
    type: PledgeType
    issue: IssueTypedDict
    refunded_at: NotRequired[Nullable[datetime]]
    r"""If and when the pledge was refunded to the pledger"""
    scheduled_payout_at: NotRequired[Nullable[datetime]]
    r"""When the payout is scheduled to be made to the maintainers behind the issue. Disputes must be made before this date."""
    pledger: NotRequired[Nullable[PledgerTypedDict]]
    r"""The user or organization that made this pledge"""
    hosted_invoice_url: NotRequired[Nullable[str]]
    r"""URL of invoice for this pledge"""
    authed_can_admin_sender: NotRequired[bool]
    r"""If the currently authenticated subject can perform admin actions on behalf of the maker of the peldge"""
    authed_can_admin_received: NotRequired[bool]
    r"""If the currently authenticated subject can perform admin actions on behalf of the receiver of the peldge"""
    created_by: NotRequired[Nullable[PledgerTypedDict]]
    r"""For pledges made by an organization, or on behalf of an organization. This is the user that made the pledge. Only visible for members of said organization."""


class Pledge(BaseModel):
    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    amount: int
    r"""Amount pledged towards the issue"""

    currency: str

    state: PledgeState

    type: PledgeType

    issue: Issue

    refunded_at: OptionalNullable[datetime] = UNSET
    r"""If and when the pledge was refunded to the pledger"""

    scheduled_payout_at: OptionalNullable[datetime] = UNSET
    r"""When the payout is scheduled to be made to the maintainers behind the issue. Disputes must be made before this date."""

    pledger: OptionalNullable[Pledger] = UNSET
    r"""The user or organization that made this pledge"""

    hosted_invoice_url: OptionalNullable[str] = UNSET
    r"""URL of invoice for this pledge"""

    authed_can_admin_sender: Optional[bool] = False
    r"""If the currently authenticated subject can perform admin actions on behalf of the maker of the peldge"""

    authed_can_admin_received: Optional[bool] = False
    r"""If the currently authenticated subject can perform admin actions on behalf of the receiver of the peldge"""

    created_by: OptionalNullable[Pledger] = UNSET
    r"""For pledges made by an organization, or on behalf of an organization. This is the user that made the pledge. Only visible for members of said organization."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "refunded_at",
            "scheduled_payout_at",
            "pledger",
            "hosted_invoice_url",
            "authed_can_admin_sender",
            "authed_can_admin_received",
            "created_by",
        ]
        nullable_fields = [
            "modified_at",
            "refunded_at",
            "scheduled_payout_at",
            "pledger",
            "hosted_invoice_url",
            "created_by",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
