"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductPriceOneTimeCustomCreateType(str, Enum):
    ONE_TIME = "one_time"


class ProductPriceOneTimeCustomCreateAmountType(str, Enum):
    CUSTOM = "custom"


class ProductPriceOneTimeCustomCreateTypedDict(TypedDict):
    r"""Schema to create a pay-what-you-want price for a one-time product."""

    type: ProductPriceOneTimeCustomCreateType
    amount_type: ProductPriceOneTimeCustomCreateAmountType
    price_currency: NotRequired[str]
    r"""The currency. Currently, only `usd` is supported."""
    minimum_amount: NotRequired[Nullable[int]]
    r"""The minimum amount the customer can pay."""
    maximum_amount: NotRequired[Nullable[int]]
    r"""The maximum amount the customer can pay."""
    preset_amount: NotRequired[Nullable[int]]
    r"""The initial amount shown to the customer."""


class ProductPriceOneTimeCustomCreate(BaseModel):
    r"""Schema to create a pay-what-you-want price for a one-time product."""

    TYPE: Annotated[
        Annotated[
            ProductPriceOneTimeCustomCreateType,
            AfterValidator(
                validate_const(ProductPriceOneTimeCustomCreateType.ONE_TIME)
            ),
        ],
        pydantic.Field(alias="type"),
    ] = ProductPriceOneTimeCustomCreateType.ONE_TIME

    AMOUNT_TYPE: Annotated[
        Annotated[
            ProductPriceOneTimeCustomCreateAmountType,
            AfterValidator(
                validate_const(ProductPriceOneTimeCustomCreateAmountType.CUSTOM)
            ),
        ],
        pydantic.Field(alias="amount_type"),
    ] = ProductPriceOneTimeCustomCreateAmountType.CUSTOM

    price_currency: Optional[str] = "usd"
    r"""The currency. Currently, only `usd` is supported."""

    minimum_amount: OptionalNullable[int] = UNSET
    r"""The minimum amount the customer can pay."""

    maximum_amount: OptionalNullable[int] = UNSET
    r"""The maximum amount the customer can pay."""

    preset_amount: OptionalNullable[int] = UNSET
    r"""The initial amount shown to the customer."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "price_currency",
            "minimum_amount",
            "maximum_amount",
            "preset_amount",
        ]
        nullable_fields = ["minimum_amount", "maximum_amount", "preset_amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
