"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductPriceOneTimeFixedCreateType(str, Enum):
    ONE_TIME = "one_time"


class ProductPriceOneTimeFixedCreateAmountType(str, Enum):
    FIXED = "fixed"


class ProductPriceOneTimeFixedCreateTypedDict(TypedDict):
    r"""Schema to create a one-time product price."""

    price_amount: int
    r"""The price in cents."""
    type: ProductPriceOneTimeFixedCreateType
    amount_type: ProductPriceOneTimeFixedCreateAmountType
    price_currency: NotRequired[str]
    r"""The currency. Currently, only `usd` is supported."""


class ProductPriceOneTimeFixedCreate(BaseModel):
    r"""Schema to create a one-time product price."""

    price_amount: int
    r"""The price in cents."""

    TYPE: Annotated[
        Annotated[
            ProductPriceOneTimeFixedCreateType,
            AfterValidator(validate_const(ProductPriceOneTimeFixedCreateType.ONE_TIME)),
        ],
        pydantic.Field(alias="type"),
    ] = ProductPriceOneTimeFixedCreateType.ONE_TIME

    AMOUNT_TYPE: Annotated[
        Annotated[
            ProductPriceOneTimeFixedCreateAmountType,
            AfterValidator(
                validate_const(ProductPriceOneTimeFixedCreateAmountType.FIXED)
            ),
        ],
        pydantic.Field(alias="amount_type"),
    ] = ProductPriceOneTimeFixedCreateAmountType.FIXED

    price_currency: Optional[str] = "usd"
    r"""The currency. Currently, only `usd` is supported."""
