"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .subscriptionrecurringinterval import SubscriptionRecurringInterval
from datetime import datetime
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict


class AmountType(str, Enum):
    FIXED = "fixed"


class Type(str, Enum):
    r"""The type of the price."""

    RECURRING = "recurring"


class ProductPriceRecurringFixedTypedDict(TypedDict):
    r"""A recurring price for a product, i.e. a subscription."""

    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the price."""
    is_archived: bool
    r"""Whether the price is archived and no longer available."""
    product_id: str
    r"""The ID of the product owning the price."""
    price_currency: str
    r"""The currency."""
    price_amount: int
    r"""The price in cents."""
    recurring_interval: SubscriptionRecurringInterval
    amount_type: AmountType
    type: Type
    r"""The type of the price."""


class ProductPriceRecurringFixed(BaseModel):
    r"""A recurring price for a product, i.e. a subscription."""

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the price."""

    is_archived: bool
    r"""Whether the price is archived and no longer available."""

    product_id: str
    r"""The ID of the product owning the price."""

    price_currency: str
    r"""The currency."""

    price_amount: int
    r"""The price in cents."""

    recurring_interval: SubscriptionRecurringInterval

    AMOUNT_TYPE: Annotated[
        Annotated[AmountType, AfterValidator(validate_const(AmountType.FIXED))],
        pydantic.Field(alias="amount_type"),
    ] = AmountType.FIXED

    TYPE: Annotated[
        Annotated[Type, AfterValidator(validate_const(Type.RECURRING))],
        pydantic.Field(alias="type"),
    ] = Type.RECURRING
    r"""The type of the price."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["modified_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
