"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .subscriptionrecurringinterval import SubscriptionRecurringInterval
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductPriceRecurringFixedCreateType(str, Enum):
    RECURRING = "recurring"


class ProductPriceRecurringFixedCreateAmountType(str, Enum):
    FIXED = "fixed"


class ProductPriceRecurringFixedCreateTypedDict(TypedDict):
    r"""Schema to create a recurring product price, i.e. a subscription."""

    price_amount: int
    r"""The price in cents."""
    recurring_interval: SubscriptionRecurringInterval
    type: ProductPriceRecurringFixedCreateType
    amount_type: ProductPriceRecurringFixedCreateAmountType
    price_currency: NotRequired[str]
    r"""The currency. Currently, only `usd` is supported."""


class ProductPriceRecurringFixedCreate(BaseModel):
    r"""Schema to create a recurring product price, i.e. a subscription."""

    price_amount: int
    r"""The price in cents."""

    recurring_interval: SubscriptionRecurringInterval

    TYPE: Annotated[
        Annotated[
            ProductPriceRecurringFixedCreateType,
            AfterValidator(
                validate_const(ProductPriceRecurringFixedCreateType.RECURRING)
            ),
        ],
        pydantic.Field(alias="type"),
    ] = ProductPriceRecurringFixedCreateType.RECURRING

    AMOUNT_TYPE: Annotated[
        Annotated[
            ProductPriceRecurringFixedCreateAmountType,
            AfterValidator(
                validate_const(ProductPriceRecurringFixedCreateAmountType.FIXED)
            ),
        ],
        pydantic.Field(alias="amount_type"),
    ] = ProductPriceRecurringFixedCreateAmountType.FIXED

    price_currency: Optional[str] = "usd"
    r"""The currency. Currently, only `usd` is supported."""
