"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk import utils
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated


class Error(str, Enum):
    RESOURCE_NOT_FOUND = "ResourceNotFound"


class ResourceNotFoundData(BaseModel):
    detail: str

    ERROR: Annotated[
        Annotated[Error, AfterValidator(validate_const(Error.RESOURCE_NOT_FOUND))],
        pydantic.Field(alias="error"),
    ] = Error.RESOURCE_NOT_FOUND


class ResourceNotFound(Exception):
    data: ResourceNotFoundData

    def __init__(self, data: ResourceNotFoundData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ResourceNotFoundData)
