"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk import utils
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated


class UnauthorizedError(str, Enum):
    UNAUTHORIZED = "Unauthorized"


class UnauthorizedData(BaseModel):
    detail: str

    ERROR: Annotated[
        Annotated[
            UnauthorizedError,
            AfterValidator(validate_const(UnauthorizedError.UNAUTHORIZED)),
        ],
        pydantic.Field(alias="error"),
    ] = UnauthorizedError.UNAUTHORIZED


class Unauthorized(Exception):
    data: UnauthorizedData

    def __init__(self, data: UnauthorizedData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UnauthorizedData)
