"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .checkout import Checkout, CheckoutTypedDict
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict


class WebhookCheckoutCreatedPayloadType(str, Enum):
    CHECKOUT_CREATED = "checkout.created"


class WebhookCheckoutCreatedPayloadTypedDict(TypedDict):
    r"""Sent when a new checkout is created.

    **Discord & Slack support:** Basic
    """

    data: CheckoutTypedDict
    r"""Checkout session data retrieved using an access token."""
    type: WebhookCheckoutCreatedPayloadType


class WebhookCheckoutCreatedPayload(BaseModel):
    r"""Sent when a new checkout is created.

    **Discord & Slack support:** Basic
    """

    data: Checkout
    r"""Checkout session data retrieved using an access token."""

    TYPE: Annotated[
        Annotated[
            WebhookCheckoutCreatedPayloadType,
            AfterValidator(
                validate_const(WebhookCheckoutCreatedPayloadType.CHECKOUT_CREATED)
            ),
        ],
        pydantic.Field(alias="type"),
    ] = WebhookCheckoutCreatedPayloadType.CHECKOUT_CREATED
