"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .pledge import Pledge, PledgeTypedDict
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict


class WebhookPledgeCreatedPayloadType(str, Enum):
    PLEDGE_CREATED = "pledge.created"


class WebhookPledgeCreatedPayloadTypedDict(TypedDict):
    r"""Sent when a new pledge is created. Note that this does mean that the pledge has been paid yet.

    **Discord & Slack support:** Full
    """

    data: PledgeTypedDict
    type: WebhookPledgeCreatedPayloadType


class WebhookPledgeCreatedPayload(BaseModel):
    r"""Sent when a new pledge is created. Note that this does mean that the pledge has been paid yet.

    **Discord & Slack support:** Full
    """

    data: Pledge

    TYPE: Annotated[
        Annotated[
            WebhookPledgeCreatedPayloadType,
            AfterValidator(
                validate_const(WebhookPledgeCreatedPayloadType.PLEDGE_CREATED)
            ),
        ],
        pydantic.Field(alias="type"),
    ] = WebhookPledgeCreatedPayloadType.PLEDGE_CREATED
