"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .product import Product, ProductTypedDict
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict


class WebhookProductCreatedPayloadType(str, Enum):
    PRODUCT_CREATED = "product.created"


class WebhookProductCreatedPayloadTypedDict(TypedDict):
    r"""Sent when a new product is created.

    **Discord & Slack support:** Basic
    """

    data: ProductTypedDict
    r"""A product."""
    type: WebhookProductCreatedPayloadType


class WebhookProductCreatedPayload(BaseModel):
    r"""Sent when a new product is created.

    **Discord & Slack support:** Basic
    """

    data: Product
    r"""A product."""

    TYPE: Annotated[
        Annotated[
            WebhookProductCreatedPayloadType,
            AfterValidator(
                validate_const(WebhookProductCreatedPayloadType.PRODUCT_CREATED)
            ),
        ],
        pydantic.Field(alias="type"),
    ] = WebhookProductCreatedPayloadType.PRODUCT_CREATED
