"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .product import Product, ProductTypedDict
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict


class WebhookProductUpdatedPayloadType(str, Enum):
    PRODUCT_UPDATED = "product.updated"


class WebhookProductUpdatedPayloadTypedDict(TypedDict):
    r"""Sent when a product is updated.

    **Discord & Slack support:** Basic
    """

    data: ProductTypedDict
    r"""A product."""
    type: WebhookProductUpdatedPayloadType


class WebhookProductUpdatedPayload(BaseModel):
    r"""Sent when a product is updated.

    **Discord & Slack support:** Basic
    """

    data: Product
    r"""A product."""

    TYPE: Annotated[
        Annotated[
            WebhookProductUpdatedPayloadType,
            AfterValidator(
                validate_const(WebhookProductUpdatedPayloadType.PRODUCT_UPDATED)
            ),
        ],
        pydantic.Field(alias="type"),
    ] = WebhookProductUpdatedPayloadType.PRODUCT_UPDATED
