"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .subscription import Subscription, SubscriptionTypedDict
from enum import Enum
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict


class WebhookSubscriptionRevokedPayloadType(str, Enum):
    SUBSCRIPTION_REVOKED = "subscription.revoked"


class WebhookSubscriptionRevokedPayloadTypedDict(TypedDict):
    r"""Sent when a subscription is revoked, the user looses access immediately.
    Happens when the subscription is canceled, or payment is past due.

    **Discord & Slack support:** Full
    """

    data: SubscriptionTypedDict
    type: WebhookSubscriptionRevokedPayloadType


class WebhookSubscriptionRevokedPayload(BaseModel):
    r"""Sent when a subscription is revoked, the user looses access immediately.
    Happens when the subscription is canceled, or payment is past due.

    **Discord & Slack support:** Full
    """

    data: Subscription

    TYPE: Annotated[
        Annotated[
            WebhookSubscriptionRevokedPayloadType,
            AfterValidator(
                validate_const(
                    WebhookSubscriptionRevokedPayloadType.SUBSCRIPTION_REVOKED
                )
            ),
        ],
        pydantic.Field(alias="type"),
    ] = WebhookSubscriptionRevokedPayloadType.SUBSCRIPTION_REVOKED
