import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdk8s as _cdk8s_d3d9af27
import constructs as _constructs_77d1e7e8


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.Affinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class Affinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional[typing.Union["NodeAffinity", typing.Dict[builtins.str, typing.Any]]] = None,
        pod_affinity: typing.Optional[typing.Union["PodAffinity", typing.Dict[builtins.str, typing.Any]]] = None,
        pod_anti_affinity: typing.Optional[typing.Union["PodAntiAffinity", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Affinity is a group of affinity scheduling rules.

        :param node_affinity: Describes node affinity scheduling rules for the pod.
        :param pod_affinity: Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        :param pod_anti_affinity: Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).

        :schema: io.k8s.api.core.v1.Affinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = NodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = PodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = PodAntiAffinity(**pod_anti_affinity)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ffb7dca5621107bc06062a429f219a6966a7af5d8c15cd2cd756dfe0cf5d7cb7)
            check_type(argname="argument node_affinity", value=node_affinity, expected_type=type_hints["node_affinity"])
            check_type(argname="argument pod_affinity", value=pod_affinity, expected_type=type_hints["pod_affinity"])
            check_type(argname="argument pod_anti_affinity", value=pod_anti_affinity, expected_type=type_hints["pod_anti_affinity"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(self) -> typing.Optional["NodeAffinity"]:
        '''Describes node affinity scheduling rules for the pod.

        :schema: io.k8s.api.core.v1.Affinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["NodeAffinity"], result)

    @builtins.property
    def pod_affinity(self) -> typing.Optional["PodAffinity"]:
        '''Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).

        :schema: io.k8s.api.core.v1.Affinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["PodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(self) -> typing.Optional["PodAntiAffinity"]:
        '''Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).

        :schema: io.k8s.api.core.v1.Affinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["PodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Affinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AggregationRule",
    jsii_struct_bases=[],
    name_mapping={"cluster_role_selectors": "clusterRoleSelectors"},
)
class AggregationRule:
    def __init__(
        self,
        *,
        cluster_role_selectors: typing.Optional[typing.Sequence[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.

        :param cluster_role_selectors: ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules. If any of the selectors match, then the ClusterRole's permissions will be added

        :schema: io.k8s.api.rbac.v1.AggregationRule
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13a63c1a594fa3696da520ba00f0e8e7f15b73a05a4d2a4a592b15d6eeac9b4c)
            check_type(argname="argument cluster_role_selectors", value=cluster_role_selectors, expected_type=type_hints["cluster_role_selectors"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if cluster_role_selectors is not None:
            self._values["cluster_role_selectors"] = cluster_role_selectors

    @builtins.property
    def cluster_role_selectors(self) -> typing.Optional[typing.List["LabelSelector"]]:
        '''ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.

        If any of the selectors match, then the ClusterRole's permissions will be added

        :schema: io.k8s.api.rbac.v1.AggregationRule#clusterRoleSelectors
        '''
        result = self._values.get("cluster_role_selectors")
        return typing.cast(typing.Optional[typing.List["LabelSelector"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AggregationRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AllowedCsiDriverV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class AllowedCsiDriverV1Beta1:
    def __init__(self, *, name: builtins.str) -> None:
        '''AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.

        :param name: Name is the registered name of the CSI driver.

        :schema: io.k8s.api.policy.v1beta1.AllowedCSIDriver
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__115680884f02d4be6b75eca3ae3acbbc94892cf2e351a81f48a5d65035caf8cc)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Name is the registered name of the CSI driver.

        :schema: io.k8s.api.policy.v1beta1.AllowedCSIDriver#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AllowedCsiDriverV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AllowedFlexVolumeV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"driver": "driver"},
)
class AllowedFlexVolumeV1Beta1:
    def __init__(self, *, driver: builtins.str) -> None:
        '''AllowedFlexVolume represents a single Flexvolume that is allowed to be used.

        :param driver: driver is the name of the Flexvolume driver.

        :schema: io.k8s.api.policy.v1beta1.AllowedFlexVolume
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8837032d60cdfa14ab4b5ba85d8df2df95fd577fdcb01b7904ca155f132ec040)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the Flexvolume driver.

        :schema: io.k8s.api.policy.v1beta1.AllowedFlexVolume#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AllowedFlexVolumeV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AllowedHostPathV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"path_prefix": "pathPrefix", "read_only": "readOnly"},
)
class AllowedHostPathV1Beta1:
    def __init__(
        self,
        *,
        path_prefix: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use.

        It requires the path prefix to be defined.

        :param path_prefix: pathPrefix is the path prefix that the host volume must match. It does not support ``*``. Trailing slashes are trimmed when validating the path prefix with a host path. Examples: ``/foo`` would allow ``/foo``, ``/foo/`` and ``/foo/bar`` ``/foo`` would not allow ``/food`` or ``/etc/foo``
        :param read_only: when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.

        :schema: io.k8s.api.policy.v1beta1.AllowedHostPath
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bbb5abd1897211f2834eb1957133ad0b56f5a6c609870d66765b5f9625b72ae7)
            check_type(argname="argument path_prefix", value=path_prefix, expected_type=type_hints["path_prefix"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if path_prefix is not None:
            self._values["path_prefix"] = path_prefix
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def path_prefix(self) -> typing.Optional[builtins.str]:
        '''pathPrefix is the path prefix that the host volume must match.

        It does not support ``*``. Trailing slashes are trimmed when validating the path prefix with a host path.

        Examples: ``/foo`` would allow ``/foo``, ``/foo/`` and ``/foo/bar`` ``/foo`` would not allow ``/food`` or ``/etc/foo``

        :schema: io.k8s.api.policy.v1beta1.AllowedHostPath#pathPrefix
        '''
        result = self._values.get("path_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.

        :schema: io.k8s.api.policy.v1beta1.AllowedHostPath#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AllowedHostPathV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ApiServiceSpec",
    jsii_struct_bases=[],
    name_mapping={
        "group_priority_minimum": "groupPriorityMinimum",
        "version_priority": "versionPriority",
        "ca_bundle": "caBundle",
        "group": "group",
        "insecure_skip_tls_verify": "insecureSkipTlsVerify",
        "service": "service",
        "version": "version",
    },
)
class ApiServiceSpec:
    def __init__(
        self,
        *,
        group_priority_minimum: jsii.Number,
        version_priority: jsii.Number,
        ca_bundle: typing.Optional[builtins.str] = None,
        group: typing.Optional[builtins.str] = None,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        service: typing.Optional[typing.Union["ServiceReference", typing.Dict[builtins.str, typing.Any]]] = None,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''APIServiceSpec contains information for locating and communicating with a server.

        Only https is supported, though you are able to disable certificate verification.

        :param group_priority_minimum: GroupPriorityMininum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object. (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
        :param version_priority: VersionPriority controls the ordering of this API version inside of its group. Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        :param ca_bundle: CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.
        :param group: Group is the API group name this server hosts.
        :param insecure_skip_tls_verify: InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged. You should use the CABundle instead.
        :param service: Service is a reference to the service for this API server. It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
        :param version: Version is the API version this server hosts. For example, "v1"

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec
        '''
        if isinstance(service, dict):
            service = ServiceReference(**service)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6ed2185d13bef02f8fbee75c93f6476e8d88ba41e9972d6a846b1dce6c597f7)
            check_type(argname="argument group_priority_minimum", value=group_priority_minimum, expected_type=type_hints["group_priority_minimum"])
            check_type(argname="argument version_priority", value=version_priority, expected_type=type_hints["version_priority"])
            check_type(argname="argument ca_bundle", value=ca_bundle, expected_type=type_hints["ca_bundle"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument insecure_skip_tls_verify", value=insecure_skip_tls_verify, expected_type=type_hints["insecure_skip_tls_verify"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument version", value=version, expected_type=type_hints["version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "group_priority_minimum": group_priority_minimum,
            "version_priority": version_priority,
        }
        if ca_bundle is not None:
            self._values["ca_bundle"] = ca_bundle
        if group is not None:
            self._values["group"] = group
        if insecure_skip_tls_verify is not None:
            self._values["insecure_skip_tls_verify"] = insecure_skip_tls_verify
        if service is not None:
            self._values["service"] = service
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def group_priority_minimum(self) -> jsii.Number:
        '''GroupPriorityMininum is the priority this group should have at least.

        Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#groupPriorityMinimum
        '''
        result = self._values.get("group_priority_minimum")
        assert result is not None, "Required property 'group_priority_minimum' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def version_priority(self) -> jsii.Number:
        '''VersionPriority controls the ordering of this API version inside of its group.

        Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#versionPriority
        '''
        result = self._values.get("version_priority")
        assert result is not None, "Required property 'version_priority' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def ca_bundle(self) -> typing.Optional[builtins.str]:
        '''CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.

        If unspecified, system trust roots on the apiserver are used.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#caBundle
        '''
        result = self._values.get("ca_bundle")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def group(self) -> typing.Optional[builtins.str]:
        '''Group is the API group name this server hosts.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#group
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def insecure_skip_tls_verify(self) -> typing.Optional[builtins.bool]:
        '''InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server.

        This is strongly discouraged.  You should use the CABundle instead.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#insecureSkipTLSVerify
        '''
        result = self._values.get("insecure_skip_tls_verify")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def service(self) -> typing.Optional["ServiceReference"]:
        '''Service is a reference to the service for this API server.

        It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#service
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional["ServiceReference"], result)

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        '''Version is the API version this server hosts.

        For example, "v1"

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#version
        '''
        result = self._values.get("version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiServiceSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AwsElasticBlockStoreVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStoreVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Persistent Disk resource in AWS.

        An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.

        :param volume_id: volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        :param read_only: readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77f75370cdec72ba03b6034472d031f937fccc30c298a8b5f500c0a1c3976d75)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume).

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''partition is the partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly value true will force the readOnly setting in VolumeMounts.

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStoreVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AzureDiskVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "disk_name": "diskName",
        "disk_uri": "diskUri",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class AzureDiskVolumeSource:
    def __init__(
        self,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[builtins.str] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.

        :param disk_name: diskName is the Name of the data disk in the blob storage.
        :param disk_uri: diskURI is the URI of data disk in the blob storage.
        :param caching_mode: cachingMode is the Host Caching mode: None, Read Only, Read Write.
        :param fs_type: fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param kind: kind expected values are Shared: multiple blob disks per storage account Dedicated: single blob disk per storage account Managed: azure managed data disk (only in managed availability set). defaults to shared
        :param read_only: readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc606c5748ebceba4481279047a30b6151866949b656d0182a96375a0a1530f9)
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''diskName is the Name of the data disk in the blob storage.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#diskName
        '''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''diskURI is the URI of data disk in the blob storage.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#diskURI
        '''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[builtins.str]:
        '''cachingMode is the Host Caching mode: None, Read Only, Read Write.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#cachingMode
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set).

        defaults to shared

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AzureFilePersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
        "secret_namespace": "secretNamespace",
    },
)
class AzureFilePersistentVolumeSource:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
        secret_namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''AzureFile represents an Azure File Service mount on the host and bind mount to the pod.

        :param secret_name: secretName is the name of secret that contains Azure Storage Account Name and Key.
        :param share_name: shareName is the azure Share Name.
        :param read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_namespace: secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b582dc0e93006a9e2be4d0255dc23f9ca0c24e44d7faeabb20af7c0875be134f)
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
            check_type(argname="argument share_name", value=share_name, expected_type=type_hints["share_name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_namespace", value=secret_namespace, expected_type=type_hints["secret_namespace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_namespace is not None:
            self._values["secret_namespace"] = secret_namespace

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''secretName is the name of secret that contains Azure Storage Account Name and Key.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''shareName is the azure Share Name.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_namespace(self) -> typing.Optional[builtins.str]:
        '''secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretNamespace
        '''
        result = self._values.get("secret_namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureFilePersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.AzureFileVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
    },
)
class AzureFileVolumeSource:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''AzureFile represents an Azure File Service mount on the host and bind mount to the pod.

        :param secret_name: secretName is the name of secret that contains Azure Storage Account Name and Key.
        :param share_name: shareName is the azure share Name.
        :param read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d917975c113870ecf3a52ce8d5b261ad09861bcc3acc939cfe4effb0ec74aedd)
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
            check_type(argname="argument share_name", value=share_name, expected_type=type_hints["share_name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''secretName is the  name of secret that contains Azure Storage Account Name and Key.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''shareName is the azure share Name.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureFileVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.BoundObjectReference",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "kind": "kind",
        "name": "name",
        "uid": "uid",
    },
)
class BoundObjectReference:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        uid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''BoundObjectReference is a reference to an object that a token is bound to.

        :param api_version: API version of the referent.
        :param kind: Kind of the referent. Valid kinds are 'Pod' and 'Secret'.
        :param name: Name of the referent.
        :param uid: UID of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8b179754679084e5dc772adcb8eb6e4269b7371de71a2ce28a1a01cd97c45c8)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if kind is not None:
            self._values["kind"] = kind
        if name is not None:
            self._values["name"] = name
        if uid is not None:
            self._values["uid"] = uid

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''API version of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''Kind of the referent.

        Valid kinds are 'Pod' and 'Secret'.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''UID of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BoundObjectReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.Capabilities",
    jsii_struct_bases=[],
    name_mapping={"add": "add", "drop": "drop"},
)
class Capabilities:
    def __init__(
        self,
        *,
        add: typing.Optional[typing.Sequence[builtins.str]] = None,
        drop: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Adds and removes POSIX capabilities from running containers.

        :param add: Added capabilities.
        :param drop: Removed capabilities.

        :schema: io.k8s.api.core.v1.Capabilities
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__073f239913eb7ef5022d307326547d9a2d5c05177481b0d2c2b8ef2993bb79c0)
            check_type(argname="argument add", value=add, expected_type=type_hints["add"])
            check_type(argname="argument drop", value=drop, expected_type=type_hints["drop"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if add is not None:
            self._values["add"] = add
        if drop is not None:
            self._values["drop"] = drop

    @builtins.property
    def add(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Added capabilities.

        :schema: io.k8s.api.core.v1.Capabilities#add
        '''
        result = self._values.get("add")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def drop(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Removed capabilities.

        :schema: io.k8s.api.core.v1.Capabilities#drop
        '''
        result = self._values.get("drop")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Capabilities(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CephFsPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class CephFsPersistentVolumeSource:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.

        :param monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param user: user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d613840610e36dac650c3dc5b14e134c2ee58f5fd866c611282e1493da14e5ac)
            check_type(argname="argument monitors", value=monitors, expected_type=type_hints["monitors"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_file", value=secret_file, expected_type=type_hints["secret_file"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.

        More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CephFsPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CephFsVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class CephFsVolumeSource:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.

        :param monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param user: user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff5d9f8fa3eb936b63648e3bb23a7494d80aae87c1a75b27478867f7f9c7ad04)
            check_type(argname="argument monitors", value=monitors, expected_type=type_hints["monitors"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_file", value=secret_file, expected_type=type_hints["secret_file"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.

        More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CephFsVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CertificateSigningRequestSpec",
    jsii_struct_bases=[],
    name_mapping={
        "request": "request",
        "signer_name": "signerName",
        "expiration_seconds": "expirationSeconds",
        "extra": "extra",
        "groups": "groups",
        "uid": "uid",
        "usages": "usages",
        "username": "username",
    },
)
class CertificateSigningRequestSpec:
    def __init__(
        self,
        *,
        request: builtins.str,
        signer_name: builtins.str,
        expiration_seconds: typing.Optional[jsii.Number] = None,
        extra: typing.Optional[typing.Mapping[builtins.str, typing.Sequence[builtins.str]]] = None,
        groups: typing.Optional[typing.Sequence[builtins.str]] = None,
        uid: typing.Optional[builtins.str] = None,
        usages: typing.Optional[typing.Sequence[builtins.str]] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CertificateSigningRequestSpec contains the certificate request.

        :param request: request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.
        :param signer_name: signerName indicates the requested signer, and is a qualified name. List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector. Well-known Kubernetes signers are: 1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver. Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager. 2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver. Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager. 3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely. Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager. More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers Custom signerNames can also be specified. The signer defines: 1. Trust distribution: how trust (CA bundles) are distributed. 2. Permitted subjects: and behavior when a disallowed subject is requested. 3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested. 4. Required, permitted, or forbidden key usages / extended key usages. 5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin. 6. Whether or not requests for CA certificates are allowed.
        :param expiration_seconds: expirationSeconds is the requested duration of validity of the issued certificate. The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration. The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager. Certificate signers may not honor this field for various reasons: 1. Old signer that is unaware of the field (such as the in-tree implementations prior to v1.22) 2. Signer whose configured maximum is shorter than the requested duration 3. Signer whose configured minimum is longer than the requested duration The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.
        :param extra: extra contains extra attributes of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
        :param groups: groups contains group membership of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
        :param uid: uid contains the uid of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
        :param usages: usages specifies a set of key usages requested in the issued certificate. Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth". Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth". Valid values are: "signing", "digital signature", "content commitment", "key encipherment", "key agreement", "data encipherment", "cert sign", "crl sign", "encipher only", "decipher only", "any", "server auth", "client auth", "code signing", "email protection", "s/mime", "ipsec end system", "ipsec tunnel", "ipsec user", "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"
        :param username: username contains the name of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02cca93ba95dd071e5f89a7c91d80dc5e77d05e23e9c61d630a9cea3a2a70bae)
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
            check_type(argname="argument signer_name", value=signer_name, expected_type=type_hints["signer_name"])
            check_type(argname="argument expiration_seconds", value=expiration_seconds, expected_type=type_hints["expiration_seconds"])
            check_type(argname="argument extra", value=extra, expected_type=type_hints["extra"])
            check_type(argname="argument groups", value=groups, expected_type=type_hints["groups"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
            check_type(argname="argument usages", value=usages, expected_type=type_hints["usages"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "request": request,
            "signer_name": signer_name,
        }
        if expiration_seconds is not None:
            self._values["expiration_seconds"] = expiration_seconds
        if extra is not None:
            self._values["extra"] = extra
        if groups is not None:
            self._values["groups"] = groups
        if uid is not None:
            self._values["uid"] = uid
        if usages is not None:
            self._values["usages"] = usages
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def request(self) -> builtins.str:
        '''request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block.

        When serialized as JSON or YAML, the data is additionally base64-encoded.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#request
        '''
        result = self._values.get("request")
        assert result is not None, "Required property 'request' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def signer_name(self) -> builtins.str:
        '''signerName indicates the requested signer, and is a qualified name.

        List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector.

        Well-known Kubernetes signers are:

        1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver.
           Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager.
        2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver.
           Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
        3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
           Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.

        More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers

        Custom signerNames can also be specified. The signer defines:

        1. Trust distribution: how trust (CA bundles) are distributed.
        2. Permitted subjects: and behavior when a disallowed subject is requested.
        3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
        4. Required, permitted, or forbidden key usages / extended key usages.
        5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
        6. Whether or not requests for CA certificates are allowed.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#signerName
        '''
        result = self._values.get("signer_name")
        assert result is not None, "Required property 'signer_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def expiration_seconds(self) -> typing.Optional[jsii.Number]:
        '''expirationSeconds is the requested duration of validity of the issued certificate.

        The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration.

        The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager.

        Certificate signers may not honor this field for various reasons:

        1. Old signer that is unaware of the field (such as the in-tree
           implementations prior to v1.22)
        2. Signer whose configured maximum is shorter than the requested duration
        3. Signer whose configured minimum is longer than the requested duration

        The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#expirationSeconds
        '''
        result = self._values.get("expiration_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def extra(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.List[builtins.str]]]:
        '''extra contains extra attributes of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#extra
        '''
        result = self._values.get("extra")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.List[builtins.str]]], result)

    @builtins.property
    def groups(self) -> typing.Optional[typing.List[builtins.str]]:
        '''groups contains group membership of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#groups
        '''
        result = self._values.get("groups")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''uid contains the uid of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def usages(self) -> typing.Optional[typing.List[builtins.str]]:
        '''usages specifies a set of key usages requested in the issued certificate.

        Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth".

        Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth".

        Valid values are:
        "signing", "digital signature", "content commitment",
        "key encipherment", "key agreement", "data encipherment",
        "cert sign", "crl sign", "encipher only", "decipher only", "any",
        "server auth", "client auth",
        "code signing", "email protection", "s/mime",
        "ipsec end system", "ipsec tunnel", "ipsec user",
        "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#usages
        '''
        result = self._values.get("usages")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''username contains the name of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#username
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CertificateSigningRequestSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CinderPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class CinderPersistentVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents a cinder volume resource in Openstack.

        A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.

        :param volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param fs_type: fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param secret_ref: secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b753625759818f0c47f0cf6a99c20f785098514b556c4ce53ecb41a9980b49d)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''volumeID used to identify the volume in cinder.

        More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CinderPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CinderVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class CinderVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents a cinder volume resource in Openstack.

        A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.

        :param volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param secret_ref: secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab58f8b5dcdc79e4cebe1f9ca21c262d879f162b556c376d0069e9cb979d947e)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''volumeID used to identify the volume in cinder.

        More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CinderVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ClientIpConfig",
    jsii_struct_bases=[],
    name_mapping={"timeout_seconds": "timeoutSeconds"},
)
class ClientIpConfig:
    def __init__(self, *, timeout_seconds: typing.Optional[jsii.Number] = None) -> None:
        '''ClientIPConfig represents the configurations of Client IP based session affinity.

        :param timeout_seconds: timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).

        :schema: io.k8s.api.core.v1.ClientIPConfig
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c57fb595db848576d7b461298f59c404bf164caa585a20fcfd51d98f9423035)
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''timeoutSeconds specifies the seconds of ClientIP type session sticky time.

        The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).

        :schema: io.k8s.api.core.v1.ClientIPConfig#timeoutSeconds
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClientIpConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ComponentCondition",
    jsii_struct_bases=[],
    name_mapping={
        "status": "status",
        "type": "type",
        "error": "error",
        "message": "message",
    },
)
class ComponentCondition:
    def __init__(
        self,
        *,
        status: builtins.str,
        type: builtins.str,
        error: typing.Optional[builtins.str] = None,
        message: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Information about the condition of a component.

        :param status: Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown".
        :param type: Type of condition for a component. Valid value: "Healthy"
        :param error: Condition error code for a component. For example, a health check error code.
        :param message: Message about the condition for a component. For example, information about a health check.

        :schema: io.k8s.api.core.v1.ComponentCondition
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a124bc77e770f921d180f31cf3fccdb2b6a82584ebd90a2e7185f3f0a41456b9)
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument error", value=error, expected_type=type_hints["error"])
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "status": status,
            "type": type,
        }
        if error is not None:
            self._values["error"] = error
        if message is not None:
            self._values["message"] = message

    @builtins.property
    def status(self) -> builtins.str:
        '''Status of the condition for a component.

        Valid values for "Healthy": "True", "False", or "Unknown".

        :schema: io.k8s.api.core.v1.ComponentCondition#status
        '''
        result = self._values.get("status")
        assert result is not None, "Required property 'status' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Type of condition for a component.

        Valid value: "Healthy"

        :schema: io.k8s.api.core.v1.ComponentCondition#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def error(self) -> typing.Optional[builtins.str]:
        '''Condition error code for a component.

        For example, a health check error code.

        :schema: io.k8s.api.core.v1.ComponentCondition#error
        '''
        result = self._values.get("error")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def message(self) -> typing.Optional[builtins.str]:
        '''Message about the condition for a component.

        For example, information about a health check.

        :schema: io.k8s.api.core.v1.ComponentCondition#message
        '''
        result = self._values.get("message")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ComponentCondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ConfigMapEnvSource",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "optional": "optional"},
)
class ConfigMapEnvSource:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.

        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: Specify whether the ConfigMap must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapEnvSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3e2cae176ceee9656e858d6564e8a56beb095309607a28650e2bf5bc1ac593b)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapEnvSource#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapEnvSource#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapEnvSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ConfigMapKeySelector",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class ConfigMapKeySelector:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Selects a key from a ConfigMap.

        :param key: The key to select.
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: Specify whether the ConfigMap or its key must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__300095b07ebf5d292f91960a7a213721d6d565d5e12f1889daee166e0a2fd860)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''The key to select.

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its key must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapKeySelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ConfigMapNodeConfigSource",
    jsii_struct_bases=[],
    name_mapping={
        "kubelet_config_key": "kubeletConfigKey",
        "name": "name",
        "namespace": "namespace",
        "resource_version": "resourceVersion",
        "uid": "uid",
    },
)
class ConfigMapNodeConfigSource:
    def __init__(
        self,
        *,
        kubelet_config_key: builtins.str,
        name: builtins.str,
        namespace: builtins.str,
        resource_version: typing.Optional[builtins.str] = None,
        uid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.

        This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration

        :param kubelet_config_key: KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        :param name: Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        :param namespace: Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        :param resource_version: ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        :param uid: UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bdff463d593c5d2ac3255c3cf2e22f6c7b59a87771e90e9b5c0644a40d81c8b)
            check_type(argname="argument kubelet_config_key", value=kubelet_config_key, expected_type=type_hints["kubelet_config_key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument resource_version", value=resource_version, expected_type=type_hints["resource_version"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kubelet_config_key": kubelet_config_key,
            "name": name,
            "namespace": namespace,
        }
        if resource_version is not None:
            self._values["resource_version"] = resource_version
        if uid is not None:
            self._values["uid"] = uid

    @builtins.property
    def kubelet_config_key(self) -> builtins.str:
        '''KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#kubeletConfigKey
        '''
        result = self._values.get("kubelet_config_key")
        assert result is not None, "Required property 'kubelet_config_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#namespace
        '''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_version(self) -> typing.Optional[builtins.str]:
        '''ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#resourceVersion
        '''
        result = self._values.get("resource_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapNodeConfigSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ConfigMapProjection",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "name": "name", "optional": "optional"},
)
class ConfigMapProjection:
    def __init__(
        self,
        *,
        items: typing.Optional[typing.Sequence[typing.Union["KeyToPath", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Adapts a ConfigMap into a projected volume.

        The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.

        :param items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapProjection
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__640d6af184a4a36f8a27618730217af6aedce52d48248e4466988a8a1ca020b4)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def items(self) -> typing.Optional[typing.List["KeyToPath"]]:
        '''items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.

        :schema: io.k8s.api.core.v1.ConfigMapProjection#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["KeyToPath"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapProjection#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapProjection#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapProjection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ConfigMapVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class ConfigMapVolumeSource:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[typing.Union["KeyToPath", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Adapts a ConfigMap into a volume.

        The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.

        :param default_mode: defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a89ca74cd51b1fb04bddd7065c1d9d25988e40b809fd316ab0146c678943d293)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''defaultMode is optional: mode bits used to set permissions on created files by default.

        Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.List["KeyToPath"]]:
        '''items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["KeyToPath"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.Container",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "args": "args",
        "command": "command",
        "env": "env",
        "env_from": "envFrom",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness_probe": "livenessProbe",
        "ports": "ports",
        "readiness_probe": "readinessProbe",
        "resources": "resources",
        "security_context": "securityContext",
        "startup_probe": "startupProbe",
        "stdin": "stdin",
        "stdin_once": "stdinOnce",
        "termination_message_path": "terminationMessagePath",
        "termination_message_policy": "terminationMessagePolicy",
        "tty": "tty",
        "volume_devices": "volumeDevices",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class Container:
    def __init__(
        self,
        *,
        name: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env: typing.Optional[typing.Sequence[typing.Union["EnvVar", typing.Dict[builtins.str, typing.Any]]]] = None,
        env_from: typing.Optional[typing.Sequence[typing.Union["EnvFromSource", typing.Dict[builtins.str, typing.Any]]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        lifecycle: typing.Optional[typing.Union["Lifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        resources: typing.Optional[typing.Union["ResourceRequirements", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["SecurityContext", typing.Dict[builtins.str, typing.Any]]] = None,
        startup_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        stdin: typing.Optional[builtins.bool] = None,
        stdin_once: typing.Optional[builtins.bool] = None,
        termination_message_path: typing.Optional[builtins.str] = None,
        termination_message_policy: typing.Optional[builtins.str] = None,
        tty: typing.Optional[builtins.bool] = None,
        volume_devices: typing.Optional[typing.Sequence[typing.Union["VolumeDevice", typing.Dict[builtins.str, typing.Any]]]] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''A single application container that you want to run within a pod.

        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        :param args: Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param command: Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param env: List of environment variables to set in the container. Cannot be updated.
        :param env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        :param image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images Default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        :param liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param ports: List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.
        :param readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param startup_probe: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. Default: false.
        :param stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false Default: false
        :param termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. Default: dev/termination-log. Cannot be updated.
        :param termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. Default: File. Cannot be updated.
        :param tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. Default: false.
        :param volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container
        '''
        if isinstance(lifecycle, dict):
            lifecycle = Lifecycle(**lifecycle)
        if isinstance(liveness_probe, dict):
            liveness_probe = Probe(**liveness_probe)
        if isinstance(readiness_probe, dict):
            readiness_probe = Probe(**readiness_probe)
        if isinstance(resources, dict):
            resources = ResourceRequirements(**resources)
        if isinstance(security_context, dict):
            security_context = SecurityContext(**security_context)
        if isinstance(startup_probe, dict):
            startup_probe = Probe(**startup_probe)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c4a59a73ddff4bd8127d2731b6959cd2037492de337c6b20064d4f8341138e2a)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness_probe", value=liveness_probe, expected_type=type_hints["liveness_probe"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness_probe", value=readiness_probe, expected_type=type_hints["readiness_probe"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup_probe", value=startup_probe, expected_type=type_hints["startup_probe"])
            check_type(argname="argument stdin", value=stdin, expected_type=type_hints["stdin"])
            check_type(argname="argument stdin_once", value=stdin_once, expected_type=type_hints["stdin_once"])
            check_type(argname="argument termination_message_path", value=termination_message_path, expected_type=type_hints["termination_message_path"])
            check_type(argname="argument termination_message_policy", value=termination_message_policy, expected_type=type_hints["termination_message_policy"])
            check_type(argname="argument tty", value=tty, expected_type=type_hints["tty"])
            check_type(argname="argument volume_devices", value=volume_devices, expected_type=type_hints["volume_devices"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env is not None:
            self._values["env"] = env
        if env_from is not None:
            self._values["env_from"] = env_from
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness_probe is not None:
            self._values["liveness_probe"] = liveness_probe
        if ports is not None:
            self._values["ports"] = ports
        if readiness_probe is not None:
            self._values["readiness_probe"] = readiness_probe
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup_probe is not None:
            self._values["startup_probe"] = startup_probe
        if stdin is not None:
            self._values["stdin"] = stdin
        if stdin_once is not None:
            self._values["stdin_once"] = stdin_once
        if termination_message_path is not None:
            self._values["termination_message_path"] = termination_message_path
        if termination_message_policy is not None:
            self._values["termination_message_policy"] = termination_message_policy
        if tty is not None:
            self._values["tty"] = tty
        if volume_devices is not None:
            self._values["volume_devices"] = volume_devices
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.Container#args
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.Container#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List["EnvVar"]]:
        '''List of environment variables to set in the container.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List["EnvVar"]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFromSource"]]:
        '''List of sources to populate environment variables in the container.

        The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#envFrom
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFromSource"]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''Container image name.

        More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.

        :schema: io.k8s.api.core.v1.Container#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''Image pull policy.

        One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :schema: io.k8s.api.core.v1.Container#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["Lifecycle"]:
        '''Actions that the management system should take in response to container lifecycle events.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#lifecycle
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["Lifecycle"], result)

    @builtins.property
    def liveness_probe(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :schema: io.k8s.api.core.v1.Container#livenessProbe
        '''
        result = self._values.get("liveness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ContainerPort"]]:
        '''List of ports to expose from the container.

        Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ContainerPort"]], result)

    @builtins.property
    def readiness_probe(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container service readiness.

        Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :schema: io.k8s.api.core.v1.Container#readinessProbe
        '''
        result = self._values.get("readiness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ResourceRequirements"]:
        '''Compute Resources required by this container.

        Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/

        :schema: io.k8s.api.core.v1.Container#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ResourceRequirements"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["SecurityContext"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/

        :schema: io.k8s.api.core.v1.Container#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["SecurityContext"], result)

    @builtins.property
    def startup_probe(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :schema: io.k8s.api.core.v1.Container#startupProbe
        '''
        result = self._values.get("startup_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def stdin(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a buffer for stdin in the container runtime.

        If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.Container#stdin
        '''
        result = self._values.get("stdin")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stdin_once(self) -> typing.Optional[builtins.bool]:
        '''Whether the container runtime should close the stdin channel after it has been opened by a single attach.

        When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :default: false

        :schema: io.k8s.api.core.v1.Container#stdinOnce
        '''
        result = self._values.get("stdin_once")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def termination_message_path(self) -> typing.Optional[builtins.str]:
        '''Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.

        Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.

        :default: dev/termination-log. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#terminationMessagePath
        '''
        result = self._values.get("termination_message_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_policy(self) -> typing.Optional[builtins.str]:
        '''Indicate how the termination message should be populated.

        File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.

        :default: File. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#terminationMessagePolicy
        '''
        result = self._values.get("termination_message_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tty(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.

        Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.Container#tty
        '''
        result = self._values.get("tty")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_devices(self) -> typing.Optional[typing.List["VolumeDevice"]]:
        '''volumeDevices is the list of block devices to be used by the container.

        :schema: io.k8s.api.core.v1.Container#volumeDevices
        '''
        result = self._values.get("volume_devices")
        return typing.cast(typing.Optional[typing.List["VolumeDevice"]], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#volumeMounts
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#workingDir
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Container(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ContainerPort",
    jsii_struct_bases=[],
    name_mapping={
        "container_port": "containerPort",
        "host_ip": "hostIp",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class ContainerPort:
    def __init__(
        self,
        *,
        container_port: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ContainerPort represents a network port in a single container.

        :param container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: TCP".

        :schema: io.k8s.api.core.v1.ContainerPort
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__302b208722f24d90655e01e1acced17ad78234a52dff2eaf3a74d459676a1785)
            check_type(argname="argument container_port", value=container_port, expected_type=type_hints["container_port"])
            check_type(argname="argument host_ip", value=host_ip, expected_type=type_hints["host_ip"])
            check_type(argname="argument host_port", value=host_port, expected_type=type_hints["host_port"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container_port": container_port,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def container_port(self) -> jsii.Number:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        :schema: io.k8s.api.core.v1.ContainerPort#containerPort
        '''
        result = self._values.get("container_port")
        assert result is not None, "Required property 'container_port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''What host IP to bind the external port to.

        :schema: io.k8s.api.core.v1.ContainerPort#hostIP
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the host.

        If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.

        :schema: io.k8s.api.core.v1.ContainerPort#hostPort
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''If specified, this must be an IANA_SVC_NAME and unique within the pod.

        Each named port in a pod must have a unique name. Name for the port that can be referred to by services.

        :schema: io.k8s.api.core.v1.ContainerPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''Protocol for port.

        Must be UDP, TCP, or SCTP. Defaults to "TCP".

        :default: TCP".

        :schema: io.k8s.api.core.v1.ContainerPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ContainerResourceMetricSourceV2",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "name": "name", "target": "target"},
)
class ContainerResourceMetricSourceV2:
    def __init__(
        self,
        *,
        container: builtins.str,
        name: builtins.str,
        target: typing.Union["MetricTargetV2", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.

        :param container: container is the name of the container in the pods of the scaling target.
        :param name: name is the name of the resource in question.
        :param target: target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource
        '''
        if isinstance(target, dict):
            target = MetricTargetV2(**target)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b66a1ef8a900d105b239e44cf7610e25c7bd0bb166a9d53a5c4893247d1ed26)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "name": name,
            "target": target,
        }

    @builtins.property
    def container(self) -> builtins.str:
        '''container is the name of the container in the pods of the scaling target.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource#container
        '''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of the resource in question.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> "MetricTargetV2":
        '''target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTargetV2", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResourceMetricSourceV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ContainerResourceMetricSourceV2Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "container": "container",
        "name": "name",
        "target_average_utilization": "targetAverageUtilization",
        "target_average_value": "targetAverageValue",
    },
)
class ContainerResourceMetricSourceV2Beta1:
    def __init__(
        self,
        *,
        container: builtins.str,
        name: builtins.str,
        target_average_utilization: typing.Optional[jsii.Number] = None,
        target_average_value: typing.Optional["Quantity"] = None,
    ) -> None:
        '''ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.

        :param container: container is the name of the container in the pods of the scaling target.
        :param name: name is the name of the resource in question.
        :param target_average_utilization: targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param target_average_value: targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type.

        :schema: io.k8s.api.autoscaling.v2beta1.ContainerResourceMetricSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a25bf5b3086d7e461333005fed95e26015fd44d8c3a8c9efe6d7a1c976bc29c)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target_average_utilization", value=target_average_utilization, expected_type=type_hints["target_average_utilization"])
            check_type(argname="argument target_average_value", value=target_average_value, expected_type=type_hints["target_average_value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "name": name,
        }
        if target_average_utilization is not None:
            self._values["target_average_utilization"] = target_average_utilization
        if target_average_value is not None:
            self._values["target_average_value"] = target_average_value

    @builtins.property
    def container(self) -> builtins.str:
        '''container is the name of the container in the pods of the scaling target.

        :schema: io.k8s.api.autoscaling.v2beta1.ContainerResourceMetricSource#container
        '''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of the resource in question.

        :schema: io.k8s.api.autoscaling.v2beta1.ContainerResourceMetricSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target_average_utilization(self) -> typing.Optional[jsii.Number]:
        '''targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.

        :schema: io.k8s.api.autoscaling.v2beta1.ContainerResourceMetricSource#targetAverageUtilization
        '''
        result = self._values.get("target_average_utilization")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def target_average_value(self) -> typing.Optional["Quantity"]:
        '''targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the "pods" metric source type.

        :schema: io.k8s.api.autoscaling.v2beta1.ContainerResourceMetricSource#targetAverageValue
        '''
        result = self._values.get("target_average_value")
        return typing.cast(typing.Optional["Quantity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResourceMetricSourceV2Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ContainerResourceMetricSourceV2Beta2",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "name": "name", "target": "target"},
)
class ContainerResourceMetricSourceV2Beta2:
    def __init__(
        self,
        *,
        container: builtins.str,
        name: builtins.str,
        target: typing.Union["MetricTargetV2Beta2", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.

        :param container: container is the name of the container in the pods of the scaling target.
        :param name: name is the name of the resource in question.
        :param target: target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource
        '''
        if isinstance(target, dict):
            target = MetricTargetV2Beta2(**target)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab3e893e92115cf8fa4391fe8d1d8cabf62c6694a99bedf529c84efe2eb3977f)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "name": name,
            "target": target,
        }

    @builtins.property
    def container(self) -> builtins.str:
        '''container is the name of the container in the pods of the scaling target.

        :schema: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource#container
        '''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of the resource in question.

        :schema: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> "MetricTargetV2Beta2":
        '''target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTargetV2Beta2", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResourceMetricSourceV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CronJobSpec",
    jsii_struct_bases=[],
    name_mapping={
        "job_template": "jobTemplate",
        "schedule": "schedule",
        "concurrency_policy": "concurrencyPolicy",
        "failed_jobs_history_limit": "failedJobsHistoryLimit",
        "starting_deadline_seconds": "startingDeadlineSeconds",
        "successful_jobs_history_limit": "successfulJobsHistoryLimit",
        "suspend": "suspend",
        "time_zone": "timeZone",
    },
)
class CronJobSpec:
    def __init__(
        self,
        *,
        job_template: typing.Union["JobTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        schedule: builtins.str,
        concurrency_policy: typing.Optional[builtins.str] = None,
        failed_jobs_history_limit: typing.Optional[jsii.Number] = None,
        starting_deadline_seconds: typing.Optional[jsii.Number] = None,
        successful_jobs_history_limit: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
        time_zone: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CronJobSpec describes how the job execution will look like and when it will actually run.

        :param job_template: Specifies the job that will be created when executing a CronJob.
        :param schedule: The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        :param concurrency_policy: Specifies how to treat concurrent executions of a Job. Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        :param failed_jobs_history_limit: The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1. Default: 1.
        :param starting_deadline_seconds: Optional deadline in seconds for starting the job if it misses scheduled time for any reason. Missed jobs executions will be counted as failed ones.
        :param successful_jobs_history_limit: The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3. Default: 3.
        :param suspend: This flag tells the controller to suspend subsequent executions, it does not apply to already started executions. Defaults to false. Default: false.
        :param time_zone: The time zone for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will rely on the time zone of the kube-controller-manager process. ALPHA: This field is in alpha and must be enabled via the ``CronJobTimeZone`` feature gate.

        :schema: io.k8s.api.batch.v1.CronJobSpec
        '''
        if isinstance(job_template, dict):
            job_template = JobTemplateSpec(**job_template)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfadece21b1b9b13307d2c97907be510872b160bd4d04476de7da5be3f36ca81)
            check_type(argname="argument job_template", value=job_template, expected_type=type_hints["job_template"])
            check_type(argname="argument schedule", value=schedule, expected_type=type_hints["schedule"])
            check_type(argname="argument concurrency_policy", value=concurrency_policy, expected_type=type_hints["concurrency_policy"])
            check_type(argname="argument failed_jobs_history_limit", value=failed_jobs_history_limit, expected_type=type_hints["failed_jobs_history_limit"])
            check_type(argname="argument starting_deadline_seconds", value=starting_deadline_seconds, expected_type=type_hints["starting_deadline_seconds"])
            check_type(argname="argument successful_jobs_history_limit", value=successful_jobs_history_limit, expected_type=type_hints["successful_jobs_history_limit"])
            check_type(argname="argument suspend", value=suspend, expected_type=type_hints["suspend"])
            check_type(argname="argument time_zone", value=time_zone, expected_type=type_hints["time_zone"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "job_template": job_template,
            "schedule": schedule,
        }
        if concurrency_policy is not None:
            self._values["concurrency_policy"] = concurrency_policy
        if failed_jobs_history_limit is not None:
            self._values["failed_jobs_history_limit"] = failed_jobs_history_limit
        if starting_deadline_seconds is not None:
            self._values["starting_deadline_seconds"] = starting_deadline_seconds
        if successful_jobs_history_limit is not None:
            self._values["successful_jobs_history_limit"] = successful_jobs_history_limit
        if suspend is not None:
            self._values["suspend"] = suspend
        if time_zone is not None:
            self._values["time_zone"] = time_zone

    @builtins.property
    def job_template(self) -> "JobTemplateSpec":
        '''Specifies the job that will be created when executing a CronJob.

        :schema: io.k8s.api.batch.v1.CronJobSpec#jobTemplate
        '''
        result = self._values.get("job_template")
        assert result is not None, "Required property 'job_template' is missing"
        return typing.cast("JobTemplateSpec", result)

    @builtins.property
    def schedule(self) -> builtins.str:
        '''The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.

        :schema: io.k8s.api.batch.v1.CronJobSpec#schedule
        '''
        result = self._values.get("schedule")
        assert result is not None, "Required property 'schedule' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def concurrency_policy(self) -> typing.Optional[builtins.str]:
        '''Specifies how to treat concurrent executions of a Job.

        Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one

        :schema: io.k8s.api.batch.v1.CronJobSpec#concurrencyPolicy
        '''
        result = self._values.get("concurrency_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def failed_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of failed finished jobs to retain.

        Value must be non-negative integer. Defaults to 1.

        :default: 1.

        :schema: io.k8s.api.batch.v1.CronJobSpec#failedJobsHistoryLimit
        '''
        result = self._values.get("failed_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def starting_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''Optional deadline in seconds for starting the job if it misses scheduled time for any reason.

        Missed jobs executions will be counted as failed ones.

        :schema: io.k8s.api.batch.v1.CronJobSpec#startingDeadlineSeconds
        '''
        result = self._values.get("starting_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def successful_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of successful finished jobs to retain.

        Value must be non-negative integer. Defaults to 3.

        :default: 3.

        :schema: io.k8s.api.batch.v1.CronJobSpec#successfulJobsHistoryLimit
        '''
        result = self._values.get("successful_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.batch.v1.CronJobSpec#suspend
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def time_zone(self) -> typing.Optional[builtins.str]:
        '''The time zone for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will rely on the time zone of the kube-controller-manager process. ALPHA: This field is in alpha and must be enabled via the ``CronJobTimeZone`` feature gate.

        :schema: io.k8s.api.batch.v1.CronJobSpec#timeZone
        '''
        result = self._values.get("time_zone")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CronJobSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CronJobSpecV1Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "job_template": "jobTemplate",
        "schedule": "schedule",
        "concurrency_policy": "concurrencyPolicy",
        "failed_jobs_history_limit": "failedJobsHistoryLimit",
        "starting_deadline_seconds": "startingDeadlineSeconds",
        "successful_jobs_history_limit": "successfulJobsHistoryLimit",
        "suspend": "suspend",
        "time_zone": "timeZone",
    },
)
class CronJobSpecV1Beta1:
    def __init__(
        self,
        *,
        job_template: typing.Union["JobTemplateSpecV1Beta1", typing.Dict[builtins.str, typing.Any]],
        schedule: builtins.str,
        concurrency_policy: typing.Optional[builtins.str] = None,
        failed_jobs_history_limit: typing.Optional[jsii.Number] = None,
        starting_deadline_seconds: typing.Optional[jsii.Number] = None,
        successful_jobs_history_limit: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
        time_zone: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CronJobSpec describes how the job execution will look like and when it will actually run.

        :param job_template: Specifies the job that will be created when executing a CronJob.
        :param schedule: The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        :param concurrency_policy: Specifies how to treat concurrent executions of a Job. Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        :param failed_jobs_history_limit: The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1. Default: 1.
        :param starting_deadline_seconds: Optional deadline in seconds for starting the job if it misses scheduled time for any reason. Missed jobs executions will be counted as failed ones.
        :param successful_jobs_history_limit: The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified. Defaults to 3. Default: 3.
        :param suspend: This flag tells the controller to suspend subsequent executions, it does not apply to already started executions. Defaults to false. Default: false.
        :param time_zone: The time zone for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will rely on the time zone of the kube-controller-manager process. ALPHA: This field is in alpha and must be enabled via the ``CronJobTimeZone`` feature gate.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec
        '''
        if isinstance(job_template, dict):
            job_template = JobTemplateSpecV1Beta1(**job_template)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b45cd14d51f14554037e1334467e76131a0d4f26a1f051340ea146c0924ecab3)
            check_type(argname="argument job_template", value=job_template, expected_type=type_hints["job_template"])
            check_type(argname="argument schedule", value=schedule, expected_type=type_hints["schedule"])
            check_type(argname="argument concurrency_policy", value=concurrency_policy, expected_type=type_hints["concurrency_policy"])
            check_type(argname="argument failed_jobs_history_limit", value=failed_jobs_history_limit, expected_type=type_hints["failed_jobs_history_limit"])
            check_type(argname="argument starting_deadline_seconds", value=starting_deadline_seconds, expected_type=type_hints["starting_deadline_seconds"])
            check_type(argname="argument successful_jobs_history_limit", value=successful_jobs_history_limit, expected_type=type_hints["successful_jobs_history_limit"])
            check_type(argname="argument suspend", value=suspend, expected_type=type_hints["suspend"])
            check_type(argname="argument time_zone", value=time_zone, expected_type=type_hints["time_zone"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "job_template": job_template,
            "schedule": schedule,
        }
        if concurrency_policy is not None:
            self._values["concurrency_policy"] = concurrency_policy
        if failed_jobs_history_limit is not None:
            self._values["failed_jobs_history_limit"] = failed_jobs_history_limit
        if starting_deadline_seconds is not None:
            self._values["starting_deadline_seconds"] = starting_deadline_seconds
        if successful_jobs_history_limit is not None:
            self._values["successful_jobs_history_limit"] = successful_jobs_history_limit
        if suspend is not None:
            self._values["suspend"] = suspend
        if time_zone is not None:
            self._values["time_zone"] = time_zone

    @builtins.property
    def job_template(self) -> "JobTemplateSpecV1Beta1":
        '''Specifies the job that will be created when executing a CronJob.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#jobTemplate
        '''
        result = self._values.get("job_template")
        assert result is not None, "Required property 'job_template' is missing"
        return typing.cast("JobTemplateSpecV1Beta1", result)

    @builtins.property
    def schedule(self) -> builtins.str:
        '''The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#schedule
        '''
        result = self._values.get("schedule")
        assert result is not None, "Required property 'schedule' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def concurrency_policy(self) -> typing.Optional[builtins.str]:
        '''Specifies how to treat concurrent executions of a Job.

        Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#concurrencyPolicy
        '''
        result = self._values.get("concurrency_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def failed_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of failed finished jobs to retain.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.

        :default: 1.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#failedJobsHistoryLimit
        '''
        result = self._values.get("failed_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def starting_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''Optional deadline in seconds for starting the job if it misses scheduled time for any reason.

        Missed jobs executions will be counted as failed ones.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#startingDeadlineSeconds
        '''
        result = self._values.get("starting_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def successful_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of successful finished jobs to retain.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 3.

        :default: 3.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#successfulJobsHistoryLimit
        '''
        result = self._values.get("successful_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#suspend
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def time_zone(self) -> typing.Optional[builtins.str]:
        '''The time zone for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will rely on the time zone of the kube-controller-manager process. ALPHA: This field is in alpha and must be enabled via the ``CronJobTimeZone`` feature gate.

        :schema: io.k8s.api.batch.v1beta1.CronJobSpec#timeZone
        '''
        result = self._values.get("time_zone")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CronJobSpecV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CrossVersionObjectReference",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReference:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        :param name: Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param api_version: API version of the referent.

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2738449f9888f19f9d72d728d1888fd2b0e24e1b73eba1b4dcbe3f5de2752fa)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the referent;

        More info: http://kubernetes.io/docs/user-guide/identifiers#names

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''API version of the referent.

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CrossVersionObjectReferenceV2",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReferenceV2:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        :param name: Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param api_version: API version of the referent.

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbd6d56d4cc22d664584460d55947f58d76ff81dc75d151c5df75da769142fc7)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the referent;

        More info: http://kubernetes.io/docs/user-guide/identifiers#names

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''API version of the referent.

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReferenceV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CrossVersionObjectReferenceV2Beta1",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReferenceV2Beta1:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        :param name: Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param api_version: API version of the referent.

        :schema: io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9a2d20e3cde347099c655560b524dcb880155743883e530166337e2dbf66f0b)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"

        :schema: io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the referent;

        More info: http://kubernetes.io/docs/user-guide/identifiers#names

        :schema: io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''API version of the referent.

        :schema: io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReferenceV2Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CrossVersionObjectReferenceV2Beta2",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReferenceV2Beta2:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        :param name: Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param api_version: API version of the referent.

        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a9c73b345f023baeccf02721fb11de65c6bb6d72ea62a5036d623a920f67676)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"

        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the referent;

        More info: http://kubernetes.io/docs/user-guide/identifiers#names

        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''API version of the referent.

        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReferenceV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CsiDriverSpec",
    jsii_struct_bases=[],
    name_mapping={
        "attach_required": "attachRequired",
        "fs_group_policy": "fsGroupPolicy",
        "pod_info_on_mount": "podInfoOnMount",
        "requires_republish": "requiresRepublish",
        "storage_capacity": "storageCapacity",
        "token_requests": "tokenRequests",
        "volume_lifecycle_modes": "volumeLifecycleModes",
    },
)
class CsiDriverSpec:
    def __init__(
        self,
        *,
        attach_required: typing.Optional[builtins.bool] = None,
        fs_group_policy: typing.Optional[builtins.str] = None,
        pod_info_on_mount: typing.Optional[builtins.bool] = None,
        requires_republish: typing.Optional[builtins.bool] = None,
        storage_capacity: typing.Optional[builtins.bool] = None,
        token_requests: typing.Optional[typing.Sequence[typing.Union["TokenRequest", typing.Dict[builtins.str, typing.Any]]]] = None,
        volume_lifecycle_modes: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''CSIDriverSpec is the specification of a CSIDriver.

        :param attach_required: attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called. This field is immutable.
        :param fs_group_policy: Defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details. This field is immutable. Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce. Default: ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        :param pod_info_on_mount: If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume defined by a CSIVolumeSource, otherwise "false". "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver. This field is immutable. Default: false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
        :param requires_republish: RequiresRepublish indicates the CSI driver wants ``NodePublishVolume`` being periodically called to reflect any possible change in the mounted volume. This field defaults to false. Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        :param storage_capacity: If set to true, storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information. The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object. Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published. This field was immutable in Kubernetes <= 1.22 and now is mutable.
        :param token_requests: TokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": { "": { "token": , "expirationTimestamp": , }, ... } Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        :param volume_lifecycle_modes: volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future. This field is beta. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff3f4169186f4feb316b4c8ca7cf0bde0f4a70a63c5f6deae91341f45832fc0c)
            check_type(argname="argument attach_required", value=attach_required, expected_type=type_hints["attach_required"])
            check_type(argname="argument fs_group_policy", value=fs_group_policy, expected_type=type_hints["fs_group_policy"])
            check_type(argname="argument pod_info_on_mount", value=pod_info_on_mount, expected_type=type_hints["pod_info_on_mount"])
            check_type(argname="argument requires_republish", value=requires_republish, expected_type=type_hints["requires_republish"])
            check_type(argname="argument storage_capacity", value=storage_capacity, expected_type=type_hints["storage_capacity"])
            check_type(argname="argument token_requests", value=token_requests, expected_type=type_hints["token_requests"])
            check_type(argname="argument volume_lifecycle_modes", value=volume_lifecycle_modes, expected_type=type_hints["volume_lifecycle_modes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if attach_required is not None:
            self._values["attach_required"] = attach_required
        if fs_group_policy is not None:
            self._values["fs_group_policy"] = fs_group_policy
        if pod_info_on_mount is not None:
            self._values["pod_info_on_mount"] = pod_info_on_mount
        if requires_republish is not None:
            self._values["requires_republish"] = requires_republish
        if storage_capacity is not None:
            self._values["storage_capacity"] = storage_capacity
        if token_requests is not None:
            self._values["token_requests"] = token_requests
        if volume_lifecycle_modes is not None:
            self._values["volume_lifecycle_modes"] = volume_lifecycle_modes

    @builtins.property
    def attach_required(self) -> typing.Optional[builtins.bool]:
        '''attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting.

        The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#attachRequired
        '''
        result = self._values.get("attach_required")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_group_policy(self) -> typing.Optional[builtins.str]:
        '''Defines if the underlying volume supports changing ownership and permission of the volume before being mounted.

        Refer to the specific FSGroupPolicy values for additional details.

        This field is immutable.

        Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.

        :default: ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#fsGroupPolicy
        '''
        result = self._values.get("fs_group_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pod_info_on_mount(self) -> typing.Optional[builtins.bool]:
        '''If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume defined by a CSIVolumeSource, otherwise "false".

        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

        This field is immutable.

        :default: false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#podInfoOnMount
        '''
        result = self._values.get("pod_info_on_mount")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def requires_republish(self) -> typing.Optional[builtins.bool]:
        '''RequiresRepublish indicates the CSI driver wants ``NodePublishVolume`` being periodically called to reflect any possible change in the mounted volume.

        This field defaults to false.

        Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#requiresRepublish
        '''
        result = self._values.get("requires_republish")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def storage_capacity(self) -> typing.Optional[builtins.bool]:
        '''If set to true, storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information.

        The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

        Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

        This field was immutable in Kubernetes <= 1.22 and now is mutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#storageCapacity
        '''
        result = self._values.get("storage_capacity")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def token_requests(self) -> typing.Optional[typing.List["TokenRequest"]]:
        '''TokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication.

        Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
        "": {
        "token": ,
        "expirationTimestamp": ,
        },
        ...
        }

        Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#tokenRequests
        '''
        result = self._values.get("token_requests")
        return typing.cast(typing.Optional[typing.List["TokenRequest"]], result)

    @builtins.property
    def volume_lifecycle_modes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''volumeLifecycleModes defines what kind of volumes this CSI volume driver supports.

        The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future. This field is beta.

        This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#volumeLifecycleModes
        '''
        result = self._values.get("volume_lifecycle_modes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiDriverSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CsiNodeDriver",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "node_id": "nodeId",
        "allocatable": "allocatable",
        "topology_keys": "topologyKeys",
    },
)
class CsiNodeDriver:
    def __init__(
        self,
        *,
        name: builtins.str,
        node_id: builtins.str,
        allocatable: typing.Optional[typing.Union["VolumeNodeResources", typing.Dict[builtins.str, typing.Any]]] = None,
        topology_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''CSINodeDriver holds information about the specification of one CSI driver installed on a node.

        :param name: This is the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        :param node_id: nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        :param allocatable: allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        :param topology_keys: topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.

        :schema: io.k8s.api.storage.v1.CSINodeDriver
        '''
        if isinstance(allocatable, dict):
            allocatable = VolumeNodeResources(**allocatable)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d80ea5bb03a24072a0618a85316a899e6d72a72e6a001686899d2f9174f81a04)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_id", value=node_id, expected_type=type_hints["node_id"])
            check_type(argname="argument allocatable", value=allocatable, expected_type=type_hints["allocatable"])
            check_type(argname="argument topology_keys", value=topology_keys, expected_type=type_hints["topology_keys"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "node_id": node_id,
        }
        if allocatable is not None:
            self._values["allocatable"] = allocatable
        if topology_keys is not None:
            self._values["topology_keys"] = topology_keys

    @builtins.property
    def name(self) -> builtins.str:
        '''This is the name of the CSI driver that this object refers to.

        This MUST be the same name returned by the CSI GetPluginName() call for that driver.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def node_id(self) -> builtins.str:
        '''nodeID of the node from the driver point of view.

        This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#nodeID
        '''
        result = self._values.get("node_id")
        assert result is not None, "Required property 'node_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def allocatable(self) -> typing.Optional["VolumeNodeResources"]:
        '''allocatable represents the volume resources of a node that are available for scheduling.

        This field is beta.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#allocatable
        '''
        result = self._values.get("allocatable")
        return typing.cast(typing.Optional["VolumeNodeResources"], result)

    @builtins.property
    def topology_keys(self) -> typing.Optional[typing.List[builtins.str]]:
        '''topologyKeys is the list of keys supported by the driver.

        When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#topologyKeys
        '''
        result = self._values.get("topology_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiNodeDriver(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CsiNodeSpec",
    jsii_struct_bases=[],
    name_mapping={"drivers": "drivers"},
)
class CsiNodeSpec:
    def __init__(
        self,
        *,
        drivers: typing.Sequence[typing.Union[CsiNodeDriver, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''CSINodeSpec holds information about the specification of all CSI drivers installed on a node.

        :param drivers: drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.

        :schema: io.k8s.api.storage.v1.CSINodeSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0e93464a0f0b7535c2fe48261588e9f829185777d7f056e924bf6e04ec9b16b)
            check_type(argname="argument drivers", value=drivers, expected_type=type_hints["drivers"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "drivers": drivers,
        }

    @builtins.property
    def drivers(self) -> typing.List[CsiNodeDriver]:
        '''drivers is a list of information of all CSI Drivers existing on a node.

        If all drivers in the list are uninstalled, this can become empty.

        :schema: io.k8s.api.storage.v1.CSINodeSpec#drivers
        '''
        result = self._values.get("drivers")
        assert result is not None, "Required property 'drivers' is missing"
        return typing.cast(typing.List[CsiNodeDriver], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiNodeSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CsiPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "volume_handle": "volumeHandle",
        "controller_expand_secret_ref": "controllerExpandSecretRef",
        "controller_publish_secret_ref": "controllerPublishSecretRef",
        "fs_type": "fsType",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "node_stage_secret_ref": "nodeStageSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class CsiPersistentVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        volume_handle: builtins.str,
        controller_expand_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        controller_publish_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        fs_type: typing.Optional[builtins.str] = None,
        node_publish_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        node_stage_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Represents storage that is managed by an external CSI volume driver (Beta feature).

        :param driver: driver is the name of the driver to use for this volume. Required.
        :param volume_handle: volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        :param controller_expand_secret_ref: controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param controller_publish_secret_ref: controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param fs_type: fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        :param node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param node_stage_secret_ref: nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param read_only: readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write). Default: false (read/write).
        :param volume_attributes: volumeAttributes of the volume to publish.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource
        '''
        if isinstance(controller_expand_secret_ref, dict):
            controller_expand_secret_ref = SecretReference(**controller_expand_secret_ref)
        if isinstance(controller_publish_secret_ref, dict):
            controller_publish_secret_ref = SecretReference(**controller_publish_secret_ref)
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = SecretReference(**node_publish_secret_ref)
        if isinstance(node_stage_secret_ref, dict):
            node_stage_secret_ref = SecretReference(**node_stage_secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__183752673e7babe9f34f0092c96623a97d071f71eedc52e30f02a5911d5e9444)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument volume_handle", value=volume_handle, expected_type=type_hints["volume_handle"])
            check_type(argname="argument controller_expand_secret_ref", value=controller_expand_secret_ref, expected_type=type_hints["controller_expand_secret_ref"])
            check_type(argname="argument controller_publish_secret_ref", value=controller_publish_secret_ref, expected_type=type_hints["controller_publish_secret_ref"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument node_publish_secret_ref", value=node_publish_secret_ref, expected_type=type_hints["node_publish_secret_ref"])
            check_type(argname="argument node_stage_secret_ref", value=node_stage_secret_ref, expected_type=type_hints["node_stage_secret_ref"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument volume_attributes", value=volume_attributes, expected_type=type_hints["volume_attributes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
            "volume_handle": volume_handle,
        }
        if controller_expand_secret_ref is not None:
            self._values["controller_expand_secret_ref"] = controller_expand_secret_ref
        if controller_publish_secret_ref is not None:
            self._values["controller_publish_secret_ref"] = controller_publish_secret_ref
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if node_stage_secret_ref is not None:
            self._values["node_stage_secret_ref"] = node_stage_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the driver to use for this volume.

        Required.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def volume_handle(self) -> builtins.str:
        '''volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls.

        Required.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeHandle
        '''
        result = self._values.get("volume_handle")
        assert result is not None, "Required property 'volume_handle' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def controller_expand_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call.

        This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerExpandSecretRef
        '''
        result = self._values.get("controller_expand_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def controller_publish_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerPublishSecretRef
        '''
        result = self._values.get("controller_publish_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_publish_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def node_stage_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodeStageSecretRef
        '''
        result = self._values.get("node_stage_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly value to pass to ControllerPublishVolumeRequest.

        Defaults to false (read/write).

        :default: false (read/write).

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''volumeAttributes of the volume to publish.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CsiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class CsiVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        node_publish_secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Represents a source location of a volume to mount, managed by an external CSI driver.

        :param driver: driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        :param fs_type: fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        :param node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        :param read_only: readOnly specifies a read-only configuration for the volume. Defaults to false (read/write). Default: false (read/write).
        :param volume_attributes: volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.

        :schema: io.k8s.api.core.v1.CSIVolumeSource
        '''
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = LocalObjectReference(**node_publish_secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__37f00c4155f83a08fafd9fa10b54c74e5e90e7ae5fdd7e97135888a725216e20)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument node_publish_secret_ref", value=node_publish_secret_ref, expected_type=type_hints["node_publish_secret_ref"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument volume_attributes", value=volume_attributes, expected_type=type_hints["volume_attributes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the CSI driver that handles this volume.

        Consult with your admin for the correct name as registered in the cluster.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType to mount.

        Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_publish_secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.

        This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly specifies a read-only configuration for the volume.

        Defaults to false (read/write).

        :default: false (read/write).

        :schema: io.k8s.api.core.v1.CSIVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''volumeAttributes stores driver-specific properties that are passed to the CSI driver.

        Consult your driver's documentation for supported values.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceColumnDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "json_path": "jsonPath",
        "name": "name",
        "type": "type",
        "description": "description",
        "format": "format",
        "priority": "priority",
    },
)
class CustomResourceColumnDefinition:
    def __init__(
        self,
        *,
        json_path: builtins.str,
        name: builtins.str,
        type: builtins.str,
        description: typing.Optional[builtins.str] = None,
        format: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''CustomResourceColumnDefinition specifies a column for server side printing.

        :param json_path: jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        :param name: name is a human readable name for the column.
        :param type: type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param description: description is a human readable description of this column.
        :param format: format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param priority: priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84d728e1e2cd4b9e2b5633c8a5292e397c99d5bbdd98dd78ad3669ffb7f2e904)
            check_type(argname="argument json_path", value=json_path, expected_type=type_hints["json_path"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "json_path": json_path,
            "name": name,
            "type": type,
        }
        if description is not None:
            self._values["description"] = description
        if format is not None:
            self._values["format"] = format
        if priority is not None:
            self._values["priority"] = priority

    @builtins.property
    def json_path(self) -> builtins.str:
        '''jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#jsonPath
        '''
        result = self._values.get("json_path")
        assert result is not None, "Required property 'json_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is a human readable name for the column.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''type is an OpenAPI type definition for this column.

        See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''description is a human readable description of this column.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        '''format is an optional OpenAPI type definition for this column.

        The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#format
        '''
        result = self._values.get("format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        '''priority is an integer defining the relative importance of this column compared to others.

        Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#priority
        '''
        result = self._values.get("priority")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceColumnDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceConversion",
    jsii_struct_bases=[],
    name_mapping={"strategy": "strategy", "webhook": "webhook"},
)
class CustomResourceConversion:
    def __init__(
        self,
        *,
        strategy: builtins.str,
        webhook: typing.Optional[typing.Union["WebhookConversion", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceConversion describes how to convert different versions of a CR.

        :param strategy: strategy specifies how custom resources are converted between versions. Allowed values are: - ``None``: The converter only change the apiVersion and would not touch any other field in the custom resource. - ``Webhook``: API Server will call to an external webhook to do the conversion. Additional information is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
        :param webhook: webhook describes how to call the conversion webhook. Required when ``strategy`` is set to ``Webhook``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion
        '''
        if isinstance(webhook, dict):
            webhook = WebhookConversion(**webhook)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e344127f68bd20b5351e9aece02e63bf8dda489899bcc3a5127e33b4997e9e0f)
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
            check_type(argname="argument webhook", value=webhook, expected_type=type_hints["webhook"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "strategy": strategy,
        }
        if webhook is not None:
            self._values["webhook"] = webhook

    @builtins.property
    def strategy(self) -> builtins.str:
        '''strategy specifies how custom resources are converted between versions.

        Allowed values are: - ``None``: The converter only change the apiVersion and would not touch any other field in the custom resource. - ``Webhook``: API Server will call to an external webhook to do the conversion. Additional information
        is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion#strategy
        '''
        result = self._values.get("strategy")
        assert result is not None, "Required property 'strategy' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def webhook(self) -> typing.Optional["WebhookConversion"]:
        '''webhook describes how to call the conversion webhook.

        Required when ``strategy`` is set to ``Webhook``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion#webhook
        '''
        result = self._values.get("webhook")
        return typing.cast(typing.Optional["WebhookConversion"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceConversion(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceDefinitionNames",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "plural": "plural",
        "categories": "categories",
        "list_kind": "listKind",
        "short_names": "shortNames",
        "singular": "singular",
    },
)
class CustomResourceDefinitionNames:
    def __init__(
        self,
        *,
        kind: builtins.str,
        plural: builtins.str,
        categories: typing.Optional[typing.Sequence[builtins.str]] = None,
        list_kind: typing.Optional[builtins.str] = None,
        short_names: typing.Optional[typing.Sequence[builtins.str]] = None,
        singular: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.

        :param kind: kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the ``kind`` attribute in API calls.
        :param plural: plural is the plural name of the resource to serve. The custom resources are served under ``/apis/<group>/<version>/.../<plural>``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``). Must be all lowercase.
        :param categories: categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like ``kubectl get all``.
        :param list_kind: listKind is the serialized kind of the list for this resource. Defaults to "``kind``List". Default: kind`List".
        :param short_names: shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like ``kubectl get <shortname>``. It must be all lowercase.
        :param singular: singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased ``kind``. Default: lowercased ``kind``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59297484af9c54f4f367a1e8a0fe36c6ffd34a072d0cb7c0d96282433dd7227c)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument plural", value=plural, expected_type=type_hints["plural"])
            check_type(argname="argument categories", value=categories, expected_type=type_hints["categories"])
            check_type(argname="argument list_kind", value=list_kind, expected_type=type_hints["list_kind"])
            check_type(argname="argument short_names", value=short_names, expected_type=type_hints["short_names"])
            check_type(argname="argument singular", value=singular, expected_type=type_hints["singular"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "plural": plural,
        }
        if categories is not None:
            self._values["categories"] = categories
        if list_kind is not None:
            self._values["list_kind"] = list_kind
        if short_names is not None:
            self._values["short_names"] = short_names
        if singular is not None:
            self._values["singular"] = singular

    @builtins.property
    def kind(self) -> builtins.str:
        '''kind is the serialized kind of the resource.

        It is normally CamelCase and singular. Custom resource instances will use this value as the ``kind`` attribute in API calls.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def plural(self) -> builtins.str:
        '''plural is the plural name of the resource to serve.

        The custom resources are served under ``/apis/<group>/<version>/.../<plural>``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``). Must be all lowercase.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#plural
        '''
        result = self._values.get("plural")
        assert result is not None, "Required property 'plural' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def categories(self) -> typing.Optional[typing.List[builtins.str]]:
        '''categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like ``kubectl get all``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#categories
        '''
        result = self._values.get("categories")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def list_kind(self) -> typing.Optional[builtins.str]:
        '''listKind is the serialized kind of the list for this resource.

        Defaults to "``kind``List".

        :default: kind`List".

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#listKind
        '''
        result = self._values.get("list_kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def short_names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like ``kubectl get <shortname>``.

        It must be all lowercase.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#shortNames
        '''
        result = self._values.get("short_names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def singular(self) -> typing.Optional[builtins.str]:
        '''singular is the singular name of the resource.

        It must be all lowercase. Defaults to lowercased ``kind``.

        :default: lowercased ``kind``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#singular
        '''
        result = self._values.get("singular")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionNames(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceDefinitionSpec",
    jsii_struct_bases=[],
    name_mapping={
        "group": "group",
        "names": "names",
        "scope": "scope",
        "versions": "versions",
        "conversion": "conversion",
        "preserve_unknown_fields": "preserveUnknownFields",
    },
)
class CustomResourceDefinitionSpec:
    def __init__(
        self,
        *,
        group: builtins.str,
        names: typing.Union[CustomResourceDefinitionNames, typing.Dict[builtins.str, typing.Any]],
        scope: builtins.str,
        versions: typing.Sequence[typing.Union["CustomResourceDefinitionVersion", typing.Dict[builtins.str, typing.Any]]],
        conversion: typing.Optional[typing.Union[CustomResourceConversion, typing.Dict[builtins.str, typing.Any]]] = None,
        preserve_unknown_fields: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''CustomResourceDefinitionSpec describes how a user wants their resource to appear.

        :param group: group is the API group of the defined custom resource. The custom resources are served under ``/apis/<group>/...``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``).
        :param names: names specify the resource and kind names for the custom resource.
        :param scope: scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are ``Cluster`` and ``Namespaced``.
        :param versions: versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        :param conversion: conversion defines conversion settings for the CRD.
        :param preserve_unknown_fields: preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting ``x-preserve-unknown-fields`` to true in ``spec.versions[*].schema.openAPIV3Schema``. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec
        '''
        if isinstance(names, dict):
            names = CustomResourceDefinitionNames(**names)
        if isinstance(conversion, dict):
            conversion = CustomResourceConversion(**conversion)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dbf84239604053a5d389d29e1b7ab021ccba63d3614cdada09f6414325daec87)
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument versions", value=versions, expected_type=type_hints["versions"])
            check_type(argname="argument conversion", value=conversion, expected_type=type_hints["conversion"])
            check_type(argname="argument preserve_unknown_fields", value=preserve_unknown_fields, expected_type=type_hints["preserve_unknown_fields"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "group": group,
            "names": names,
            "scope": scope,
            "versions": versions,
        }
        if conversion is not None:
            self._values["conversion"] = conversion
        if preserve_unknown_fields is not None:
            self._values["preserve_unknown_fields"] = preserve_unknown_fields

    @builtins.property
    def group(self) -> builtins.str:
        '''group is the API group of the defined custom resource.

        The custom resources are served under ``/apis/<group>/...``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``).

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#group
        '''
        result = self._values.get("group")
        assert result is not None, "Required property 'group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def names(self) -> CustomResourceDefinitionNames:
        '''names specify the resource and kind names for the custom resource.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#names
        '''
        result = self._values.get("names")
        assert result is not None, "Required property 'names' is missing"
        return typing.cast(CustomResourceDefinitionNames, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''scope indicates whether the defined custom resource is cluster- or namespace-scoped.

        Allowed values are ``Cluster`` and ``Namespaced``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def versions(self) -> typing.List["CustomResourceDefinitionVersion"]:
        '''versions is the list of all API versions of the defined custom resource.

        Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#versions
        '''
        result = self._values.get("versions")
        assert result is not None, "Required property 'versions' is missing"
        return typing.cast(typing.List["CustomResourceDefinitionVersion"], result)

    @builtins.property
    def conversion(self) -> typing.Optional[CustomResourceConversion]:
        '''conversion defines conversion settings for the CRD.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#conversion
        '''
        result = self._values.get("conversion")
        return typing.cast(typing.Optional[CustomResourceConversion], result)

    @builtins.property
    def preserve_unknown_fields(self) -> typing.Optional[builtins.bool]:
        '''preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage.

        apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting ``x-preserve-unknown-fields`` to true in ``spec.versions[*].schema.openAPIV3Schema``. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#preserveUnknownFields
        '''
        result = self._values.get("preserve_unknown_fields")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceDefinitionVersion",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "served": "served",
        "storage": "storage",
        "additional_printer_columns": "additionalPrinterColumns",
        "deprecated": "deprecated",
        "deprecation_warning": "deprecationWarning",
        "schema": "schema",
        "subresources": "subresources",
    },
)
class CustomResourceDefinitionVersion:
    def __init__(
        self,
        *,
        name: builtins.str,
        served: builtins.bool,
        storage: builtins.bool,
        additional_printer_columns: typing.Optional[typing.Sequence[typing.Union[CustomResourceColumnDefinition, typing.Dict[builtins.str, typing.Any]]]] = None,
        deprecated: typing.Optional[builtins.bool] = None,
        deprecation_warning: typing.Optional[builtins.str] = None,
        schema: typing.Optional[typing.Union["CustomResourceValidation", typing.Dict[builtins.str, typing.Any]]] = None,
        subresources: typing.Optional[typing.Union["CustomResourceSubresources", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceDefinitionVersion describes a version for CRD.

        :param name: name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at ``/apis/<group>/<version>/...`` if ``served`` is true.
        :param served: served is a flag enabling/disabling this version from being served via REST APIs.
        :param storage: storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        :param additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
        :param deprecated: deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false. Default: false.
        :param deprecation_warning: deprecationWarning overrides the default warning returned to API clients. May only be set when ``deprecated`` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        :param schema: schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
        :param subresources: subresources specify what subresources this version of the defined custom resource have.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion
        '''
        if isinstance(schema, dict):
            schema = CustomResourceValidation(**schema)
        if isinstance(subresources, dict):
            subresources = CustomResourceSubresources(**subresources)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__94669c998c6a16590f1b1912ee6c072ad3671c70329c2958434115187c87333d)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument served", value=served, expected_type=type_hints["served"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument additional_printer_columns", value=additional_printer_columns, expected_type=type_hints["additional_printer_columns"])
            check_type(argname="argument deprecated", value=deprecated, expected_type=type_hints["deprecated"])
            check_type(argname="argument deprecation_warning", value=deprecation_warning, expected_type=type_hints["deprecation_warning"])
            check_type(argname="argument schema", value=schema, expected_type=type_hints["schema"])
            check_type(argname="argument subresources", value=subresources, expected_type=type_hints["subresources"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "served": served,
            "storage": storage,
        }
        if additional_printer_columns is not None:
            self._values["additional_printer_columns"] = additional_printer_columns
        if deprecated is not None:
            self._values["deprecated"] = deprecated
        if deprecation_warning is not None:
            self._values["deprecation_warning"] = deprecation_warning
        if schema is not None:
            self._values["schema"] = schema
        if subresources is not None:
            self._values["subresources"] = subresources

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at ``/apis/<group>/<version>/...`` if ``served`` is true.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def served(self) -> builtins.bool:
        '''served is a flag enabling/disabling this version from being served via REST APIs.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#served
        '''
        result = self._values.get("served")
        assert result is not None, "Required property 'served' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def storage(self) -> builtins.bool:
        '''storage indicates this version should be used when persisting custom resources to storage.

        There must be exactly one version with storage=true.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#storage
        '''
        result = self._values.get("storage")
        assert result is not None, "Required property 'storage' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def additional_printer_columns(
        self,
    ) -> typing.Optional[typing.List[CustomResourceColumnDefinition]]:
        '''additionalPrinterColumns specifies additional columns returned in Table output.

        See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#additionalPrinterColumns
        '''
        result = self._values.get("additional_printer_columns")
        return typing.cast(typing.Optional[typing.List[CustomResourceColumnDefinition]], result)

    @builtins.property
    def deprecated(self) -> typing.Optional[builtins.bool]:
        '''deprecated indicates this version of the custom resource API is deprecated.

        When set to true, API requests to this version receive a warning header in the server response. Defaults to false.

        :default: false.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#deprecated
        '''
        result = self._values.get("deprecated")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def deprecation_warning(self) -> typing.Optional[builtins.str]:
        '''deprecationWarning overrides the default warning returned to API clients.

        May only be set when ``deprecated`` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#deprecationWarning
        '''
        result = self._values.get("deprecation_warning")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def schema(self) -> typing.Optional["CustomResourceValidation"]:
        '''schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#schema
        '''
        result = self._values.get("schema")
        return typing.cast(typing.Optional["CustomResourceValidation"], result)

    @builtins.property
    def subresources(self) -> typing.Optional["CustomResourceSubresources"]:
        '''subresources specify what subresources this version of the defined custom resource have.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#subresources
        '''
        result = self._values.get("subresources")
        return typing.cast(typing.Optional["CustomResourceSubresources"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionVersion(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceSubresourceScale",
    jsii_struct_bases=[],
    name_mapping={
        "spec_replicas_path": "specReplicasPath",
        "status_replicas_path": "statusReplicasPath",
        "label_selector_path": "labelSelectorPath",
    },
)
class CustomResourceSubresourceScale:
    def __init__(
        self,
        *,
        spec_replicas_path: builtins.str,
        status_replicas_path: builtins.str,
        label_selector_path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.

        :param spec_replicas_path: specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``spec.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.spec``. If there is no value under the given path in the custom resource, the ``/scale`` subresource will return an error on GET.
        :param status_replicas_path: statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status``. If there is no value under the given path in the custom resource, the ``status.replicas`` value in the ``/scale`` subresource will default to 0.
        :param label_selector_path: labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.selector``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status`` or ``.spec``. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the ``status.selector`` value in the ``/scale`` subresource will default to the empty string.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f202e27abdb12fe82245dcc71c1a0b4d68828b6e2d55f177bbe611b2b562b683)
            check_type(argname="argument spec_replicas_path", value=spec_replicas_path, expected_type=type_hints["spec_replicas_path"])
            check_type(argname="argument status_replicas_path", value=status_replicas_path, expected_type=type_hints["status_replicas_path"])
            check_type(argname="argument label_selector_path", value=label_selector_path, expected_type=type_hints["label_selector_path"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec_replicas_path": spec_replicas_path,
            "status_replicas_path": status_replicas_path,
        }
        if label_selector_path is not None:
            self._values["label_selector_path"] = label_selector_path

    @builtins.property
    def spec_replicas_path(self) -> builtins.str:
        '''specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``spec.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.spec``. If there is no value under the given path in the custom resource, the ``/scale`` subresource will return an error on GET.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale#specReplicasPath
        '''
        result = self._values.get("spec_replicas_path")
        assert result is not None, "Required property 'spec_replicas_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def status_replicas_path(self) -> builtins.str:
        '''statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status``. If there is no value under the given path in the custom resource, the ``status.replicas`` value in the ``/scale`` subresource will default to 0.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale#statusReplicasPath
        '''
        result = self._values.get("status_replicas_path")
        assert result is not None, "Required property 'status_replicas_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector_path(self) -> typing.Optional[builtins.str]:
        '''labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.selector``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status`` or ``.spec``. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the ``status.selector`` value in the ``/scale`` subresource will default to the empty string.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale#labelSelectorPath
        '''
        result = self._values.get("label_selector_path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceSubresourceScale(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceSubresources",
    jsii_struct_bases=[],
    name_mapping={"scale": "scale", "status": "status"},
)
class CustomResourceSubresources:
    def __init__(
        self,
        *,
        scale: typing.Optional[typing.Union[CustomResourceSubresourceScale, typing.Dict[builtins.str, typing.Any]]] = None,
        status: typing.Any = None,
    ) -> None:
        '''CustomResourceSubresources defines the status and scale subresources for CustomResources.

        :param scale: scale indicates the custom resource should serve a ``/scale`` subresource that returns an ``autoscaling/v1`` Scale object.
        :param status: status indicates the custom resource should serve a ``/status`` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the ``status`` stanza of the object. 2. requests to the custom resource ``/status`` subresource ignore changes to anything other than the ``status`` stanza of the object.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources
        '''
        if isinstance(scale, dict):
            scale = CustomResourceSubresourceScale(**scale)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9de2d7c262b4a573e5274d8d14ceef7929fab2b97c5de88b663d5b061085ba6e)
            check_type(argname="argument scale", value=scale, expected_type=type_hints["scale"])
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if scale is not None:
            self._values["scale"] = scale
        if status is not None:
            self._values["status"] = status

    @builtins.property
    def scale(self) -> typing.Optional[CustomResourceSubresourceScale]:
        '''scale indicates the custom resource should serve a ``/scale`` subresource that returns an ``autoscaling/v1`` Scale object.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources#scale
        '''
        result = self._values.get("scale")
        return typing.cast(typing.Optional[CustomResourceSubresourceScale], result)

    @builtins.property
    def status(self) -> typing.Any:
        '''status indicates the custom resource should serve a ``/status`` subresource.

        When enabled: 1. requests to the custom resource primary endpoint ignore changes to the ``status`` stanza of the object. 2. requests to the custom resource ``/status`` subresource ignore changes to anything other than the ``status`` stanza of the object.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources#status
        '''
        result = self._values.get("status")
        return typing.cast(typing.Any, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceSubresources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.CustomResourceValidation",
    jsii_struct_bases=[],
    name_mapping={"open_apiv3_schema": "openApiv3Schema"},
)
class CustomResourceValidation:
    def __init__(
        self,
        *,
        open_apiv3_schema: typing.Optional[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceValidation is a list of validation methods for CustomResources.

        :param open_apiv3_schema: openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation
        '''
        if isinstance(open_apiv3_schema, dict):
            open_apiv3_schema = JsonSchemaProps(**open_apiv3_schema)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0bce895e850b97c31bcd535b024972b1362c53b445beef3d6aaeb6919035b921)
            check_type(argname="argument open_apiv3_schema", value=open_apiv3_schema, expected_type=type_hints["open_apiv3_schema"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if open_apiv3_schema is not None:
            self._values["open_apiv3_schema"] = open_apiv3_schema

    @builtins.property
    def open_apiv3_schema(self) -> typing.Optional["JsonSchemaProps"]:
        '''openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation#openAPIV3Schema
        '''
        result = self._values.get("open_apiv3_schema")
        return typing.cast(typing.Optional["JsonSchemaProps"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceValidation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DaemonSetSpec",
    jsii_struct_bases=[],
    name_mapping={
        "selector": "selector",
        "template": "template",
        "min_ready_seconds": "minReadySeconds",
        "revision_history_limit": "revisionHistoryLimit",
        "update_strategy": "updateStrategy",
    },
)
class DaemonSetSpec:
    def __init__(
        self,
        *,
        selector: typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]],
        template: typing.Union["PodTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        revision_history_limit: typing.Optional[jsii.Number] = None,
        update_strategy: typing.Optional[typing.Union["DaemonSetUpdateStrategy", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DaemonSetSpec is the specification of a daemon set.

        :param selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready). Default: 0 (pod will be considered available as soon as it is ready).
        :param revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10. Default: 10.
        :param update_strategy: An update strategy to replace existing DaemonSet pods with new pods.

        :schema: io.k8s.api.apps.v1.DaemonSetSpec
        '''
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(update_strategy, dict):
            update_strategy = DaemonSetUpdateStrategy(**update_strategy)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__867efeba4bf97df4446dbf232042812b240963b03528282b022ac2bf034dcb43)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument template", value=template, expected_type=type_hints["template"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
            check_type(argname="argument revision_history_limit", value=revision_history_limit, expected_type=type_hints["revision_history_limit"])
            check_type(argname="argument update_strategy", value=update_strategy, expected_type=type_hints["update_strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "selector": selector,
            "template": template,
        }
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds
        if revision_history_limit is not None:
            self._values["revision_history_limit"] = revision_history_limit
        if update_strategy is not None:
            self._values["update_strategy"] = update_strategy

    @builtins.property
    def selector(self) -> "LabelSelector":
        '''A label query over pods that are managed by the daemon set.

        Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#selector
        '''
        result = self._values.get("selector")
        assert result is not None, "Required property 'selector' is missing"
        return typing.cast("LabelSelector", result)

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''An object that describes the pod that will be created.

        The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available.

        Defaults to 0 (pod will be considered available as soon as it is ready).

        :default: 0 (pod will be considered available as soon as it is ready).

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#minReadySeconds
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def revision_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of old history to retain to allow rollback.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.

        :default: 10.

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#revisionHistoryLimit
        '''
        result = self._values.get("revision_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def update_strategy(self) -> typing.Optional["DaemonSetUpdateStrategy"]:
        '''An update strategy to replace existing DaemonSet pods with new pods.

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#updateStrategy
        '''
        result = self._values.get("update_strategy")
        return typing.cast(typing.Optional["DaemonSetUpdateStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DaemonSetUpdateStrategy",
    jsii_struct_bases=[],
    name_mapping={"rolling_update": "rollingUpdate", "type": "type"},
)
class DaemonSetUpdateStrategy:
    def __init__(
        self,
        *,
        rolling_update: typing.Optional[typing.Union["RollingUpdateDaemonSet", typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.

        :param rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate. Default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DaemonSetUpdateStrategy
        '''
        if isinstance(rolling_update, dict):
            rolling_update = RollingUpdateDaemonSet(**rolling_update)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5e0f581d8a20b9105b81b844f4e167b368e360c585b35a21311f3ca98fb46b91)
            check_type(argname="argument rolling_update", value=rolling_update, expected_type=type_hints["rolling_update"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if rolling_update is not None:
            self._values["rolling_update"] = rolling_update
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def rolling_update(self) -> typing.Optional["RollingUpdateDaemonSet"]:
        '''Rolling update config params.

        Present only if type = "RollingUpdate".

        :schema: io.k8s.api.apps.v1.DaemonSetUpdateStrategy#rollingUpdate
        '''
        result = self._values.get("rolling_update")
        return typing.cast(typing.Optional["RollingUpdateDaemonSet"], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Type of daemon set update.

        Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.

        :default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DaemonSetUpdateStrategy#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetUpdateStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DeleteOptions",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "dry_run": "dryRun",
        "grace_period_seconds": "gracePeriodSeconds",
        "kind": "kind",
        "orphan_dependents": "orphanDependents",
        "preconditions": "preconditions",
        "propagation_policy": "propagationPolicy",
    },
)
class DeleteOptions:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        dry_run: typing.Optional[typing.Sequence[builtins.str]] = None,
        grace_period_seconds: typing.Optional[jsii.Number] = None,
        kind: typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"] = None,
        orphan_dependents: typing.Optional[builtins.bool] = None,
        preconditions: typing.Optional[typing.Union["Preconditions", typing.Dict[builtins.str, typing.Any]]] = None,
        propagation_policy: typing.Optional[builtins.str] = None,
    ) -> None:
        '''DeleteOptions may be provided when deleting an API object.

        :param api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param dry_run: When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
        :param grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately. Default: a per object value if not specified. zero means delete immediately.
        :param kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param preconditions: Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.
        :param propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions
        '''
        if isinstance(preconditions, dict):
            preconditions = Preconditions(**preconditions)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__894937ed6f7f9cda974d912f2801a6ae827d5990e69eaf69313dca9730e1d2db)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument dry_run", value=dry_run, expected_type=type_hints["dry_run"])
            check_type(argname="argument grace_period_seconds", value=grace_period_seconds, expected_type=type_hints["grace_period_seconds"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument orphan_dependents", value=orphan_dependents, expected_type=type_hints["orphan_dependents"])
            check_type(argname="argument preconditions", value=preconditions, expected_type=type_hints["preconditions"])
            check_type(argname="argument propagation_policy", value=propagation_policy, expected_type=type_hints["propagation_policy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if dry_run is not None:
            self._values["dry_run"] = dry_run
        if grace_period_seconds is not None:
            self._values["grace_period_seconds"] = grace_period_seconds
        if kind is not None:
            self._values["kind"] = kind
        if orphan_dependents is not None:
            self._values["orphan_dependents"] = orphan_dependents
        if preconditions is not None:
            self._values["preconditions"] = preconditions
        if propagation_policy is not None:
            self._values["propagation_policy"] = propagation_policy

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''APIVersion defines the versioned schema of this representation of an object.

        Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dry_run(self) -> typing.Optional[typing.List[builtins.str]]:
        '''When present, indicates that modifications should not be persisted.

        An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#dryRun
        '''
        result = self._values.get("dry_run")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def grace_period_seconds(self) -> typing.Optional[jsii.Number]:
        '''The duration in seconds before the object should be deleted.

        Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.

        :default: a per object value if not specified. zero means delete immediately.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#gracePeriodSeconds
        '''
        result = self._values.get("grace_period_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def kind(
        self,
    ) -> typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"]:
        '''Kind is a string value representing the REST resource this object represents.

        Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"], result)

    @builtins.property
    def orphan_dependents(self) -> typing.Optional[builtins.bool]:
        '''Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#orphanDependents
        '''
        result = self._values.get("orphan_dependents")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def preconditions(self) -> typing.Optional["Preconditions"]:
        '''Must be fulfilled before a deletion is carried out.

        If not possible, a 409 Conflict status will be returned.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#preconditions
        '''
        result = self._values.get("preconditions")
        return typing.cast(typing.Optional["Preconditions"], result)

    @builtins.property
    def propagation_policy(self) -> typing.Optional[builtins.str]:
        '''Whether and how garbage collection will be performed.

        Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#propagationPolicy
        '''
        result = self._values.get("propagation_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeleteOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DeploymentSpec",
    jsii_struct_bases=[],
    name_mapping={
        "selector": "selector",
        "template": "template",
        "min_ready_seconds": "minReadySeconds",
        "paused": "paused",
        "progress_deadline_seconds": "progressDeadlineSeconds",
        "replicas": "replicas",
        "revision_history_limit": "revisionHistoryLimit",
        "strategy": "strategy",
    },
)
class DeploymentSpec:
    def __init__(
        self,
        *,
        selector: typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]],
        template: typing.Union["PodTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        paused: typing.Optional[builtins.bool] = None,
        progress_deadline_seconds: typing.Optional[jsii.Number] = None,
        replicas: typing.Optional[jsii.Number] = None,
        revision_history_limit: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[typing.Union["DeploymentStrategy", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DeploymentSpec is the specification of the desired behavior of the Deployment.

        :param selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param template: Template describes the pods that will be created.
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready) Default: 0 (pod will be considered available as soon as it is ready)
        :param paused: Indicates that the deployment is paused.
        :param progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s. Default: 600s.
        :param replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1. Default: 1.
        :param revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10. Default: 10.
        :param strategy: The deployment strategy to use to replace existing pods with new ones.

        :schema: io.k8s.api.apps.v1.DeploymentSpec
        '''
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(strategy, dict):
            strategy = DeploymentStrategy(**strategy)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__841a9c1f4301ff911ebb48475d8f6e792e522377dd9225c66fb63ec6de840472)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument template", value=template, expected_type=type_hints["template"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
            check_type(argname="argument paused", value=paused, expected_type=type_hints["paused"])
            check_type(argname="argument progress_deadline_seconds", value=progress_deadline_seconds, expected_type=type_hints["progress_deadline_seconds"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument revision_history_limit", value=revision_history_limit, expected_type=type_hints["revision_history_limit"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "selector": selector,
            "template": template,
        }
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds
        if paused is not None:
            self._values["paused"] = paused
        if progress_deadline_seconds is not None:
            self._values["progress_deadline_seconds"] = progress_deadline_seconds
        if replicas is not None:
            self._values["replicas"] = replicas
        if revision_history_limit is not None:
            self._values["revision_history_limit"] = revision_history_limit
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def selector(self) -> "LabelSelector":
        '''Label selector for pods.

        Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#selector
        '''
        result = self._values.get("selector")
        assert result is not None, "Required property 'selector' is missing"
        return typing.cast("LabelSelector", result)

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''Template describes the pods that will be created.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Defaults to 0 (pod will be considered available as soon as it is ready)

        :default: 0 (pod will be considered available as soon as it is ready)

        :schema: io.k8s.api.apps.v1.DeploymentSpec#minReadySeconds
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def paused(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the deployment is paused.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#paused
        '''
        result = self._values.get("paused")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def progress_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''The maximum time in seconds for a deployment to make progress before it is considered to be failed.

        The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.

        :default: 600s.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#progressDeadlineSeconds
        '''
        result = self._values.get("progress_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.

        :default: 1.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#replicas
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def revision_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of old ReplicaSets to retain to allow rollback.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.

        :default: 10.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#revisionHistoryLimit
        '''
        result = self._values.get("revision_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(self) -> typing.Optional["DeploymentStrategy"]:
        '''The deployment strategy to use to replace existing pods with new ones.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#strategy
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["DeploymentStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DeploymentStrategy",
    jsii_struct_bases=[],
    name_mapping={"rolling_update": "rollingUpdate", "type": "type"},
)
class DeploymentStrategy:
    def __init__(
        self,
        *,
        rolling_update: typing.Optional[typing.Union["RollingUpdateDeployment", typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''DeploymentStrategy describes how to replace existing pods with new ones.

        :param rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate. Default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DeploymentStrategy
        '''
        if isinstance(rolling_update, dict):
            rolling_update = RollingUpdateDeployment(**rolling_update)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__391908f87bbaeb572483978b823fbfc34749e495faa875d07fd2958f1cf1b31e)
            check_type(argname="argument rolling_update", value=rolling_update, expected_type=type_hints["rolling_update"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if rolling_update is not None:
            self._values["rolling_update"] = rolling_update
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def rolling_update(self) -> typing.Optional["RollingUpdateDeployment"]:
        '''Rolling update config params.

        Present only if DeploymentStrategyType = RollingUpdate.

        :schema: io.k8s.api.apps.v1.DeploymentStrategy#rollingUpdate
        '''
        result = self._values.get("rolling_update")
        return typing.cast(typing.Optional["RollingUpdateDeployment"], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Type of deployment.

        Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.

        :default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DeploymentStrategy#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DownwardApiProjection",
    jsii_struct_bases=[],
    name_mapping={"items": "items"},
)
class DownwardApiProjection:
    def __init__(
        self,
        *,
        items: typing.Optional[typing.Sequence[typing.Union["DownwardApiVolumeFile", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Represents downward API info for projecting into a projected volume.

        Note that this is identical to a downwardAPI volume source without the default mode.

        :param items: Items is a list of DownwardAPIVolume file.

        :schema: io.k8s.api.core.v1.DownwardAPIProjection
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__711d695f8771b2e426996385f687114ed58e45bd2d0a317e40a268e23b02535a)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def items(self) -> typing.Optional[typing.List["DownwardApiVolumeFile"]]:
        '''Items is a list of DownwardAPIVolume file.

        :schema: io.k8s.api.core.v1.DownwardAPIProjection#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["DownwardApiVolumeFile"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiProjection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DownwardApiVolumeFile",
    jsii_struct_bases=[],
    name_mapping={
        "path": "path",
        "field_ref": "fieldRef",
        "mode": "mode",
        "resource_field_ref": "resourceFieldRef",
    },
)
class DownwardApiVolumeFile:
    def __init__(
        self,
        *,
        path: builtins.str,
        field_ref: typing.Optional[typing.Union["ObjectFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        mode: typing.Optional[jsii.Number] = None,
        resource_field_ref: typing.Optional[typing.Union["ResourceFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DownwardAPIVolumeFile represents information to create the file containing the pod field.

        :param path: Required: Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        :param field_ref: Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
        :param mode: Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile
        '''
        if isinstance(field_ref, dict):
            field_ref = ObjectFieldSelector(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = ResourceFieldSelector(**resource_field_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a570f99c2ba47cd77879c45f1daefb2d91381c5b368c7e8b3d2e51379f30aa4)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if mode is not None:
            self._values["mode"] = mode
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref

    @builtins.property
    def path(self) -> builtins.str:
        '''Required: Path is  the relative path name of the file to be created.

        Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def field_ref(self) -> typing.Optional["ObjectFieldSelector"]:
        '''Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["ObjectFieldSelector"], result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.

        YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def resource_field_ref(self) -> typing.Optional["ResourceFieldSelector"]:
        '''Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["ResourceFieldSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiVolumeFile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.DownwardApiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"default_mode": "defaultMode", "items": "items"},
)
class DownwardApiVolumeSource:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[typing.Union[DownwardApiVolumeFile, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''DownwardAPIVolumeSource represents a volume containing downward API info.

        Downward API volumes support ownership management and SELinux relabeling.

        :param default_mode: Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: Items is a list of downward API volume file.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__422c1ea08d70fcb32828342c42774b005a17c8d71f9adcea606fbeb6b5e6b16d)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits to use on created files by default.

        Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.List[DownwardApiVolumeFile]]:
        '''Items is a list of downward API volume file.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List[DownwardApiVolumeFile]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EmptyDirVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class EmptyDirVolumeSource:
    def __init__(
        self,
        *,
        medium: typing.Optional[builtins.str] = None,
        size_limit: typing.Optional["Quantity"] = None,
    ) -> None:
        '''Represents an empty directory for a pod.

        Empty directory volumes support ownership management and SELinux relabeling.

        :param medium: medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param size_limit: sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir

        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eaad1a1f3f65b1ccaa29b1d27db9c74d563561aa2ceac42027d818fae3530be9)
            check_type(argname="argument medium", value=medium, expected_type=type_hints["medium"])
            check_type(argname="argument size_limit", value=size_limit, expected_type=type_hints["size_limit"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[builtins.str]:
        '''medium represents what type of storage medium should back this directory.

        The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir

        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource#medium
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def size_limit(self) -> typing.Optional["Quantity"]:
        '''sizeLimit is the total amount of local storage required for this EmptyDir volume.

        The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir

        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource#sizeLimit
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional["Quantity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EmptyDirVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.Endpoint",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "conditions": "conditions",
        "deprecated_topology": "deprecatedTopology",
        "hints": "hints",
        "hostname": "hostname",
        "node_name": "nodeName",
        "target_ref": "targetRef",
        "zone": "zone",
    },
)
class Endpoint:
    def __init__(
        self,
        *,
        addresses: typing.Sequence[builtins.str],
        conditions: typing.Optional[typing.Union["EndpointConditions", typing.Dict[builtins.str, typing.Any]]] = None,
        deprecated_topology: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        hints: typing.Optional[typing.Union["EndpointHints", typing.Dict[builtins.str, typing.Any]]] = None,
        hostname: typing.Optional[builtins.str] = None,
        node_name: typing.Optional[builtins.str] = None,
        target_ref: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        zone: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Endpoint represents a single logical "backend" implementing a service.

        :param addresses: addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267
        :param conditions: conditions contains information about the current status of the endpoint.
        :param deprecated_topology: deprecatedTopology contains topology information part of the v1beta1 API. This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24). While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead.
        :param hints: hints contains information associated with how an endpoint should be consumed.
        :param hostname: hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
        :param node_name: nodeName represents the name of the Node hosting this endpoint. This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.
        :param target_ref: targetRef is a reference to a Kubernetes object that represents this endpoint.
        :param zone: zone is the name of the Zone this endpoint exists in.

        :schema: io.k8s.api.discovery.v1.Endpoint
        '''
        if isinstance(conditions, dict):
            conditions = EndpointConditions(**conditions)
        if isinstance(hints, dict):
            hints = EndpointHints(**hints)
        if isinstance(target_ref, dict):
            target_ref = ObjectReference(**target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cfd0ca1444c0c2ece3efe0ff6e4cdce10f2d024de347a1d563bf59beb854d2b1)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument deprecated_topology", value=deprecated_topology, expected_type=type_hints["deprecated_topology"])
            check_type(argname="argument hints", value=hints, expected_type=type_hints["hints"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
            check_type(argname="argument target_ref", value=target_ref, expected_type=type_hints["target_ref"])
            check_type(argname="argument zone", value=zone, expected_type=type_hints["zone"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "addresses": addresses,
        }
        if conditions is not None:
            self._values["conditions"] = conditions
        if deprecated_topology is not None:
            self._values["deprecated_topology"] = deprecated_topology
        if hints is not None:
            self._values["hints"] = hints
        if hostname is not None:
            self._values["hostname"] = hostname
        if node_name is not None:
            self._values["node_name"] = node_name
        if target_ref is not None:
            self._values["target_ref"] = target_ref
        if zone is not None:
            self._values["zone"] = zone

    @builtins.property
    def addresses(self) -> typing.List[builtins.str]:
        '''addresses of this endpoint.

        The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267

        :schema: io.k8s.api.discovery.v1.Endpoint#addresses
        '''
        result = self._values.get("addresses")
        assert result is not None, "Required property 'addresses' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def conditions(self) -> typing.Optional["EndpointConditions"]:
        '''conditions contains information about the current status of the endpoint.

        :schema: io.k8s.api.discovery.v1.Endpoint#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional["EndpointConditions"], result)

    @builtins.property
    def deprecated_topology(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''deprecatedTopology contains topology information part of the v1beta1 API.

        This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24).  While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead.

        :schema: io.k8s.api.discovery.v1.Endpoint#deprecatedTopology
        '''
        result = self._values.get("deprecated_topology")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def hints(self) -> typing.Optional["EndpointHints"]:
        '''hints contains information associated with how an endpoint should be consumed.

        :schema: io.k8s.api.discovery.v1.Endpoint#hints
        '''
        result = self._values.get("hints")
        return typing.cast(typing.Optional["EndpointHints"], result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''hostname of this endpoint.

        This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.

        :schema: io.k8s.api.discovery.v1.Endpoint#hostname
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_name(self) -> typing.Optional[builtins.str]:
        '''nodeName represents the name of the Node hosting this endpoint.

        This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.

        :schema: io.k8s.api.discovery.v1.Endpoint#nodeName
        '''
        result = self._values.get("node_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_ref(self) -> typing.Optional["ObjectReference"]:
        '''targetRef is a reference to a Kubernetes object that represents this endpoint.

        :schema: io.k8s.api.discovery.v1.Endpoint#targetRef
        '''
        result = self._values.get("target_ref")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def zone(self) -> typing.Optional[builtins.str]:
        '''zone is the name of the Zone this endpoint exists in.

        :schema: io.k8s.api.discovery.v1.Endpoint#zone
        '''
        result = self._values.get("zone")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Endpoint(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointAddress",
    jsii_struct_bases=[],
    name_mapping={
        "ip": "ip",
        "hostname": "hostname",
        "node_name": "nodeName",
        "target_ref": "targetRef",
    },
)
class EndpointAddress:
    def __init__(
        self,
        *,
        ip: builtins.str,
        hostname: typing.Optional[builtins.str] = None,
        node_name: typing.Optional[builtins.str] = None,
        target_ref: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointAddress is a tuple that describes single IP address.

        :param ip: The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.
        :param hostname: The Hostname of this endpoint.
        :param node_name: Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        :param target_ref: Reference to object providing the endpoint.

        :schema: io.k8s.api.core.v1.EndpointAddress
        '''
        if isinstance(target_ref, dict):
            target_ref = ObjectReference(**target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08f6719f1d7a138d9f76f8690bb958fdcc5dc65ac8098c976477b23b1a3805de)
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
            check_type(argname="argument target_ref", value=target_ref, expected_type=type_hints["target_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "ip": ip,
        }
        if hostname is not None:
            self._values["hostname"] = hostname
        if node_name is not None:
            self._values["node_name"] = node_name
        if target_ref is not None:
            self._values["target_ref"] = target_ref

    @builtins.property
    def ip(self) -> builtins.str:
        '''The IP of this endpoint.

        May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.

        :schema: io.k8s.api.core.v1.EndpointAddress#ip
        '''
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''The Hostname of this endpoint.

        :schema: io.k8s.api.core.v1.EndpointAddress#hostname
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_name(self) -> typing.Optional[builtins.str]:
        '''Optional: Node hosting this endpoint.

        This can be used to determine endpoints local to a node.

        :schema: io.k8s.api.core.v1.EndpointAddress#nodeName
        '''
        result = self._values.get("node_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_ref(self) -> typing.Optional["ObjectReference"]:
        '''Reference to object providing the endpoint.

        :schema: io.k8s.api.core.v1.EndpointAddress#targetRef
        '''
        result = self._values.get("target_ref")
        return typing.cast(typing.Optional["ObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointAddress(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointConditions",
    jsii_struct_bases=[],
    name_mapping={
        "ready": "ready",
        "serving": "serving",
        "terminating": "terminating",
    },
)
class EndpointConditions:
    def __init__(
        self,
        *,
        ready: typing.Optional[builtins.bool] = None,
        serving: typing.Optional[builtins.bool] = None,
        terminating: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''EndpointConditions represents the current condition of an endpoint.

        :param ready: ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints.
        :param serving: serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
        :param terminating: terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.

        :schema: io.k8s.api.discovery.v1.EndpointConditions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edca9f17d9df0299ad805b919e3cdbc112eaf4221d6fdea8118899322dcd58b6)
            check_type(argname="argument ready", value=ready, expected_type=type_hints["ready"])
            check_type(argname="argument serving", value=serving, expected_type=type_hints["serving"])
            check_type(argname="argument terminating", value=terminating, expected_type=type_hints["terminating"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ready is not None:
            self._values["ready"] = ready
        if serving is not None:
            self._values["serving"] = serving
        if terminating is not None:
            self._values["terminating"] = terminating

    @builtins.property
    def ready(self) -> typing.Optional[builtins.bool]:
        '''ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint.

        A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints.

        :schema: io.k8s.api.discovery.v1.EndpointConditions#ready
        '''
        result = self._values.get("ready")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def serving(self) -> typing.Optional[builtins.bool]:
        '''serving is identical to ready except that it is set regardless of the terminating state of endpoints.

        This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.

        :schema: io.k8s.api.discovery.v1.EndpointConditions#serving
        '''
        result = self._values.get("serving")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def terminating(self) -> typing.Optional[builtins.bool]:
        '''terminating indicates that this endpoint is terminating.

        A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.

        :schema: io.k8s.api.discovery.v1.EndpointConditions#terminating
        '''
        result = self._values.get("terminating")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointConditions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointConditionsV1Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "ready": "ready",
        "serving": "serving",
        "terminating": "terminating",
    },
)
class EndpointConditionsV1Beta1:
    def __init__(
        self,
        *,
        ready: typing.Optional[builtins.bool] = None,
        serving: typing.Optional[builtins.bool] = None,
        terminating: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''EndpointConditions represents the current condition of an endpoint.

        :param ready: ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints.
        :param serving: serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
        :param terminating: terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.

        :schema: io.k8s.api.discovery.v1beta1.EndpointConditions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d57cac21fe4dd438bec77c54165579565d7ac39cb103f8b0a9853dbeb37f3e6b)
            check_type(argname="argument ready", value=ready, expected_type=type_hints["ready"])
            check_type(argname="argument serving", value=serving, expected_type=type_hints["serving"])
            check_type(argname="argument terminating", value=terminating, expected_type=type_hints["terminating"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ready is not None:
            self._values["ready"] = ready
        if serving is not None:
            self._values["serving"] = serving
        if terminating is not None:
            self._values["terminating"] = terminating

    @builtins.property
    def ready(self) -> typing.Optional[builtins.bool]:
        '''ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint.

        A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints.

        :schema: io.k8s.api.discovery.v1beta1.EndpointConditions#ready
        '''
        result = self._values.get("ready")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def serving(self) -> typing.Optional[builtins.bool]:
        '''serving is identical to ready except that it is set regardless of the terminating state of endpoints.

        This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.

        :schema: io.k8s.api.discovery.v1beta1.EndpointConditions#serving
        '''
        result = self._values.get("serving")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def terminating(self) -> typing.Optional[builtins.bool]:
        '''terminating indicates that this endpoint is terminating.

        A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.

        :schema: io.k8s.api.discovery.v1beta1.EndpointConditions#terminating
        '''
        result = self._values.get("terminating")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointConditionsV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointHints",
    jsii_struct_bases=[],
    name_mapping={"for_zones": "forZones"},
)
class EndpointHints:
    def __init__(
        self,
        *,
        for_zones: typing.Optional[typing.Sequence[typing.Union["ForZone", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointHints provides hints describing how an endpoint should be consumed.

        :param for_zones: forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.

        :schema: io.k8s.api.discovery.v1.EndpointHints
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__97b7876c7ea342135d85d3409bcd1d48936859e714909aa45c9cf926b38aff5e)
            check_type(argname="argument for_zones", value=for_zones, expected_type=type_hints["for_zones"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if for_zones is not None:
            self._values["for_zones"] = for_zones

    @builtins.property
    def for_zones(self) -> typing.Optional[typing.List["ForZone"]]:
        '''forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.

        :schema: io.k8s.api.discovery.v1.EndpointHints#forZones
        '''
        result = self._values.get("for_zones")
        return typing.cast(typing.Optional[typing.List["ForZone"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointHints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointHintsV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"for_zones": "forZones"},
)
class EndpointHintsV1Beta1:
    def __init__(
        self,
        *,
        for_zones: typing.Optional[typing.Sequence[typing.Union["ForZoneV1Beta1", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointHints provides hints describing how an endpoint should be consumed.

        :param for_zones: forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing. May contain a maximum of 8 entries.

        :schema: io.k8s.api.discovery.v1beta1.EndpointHints
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e0cb8658304f9388ddf5d2763773d9ce267f5ceaa6a98ff3a59aa5c53eadc1b)
            check_type(argname="argument for_zones", value=for_zones, expected_type=type_hints["for_zones"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if for_zones is not None:
            self._values["for_zones"] = for_zones

    @builtins.property
    def for_zones(self) -> typing.Optional[typing.List["ForZoneV1Beta1"]]:
        '''forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.

        May contain a maximum of 8 entries.

        :schema: io.k8s.api.discovery.v1beta1.EndpointHints#forZones
        '''
        result = self._values.get("for_zones")
        return typing.cast(typing.Optional[typing.List["ForZoneV1Beta1"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointHintsV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointPort",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "app_protocol": "appProtocol",
        "name": "name",
        "protocol": "protocol",
    },
)
class EndpointPort:
    def __init__(
        self,
        *,
        port: jsii.Number,
        app_protocol: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''EndpointPort is a tuple that describes a single port.

        :param port: The port number of the endpoint.
        :param app_protocol: The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.
        :param name: The name of this port. This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        :param protocol: The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP. Default: TCP.

        :schema: io.k8s.api.core.v1.EndpointPort
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e1eb4014d7d9211853d28840f47115730038a28cd88f7ebd6aa6be596a2f808)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument app_protocol", value=app_protocol, expected_type=type_hints["app_protocol"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if app_protocol is not None:
            self._values["app_protocol"] = app_protocol
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def port(self) -> jsii.Number:
        '''The port number of the endpoint.

        :schema: io.k8s.api.core.v1.EndpointPort#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def app_protocol(self) -> typing.Optional[builtins.str]:
        '''The application protocol for this port.

        This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.

        :schema: io.k8s.api.core.v1.EndpointPort#appProtocol
        '''
        result = self._values.get("app_protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port.

        This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.

        :schema: io.k8s.api.core.v1.EndpointPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''The IP protocol for this port.

        Must be UDP, TCP, or SCTP. Default is TCP.

        :default: TCP.

        :schema: io.k8s.api.core.v1.EndpointPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointPortV1Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "app_protocol": "appProtocol",
        "name": "name",
        "port": "port",
        "protocol": "protocol",
    },
)
class EndpointPortV1Beta1:
    def __init__(
        self,
        *,
        app_protocol: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''EndpointPort represents a Port used by an EndpointSlice.

        :param app_protocol: The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.
        :param name: The name of this port. All ports in an EndpointSlice must have a unique name. If the EndpointSlice is dervied from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass DNS_LABEL validation: * must be no more than 63 characters long. * must consist of lower case alphanumeric characters or '-'. * must start and end with an alphanumeric character. Default is empty string. Default: empty string.
        :param port: The port number of the endpoint. If this is not specified, ports are not restricted and must be interpreted in the context of the specific consumer.
        :param protocol: The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP. Default: TCP.

        :schema: io.k8s.api.discovery.v1beta1.EndpointPort
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0e115d15b9b99ed92307ad50cc8c90393880075bb82ccb075e25f3462b5b79d)
            check_type(argname="argument app_protocol", value=app_protocol, expected_type=type_hints["app_protocol"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if app_protocol is not None:
            self._values["app_protocol"] = app_protocol
        if name is not None:
            self._values["name"] = name
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def app_protocol(self) -> typing.Optional[builtins.str]:
        '''The application protocol for this port.

        This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.

        :schema: io.k8s.api.discovery.v1beta1.EndpointPort#appProtocol
        '''
        result = self._values.get("app_protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port.

        All ports in an EndpointSlice must have a unique name. If the EndpointSlice is dervied from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass DNS_LABEL validation: * must be no more than 63 characters long. * must consist of lower case alphanumeric characters or '-'. * must start and end with an alphanumeric character. Default is empty string.

        :default: empty string.

        :schema: io.k8s.api.discovery.v1beta1.EndpointPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port number of the endpoint.

        If this is not specified, ports are not restricted and must be interpreted in the context of the specific consumer.

        :schema: io.k8s.api.discovery.v1beta1.EndpointPort#port
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''The IP protocol for this port.

        Must be UDP, TCP, or SCTP. Default is TCP.

        :default: TCP.

        :schema: io.k8s.api.discovery.v1beta1.EndpointPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointPortV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointSubset",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "not_ready_addresses": "notReadyAddresses",
        "ports": "ports",
    },
)
class EndpointSubset:
    def __init__(
        self,
        *,
        addresses: typing.Optional[typing.Sequence[typing.Union[EndpointAddress, typing.Dict[builtins.str, typing.Any]]]] = None,
        not_ready_addresses: typing.Optional[typing.Sequence[typing.Union[EndpointAddress, typing.Dict[builtins.str, typing.Any]]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointSubset is a group of addresses with a common set of ports.

        The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:
        {
        Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        }
        The resulting set of endpoints can be viewed as:
        a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
        b: [ 10.10.1.1:309, 10.10.2.2:309 ]

        :param addresses: IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        :param not_ready_addresses: IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        :param ports: Port numbers available on the related IP addresses.

        :schema: io.k8s.api.core.v1.EndpointSubset
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__894c6eef8dcde4bff73dd96225e627bb46691d50a56454109b4106a59a2ae3ff)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument not_ready_addresses", value=not_ready_addresses, expected_type=type_hints["not_ready_addresses"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if addresses is not None:
            self._values["addresses"] = addresses
        if not_ready_addresses is not None:
            self._values["not_ready_addresses"] = not_ready_addresses
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def addresses(self) -> typing.Optional[typing.List[EndpointAddress]]:
        '''IP addresses which offer the related ports that are marked as ready.

        These endpoints should be considered safe for load balancers and clients to utilize.

        :schema: io.k8s.api.core.v1.EndpointSubset#addresses
        '''
        result = self._values.get("addresses")
        return typing.cast(typing.Optional[typing.List[EndpointAddress]], result)

    @builtins.property
    def not_ready_addresses(self) -> typing.Optional[typing.List[EndpointAddress]]:
        '''IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.

        :schema: io.k8s.api.core.v1.EndpointSubset#notReadyAddresses
        '''
        result = self._values.get("not_ready_addresses")
        return typing.cast(typing.Optional[typing.List[EndpointAddress]], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[EndpointPort]]:
        '''Port numbers available on the related IP addresses.

        :schema: io.k8s.api.core.v1.EndpointSubset#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[EndpointPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointSubset(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EndpointV1Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "conditions": "conditions",
        "hints": "hints",
        "hostname": "hostname",
        "node_name": "nodeName",
        "target_ref": "targetRef",
        "topology": "topology",
    },
)
class EndpointV1Beta1:
    def __init__(
        self,
        *,
        addresses: typing.Sequence[builtins.str],
        conditions: typing.Optional[typing.Union[EndpointConditionsV1Beta1, typing.Dict[builtins.str, typing.Any]]] = None,
        hints: typing.Optional[typing.Union[EndpointHintsV1Beta1, typing.Dict[builtins.str, typing.Any]]] = None,
        hostname: typing.Optional[builtins.str] = None,
        node_name: typing.Optional[builtins.str] = None,
        target_ref: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        topology: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Endpoint represents a single logical "backend" implementing a service.

        :param addresses: addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267
        :param conditions: conditions contains information about the current status of the endpoint.
        :param hints: hints contains information associated with how an endpoint should be consumed.
        :param hostname: hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
        :param node_name: nodeName represents the name of the Node hosting this endpoint. This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.
        :param target_ref: targetRef is a reference to a Kubernetes object that represents this endpoint.
        :param topology: topology contains arbitrary topology information associated with the endpoint. These key/value pairs must conform with the label format. https://kubernetes.io/docs/concepts/overview/working-with-objects/labels Topology may include a maximum of 16 key/value pairs. This includes, but is not limited to the following well known keys: * kubernetes.io/hostname: the value indicates the hostname of the node where the endpoint is located. This should match the corresponding node label. - topology.kubernetes.io/zone: the value indicates the zone where the endpoint is located. This should match the corresponding node label. - topology.kubernetes.io/region: the value indicates the region where the endpoint is located. This should match the corresponding node label. This field is deprecated and will be removed in future api versions.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint
        '''
        if isinstance(conditions, dict):
            conditions = EndpointConditionsV1Beta1(**conditions)
        if isinstance(hints, dict):
            hints = EndpointHintsV1Beta1(**hints)
        if isinstance(target_ref, dict):
            target_ref = ObjectReference(**target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b3891f68fba8b1b2818a18e4f257798f93efb78d1908638fb8d20c3d1af955b)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument hints", value=hints, expected_type=type_hints["hints"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
            check_type(argname="argument target_ref", value=target_ref, expected_type=type_hints["target_ref"])
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "addresses": addresses,
        }
        if conditions is not None:
            self._values["conditions"] = conditions
        if hints is not None:
            self._values["hints"] = hints
        if hostname is not None:
            self._values["hostname"] = hostname
        if node_name is not None:
            self._values["node_name"] = node_name
        if target_ref is not None:
            self._values["target_ref"] = target_ref
        if topology is not None:
            self._values["topology"] = topology

    @builtins.property
    def addresses(self) -> typing.List[builtins.str]:
        '''addresses of this endpoint.

        The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#addresses
        '''
        result = self._values.get("addresses")
        assert result is not None, "Required property 'addresses' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def conditions(self) -> typing.Optional[EndpointConditionsV1Beta1]:
        '''conditions contains information about the current status of the endpoint.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional[EndpointConditionsV1Beta1], result)

    @builtins.property
    def hints(self) -> typing.Optional[EndpointHintsV1Beta1]:
        '''hints contains information associated with how an endpoint should be consumed.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#hints
        '''
        result = self._values.get("hints")
        return typing.cast(typing.Optional[EndpointHintsV1Beta1], result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''hostname of this endpoint.

        This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#hostname
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_name(self) -> typing.Optional[builtins.str]:
        '''nodeName represents the name of the Node hosting this endpoint.

        This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#nodeName
        '''
        result = self._values.get("node_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_ref(self) -> typing.Optional["ObjectReference"]:
        '''targetRef is a reference to a Kubernetes object that represents this endpoint.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#targetRef
        '''
        result = self._values.get("target_ref")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def topology(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''topology contains arbitrary topology information associated with the endpoint.

        These key/value pairs must conform with the label format. https://kubernetes.io/docs/concepts/overview/working-with-objects/labels Topology may include a maximum of 16 key/value pairs. This includes, but is not limited to the following well known keys: * kubernetes.io/hostname: the value indicates the hostname of the node
        where the endpoint is located. This should match the corresponding
        node label.

        - topology.kubernetes.io/zone: the value indicates the zone where the
          endpoint is located. This should match the corresponding node label.
        - topology.kubernetes.io/region: the value indicates the region where the
          endpoint is located. This should match the corresponding node label.
          This field is deprecated and will be removed in future api versions.

        :schema: io.k8s.api.discovery.v1beta1.Endpoint#topology
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EnvFromSource",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_ref": "configMapRef",
        "prefix": "prefix",
        "secret_ref": "secretRef",
    },
)
class EnvFromSource:
    def __init__(
        self,
        *,
        config_map_ref: typing.Optional[typing.Union[ConfigMapEnvSource, typing.Dict[builtins.str, typing.Any]]] = None,
        prefix: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["SecretEnvSource", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EnvFromSource represents the source of a set of ConfigMaps.

        :param config_map_ref: The ConfigMap to select from.
        :param prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        :param secret_ref: The Secret to select from.

        :schema: io.k8s.api.core.v1.EnvFromSource
        '''
        if isinstance(config_map_ref, dict):
            config_map_ref = ConfigMapEnvSource(**config_map_ref)
        if isinstance(secret_ref, dict):
            secret_ref = SecretEnvSource(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a045aba02ed0ba81f66787f7274ddf8891abeeb79cf6d3ea59adc6088c5502af)
            check_type(argname="argument config_map_ref", value=config_map_ref, expected_type=type_hints["config_map_ref"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if config_map_ref is not None:
            self._values["config_map_ref"] = config_map_ref
        if prefix is not None:
            self._values["prefix"] = prefix
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def config_map_ref(self) -> typing.Optional[ConfigMapEnvSource]:
        '''The ConfigMap to select from.

        :schema: io.k8s.api.core.v1.EnvFromSource#configMapRef
        '''
        result = self._values.get("config_map_ref")
        return typing.cast(typing.Optional[ConfigMapEnvSource], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''An optional identifier to prepend to each key in the ConfigMap.

        Must be a C_IDENTIFIER.

        :schema: io.k8s.api.core.v1.EnvFromSource#prefix
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretEnvSource"]:
        '''The Secret to select from.

        :schema: io.k8s.api.core.v1.EnvFromSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretEnvSource"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvFromSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EnvVar",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value", "value_from": "valueFrom"},
)
class EnvVar:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
        value_from: typing.Optional[typing.Union["EnvVarSource", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EnvVar represents an environment variable present in a Container.

        :param name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param value: Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". Default: .
        :param value_from: Source for the environment variable's value. Cannot be used if value is not empty.

        :schema: io.k8s.api.core.v1.EnvVar
        '''
        if isinstance(value_from, dict):
            value_from = EnvVarSource(**value_from)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__746ae7813e5a37f1a6cd79776dbf8758cceb35f80cb369696c2529c62f8aeed2)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument value_from", value=value_from, expected_type=type_hints["value_from"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value
        if value_from is not None:
            self._values["value_from"] = value_from

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the environment variable.

        Must be a C_IDENTIFIER.

        :schema: io.k8s.api.core.v1.EnvVar#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables.

        If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".

        :default: .

        :schema: io.k8s.api.core.v1.EnvVar#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value_from(self) -> typing.Optional["EnvVarSource"]:
        '''Source for the environment variable's value.

        Cannot be used if value is not empty.

        :schema: io.k8s.api.core.v1.EnvVar#valueFrom
        '''
        result = self._values.get("value_from")
        return typing.cast(typing.Optional["EnvVarSource"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvVar(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EnvVarSource",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_key_ref": "configMapKeyRef",
        "field_ref": "fieldRef",
        "resource_field_ref": "resourceFieldRef",
        "secret_key_ref": "secretKeyRef",
    },
)
class EnvVarSource:
    def __init__(
        self,
        *,
        config_map_key_ref: typing.Optional[typing.Union[ConfigMapKeySelector, typing.Dict[builtins.str, typing.Any]]] = None,
        field_ref: typing.Optional[typing.Union["ObjectFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        resource_field_ref: typing.Optional[typing.Union["ResourceFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        secret_key_ref: typing.Optional[typing.Union["SecretKeySelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EnvVarSource represents a source for the value of an EnvVar.

        :param config_map_key_ref: Selects a key of a ConfigMap.
        :param field_ref: Selects a field of the pod: supports metadata.name, metadata.namespace, ``metadata.labels['<KEY>']``, ``metadata.annotations['<KEY>']``, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        :param resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        :param secret_key_ref: Selects a key of a secret in the pod's namespace.

        :schema: io.k8s.api.core.v1.EnvVarSource
        '''
        if isinstance(config_map_key_ref, dict):
            config_map_key_ref = ConfigMapKeySelector(**config_map_key_ref)
        if isinstance(field_ref, dict):
            field_ref = ObjectFieldSelector(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = ResourceFieldSelector(**resource_field_ref)
        if isinstance(secret_key_ref, dict):
            secret_key_ref = SecretKeySelector(**secret_key_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad9bbbcc9cff26e39cc2251cc525141521edc2400d798c795b1afbc3dbf0ce08)
            check_type(argname="argument config_map_key_ref", value=config_map_key_ref, expected_type=type_hints["config_map_key_ref"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
            check_type(argname="argument secret_key_ref", value=secret_key_ref, expected_type=type_hints["secret_key_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if config_map_key_ref is not None:
            self._values["config_map_key_ref"] = config_map_key_ref
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref
        if secret_key_ref is not None:
            self._values["secret_key_ref"] = secret_key_ref

    @builtins.property
    def config_map_key_ref(self) -> typing.Optional[ConfigMapKeySelector]:
        '''Selects a key of a ConfigMap.

        :schema: io.k8s.api.core.v1.EnvVarSource#configMapKeyRef
        '''
        result = self._values.get("config_map_key_ref")
        return typing.cast(typing.Optional[ConfigMapKeySelector], result)

    @builtins.property
    def field_ref(self) -> typing.Optional["ObjectFieldSelector"]:
        '''Selects a field of the pod: supports metadata.name, metadata.namespace, ``metadata.labels['<KEY>']``, ``metadata.annotations['<KEY>']``, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.

        :schema: io.k8s.api.core.v1.EnvVarSource#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["ObjectFieldSelector"], result)

    @builtins.property
    def resource_field_ref(self) -> typing.Optional["ResourceFieldSelector"]:
        '''Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.

        :schema: io.k8s.api.core.v1.EnvVarSource#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["ResourceFieldSelector"], result)

    @builtins.property
    def secret_key_ref(self) -> typing.Optional["SecretKeySelector"]:
        '''Selects a key of a secret in the pod's namespace.

        :schema: io.k8s.api.core.v1.EnvVarSource#secretKeyRef
        '''
        result = self._values.get("secret_key_ref")
        return typing.cast(typing.Optional["SecretKeySelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvVarSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EphemeralContainer",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "args": "args",
        "command": "command",
        "env": "env",
        "env_from": "envFrom",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness_probe": "livenessProbe",
        "ports": "ports",
        "readiness_probe": "readinessProbe",
        "resources": "resources",
        "security_context": "securityContext",
        "startup_probe": "startupProbe",
        "stdin": "stdin",
        "stdin_once": "stdinOnce",
        "target_container_name": "targetContainerName",
        "termination_message_path": "terminationMessagePath",
        "termination_message_policy": "terminationMessagePolicy",
        "tty": "tty",
        "volume_devices": "volumeDevices",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class EphemeralContainer:
    def __init__(
        self,
        *,
        name: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env: typing.Optional[typing.Sequence[typing.Union[EnvVar, typing.Dict[builtins.str, typing.Any]]]] = None,
        env_from: typing.Optional[typing.Sequence[typing.Union[EnvFromSource, typing.Dict[builtins.str, typing.Any]]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        lifecycle: typing.Optional[typing.Union["Lifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        resources: typing.Optional[typing.Union["ResourceRequirements", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["SecurityContext", typing.Dict[builtins.str, typing.Any]]] = None,
        startup_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        stdin: typing.Optional[builtins.bool] = None,
        stdin_once: typing.Optional[builtins.bool] = None,
        target_container_name: typing.Optional[builtins.str] = None,
        termination_message_path: typing.Optional[builtins.str] = None,
        termination_message_policy: typing.Optional[builtins.str] = None,
        tty: typing.Optional[builtins.bool] = None,
        volume_devices: typing.Optional[typing.Sequence[typing.Union["VolumeDevice", typing.Dict[builtins.str, typing.Any]]]] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging.

        Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

        To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted.

        This is a beta feature available on clusters that haven't disabled the EphemeralContainers feature gate.

        :param name: Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        :param args: Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param command: Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param env: List of environment variables to set in the container. Cannot be updated.
        :param env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images Default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param lifecycle: Lifecycle is not allowed for ephemeral containers.
        :param liveness_probe: Probes are not allowed for ephemeral containers.
        :param ports: Ports are not allowed for ephemeral containers.
        :param readiness_probe: Probes are not allowed for ephemeral containers.
        :param resources: Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        :param security_context: Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
        :param startup_probe: Probes are not allowed for ephemeral containers.
        :param stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. Default: false.
        :param stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false Default: false
        :param target_container_name: If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec. The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.
        :param termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. Default: dev/termination-log. Cannot be updated.
        :param termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. Default: File. Cannot be updated.
        :param tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. Default: false.
        :param volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer
        '''
        if isinstance(lifecycle, dict):
            lifecycle = Lifecycle(**lifecycle)
        if isinstance(liveness_probe, dict):
            liveness_probe = Probe(**liveness_probe)
        if isinstance(readiness_probe, dict):
            readiness_probe = Probe(**readiness_probe)
        if isinstance(resources, dict):
            resources = ResourceRequirements(**resources)
        if isinstance(security_context, dict):
            security_context = SecurityContext(**security_context)
        if isinstance(startup_probe, dict):
            startup_probe = Probe(**startup_probe)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9bc177162882523431c1d9e76234e32dff787ef17ee4f401802f447dc30a8f4)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness_probe", value=liveness_probe, expected_type=type_hints["liveness_probe"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness_probe", value=readiness_probe, expected_type=type_hints["readiness_probe"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup_probe", value=startup_probe, expected_type=type_hints["startup_probe"])
            check_type(argname="argument stdin", value=stdin, expected_type=type_hints["stdin"])
            check_type(argname="argument stdin_once", value=stdin_once, expected_type=type_hints["stdin_once"])
            check_type(argname="argument target_container_name", value=target_container_name, expected_type=type_hints["target_container_name"])
            check_type(argname="argument termination_message_path", value=termination_message_path, expected_type=type_hints["termination_message_path"])
            check_type(argname="argument termination_message_policy", value=termination_message_policy, expected_type=type_hints["termination_message_policy"])
            check_type(argname="argument tty", value=tty, expected_type=type_hints["tty"])
            check_type(argname="argument volume_devices", value=volume_devices, expected_type=type_hints["volume_devices"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env is not None:
            self._values["env"] = env
        if env_from is not None:
            self._values["env_from"] = env_from
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness_probe is not None:
            self._values["liveness_probe"] = liveness_probe
        if ports is not None:
            self._values["ports"] = ports
        if readiness_probe is not None:
            self._values["readiness_probe"] = readiness_probe
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup_probe is not None:
            self._values["startup_probe"] = startup_probe
        if stdin is not None:
            self._values["stdin"] = stdin
        if stdin_once is not None:
            self._values["stdin_once"] = stdin_once
        if target_container_name is not None:
            self._values["target_container_name"] = target_container_name
        if termination_message_path is not None:
            self._values["termination_message_path"] = termination_message_path
        if termination_message_policy is not None:
            self._values["termination_message_policy"] = termination_message_policy
        if tty is not None:
            self._values["tty"] = tty
        if volume_devices is not None:
            self._values["volume_devices"] = volume_devices
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the ephemeral container specified as a DNS_LABEL.

        This name must be unique among all containers, init containers and ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.EphemeralContainer#args
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.EphemeralContainer#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List[EnvVar]]:
        '''List of environment variables to set in the container.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List[EnvVar]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List[EnvFromSource]]:
        '''List of sources to populate environment variables in the container.

        The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#envFrom
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List[EnvFromSource]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''Container image name.

        More info: https://kubernetes.io/docs/concepts/containers/images

        :schema: io.k8s.api.core.v1.EphemeralContainer#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''Image pull policy.

        One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :schema: io.k8s.api.core.v1.EphemeralContainer#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["Lifecycle"]:
        '''Lifecycle is not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#lifecycle
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["Lifecycle"], result)

    @builtins.property
    def liveness_probe(self) -> typing.Optional["Probe"]:
        '''Probes are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#livenessProbe
        '''
        result = self._values.get("liveness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ContainerPort]]:
        '''Ports are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ContainerPort]], result)

    @builtins.property
    def readiness_probe(self) -> typing.Optional["Probe"]:
        '''Probes are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#readinessProbe
        '''
        result = self._values.get("readiness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ResourceRequirements"]:
        '''Resources are not allowed for ephemeral containers.

        Ephemeral containers use spare resources already allocated to the pod.

        :schema: io.k8s.api.core.v1.EphemeralContainer#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ResourceRequirements"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["SecurityContext"]:
        '''Optional: SecurityContext defines the security options the ephemeral container should be run with.

        If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.

        :schema: io.k8s.api.core.v1.EphemeralContainer#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["SecurityContext"], result)

    @builtins.property
    def startup_probe(self) -> typing.Optional["Probe"]:
        '''Probes are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#startupProbe
        '''
        result = self._values.get("startup_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def stdin(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a buffer for stdin in the container runtime.

        If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.EphemeralContainer#stdin
        '''
        result = self._values.get("stdin")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stdin_once(self) -> typing.Optional[builtins.bool]:
        '''Whether the container runtime should close the stdin channel after it has been opened by a single attach.

        When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :default: false

        :schema: io.k8s.api.core.v1.EphemeralContainer#stdinOnce
        '''
        result = self._values.get("stdin_once")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def target_container_name(self) -> typing.Optional[builtins.str]:
        '''If set, the name of the container from PodSpec that this ephemeral container targets.

        The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.

        The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.

        :schema: io.k8s.api.core.v1.EphemeralContainer#targetContainerName
        '''
        result = self._values.get("target_container_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_path(self) -> typing.Optional[builtins.str]:
        '''Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.

        Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.

        :default: dev/termination-log. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#terminationMessagePath
        '''
        result = self._values.get("termination_message_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_policy(self) -> typing.Optional[builtins.str]:
        '''Indicate how the termination message should be populated.

        File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.

        :default: File. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#terminationMessagePolicy
        '''
        result = self._values.get("termination_message_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tty(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.

        Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.EphemeralContainer#tty
        '''
        result = self._values.get("tty")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_devices(self) -> typing.Optional[typing.List["VolumeDevice"]]:
        '''volumeDevices is the list of block devices to be used by the container.

        :schema: io.k8s.api.core.v1.EphemeralContainer#volumeDevices
        '''
        result = self._values.get("volume_devices")
        return typing.cast(typing.Optional[typing.List["VolumeDevice"]], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Subpath mounts are not allowed for ephemeral containers. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#volumeMounts
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#workingDir
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralContainer(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EphemeralVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"volume_claim_template": "volumeClaimTemplate"},
)
class EphemeralVolumeSource:
    def __init__(
        self,
        *,
        volume_claim_template: typing.Optional[typing.Union["PersistentVolumeClaimTemplate", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents an ephemeral volume that is handled by a normal storage driver.

        :param volume_claim_template: Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod. The name of the PVC will be ``<pod name>-<volume name>`` where ``<volume name>`` is the name from the ``PodSpec.Volumes`` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long). An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster. This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created. Required, must not be nil.

        :schema: io.k8s.api.core.v1.EphemeralVolumeSource
        '''
        if isinstance(volume_claim_template, dict):
            volume_claim_template = PersistentVolumeClaimTemplate(**volume_claim_template)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33cec17ce2630fccc741460a3ea94c7a00a14664acdfb5d0ca710f68f198666e)
            check_type(argname="argument volume_claim_template", value=volume_claim_template, expected_type=type_hints["volume_claim_template"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if volume_claim_template is not None:
            self._values["volume_claim_template"] = volume_claim_template

    @builtins.property
    def volume_claim_template(self) -> typing.Optional["PersistentVolumeClaimTemplate"]:
        '''Will be used to create a stand-alone PVC to provision the volume.

        The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be ``<pod name>-<volume name>`` where ``<volume name>`` is the name from the ``PodSpec.Volumes`` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

        An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

        This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

        Required, must not be nil.

        :schema: io.k8s.api.core.v1.EphemeralVolumeSource#volumeClaimTemplate
        '''
        result = self._values.get("volume_claim_template")
        return typing.cast(typing.Optional["PersistentVolumeClaimTemplate"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EventSeries",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "last_observed_time": "lastObservedTime"},
)
class EventSeries:
    def __init__(
        self,
        *,
        count: jsii.Number,
        last_observed_time: datetime.datetime,
    ) -> None:
        '''EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in "k8s.io/client-go/tools/events/event_broadcaster.go" shows how this struct is updated on heartbeats and can guide customized reporter implementations.

        :param count: count is the number of occurrences in this series up to the last heartbeat time.
        :param last_observed_time: lastObservedTime is the time when last Event from the series was seen before last heartbeat.

        :schema: io.k8s.api.events.v1.EventSeries
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__592ab9e8eb339da2517e5e7ce8892c1b9eb654160d9109db80270e4afad0b1eb)
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument last_observed_time", value=last_observed_time, expected_type=type_hints["last_observed_time"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "count": count,
            "last_observed_time": last_observed_time,
        }

    @builtins.property
    def count(self) -> jsii.Number:
        '''count is the number of occurrences in this series up to the last heartbeat time.

        :schema: io.k8s.api.events.v1.EventSeries#count
        '''
        result = self._values.get("count")
        assert result is not None, "Required property 'count' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def last_observed_time(self) -> datetime.datetime:
        '''lastObservedTime is the time when last Event from the series was seen before last heartbeat.

        :schema: io.k8s.api.events.v1.EventSeries#lastObservedTime
        '''
        result = self._values.get("last_observed_time")
        assert result is not None, "Required property 'last_observed_time' is missing"
        return typing.cast(datetime.datetime, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSeries(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EventSeriesV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "last_observed_time": "lastObservedTime"},
)
class EventSeriesV1Beta1:
    def __init__(
        self,
        *,
        count: jsii.Number,
        last_observed_time: datetime.datetime,
    ) -> None:
        '''EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.

        :param count: count is the number of occurrences in this series up to the last heartbeat time.
        :param last_observed_time: lastObservedTime is the time when last Event from the series was seen before last heartbeat.

        :schema: io.k8s.api.events.v1beta1.EventSeries
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18f63563d915895281215194711e0f470a40ac7879d7af2b2b59e64d2a75dc21)
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument last_observed_time", value=last_observed_time, expected_type=type_hints["last_observed_time"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "count": count,
            "last_observed_time": last_observed_time,
        }

    @builtins.property
    def count(self) -> jsii.Number:
        '''count is the number of occurrences in this series up to the last heartbeat time.

        :schema: io.k8s.api.events.v1beta1.EventSeries#count
        '''
        result = self._values.get("count")
        assert result is not None, "Required property 'count' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def last_observed_time(self) -> datetime.datetime:
        '''lastObservedTime is the time when last Event from the series was seen before last heartbeat.

        :schema: io.k8s.api.events.v1beta1.EventSeries#lastObservedTime
        '''
        result = self._values.get("last_observed_time")
        assert result is not None, "Required property 'last_observed_time' is missing"
        return typing.cast(datetime.datetime, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSeriesV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.EventSource",
    jsii_struct_bases=[],
    name_mapping={"component": "component", "host": "host"},
)
class EventSource:
    def __init__(
        self,
        *,
        component: typing.Optional[builtins.str] = None,
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''EventSource contains information for an event.

        :param component: Component from which the event is generated.
        :param host: Node name on which the event is generated.

        :schema: io.k8s.api.core.v1.EventSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bbd4a5ecc53eb2e6726b536295f1ee138bccc26e6292cde18cfd4999add537a3)
            check_type(argname="argument component", value=component, expected_type=type_hints["component"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if component is not None:
            self._values["component"] = component
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def component(self) -> typing.Optional[builtins.str]:
        '''Component from which the event is generated.

        :schema: io.k8s.api.core.v1.EventSource#component
        '''
        result = self._values.get("component")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Node name on which the event is generated.

        :schema: io.k8s.api.core.v1.EventSource#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ExecAction",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class ExecAction:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''ExecAction describes a "run in container" action.

        :param command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.

        :schema: io.k8s.api.core.v1.ExecAction
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a8b9a43a27aa13f7c991c67c64faec85bbc75f1164b6d397ff17b0a5aa943a4)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem.

        The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.

        :schema: io.k8s.api.core.v1.ExecAction#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExecAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ExternalDocumentation",
    jsii_struct_bases=[],
    name_mapping={"description": "description", "url": "url"},
)
class ExternalDocumentation:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ExternalDocumentation allows referencing an external resource for extended documentation.

        :param description: 
        :param url: 

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__133f3e719885bd1a2f98d0cf36cfabe609ed0f4149fe2da68f5858a7b947deda)
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if url is not None:
            self._values["url"] = url

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation#url
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalDocumentation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ExternalMetricSourceV2",
    jsii_struct_bases=[],
    name_mapping={"metric": "metric", "target": "target"},
)
class ExternalMetricSourceV2:
    def __init__(
        self,
        *,
        metric: typing.Union["MetricIdentifierV2", typing.Dict[builtins.str, typing.Any]],
        target: typing.Union["MetricTargetV2", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).

        :param metric: metric identifies the target metric by name and selector.
        :param target: target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ExternalMetricSource
        '''
        if isinstance(metric, dict):
            metric = MetricIdentifierV2(**metric)
        if isinstance(target, dict):
            target = MetricTargetV2(**target)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ec19c153771aa3e996ce06f75645242813d5a962559c28ede9d2dd1e2ed4d13)
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "metric": metric,
            "target": target,
        }

    @builtins.property
    def metric(self) -> "MetricIdentifierV2":
        '''metric identifies the target metric by name and selector.

        :schema: io.k8s.api.autoscaling.v2.ExternalMetricSource#metric
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast("MetricIdentifierV2", result)

    @builtins.property
    def target(self) -> "MetricTargetV2":
        '''target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ExternalMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTargetV2", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalMetricSourceV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ExternalMetricSourceV2Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "metric_selector": "metricSelector",
        "target_average_value": "targetAverageValue",
        "target_value": "targetValue",
    },
)
class ExternalMetricSourceV2Beta1:
    def __init__(
        self,
        *,
        metric_name: builtins.str,
        metric_selector: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        target_average_value: typing.Optional["Quantity"] = None,
        target_value: typing.Optional["Quantity"] = None,
    ) -> None:
        '''ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).

        Exactly one "target" type should be set.

        :param metric_name: metricName is the name of the metric in question.
        :param metric_selector: metricSelector is used to identify a specific time series within a given metric.
        :param target_average_value: targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.
        :param target_value: targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.

        :schema: io.k8s.api.autoscaling.v2beta1.ExternalMetricSource
        '''
        if isinstance(metric_selector, dict):
            metric_selector = LabelSelector(**metric_selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9751e10deaa97312b882d92b3d08674b003a53a5f206cfd99b429d3e9a3eca32)
            check_type(argname="argument metric_name", value=metric_name, expected_type=type_hints["metric_name"])
            check_type(argname="argument metric_selector", value=metric_selector, expected_type=type_hints["metric_selector"])
            check_type(argname="argument target_average_value", value=target_average_value, expected_type=type_hints["target_average_value"])
            check_type(argname="argument target_value", value=target_value, expected_type=type_hints["target_value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "metric_name": metric_name,
        }
        if metric_selector is not None:
            self._values["metric_selector"] = metric_selector
        if target_average_value is not None:
            self._values["target_average_value"] = target_average_value
        if target_value is not None:
            self._values["target_value"] = target_value

    @builtins.property
    def metric_name(self) -> builtins.str:
        '''metricName is the name of the metric in question.

        :schema: io.k8s.api.autoscaling.v2beta1.ExternalMetricSource#metricName
        '''
        result = self._values.get("metric_name")
        assert result is not None, "Required property 'metric_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric_selector(self) -> typing.Optional["LabelSelector"]:
        '''metricSelector is used to identify a specific time series within a given metric.

        :schema: io.k8s.api.autoscaling.v2beta1.ExternalMetricSource#metricSelector
        '''
        result = self._values.get("metric_selector")
        return typing.cast(typing.Optional["LabelSelector"], result)

    @builtins.property
    def target_average_value(self) -> typing.Optional["Quantity"]:
        '''targetAverageValue is the target per-pod value of global metric (as a quantity).

        Mutually exclusive with TargetValue.

        :schema: io.k8s.api.autoscaling.v2beta1.ExternalMetricSource#targetAverageValue
        '''
        result = self._values.get("target_average_value")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def target_value(self) -> typing.Optional["Quantity"]:
        '''targetValue is the target value of the metric (as a quantity).

        Mutually exclusive with TargetAverageValue.

        :schema: io.k8s.api.autoscaling.v2beta1.ExternalMetricSource#targetValue
        '''
        result = self._values.get("target_value")
        return typing.cast(typing.Optional["Quantity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalMetricSourceV2Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ExternalMetricSourceV2Beta2",
    jsii_struct_bases=[],
    name_mapping={"metric": "metric", "target": "target"},
)
class ExternalMetricSourceV2Beta2:
    def __init__(
        self,
        *,
        metric: typing.Union["MetricIdentifierV2Beta2", typing.Dict[builtins.str, typing.Any]],
        target: typing.Union["MetricTargetV2Beta2", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).

        :param metric: metric identifies the target metric by name and selector.
        :param target: target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource
        '''
        if isinstance(metric, dict):
            metric = MetricIdentifierV2Beta2(**metric)
        if isinstance(target, dict):
            target = MetricTargetV2Beta2(**target)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cba68e131e5bac7d6fa80c1e0ed5cf1ffcc61fe92ee0565836936c255c7225a)
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "metric": metric,
            "target": target,
        }

    @builtins.property
    def metric(self) -> "MetricIdentifierV2Beta2":
        '''metric identifies the target metric by name and selector.

        :schema: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource#metric
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast("MetricIdentifierV2Beta2", result)

    @builtins.property
    def target(self) -> "MetricTargetV2Beta2":
        '''target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTargetV2Beta2", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalMetricSourceV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FcVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "lun": "lun",
        "read_only": "readOnly",
        "target_ww_ns": "targetWwNs",
        "wwids": "wwids",
    },
)
class FcVolumeSource:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        lun: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        target_ww_ns: typing.Optional[typing.Sequence[builtins.str]] = None,
        wwids: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Represents a Fibre Channel volume.

        Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.

        :param fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param lun: lun is Optional: FC target lun number.
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param target_ww_ns: targetWWNs is Optional: FC target worldwide names (WWNs).
        :param wwids: wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.

        :schema: io.k8s.api.core.v1.FCVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__228b3a65fee868e4bb8fdf2b8736917a6ce805604b021954a65363acc2639a3b)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument lun", value=lun, expected_type=type_hints["lun"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument target_ww_ns", value=target_ww_ns, expected_type=type_hints["target_ww_ns"])
            check_type(argname="argument wwids", value=wwids, expected_type=type_hints["wwids"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if lun is not None:
            self._values["lun"] = lun
        if read_only is not None:
            self._values["read_only"] = read_only
        if target_ww_ns is not None:
            self._values["target_ww_ns"] = target_ww_ns
        if wwids is not None:
            self._values["wwids"] = wwids

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.

        :schema: io.k8s.api.core.v1.FCVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lun(self) -> typing.Optional[jsii.Number]:
        '''lun is Optional: FC target lun number.

        :schema: io.k8s.api.core.v1.FCVolumeSource#lun
        '''
        result = self._values.get("lun")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.FCVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def target_ww_ns(self) -> typing.Optional[typing.List[builtins.str]]:
        '''targetWWNs is Optional: FC target worldwide names (WWNs).

        :schema: io.k8s.api.core.v1.FCVolumeSource#targetWWNs
        '''
        result = self._values.get("target_ww_ns")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def wwids(self) -> typing.Optional[typing.List[builtins.str]]:
        '''wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.

        :schema: io.k8s.api.core.v1.FCVolumeSource#wwids
        '''
        result = self._values.get("wwids")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FcVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlexPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "options": "options",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class FlexPersistentVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        options: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.

        :param driver: driver is the name of the driver to use for this volume.
        :param fs_type: fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param options: options is Optional: this field holds extra command options if any.
        :param read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_ref: secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3b5089fdf5b9f7db24920b6c506f27d36378ec35385645d95b755d3b11e448d)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if options is not None:
            self._values["options"] = options
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the driver to use for this volume.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''options is Optional: this field holds extra command options if any.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#options
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.

        This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlexPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlexVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "options": "options",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class FlexVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        options: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.

        :param driver: driver is the name of the driver to use for this volume.
        :param fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param options: options is Optional: this field holds extra command options if any.
        :param read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_ref: secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a6facddc6f27483221e7534ebe1e6d4c28380af21ec2a898f8773228e7d9756)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if options is not None:
            self._values["options"] = options
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the driver to use for this volume.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''options is Optional: this field holds extra command options if any.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#options
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.

        This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlexVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlockerVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"dataset_name": "datasetName", "dataset_uuid": "datasetUuid"},
)
class FlockerVolumeSource:
    def __init__(
        self,
        *,
        dataset_name: typing.Optional[builtins.str] = None,
        dataset_uuid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a Flocker volume mounted by the Flocker agent.

        One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.

        :param dataset_name: datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.
        :param dataset_uuid: datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset

        :schema: io.k8s.api.core.v1.FlockerVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6f5a1b71a1eca6e54b8f709d3f0363b0d8815a22ad0a73c94ddca888e7dba42)
            check_type(argname="argument dataset_name", value=dataset_name, expected_type=type_hints["dataset_name"])
            check_type(argname="argument dataset_uuid", value=dataset_uuid, expected_type=type_hints["dataset_uuid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if dataset_name is not None:
            self._values["dataset_name"] = dataset_name
        if dataset_uuid is not None:
            self._values["dataset_uuid"] = dataset_uuid

    @builtins.property
    def dataset_name(self) -> typing.Optional[builtins.str]:
        '''datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.

        :schema: io.k8s.api.core.v1.FlockerVolumeSource#datasetName
        '''
        result = self._values.get("dataset_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dataset_uuid(self) -> typing.Optional[builtins.str]:
        '''datasetUUID is the UUID of the dataset.

        This is unique identifier of a Flocker dataset

        :schema: io.k8s.api.core.v1.FlockerVolumeSource#datasetUUID
        '''
        result = self._values.get("dataset_uuid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlockerVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlowDistinguisherMethodV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"type": "type"},
)
class FlowDistinguisherMethodV1Beta1:
    def __init__(self, *, type: builtins.str) -> None:
        '''FlowDistinguisherMethod specifies the method of a flow distinguisher.

        :param type: ``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61f9b8a73e74d6643afcf5e193ed7d039f100c7ff6e5855ab74c074487a98013)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "type": type,
        }

    @builtins.property
    def type(self) -> builtins.str:
        '''``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace".

        Required.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowDistinguisherMethodV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlowDistinguisherMethodV1Beta2",
    jsii_struct_bases=[],
    name_mapping={"type": "type"},
)
class FlowDistinguisherMethodV1Beta2:
    def __init__(self, *, type: builtins.str) -> None:
        '''FlowDistinguisherMethod specifies the method of a flow distinguisher.

        :param type: ``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b960edc54a2806cff5d79c17da55aa232a669ef9bf0ed8217205b8a0c9afb01)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "type": type,
        }

    @builtins.property
    def type(self) -> builtins.str:
        '''``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace".

        Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowDistinguisherMethodV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlowSchemaSpecV1Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "priority_level_configuration": "priorityLevelConfiguration",
        "distinguisher_method": "distinguisherMethod",
        "matching_precedence": "matchingPrecedence",
        "rules": "rules",
    },
)
class FlowSchemaSpecV1Beta1:
    def __init__(
        self,
        *,
        priority_level_configuration: typing.Union["PriorityLevelConfigurationReferenceV1Beta1", typing.Dict[builtins.str, typing.Any]],
        distinguisher_method: typing.Optional[typing.Union[FlowDistinguisherMethodV1Beta1, typing.Dict[builtins.str, typing.Any]]] = None,
        matching_precedence: typing.Optional[jsii.Number] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRulesWithSubjectsV1Beta1", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''FlowSchemaSpec describes how the FlowSchema's specification looks like.

        :param priority_level_configuration: ``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param distinguisher_method: ``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema. ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param matching_precedence: ``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence. Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param rules: ``rules`` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec
        '''
        if isinstance(priority_level_configuration, dict):
            priority_level_configuration = PriorityLevelConfigurationReferenceV1Beta1(**priority_level_configuration)
        if isinstance(distinguisher_method, dict):
            distinguisher_method = FlowDistinguisherMethodV1Beta1(**distinguisher_method)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9358decf2a78376848f00c96d3b31d4693c767880086ae048a1e3e2b113c8d7a)
            check_type(argname="argument priority_level_configuration", value=priority_level_configuration, expected_type=type_hints["priority_level_configuration"])
            check_type(argname="argument distinguisher_method", value=distinguisher_method, expected_type=type_hints["distinguisher_method"])
            check_type(argname="argument matching_precedence", value=matching_precedence, expected_type=type_hints["matching_precedence"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "priority_level_configuration": priority_level_configuration,
        }
        if distinguisher_method is not None:
            self._values["distinguisher_method"] = distinguisher_method
        if matching_precedence is not None:
            self._values["matching_precedence"] = matching_precedence
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def priority_level_configuration(
        self,
    ) -> "PriorityLevelConfigurationReferenceV1Beta1":
        '''``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster.

        If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#priorityLevelConfiguration
        '''
        result = self._values.get("priority_level_configuration")
        assert result is not None, "Required property 'priority_level_configuration' is missing"
        return typing.cast("PriorityLevelConfigurationReferenceV1Beta1", result)

    @builtins.property
    def distinguisher_method(self) -> typing.Optional[FlowDistinguisherMethodV1Beta1]:
        '''``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema.

        ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#distinguisherMethod
        '''
        result = self._values.get("distinguisher_method")
        return typing.cast(typing.Optional[FlowDistinguisherMethodV1Beta1], result)

    @builtins.property
    def matching_precedence(self) -> typing.Optional[jsii.Number]:
        '''``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request.

        The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#matchingPrecedence
        '''
        result = self._values.get("matching_precedence")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta1"]]:
        '''``rules`` describes which requests will match this flow schema.

        This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta1"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowSchemaSpecV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FlowSchemaSpecV1Beta2",
    jsii_struct_bases=[],
    name_mapping={
        "priority_level_configuration": "priorityLevelConfiguration",
        "distinguisher_method": "distinguisherMethod",
        "matching_precedence": "matchingPrecedence",
        "rules": "rules",
    },
)
class FlowSchemaSpecV1Beta2:
    def __init__(
        self,
        *,
        priority_level_configuration: typing.Union["PriorityLevelConfigurationReferenceV1Beta2", typing.Dict[builtins.str, typing.Any]],
        distinguisher_method: typing.Optional[typing.Union[FlowDistinguisherMethodV1Beta2, typing.Dict[builtins.str, typing.Any]]] = None,
        matching_precedence: typing.Optional[jsii.Number] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRulesWithSubjectsV1Beta2", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''FlowSchemaSpec describes how the FlowSchema's specification looks like.

        :param priority_level_configuration: ``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param distinguisher_method: ``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema. ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param matching_precedence: ``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence. Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param rules: ``rules`` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec
        '''
        if isinstance(priority_level_configuration, dict):
            priority_level_configuration = PriorityLevelConfigurationReferenceV1Beta2(**priority_level_configuration)
        if isinstance(distinguisher_method, dict):
            distinguisher_method = FlowDistinguisherMethodV1Beta2(**distinguisher_method)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02c7d4a49b63b981a2ef165a101f4036f6c31604026198ef6e1223a143c06d97)
            check_type(argname="argument priority_level_configuration", value=priority_level_configuration, expected_type=type_hints["priority_level_configuration"])
            check_type(argname="argument distinguisher_method", value=distinguisher_method, expected_type=type_hints["distinguisher_method"])
            check_type(argname="argument matching_precedence", value=matching_precedence, expected_type=type_hints["matching_precedence"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "priority_level_configuration": priority_level_configuration,
        }
        if distinguisher_method is not None:
            self._values["distinguisher_method"] = distinguisher_method
        if matching_precedence is not None:
            self._values["matching_precedence"] = matching_precedence
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def priority_level_configuration(
        self,
    ) -> "PriorityLevelConfigurationReferenceV1Beta2":
        '''``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster.

        If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#priorityLevelConfiguration
        '''
        result = self._values.get("priority_level_configuration")
        assert result is not None, "Required property 'priority_level_configuration' is missing"
        return typing.cast("PriorityLevelConfigurationReferenceV1Beta2", result)

    @builtins.property
    def distinguisher_method(self) -> typing.Optional[FlowDistinguisherMethodV1Beta2]:
        '''``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema.

        ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#distinguisherMethod
        '''
        result = self._values.get("distinguisher_method")
        return typing.cast(typing.Optional[FlowDistinguisherMethodV1Beta2], result)

    @builtins.property
    def matching_precedence(self) -> typing.Optional[jsii.Number]:
        '''``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request.

        The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#matchingPrecedence
        '''
        result = self._values.get("matching_precedence")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta2"]]:
        '''``rules`` describes which requests will match this flow schema.

        This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta2"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowSchemaSpecV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ForZone",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class ForZone:
    def __init__(self, *, name: builtins.str) -> None:
        '''ForZone provides information about which zones should consume this endpoint.

        :param name: name represents the name of the zone.

        :schema: io.k8s.api.discovery.v1.ForZone
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__111312336364698939de9c2ef670a222b3ab268dc5de03c2a432aad4ba21893a)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name represents the name of the zone.

        :schema: io.k8s.api.discovery.v1.ForZone#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ForZone(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.ForZoneV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class ForZoneV1Beta1:
    def __init__(self, *, name: builtins.str) -> None:
        '''ForZone provides information about which zones should consume this endpoint.

        :param name: name represents the name of the zone.

        :schema: io.k8s.api.discovery.v1beta1.ForZone
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ce4e7be03f28796e39aedc36756d9ae787dadeb7372da62a01866461dc7d3ed)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name represents the name of the zone.

        :schema: io.k8s.api.discovery.v1beta1.ForZone#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ForZoneV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.FsGroupStrategyOptionsV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"ranges": "ranges", "rule": "rule"},
)
class FsGroupStrategyOptionsV1Beta1:
    def __init__(
        self,
        *,
        ranges: typing.Optional[typing.Sequence[typing.Union["IdRangeV1Beta1", typing.Dict[builtins.str, typing.Any]]]] = None,
        rule: typing.Optional[builtins.str] = None,
    ) -> None:
        '''FSGroupStrategyOptions defines the strategy type and options used to create the strategy.

        :param ranges: ranges are the allowed ranges of fs groups. If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
        :param rule: rule is the strategy that will dictate what FSGroup is used in the SecurityContext.

        :schema: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__145cd23c724cc30170c028795f92bae43a118c28193790b870493b124d4a769d)
            check_type(argname="argument ranges", value=ranges, expected_type=type_hints["ranges"])
            check_type(argname="argument rule", value=rule, expected_type=type_hints["rule"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ranges is not None:
            self._values["ranges"] = ranges
        if rule is not None:
            self._values["rule"] = rule

    @builtins.property
    def ranges(self) -> typing.Optional[typing.List["IdRangeV1Beta1"]]:
        '''ranges are the allowed ranges of fs groups.

        If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.

        :schema: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions#ranges
        '''
        result = self._values.get("ranges")
        return typing.cast(typing.Optional[typing.List["IdRangeV1Beta1"]], result)

    @builtins.property
    def rule(self) -> typing.Optional[builtins.str]:
        '''rule is the strategy that will dictate what FSGroup is used in the SecurityContext.

        :schema: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions#rule
        '''
        result = self._values.get("rule")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FsGroupStrategyOptionsV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GcePersistentDiskVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "pd_name": "pdName",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GcePersistentDiskVolumeSource:
    def __init__(
        self,
        *,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Persistent Disk resource in Google Compute Engine.

        A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.

        :param pd_name: pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param fs_type: fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk Default: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b9ddf8b1f055b968b05ecf677c5d36524b1c73920702c213c5111247a167ec7)
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "pd_name": pd_name,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def pd_name(self) -> builtins.str:
        '''pdName is unique name of the PD resource in GCE.

        Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#pdName
        '''
        result = self._values.get("pd_name")
        assert result is not None, "Required property 'pd_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''partition is the partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :default: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GcePersistentDiskVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GitRepoVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "repository": "repository",
        "directory": "directory",
        "revision": "revision",
    },
)
class GitRepoVolumeSource:
    def __init__(
        self,
        *,
        repository: builtins.str,
        directory: typing.Optional[builtins.str] = None,
        revision: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a volume that is populated with the contents of a git repository.

        Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

        DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.

        :param repository: repository is the URL.
        :param directory: directory is the target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        :param revision: revision is the commit hash for the specified revision.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44070f89045af1a26cbea1f2920ff4abd84c831f4f4476b34bb863ab562e79d4)
            check_type(argname="argument repository", value=repository, expected_type=type_hints["repository"])
            check_type(argname="argument directory", value=directory, expected_type=type_hints["directory"])
            check_type(argname="argument revision", value=revision, expected_type=type_hints["revision"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "repository": repository,
        }
        if directory is not None:
            self._values["directory"] = directory
        if revision is not None:
            self._values["revision"] = revision

    @builtins.property
    def repository(self) -> builtins.str:
        '''repository is the URL.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#repository
        '''
        result = self._values.get("repository")
        assert result is not None, "Required property 'repository' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def directory(self) -> typing.Optional[builtins.str]:
        '''directory is the target directory name.

        Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#directory
        '''
        result = self._values.get("directory")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def revision(self) -> typing.Optional[builtins.str]:
        '''revision is the commit hash for the specified revision.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#revision
        '''
        result = self._values.get("revision")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GitRepoVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GlusterfsPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "endpoints": "endpoints",
        "path": "path",
        "endpoints_namespace": "endpointsNamespace",
        "read_only": "readOnly",
    },
)
class GlusterfsPersistentVolumeSource:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        endpoints_namespace: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Glusterfs mount that lasts the lifetime of a pod.

        Glusterfs volumes do not support ownership management or SELinux relabeling.

        :param endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param endpoints_namespace: endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod Default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5211ed1f3cf0e2bb13e414af97ab59dc8139695dcb7d28ceea581bdb15daf14)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument endpoints_namespace", value=endpoints_namespace, expected_type=type_hints["endpoints_namespace"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if endpoints_namespace is not None:
            self._values["endpoints_namespace"] = endpoints_namespace
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''endpoints is the endpoint name that details Glusterfs topology.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''path is the Glusterfs volume path.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoints_namespace(self) -> typing.Optional[builtins.str]:
        '''endpointsNamespace is the namespace that contains Glusterfs endpoint.

        If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpointsNamespace
        '''
        result = self._values.get("endpoints_namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the Glusterfs volume to be mounted with read-only permissions.

        Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlusterfsPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GlusterfsVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"endpoints": "endpoints", "path": "path", "read_only": "readOnly"},
)
class GlusterfsVolumeSource:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Glusterfs mount that lasts the lifetime of a pod.

        Glusterfs volumes do not support ownership management or SELinux relabeling.

        :param endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod Default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b1c4b43d1f7c68c992dab6f80789901ce1e821023d5a1aae6908ad5ccbea2d9d)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''endpoints is the endpoint name that details Glusterfs topology.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''path is the Glusterfs volume path.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the Glusterfs volume to be mounted with read-only permissions.

        Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlusterfsVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GroupSubjectV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class GroupSubjectV1Beta1:
    def __init__(self, *, name: builtins.str) -> None:
        '''GroupSubject holds detailed information for group-kind subject.

        :param name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta1.GroupSubject
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da0783dc356c18220bafa1297247f2afcb7429ec540529d24946b87767e7ae67)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the user group that matches, or "*" to match all user groups.

        See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta1.GroupSubject#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GroupSubjectV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GroupSubjectV1Beta2",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class GroupSubjectV1Beta2:
    def __init__(self, *, name: builtins.str) -> None:
        '''GroupSubject holds detailed information for group-kind subject.

        :param name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.GroupSubject
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a052370bf36edb6d9a839fbd1c08df10098640dd0efc2cf1f29feaed62a4ea5)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the user group that matches, or "*" to match all user groups.

        See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.GroupSubject#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GroupSubjectV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.GrpcAction",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "service": "service"},
)
class GrpcAction:
    def __init__(
        self,
        *,
        port: jsii.Number,
        service: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: Port number of the gRPC service. Number must be in the range 1 to 65535.
        :param service: Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.

        :schema: io.k8s.api.core.v1.GRPCAction
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__905b2a32f9e6c4625c1bbdff7c3a4bcfa9e89098ebe53316df60187e58889a93)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if service is not None:
            self._values["service"] = service

    @builtins.property
    def port(self) -> jsii.Number:
        '''Port number of the gRPC service.

        Number must be in the range 1 to 65535.

        :schema: io.k8s.api.core.v1.GRPCAction#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def service(self) -> typing.Optional[builtins.str]:
        '''Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).

        If this is not specified, the default behavior is defined by gRPC.

        :schema: io.k8s.api.core.v1.GRPCAction#service
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GrpcAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HorizontalPodAutoscalerBehaviorV2",
    jsii_struct_bases=[],
    name_mapping={"scale_down": "scaleDown", "scale_up": "scaleUp"},
)
class HorizontalPodAutoscalerBehaviorV2:
    def __init__(
        self,
        *,
        scale_down: typing.Optional[typing.Union["HpaScalingRulesV2", typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union["HpaScalingRulesV2", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).

        :param scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of: - increase no more than 4 pods per 60 seconds - double the number of pods per 60 seconds No stabilization is used.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior
        '''
        if isinstance(scale_down, dict):
            scale_down = HpaScalingRulesV2(**scale_down)
        if isinstance(scale_up, dict):
            scale_up = HpaScalingRulesV2(**scale_up)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45b04162ae2aaba5136df5d1267417730668b2f977e088d3ec86fa880a927490)
            check_type(argname="argument scale_down", value=scale_down, expected_type=type_hints["scale_down"])
            check_type(argname="argument scale_up", value=scale_up, expected_type=type_hints["scale_up"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if scale_down is not None:
            self._values["scale_down"] = scale_down
        if scale_up is not None:
            self._values["scale_up"] = scale_up

    @builtins.property
    def scale_down(self) -> typing.Optional["HpaScalingRulesV2"]:
        '''scaleDown is scaling policy for scaling Down.

        If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior#scaleDown
        '''
        result = self._values.get("scale_down")
        return typing.cast(typing.Optional["HpaScalingRulesV2"], result)

    @builtins.property
    def scale_up(self) -> typing.Optional["HpaScalingRulesV2"]:
        '''scaleUp is scaling policy for scaling Up.

        If not set, the default value is the higher of:

        - increase no more than 4 pods per 60 seconds
        - double the number of pods per 60 seconds
          No stabilization is used.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior#scaleUp
        '''
        result = self._values.get("scale_up")
        return typing.cast(typing.Optional["HpaScalingRulesV2"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerBehaviorV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HorizontalPodAutoscalerBehaviorV2Beta2",
    jsii_struct_bases=[],
    name_mapping={"scale_down": "scaleDown", "scale_up": "scaleUp"},
)
class HorizontalPodAutoscalerBehaviorV2Beta2:
    def __init__(
        self,
        *,
        scale_down: typing.Optional[typing.Union["HpaScalingRulesV2Beta2", typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union["HpaScalingRulesV2Beta2", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).

        :param scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of: - increase no more than 4 pods per 60 seconds - double the number of pods per 60 seconds No stabilization is used.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior
        '''
        if isinstance(scale_down, dict):
            scale_down = HpaScalingRulesV2Beta2(**scale_down)
        if isinstance(scale_up, dict):
            scale_up = HpaScalingRulesV2Beta2(**scale_up)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86c6bcbfc2d812a6bb4ab81057574091a7cd82253009b7f57228f843e5a2d757)
            check_type(argname="argument scale_down", value=scale_down, expected_type=type_hints["scale_down"])
            check_type(argname="argument scale_up", value=scale_up, expected_type=type_hints["scale_up"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if scale_down is not None:
            self._values["scale_down"] = scale_down
        if scale_up is not None:
            self._values["scale_up"] = scale_up

    @builtins.property
    def scale_down(self) -> typing.Optional["HpaScalingRulesV2Beta2"]:
        '''scaleDown is scaling policy for scaling Down.

        If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior#scaleDown
        '''
        result = self._values.get("scale_down")
        return typing.cast(typing.Optional["HpaScalingRulesV2Beta2"], result)

    @builtins.property
    def scale_up(self) -> typing.Optional["HpaScalingRulesV2Beta2"]:
        '''scaleUp is scaling policy for scaling Up.

        If not set, the default value is the higher of:

        - increase no more than 4 pods per 60 seconds
        - double the number of pods per 60 seconds
          No stabilization is used.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior#scaleUp
        '''
        result = self._values.get("scale_up")
        return typing.cast(typing.Optional["HpaScalingRulesV2Beta2"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerBehaviorV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HorizontalPodAutoscalerSpec",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "min_replicas": "minReplicas",
        "target_cpu_utilization_percentage": "targetCpuUtilizationPercentage",
    },
)
class HorizontalPodAutoscalerSpec:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: typing.Union[CrossVersionObjectReference, typing.Dict[builtins.str, typing.Any]],
        min_replicas: typing.Optional[jsii.Number] = None,
        target_cpu_utilization_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''specification of a horizontal pod autoscaler.

        :param max_replicas: upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.
        :param scale_target_ref: reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
        :param min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod. minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured. Scaling is active as long as at least one metric value is available.
        :param target_cpu_utilization_percentage: target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReference(**scale_target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3c8fa1aa6869e980ace191d82756312314cfff6099a077fee71806cd8235e73)
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument scale_target_ref", value=scale_target_ref, expected_type=type_hints["scale_target_ref"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
            check_type(argname="argument target_cpu_utilization_percentage", value=target_cpu_utilization_percentage, expected_type=type_hints["target_cpu_utilization_percentage"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas
        if target_cpu_utilization_percentage is not None:
            self._values["target_cpu_utilization_percentage"] = target_cpu_utilization_percentage

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''upper limit for the number of pods that can be set by the autoscaler;

        cannot be smaller than MinReplicas.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReference:
        '''reference to scaled resource;

        horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReference, result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def target_cpu_utilization_percentage(self) -> typing.Optional[jsii.Number]:
        '''target average CPU utilization (represented as a percentage of requested CPU) over all the pods;

        if not specified the default autoscaling policy will be used.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#targetCPUUtilizationPercentage
        '''
        result = self._values.get("target_cpu_utilization_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HorizontalPodAutoscalerSpecV2",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "behavior": "behavior",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
    },
)
class HorizontalPodAutoscalerSpecV2:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: typing.Union[CrossVersionObjectReferenceV2, typing.Dict[builtins.str, typing.Any]],
        behavior: typing.Optional[typing.Union[HorizontalPodAutoscalerBehaviorV2, typing.Dict[builtins.str, typing.Any]]] = None,
        metrics: typing.Optional[typing.Sequence[typing.Union["MetricSpecV2", typing.Dict[builtins.str, typing.Any]]]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.

        :param max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used). The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods. Ergo, metrics used must decrease as the pod count is increased, and vice-versa. See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod. minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured. Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReferenceV2(**scale_target_ref)
        if isinstance(behavior, dict):
            behavior = HorizontalPodAutoscalerBehaviorV2(**behavior)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02e96a3d6bfd798ea3bd9f46fb50ae770b40715495d7929198602694f15e5ac0)
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument scale_target_ref", value=scale_target_ref, expected_type=type_hints["scale_target_ref"])
            check_type(argname="argument behavior", value=behavior, expected_type=type_hints["behavior"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if behavior is not None:
            self._values["behavior"] = behavior
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.

        It cannot be less that minReplicas.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReferenceV2:
        '''scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReferenceV2, result)

    @builtins.property
    def behavior(self) -> typing.Optional[HorizontalPodAutoscalerBehaviorV2]:
        '''behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).

        If not set, the default HPAScalingRules for scale up and scale down are used.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#behavior
        '''
        result = self._values.get("behavior")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerBehaviorV2], result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List["MetricSpecV2"]]:
        '''metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).

        The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#metrics
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List["MetricSpecV2"]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpecV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HorizontalPodAutoscalerSpecV2Beta1",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
    },
)
class HorizontalPodAutoscalerSpecV2Beta1:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: typing.Union[CrossVersionObjectReferenceV2Beta1, typing.Dict[builtins.str, typing.Any]],
        metrics: typing.Optional[typing.Sequence[typing.Union["MetricSpecV2Beta1", typing.Dict[builtins.str, typing.Any]]]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.

        :param max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used). The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods. Ergo, metrics used must decrease as the pod count is increased, and vice-versa. See the individual metric source types for more information about how each type of metric must respond.
        :param min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod. minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured. Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReferenceV2Beta1(**scale_target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__de63d7f77c5e13ce43ae2167ff95299a4f40c9417d79113e3ae9d9264a383e57)
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument scale_target_ref", value=scale_target_ref, expected_type=type_hints["scale_target_ref"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.

        It cannot be less that minReplicas.

        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReferenceV2Beta1:
        '''scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.

        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReferenceV2Beta1, result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List["MetricSpecV2Beta1"]]:
        '''metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).

        The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.

        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#metrics
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List["MetricSpecV2Beta1"]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpecV2Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HorizontalPodAutoscalerSpecV2Beta2",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "behavior": "behavior",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
    },
)
class HorizontalPodAutoscalerSpecV2Beta2:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: typing.Union[CrossVersionObjectReferenceV2Beta2, typing.Dict[builtins.str, typing.Any]],
        behavior: typing.Optional[typing.Union[HorizontalPodAutoscalerBehaviorV2Beta2, typing.Dict[builtins.str, typing.Any]]] = None,
        metrics: typing.Optional[typing.Sequence[typing.Union["MetricSpecV2Beta2", typing.Dict[builtins.str, typing.Any]]]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.

        :param max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used). The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods. Ergo, metrics used must decrease as the pod count is increased, and vice-versa. See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod. minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured. Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReferenceV2Beta2(**scale_target_ref)
        if isinstance(behavior, dict):
            behavior = HorizontalPodAutoscalerBehaviorV2Beta2(**behavior)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a9462461e9b3511df8285bc939e16d6ac395ea2112b5fefacb468c0efd208eea)
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument scale_target_ref", value=scale_target_ref, expected_type=type_hints["scale_target_ref"])
            check_type(argname="argument behavior", value=behavior, expected_type=type_hints["behavior"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if behavior is not None:
            self._values["behavior"] = behavior
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.

        It cannot be less that minReplicas.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReferenceV2Beta2:
        '''scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReferenceV2Beta2, result)

    @builtins.property
    def behavior(self) -> typing.Optional[HorizontalPodAutoscalerBehaviorV2Beta2]:
        '''behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).

        If not set, the default HPAScalingRules for scale up and scale down are used.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#behavior
        '''
        result = self._values.get("behavior")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerBehaviorV2Beta2], result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List["MetricSpecV2Beta2"]]:
        '''metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).

        The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#metrics
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List["MetricSpecV2Beta2"]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpecV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HostAlias",
    jsii_struct_bases=[],
    name_mapping={"hostnames": "hostnames", "ip": "ip"},
)
class HostAlias:
    def __init__(
        self,
        *,
        hostnames: typing.Optional[typing.Sequence[builtins.str]] = None,
        ip: typing.Optional[builtins.str] = None,
    ) -> None:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :param hostnames: Hostnames for the above IP address.
        :param ip: IP address of the host file entry.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5fabf3c8153a74d2c1ce9bc2526d033e0a3f64c04d6bf436c639398ed488f631)
            check_type(argname="argument hostnames", value=hostnames, expected_type=type_hints["hostnames"])
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hostnames is not None:
            self._values["hostnames"] = hostnames
        if ip is not None:
            self._values["ip"] = ip

    @builtins.property
    def hostnames(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Hostnames for the above IP address.

        :schema: io.k8s.api.core.v1.HostAlias#hostnames
        '''
        result = self._values.get("hostnames")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def ip(self) -> typing.Optional[builtins.str]:
        '''IP address of the host file entry.

        :schema: io.k8s.api.core.v1.HostAlias#ip
        '''
        result = self._values.get("ip")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostAlias(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HostPathVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "type": "type"},
)
class HostPathVolumeSource:
    def __init__(
        self,
        *,
        path: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a host path mapped into a pod.

        Host path volumes do not support ownership management or SELinux relabeling.

        :param path: path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param type: type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath. Default: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :schema: io.k8s.api.core.v1.HostPathVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__558b806639560cf9968bcfccdd367820a6d007c72a9b2ad69bcbd4618d522950)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''path of the directory on the host.

        If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :schema: io.k8s.api.core.v1.HostPathVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath.

        :default: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :schema: io.k8s.api.core.v1.HostPathVolumeSource#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPathVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HostPortRangeV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"max": "max", "min": "min"},
)
class HostPortRangeV1Beta1:
    def __init__(self, *, max: jsii.Number, min: jsii.Number) -> None:
        '''HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.

        It requires both the start and end to be defined.

        :param max: max is the end of the range, inclusive.
        :param min: min is the start of the range, inclusive.

        :schema: io.k8s.api.policy.v1beta1.HostPortRange
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58895a13ec8ec1239ec9128d2064ff4b634ea514e26ec263f38d2228ea681078)
            check_type(argname="argument max", value=max, expected_type=type_hints["max"])
            check_type(argname="argument min", value=min, expected_type=type_hints["min"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max": max,
            "min": min,
        }

    @builtins.property
    def max(self) -> jsii.Number:
        '''max is the end of the range, inclusive.

        :schema: io.k8s.api.policy.v1beta1.HostPortRange#max
        '''
        result = self._values.get("max")
        assert result is not None, "Required property 'max' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def min(self) -> jsii.Number:
        '''min is the start of the range, inclusive.

        :schema: io.k8s.api.policy.v1beta1.HostPortRange#min
        '''
        result = self._values.get("min")
        assert result is not None, "Required property 'min' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPortRangeV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HpaScalingPolicyV2",
    jsii_struct_bases=[],
    name_mapping={"period_seconds": "periodSeconds", "type": "type", "value": "value"},
)
class HpaScalingPolicyV2:
    def __init__(
        self,
        *,
        period_seconds: jsii.Number,
        type: builtins.str,
        value: jsii.Number,
    ) -> None:
        '''HPAScalingPolicy is a single policy which must hold true for a specified past interval.

        :param period_seconds: PeriodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param type: Type is used to specify the scaling policy.
        :param value: Value contains the amount of change which is permitted by the policy. It must be greater than zero

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2c0e5ddb7dc5bbb9e3b275acd842abcfc72356aa5b6b50e5f739d333ad26adc)
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "period_seconds": period_seconds,
            "type": type,
            "value": value,
        }

    @builtins.property
    def period_seconds(self) -> jsii.Number:
        '''PeriodSeconds specifies the window of time for which the policy should hold true.

        PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy#periodSeconds
        '''
        result = self._values.get("period_seconds")
        assert result is not None, "Required property 'period_seconds' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Type is used to specify the scaling policy.

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''Value contains the amount of change which is permitted by the policy.

        It must be greater than zero

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HpaScalingPolicyV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HpaScalingPolicyV2Beta2",
    jsii_struct_bases=[],
    name_mapping={"period_seconds": "periodSeconds", "type": "type", "value": "value"},
)
class HpaScalingPolicyV2Beta2:
    def __init__(
        self,
        *,
        period_seconds: jsii.Number,
        type: builtins.str,
        value: jsii.Number,
    ) -> None:
        '''HPAScalingPolicy is a single policy which must hold true for a specified past interval.

        :param period_seconds: PeriodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param type: Type is used to specify the scaling policy.
        :param value: Value contains the amount of change which is permitted by the policy. It must be greater than zero

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd4bd146d1f894eeac8628111a1992841642e310036277af78efc2c353f8943e)
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "period_seconds": period_seconds,
            "type": type,
            "value": value,
        }

    @builtins.property
    def period_seconds(self) -> jsii.Number:
        '''PeriodSeconds specifies the window of time for which the policy should hold true.

        PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy#periodSeconds
        '''
        result = self._values.get("period_seconds")
        assert result is not None, "Required property 'period_seconds' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Type is used to specify the scaling policy.

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''Value contains the amount of change which is permitted by the policy.

        It must be greater than zero

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HpaScalingPolicyV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HpaScalingRulesV2",
    jsii_struct_bases=[],
    name_mapping={
        "policies": "policies",
        "select_policy": "selectPolicy",
        "stabilization_window_seconds": "stabilizationWindowSeconds",
    },
)
class HpaScalingRulesV2:
    def __init__(
        self,
        *,
        policies: typing.Optional[typing.Sequence[typing.Union[HpaScalingPolicyV2, typing.Dict[builtins.str, typing.Any]]]] = None,
        select_policy: typing.Optional[builtins.str] = None,
        stabilization_window_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HPAScalingRules configures the scaling behavior for one direction.

        These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

        :param policies: policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        :param select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        :param stabilization_window_seconds: StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4a7af615d1470ad42fb715f6e93a047091b31f171e602fab126535f2bf9ce1d)
            check_type(argname="argument policies", value=policies, expected_type=type_hints["policies"])
            check_type(argname="argument select_policy", value=select_policy, expected_type=type_hints["select_policy"])
            check_type(argname="argument stabilization_window_seconds", value=stabilization_window_seconds, expected_type=type_hints["stabilization_window_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if policies is not None:
            self._values["policies"] = policies
        if select_policy is not None:
            self._values["select_policy"] = select_policy
        if stabilization_window_seconds is not None:
            self._values["stabilization_window_seconds"] = stabilization_window_seconds

    @builtins.property
    def policies(self) -> typing.Optional[typing.List[HpaScalingPolicyV2]]:
        '''policies is a list of potential scaling polices which can be used during scaling.

        At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules#policies
        '''
        result = self._values.get("policies")
        return typing.cast(typing.Optional[typing.List[HpaScalingPolicyV2]], result)

    @builtins.property
    def select_policy(self) -> typing.Optional[builtins.str]:
        '''selectPolicy is used to specify which policy should be used.

        If not set, the default value Max is used.

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules#selectPolicy
        '''
        result = self._values.get("select_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def stabilization_window_seconds(self) -> typing.Optional[jsii.Number]:
        '''StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down.

        StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules#stabilizationWindowSeconds
        '''
        result = self._values.get("stabilization_window_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HpaScalingRulesV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HpaScalingRulesV2Beta2",
    jsii_struct_bases=[],
    name_mapping={
        "policies": "policies",
        "select_policy": "selectPolicy",
        "stabilization_window_seconds": "stabilizationWindowSeconds",
    },
)
class HpaScalingRulesV2Beta2:
    def __init__(
        self,
        *,
        policies: typing.Optional[typing.Sequence[typing.Union[HpaScalingPolicyV2Beta2, typing.Dict[builtins.str, typing.Any]]]] = None,
        select_policy: typing.Optional[builtins.str] = None,
        stabilization_window_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HPAScalingRules configures the scaling behavior for one direction.

        These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

        :param policies: policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        :param select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value MaxPolicySelect is used.
        :param stabilization_window_seconds: StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingRules
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bfb6c941bb66c3270adfebde61709bbd06f3f5dc6bb2c032674df79e34bd4304)
            check_type(argname="argument policies", value=policies, expected_type=type_hints["policies"])
            check_type(argname="argument select_policy", value=select_policy, expected_type=type_hints["select_policy"])
            check_type(argname="argument stabilization_window_seconds", value=stabilization_window_seconds, expected_type=type_hints["stabilization_window_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if policies is not None:
            self._values["policies"] = policies
        if select_policy is not None:
            self._values["select_policy"] = select_policy
        if stabilization_window_seconds is not None:
            self._values["stabilization_window_seconds"] = stabilization_window_seconds

    @builtins.property
    def policies(self) -> typing.Optional[typing.List[HpaScalingPolicyV2Beta2]]:
        '''policies is a list of potential scaling polices which can be used during scaling.

        At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingRules#policies
        '''
        result = self._values.get("policies")
        return typing.cast(typing.Optional[typing.List[HpaScalingPolicyV2Beta2]], result)

    @builtins.property
    def select_policy(self) -> typing.Optional[builtins.str]:
        '''selectPolicy is used to specify which policy should be used.

        If not set, the default value MaxPolicySelect is used.

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingRules#selectPolicy
        '''
        result = self._values.get("select_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def stabilization_window_seconds(self) -> typing.Optional[jsii.Number]:
        '''StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down.

        StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).

        :schema: io.k8s.api.autoscaling.v2beta2.HPAScalingRules#stabilizationWindowSeconds
        '''
        result = self._values.get("stabilization_window_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HpaScalingRulesV2Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HttpGetAction",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class HttpGetAction:
    def __init__(
        self,
        *,
        port: "IntOrString",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["HttpHeader", typing.Dict[builtins.str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''HTTPGetAction describes an action based on HTTP Get requests.

        :param port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param path: Path to access on the HTTP server.
        :param scheme: Scheme to use for connecting to the host. Defaults to HTTP. Default: HTTP.

        :schema: io.k8s.api.core.v1.HTTPGetAction
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6454022ec44013ec3d8eb5b7475d65efdb6d341af2a5aadd1b185581780ee5c)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "IntOrString":
        '''Name or number of the port to access on the container.

        Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.

        :schema: io.k8s.api.core.v1.HTTPGetAction#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("IntOrString", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Host name to connect to, defaults to the pod IP.

        You probably want to set "Host" in httpHeaders instead.

        :schema: io.k8s.api.core.v1.HTTPGetAction#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(self) -> typing.Optional[typing.List["HttpHeader"]]:
        '''Custom headers to set in the request.

        HTTP allows repeated headers.

        :schema: io.k8s.api.core.v1.HTTPGetAction#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["HttpHeader"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path to access on the HTTP server.

        :schema: io.k8s.api.core.v1.HTTPGetAction#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''Scheme to use for connecting to the host.

        Defaults to HTTP.

        :default: HTTP.

        :schema: io.k8s.api.core.v1.HTTPGetAction#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpGetAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HttpHeader",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class HttpHeader:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''HTTPHeader describes a custom header to be used in HTTP probes.

        :param name: The header field name.
        :param value: The header field value.

        :schema: io.k8s.api.core.v1.HTTPHeader
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc16a3150b23737ed1329db5566a74b19d8e12720b7e90701f942c4aac8bc1a2)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''The header field name.

        :schema: io.k8s.api.core.v1.HTTPHeader#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''The header field value.

        :schema: io.k8s.api.core.v1.HTTPHeader#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HttpIngressPath",
    jsii_struct_bases=[],
    name_mapping={"backend": "backend", "path_type": "pathType", "path": "path"},
)
class HttpIngressPath:
    def __init__(
        self,
        *,
        backend: typing.Union["IngressBackend", typing.Dict[builtins.str, typing.Any]],
        path_type: builtins.str,
        path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''HTTPIngressPath associates a path with a backend.

        Incoming urls matching the path are forwarded to the backend.

        :param backend: Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param path_type: PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is done on a path element by element basis. A path element refers is the list of labels in the path split by the '/' separator. A request is a match for path p if every p is an element-wise prefix of p of the request path. Note that if the last element of the path is a substring of the last element in request path, it is not a match (e.g. /foo/bar matches /foo/bar/baz, but does not match /foo/barbaz). - ImplementationSpecific: Interpretation of the Path matching is up to the IngressClass. Implementations can treat this as a separate PathType or treat it identically to Prefix or Exact path types. Implementations are required to support all path types.
        :param path: Path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".

        :schema: io.k8s.api.networking.v1.HTTPIngressPath
        '''
        if isinstance(backend, dict):
            backend = IngressBackend(**backend)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__06e7f79ceba1192311f09af0fe2a9f5101877d9b830faa968c4da6259c05910b)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "backend": backend,
            "path_type": path_type,
        }
        if path is not None:
            self._values["path"] = path

    @builtins.property
    def backend(self) -> "IngressBackend":
        '''Backend defines the referenced service endpoint to which the traffic will be forwarded to.

        :schema: io.k8s.api.networking.v1.HTTPIngressPath#backend
        '''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast("IngressBackend", result)

    @builtins.property
    def path_type(self) -> builtins.str:
        '''PathType determines the interpretation of the Path matching.

        PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
        done on a path element by element basis. A path element refers is the
        list of labels in the path split by the '/' separator. A request is a
        match for path p if every p is an element-wise prefix of p of the
        request path. Note that if the last element of the path is a substring
        of the last element in request path, it is not a match (e.g. /foo/bar
        matches /foo/bar/baz, but does not match /foo/barbaz).

        - ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
          Implementations are required to support all path types.

        :schema: io.k8s.api.networking.v1.HTTPIngressPath#pathType
        '''
        result = self._values.get("path_type")
        assert result is not None, "Required property 'path_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path is matched against the path of an incoming request.

        Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".

        :schema: io.k8s.api.networking.v1.HTTPIngressPath#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIngressPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.HttpIngressRuleValue",
    jsii_struct_bases=[],
    name_mapping={"paths": "paths"},
)
class HttpIngressRuleValue:
    def __init__(
        self,
        *,
        paths: typing.Sequence[typing.Union[HttpIngressPath, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''HTTPIngressRuleValue is a list of http selectors pointing to backends.

        In the example: http:///? -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.

        :param paths: A collection of paths that map requests to backends.

        :schema: io.k8s.api.networking.v1.HTTPIngressRuleValue
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79b63d9be4ffe74f4566f39aad4a33cf2a25efbb81ee398da127f97b701b6d71)
            check_type(argname="argument paths", value=paths, expected_type=type_hints["paths"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "paths": paths,
        }

    @builtins.property
    def paths(self) -> typing.List[HttpIngressPath]:
        '''A collection of paths that map requests to backends.

        :schema: io.k8s.api.networking.v1.HTTPIngressRuleValue#paths
        '''
        result = self._values.get("paths")
        assert result is not None, "Required property 'paths' is missing"
        return typing.cast(typing.List[HttpIngressPath], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIngressRuleValue(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IdRangeV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"max": "max", "min": "min"},
)
class IdRangeV1Beta1:
    def __init__(self, *, max: jsii.Number, min: jsii.Number) -> None:
        '''IDRange provides a min/max of an allowed range of IDs.

        :param max: max is the end of the range, inclusive.
        :param min: min is the start of the range, inclusive.

        :schema: io.k8s.api.policy.v1beta1.IDRange
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a8282d2989da82ca2c9fb789059bc93f778d747c23acd281bd54233e3e3f2be)
            check_type(argname="argument max", value=max, expected_type=type_hints["max"])
            check_type(argname="argument min", value=min, expected_type=type_hints["min"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max": max,
            "min": min,
        }

    @builtins.property
    def max(self) -> jsii.Number:
        '''max is the end of the range, inclusive.

        :schema: io.k8s.api.policy.v1beta1.IDRange#max
        '''
        result = self._values.get("max")
        assert result is not None, "Required property 'max' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def min(self) -> jsii.Number:
        '''min is the start of the range, inclusive.

        :schema: io.k8s.api.policy.v1beta1.IDRange#min
        '''
        result = self._values.get("min")
        assert result is not None, "Required property 'min' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IdRangeV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressBackend",
    jsii_struct_bases=[],
    name_mapping={"resource": "resource", "service": "service"},
)
class IngressBackend:
    def __init__(
        self,
        *,
        resource: typing.Optional[typing.Union["TypedLocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        service: typing.Optional[typing.Union["IngressServiceBackend", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressBackend describes all endpoints for a given service and port.

        :param resource: Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        :param service: Service references a Service as a Backend. This is a mutually exclusive setting with "Resource".

        :schema: io.k8s.api.networking.v1.IngressBackend
        '''
        if isinstance(resource, dict):
            resource = TypedLocalObjectReference(**resource)
        if isinstance(service, dict):
            service = IngressServiceBackend(**service)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11b5f314026bb00c2eb10b361d7d2bb6858db7885972790e45a0c95a6eda0823)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if resource is not None:
            self._values["resource"] = resource
        if service is not None:
            self._values["service"] = service

    @builtins.property
    def resource(self) -> typing.Optional["TypedLocalObjectReference"]:
        '''Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object.

        If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".

        :schema: io.k8s.api.networking.v1.IngressBackend#resource
        '''
        result = self._values.get("resource")
        return typing.cast(typing.Optional["TypedLocalObjectReference"], result)

    @builtins.property
    def service(self) -> typing.Optional["IngressServiceBackend"]:
        '''Service references a Service as a Backend.

        This is a mutually exclusive setting with "Resource".

        :schema: io.k8s.api.networking.v1.IngressBackend#service
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional["IngressServiceBackend"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressBackend(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressClassParametersReference",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "name": "name",
        "api_group": "apiGroup",
        "namespace": "namespace",
        "scope": "scope",
    },
)
class IngressClassParametersReference:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        scope: typing.Optional[builtins.str] = None,
    ) -> None:
        '''IngressClassParametersReference identifies an API object.

        This can be used to specify a cluster or namespace-scoped resource.

        :param kind: Kind is the type of resource being referenced.
        :param name: Name is the name of resource being referenced.
        :param api_group: APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        :param namespace: Namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        :param scope: Scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03f2ed9ef6174d545ccbed4f8c98778cf24a8c8ceb98f5bfa2b568fbd0270d42)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group
        if namespace is not None:
            self._values["namespace"] = namespace
        if scope is not None:
            self._values["scope"] = scope

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind is the type of resource being referenced.

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name is the name of resource being referenced.

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''APIGroup is the group for the resource being referenced.

        If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#apiGroup
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''Namespace is the namespace of the resource being referenced.

        This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#namespace
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scope(self) -> typing.Optional[builtins.str]:
        '''Scope represents if this refers to a cluster or namespace scoped resource.

        This may be set to "Cluster" (default) or "Namespace".

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#scope
        '''
        result = self._values.get("scope")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressClassParametersReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressClassSpec",
    jsii_struct_bases=[],
    name_mapping={"controller": "controller", "parameters": "parameters"},
)
class IngressClassSpec:
    def __init__(
        self,
        *,
        controller: typing.Optional[builtins.str] = None,
        parameters: typing.Optional[typing.Union[IngressClassParametersReference, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressClassSpec provides information about the class of an Ingress.

        :param controller: Controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different Parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        :param parameters: Parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.

        :schema: io.k8s.api.networking.v1.IngressClassSpec
        '''
        if isinstance(parameters, dict):
            parameters = IngressClassParametersReference(**parameters)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3434ea4eea0a07c43e89c95ff6bd7b5f06de36c8dc968d8a5d495efa0390ba9)
            check_type(argname="argument controller", value=controller, expected_type=type_hints["controller"])
            check_type(argname="argument parameters", value=parameters, expected_type=type_hints["parameters"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if controller is not None:
            self._values["controller"] = controller
        if parameters is not None:
            self._values["parameters"] = parameters

    @builtins.property
    def controller(self) -> typing.Optional[builtins.str]:
        '''Controller refers to the name of the controller that should handle this class.

        This allows for different "flavors" that are controlled by the same controller. For example, you may have different Parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.

        :schema: io.k8s.api.networking.v1.IngressClassSpec#controller
        '''
        result = self._values.get("controller")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def parameters(self) -> typing.Optional[IngressClassParametersReference]:
        '''Parameters is a link to a custom resource containing additional configuration for the controller.

        This is optional if the controller does not require extra parameters.

        :schema: io.k8s.api.networking.v1.IngressClassSpec#parameters
        '''
        result = self._values.get("parameters")
        return typing.cast(typing.Optional[IngressClassParametersReference], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressClassSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressRule",
    jsii_struct_bases=[],
    name_mapping={"host": "host", "http": "http"},
)
class IngressRule:
    def __init__(
        self,
        *,
        host: typing.Optional[builtins.str] = None,
        http: typing.Optional[typing.Union[HttpIngressRuleValue, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressRule represents the rules mapping the paths under a specified host to the related backend services.

        Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.

        :param host: Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the parent Ingress. 2. The ``:`` delimiter is not respected because ports are not allowed. Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue. Host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        :param http: 

        :schema: io.k8s.api.networking.v1.IngressRule
        '''
        if isinstance(http, dict):
            http = HttpIngressRuleValue(**http)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b9a0b789de072352589aa56a784d1555ec590b61d3d31edbe4e8c0b02fa4eec)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http", value=http, expected_type=type_hints["http"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if host is not None:
            self._values["host"] = host
        if http is not None:
            self._values["http"] = http

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Host is the fully qualified domain name of a network host, as defined by RFC 3986.

        Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
        the IP in the Spec of the parent Ingress.
        2. The ``:`` delimiter is not respected because ports are not allowed.
        Currently the port of an Ingress is implicitly :80 for http and
        :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        Host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.

        :schema: io.k8s.api.networking.v1.IngressRule#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http(self) -> typing.Optional[HttpIngressRuleValue]:
        '''
        :schema: io.k8s.api.networking.v1.IngressRule#http
        '''
        result = self._values.get("http")
        return typing.cast(typing.Optional[HttpIngressRuleValue], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressServiceBackend",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "port": "port"},
)
class IngressServiceBackend:
    def __init__(
        self,
        *,
        name: builtins.str,
        port: typing.Optional[typing.Union["ServiceBackendPort", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressServiceBackend references a Kubernetes Service as a Backend.

        :param name: Name is the referenced service. The service must exist in the same namespace as the Ingress object.
        :param port: Port of the referenced service. A port name or port number is required for a IngressServiceBackend.

        :schema: io.k8s.api.networking.v1.IngressServiceBackend
        '''
        if isinstance(port, dict):
            port = ServiceBackendPort(**port)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46af11c81c3537d73e53839c45f23fc6aae389ba4a38a87a9562bdb74e0c96d4)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def name(self) -> builtins.str:
        '''Name is the referenced service.

        The service must exist in the same namespace as the Ingress object.

        :schema: io.k8s.api.networking.v1.IngressServiceBackend#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def port(self) -> typing.Optional["ServiceBackendPort"]:
        '''Port of the referenced service.

        A port name or port number is required for a IngressServiceBackend.

        :schema: io.k8s.api.networking.v1.IngressServiceBackend#port
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional["ServiceBackendPort"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressServiceBackend(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressSpec",
    jsii_struct_bases=[],
    name_mapping={
        "default_backend": "defaultBackend",
        "ingress_class_name": "ingressClassName",
        "rules": "rules",
        "tls": "tls",
    },
)
class IngressSpec:
    def __init__(
        self,
        *,
        default_backend: typing.Optional[typing.Union[IngressBackend, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress_class_name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union["IngressTls", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''IngressSpec describes the Ingress the user wishes to exist.

        :param default_backend: DefaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        :param ingress_class_name: IngressClassName is the name of the IngressClass cluster resource. The associated IngressClass defines which controller will implement the resource. This replaces the deprecated ``kubernetes.io/ingress.class`` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
        :param rules: A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param tls: TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.

        :schema: io.k8s.api.networking.v1.IngressSpec
        '''
        if isinstance(default_backend, dict):
            default_backend = IngressBackend(**default_backend)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98c9c4e5b13e77049239eb7ca6b4df1989e0a637bccc0af3b5e7af8db68112cd)
            check_type(argname="argument default_backend", value=default_backend, expected_type=type_hints["default_backend"])
            check_type(argname="argument ingress_class_name", value=ingress_class_name, expected_type=type_hints["ingress_class_name"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_backend is not None:
            self._values["default_backend"] = default_backend
        if ingress_class_name is not None:
            self._values["ingress_class_name"] = ingress_class_name
        if rules is not None:
            self._values["rules"] = rules
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def default_backend(self) -> typing.Optional[IngressBackend]:
        '''DefaultBackend is the backend that should handle requests that don't match any rule.

        If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.

        :schema: io.k8s.api.networking.v1.IngressSpec#defaultBackend
        '''
        result = self._values.get("default_backend")
        return typing.cast(typing.Optional[IngressBackend], result)

    @builtins.property
    def ingress_class_name(self) -> typing.Optional[builtins.str]:
        '''IngressClassName is the name of the IngressClass cluster resource.

        The associated IngressClass defines which controller will implement the resource. This replaces the deprecated ``kubernetes.io/ingress.class`` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.

        :schema: io.k8s.api.networking.v1.IngressSpec#ingressClassName
        '''
        result = self._values.get("ingress_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[IngressRule]]:
        '''A list of host rules used to configure the Ingress.

        If unspecified, or no rule matches, all traffic is sent to the default backend.

        :schema: io.k8s.api.networking.v1.IngressSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[IngressRule]], result)

    @builtins.property
    def tls(self) -> typing.Optional[typing.List["IngressTls"]]:
        '''TLS configuration.

        Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.

        :schema: io.k8s.api.networking.v1.IngressSpec#tls
        '''
        result = self._values.get("tls")
        return typing.cast(typing.Optional[typing.List["IngressTls"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IngressTls",
    jsii_struct_bases=[],
    name_mapping={"hosts": "hosts", "secret_name": "secretName"},
)
class IngressTls:
    def __init__(
        self,
        *,
        hosts: typing.Optional[typing.Sequence[builtins.str]] = None,
        secret_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''IngressTLS describes the transport layer security associated with an Ingress.

        :param hosts: Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified. Default: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param secret_name: SecretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.

        :schema: io.k8s.api.networking.v1.IngressTLS
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aac5636f66684bfee1646e2d1d9ca6da08eab297d97cc716d50d748ac2bb941d)
            check_type(argname="argument hosts", value=hosts, expected_type=type_hints["hosts"])
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hosts is not None:
            self._values["hosts"] = hosts
        if secret_name is not None:
            self._values["secret_name"] = secret_name

    @builtins.property
    def hosts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Hosts are a list of hosts included in the TLS certificate.

        The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.

        :default: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.

        :schema: io.k8s.api.networking.v1.IngressTLS#hosts
        '''
        result = self._values.get("hosts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def secret_name(self) -> typing.Optional[builtins.str]:
        '''SecretName is the name of the secret used to terminate TLS traffic on port 443.

        Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.

        :schema: io.k8s.api.networking.v1.IngressTLS#secretName
        '''
        result = self._values.get("secret_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class IntOrString(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.k8s.IntOrString"):
    '''
    :schema: io.k8s.apimachinery.pkg.util.intstr.IntOrString
    '''

    @jsii.member(jsii_name="fromNumber")
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "IntOrString":
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4ce3cff4bd188b1d32e2069af03e3392b0f7b32da522e9ac85e2a787402ac89)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("IntOrString", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString")
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "IntOrString":
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dbf1ee50c52f362679f189706d99fb0a7c37e2052fa5b43d2eacad9fead5a18f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("IntOrString", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.enum(
    jsii_type="cdk8s-plus-24.k8s.IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"
)
class IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind(enum.Enum):
    '''Kind is a string value representing the REST resource this object represents.

    Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

    :schema: IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind
    '''

    DELETE_OPTIONS = "DELETE_OPTIONS"
    '''DeleteOptions.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IpBlock",
    jsii_struct_bases=[],
    name_mapping={"cidr": "cidr", "except_": "except"},
)
class IpBlock:
    def __init__(
        self,
        *,
        cidr: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''IPBlock describes a particular CIDR (Ex.

        "192.168.1.1/24","2001:db9::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.

        :param cidr: CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64".
        :param except_: Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64" Except values will be rejected if they are outside the CIDR range.

        :schema: io.k8s.api.networking.v1.IPBlock
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d9f1a1c68b0771e40b1f1cedba2724280a7e9f49100d5d89f16493ef1cfd833)
            check_type(argname="argument cidr", value=cidr, expected_type=type_hints["cidr"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "cidr": cidr,
        }
        if except_ is not None:
            self._values["except_"] = except_

    @builtins.property
    def cidr(self) -> builtins.str:
        '''CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64".

        :schema: io.k8s.api.networking.v1.IPBlock#cidr
        '''
        result = self._values.get("cidr")
        assert result is not None, "Required property 'cidr' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def except_(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64" Except values will be rejected if they are outside the CIDR range.

        :schema: io.k8s.api.networking.v1.IPBlock#except
        '''
        result = self._values.get("except_")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IpBlock(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IscsiPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "iqn": "iqn",
        "lun": "lun",
        "target_portal": "targetPortal",
        "chap_auth_discovery": "chapAuthDiscovery",
        "chap_auth_session": "chapAuthSession",
        "fs_type": "fsType",
        "initiator_name": "initiatorName",
        "iscsi_interface": "iscsiInterface",
        "portals": "portals",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class IscsiPersistentVolumeSource:
    def __init__(
        self,
        *,
        iqn: builtins.str,
        lun: jsii.Number,
        target_portal: builtins.str,
        chap_auth_discovery: typing.Optional[builtins.bool] = None,
        chap_auth_session: typing.Optional[builtins.bool] = None,
        fs_type: typing.Optional[builtins.str] = None,
        initiator_name: typing.Optional[builtins.str] = None,
        iscsi_interface: typing.Optional[builtins.str] = None,
        portals: typing.Optional[typing.Sequence[builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ISCSIPersistentVolumeSource represents an ISCSI disk.

        ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.

        :param iqn: iqn is Target iSCSI Qualified Name.
        :param lun: lun is iSCSI Target Lun number.
        :param target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.
        :param chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication.
        :param fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.
        :param iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). Default: default' (tcp).
        :param portals: portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. Default: false.
        :param secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33ce576ad8a984caae35a71ba64a8ee41510f3b36df521f41e4e039ce51266c2)
            check_type(argname="argument iqn", value=iqn, expected_type=type_hints["iqn"])
            check_type(argname="argument lun", value=lun, expected_type=type_hints["lun"])
            check_type(argname="argument target_portal", value=target_portal, expected_type=type_hints["target_portal"])
            check_type(argname="argument chap_auth_discovery", value=chap_auth_discovery, expected_type=type_hints["chap_auth_discovery"])
            check_type(argname="argument chap_auth_session", value=chap_auth_session, expected_type=type_hints["chap_auth_session"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument initiator_name", value=initiator_name, expected_type=type_hints["initiator_name"])
            check_type(argname="argument iscsi_interface", value=iscsi_interface, expected_type=type_hints["iscsi_interface"])
            check_type(argname="argument portals", value=portals, expected_type=type_hints["portals"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "iqn": iqn,
            "lun": lun,
            "target_portal": target_portal,
        }
        if chap_auth_discovery is not None:
            self._values["chap_auth_discovery"] = chap_auth_discovery
        if chap_auth_session is not None:
            self._values["chap_auth_session"] = chap_auth_session
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if initiator_name is not None:
            self._values["initiator_name"] = initiator_name
        if iscsi_interface is not None:
            self._values["iscsi_interface"] = iscsi_interface
        if portals is not None:
            self._values["portals"] = portals
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def iqn(self) -> builtins.str:
        '''iqn is Target iSCSI Qualified Name.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iqn
        '''
        result = self._values.get("iqn")
        assert result is not None, "Required property 'iqn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lun(self) -> jsii.Number:
        '''lun is iSCSI Target Lun number.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#lun
        '''
        result = self._values.get("lun")
        assert result is not None, "Required property 'lun' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target_portal(self) -> builtins.str:
        '''targetPortal is iSCSI Target Portal.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#targetPortal
        '''
        result = self._values.get("target_portal")
        assert result is not None, "Required property 'target_portal' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def chap_auth_discovery(self) -> typing.Optional[builtins.bool]:
        '''chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthDiscovery
        '''
        result = self._values.get("chap_auth_discovery")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def chap_auth_session(self) -> typing.Optional[builtins.bool]:
        '''chapAuthSession defines whether support iSCSI Session CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthSession
        '''
        result = self._values.get("chap_auth_session")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initiator_name(self) -> typing.Optional[builtins.str]:
        '''initiatorName is the custom iSCSI Initiator Name.

        If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#initiatorName
        '''
        result = self._values.get("initiator_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def iscsi_interface(self) -> typing.Optional[builtins.str]:
        '''iscsiInterface is the interface Name that uses an iSCSI transport.

        Defaults to 'default' (tcp).

        :default: default' (tcp).

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iscsiInterface
        '''
        result = self._values.get("iscsi_interface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portals(self) -> typing.Optional[typing.List[builtins.str]]:
        '''portals is the iSCSI Target Portal List.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#portals
        '''
        result = self._values.get("portals")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IscsiPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.IscsiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "iqn": "iqn",
        "lun": "lun",
        "target_portal": "targetPortal",
        "chap_auth_discovery": "chapAuthDiscovery",
        "chap_auth_session": "chapAuthSession",
        "fs_type": "fsType",
        "initiator_name": "initiatorName",
        "iscsi_interface": "iscsiInterface",
        "portals": "portals",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class IscsiVolumeSource:
    def __init__(
        self,
        *,
        iqn: builtins.str,
        lun: jsii.Number,
        target_portal: builtins.str,
        chap_auth_discovery: typing.Optional[builtins.bool] = None,
        chap_auth_session: typing.Optional[builtins.bool] = None,
        fs_type: typing.Optional[builtins.str] = None,
        initiator_name: typing.Optional[builtins.str] = None,
        iscsi_interface: typing.Optional[builtins.str] = None,
        portals: typing.Optional[typing.Sequence[builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents an ISCSI disk.

        ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.

        :param iqn: iqn is the target iSCSI Qualified Name.
        :param lun: lun represents iSCSI Target Lun number.
        :param target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.
        :param chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication.
        :param fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.
        :param iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). Default: default' (tcp).
        :param portals: portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. Default: false.
        :param secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__82521fe55a3edc07cba4a5058b13a33644dfc9592106f7de97c583ca97fdea06)
            check_type(argname="argument iqn", value=iqn, expected_type=type_hints["iqn"])
            check_type(argname="argument lun", value=lun, expected_type=type_hints["lun"])
            check_type(argname="argument target_portal", value=target_portal, expected_type=type_hints["target_portal"])
            check_type(argname="argument chap_auth_discovery", value=chap_auth_discovery, expected_type=type_hints["chap_auth_discovery"])
            check_type(argname="argument chap_auth_session", value=chap_auth_session, expected_type=type_hints["chap_auth_session"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument initiator_name", value=initiator_name, expected_type=type_hints["initiator_name"])
            check_type(argname="argument iscsi_interface", value=iscsi_interface, expected_type=type_hints["iscsi_interface"])
            check_type(argname="argument portals", value=portals, expected_type=type_hints["portals"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "iqn": iqn,
            "lun": lun,
            "target_portal": target_portal,
        }
        if chap_auth_discovery is not None:
            self._values["chap_auth_discovery"] = chap_auth_discovery
        if chap_auth_session is not None:
            self._values["chap_auth_session"] = chap_auth_session
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if initiator_name is not None:
            self._values["initiator_name"] = initiator_name
        if iscsi_interface is not None:
            self._values["iscsi_interface"] = iscsi_interface
        if portals is not None:
            self._values["portals"] = portals
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def iqn(self) -> builtins.str:
        '''iqn is the target iSCSI Qualified Name.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#iqn
        '''
        result = self._values.get("iqn")
        assert result is not None, "Required property 'iqn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lun(self) -> jsii.Number:
        '''lun represents iSCSI Target Lun number.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#lun
        '''
        result = self._values.get("lun")
        assert result is not None, "Required property 'lun' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target_portal(self) -> builtins.str:
        '''targetPortal is iSCSI Target Portal.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#targetPortal
        '''
        result = self._values.get("target_portal")
        assert result is not None, "Required property 'target_portal' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def chap_auth_discovery(self) -> typing.Optional[builtins.bool]:
        '''chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#chapAuthDiscovery
        '''
        result = self._values.get("chap_auth_discovery")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def chap_auth_session(self) -> typing.Optional[builtins.bool]:
        '''chapAuthSession defines whether support iSCSI Session CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#chapAuthSession
        '''
        result = self._values.get("chap_auth_session")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initiator_name(self) -> typing.Optional[builtins.str]:
        '''initiatorName is the custom iSCSI Initiator Name.

        If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#initiatorName
        '''
        result = self._values.get("initiator_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def iscsi_interface(self) -> typing.Optional[builtins.str]:
        '''iscsiInterface is the interface Name that uses an iSCSI transport.

        Defaults to 'default' (tcp).

        :default: default' (tcp).

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#iscsiInterface
        '''
        result = self._values.get("iscsi_interface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portals(self) -> typing.Optional[typing.List[builtins.str]]:
        '''portals is the iSCSI Target Portal List.

        The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#portals
        '''
        result = self._values.get("portals")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IscsiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.JobSpec",
    jsii_struct_bases=[],
    name_mapping={
        "template": "template",
        "active_deadline_seconds": "activeDeadlineSeconds",
        "backoff_limit": "backoffLimit",
        "completion_mode": "completionMode",
        "completions": "completions",
        "manual_selector": "manualSelector",
        "parallelism": "parallelism",
        "selector": "selector",
        "suspend": "suspend",
        "ttl_seconds_after_finished": "ttlSecondsAfterFinished",
    },
)
class JobSpec:
    def __init__(
        self,
        *,
        template: typing.Union["PodTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        active_deadline_seconds: typing.Optional[jsii.Number] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        completion_mode: typing.Optional[builtins.str] = None,
        completions: typing.Optional[jsii.Number] = None,
        manual_selector: typing.Optional[builtins.bool] = None,
        parallelism: typing.Optional[jsii.Number] = None,
        selector: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        suspend: typing.Optional[builtins.bool] = None,
        ttl_seconds_after_finished: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''JobSpec describes how the job execution will look like.

        :param template: Describes the pod that will be created when executing a job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param active_deadline_seconds: Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Defaults to 6 Default: 6
        :param completion_mode: CompletionMode specifies how Pod completions are tracked. It can be ``NonIndexed`` (default) or ``Indexed``. ``NonIndexed`` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other. ``Indexed`` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is ``Indexed``, .spec.completions must be specified and ``.spec.parallelism`` must be less than or equal to 10^5. In addition, The Pod name takes the form ``$(job-name)-$(index)-$(random-string)``, the Pod hostname takes the form ``$(job-name)-$(index)``. More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
        :param completions: Specifies the desired number of successfully finished pods the job should be run with. Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value. Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param manual_selector: manualSelector controls generation of pod labels and pod selectors. Leave ``manualSelector`` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template. When true, the user is responsible for picking unique labels and specifying the selector. Failure to pick a unique label may cause this and other jobs to not function correctly. However, You may see ``manualSelector=true`` in jobs that were created with the old ``extensions/v1beta1`` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        :param parallelism: Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param selector: A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param suspend: Suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false. Default: false.
        :param ttl_seconds_after_finished: ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.

        :schema: io.k8s.api.batch.v1.JobSpec
        '''
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae66b610e3484fb09df878458e59c21839229e6c4523640961d6e03b26222fde)
            check_type(argname="argument template", value=template, expected_type=type_hints["template"])
            check_type(argname="argument active_deadline_seconds", value=active_deadline_seconds, expected_type=type_hints["active_deadline_seconds"])
            check_type(argname="argument backoff_limit", value=backoff_limit, expected_type=type_hints["backoff_limit"])
            check_type(argname="argument completion_mode", value=completion_mode, expected_type=type_hints["completion_mode"])
            check_type(argname="argument completions", value=completions, expected_type=type_hints["completions"])
            check_type(argname="argument manual_selector", value=manual_selector, expected_type=type_hints["manual_selector"])
            check_type(argname="argument parallelism", value=parallelism, expected_type=type_hints["parallelism"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument suspend", value=suspend, expected_type=type_hints["suspend"])
            check_type(argname="argument ttl_seconds_after_finished", value=ttl_seconds_after_finished, expected_type=type_hints["ttl_seconds_after_finished"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "template": template,
        }
        if active_deadline_seconds is not None:
            self._values["active_deadline_seconds"] = active_deadline_seconds
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if completion_mode is not None:
            self._values["completion_mode"] = completion_mode
        if completions is not None:
            self._values["completions"] = completions
        if manual_selector is not None:
            self._values["manual_selector"] = manual_selector
        if parallelism is not None:
            self._values["parallelism"] = parallelism
        if selector is not None:
            self._values["selector"] = selector
        if suspend is not None:
            self._values["suspend"] = suspend
        if ttl_seconds_after_finished is not None:
            self._values["ttl_seconds_after_finished"] = ttl_seconds_after_finished

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''Describes the pod that will be created when executing a job.

        More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :schema: io.k8s.api.batch.v1.JobSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def active_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it;

        value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.

        :schema: io.k8s.api.batch.v1.JobSpec#activeDeadlineSeconds
        '''
        result = self._values.get("active_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of retries before marking this job failed.

        Defaults to 6

        :default: 6

        :schema: io.k8s.api.batch.v1.JobSpec#backoffLimit
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def completion_mode(self) -> typing.Optional[builtins.str]:
        '''CompletionMode specifies how Pod completions are tracked. It can be ``NonIndexed`` (default) or ``Indexed``.

        ``NonIndexed`` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.

        ``Indexed`` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is ``Indexed``, .spec.completions must be specified and ``.spec.parallelism`` must be less than or equal to 10^5. In addition, The Pod name takes the form ``$(job-name)-$(index)-$(random-string)``, the Pod hostname takes the form ``$(job-name)-$(index)``.

        More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.

        :schema: io.k8s.api.batch.v1.JobSpec#completionMode
        '''
        result = self._values.get("completion_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def completions(self) -> typing.Optional[jsii.Number]:
        '''Specifies the desired number of successfully finished pods the job should be run with.

        Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :schema: io.k8s.api.batch.v1.JobSpec#completions
        '''
        result = self._values.get("completions")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def manual_selector(self) -> typing.Optional[builtins.bool]:
        '''manualSelector controls generation of pod labels and pod selectors.

        Leave ``manualSelector`` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see ``manualSelector=true`` in jobs that were created with the old ``extensions/v1beta1`` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector

        :schema: io.k8s.api.batch.v1.JobSpec#manualSelector
        '''
        result = self._values.get("manual_selector")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def parallelism(self) -> typing.Optional[jsii.Number]:
        '''Specifies the maximum desired number of pods the job should run at any given time.

        The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :schema: io.k8s.api.batch.v1.JobSpec#parallelism
        '''
        result = self._values.get("parallelism")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def selector(self) -> typing.Optional["LabelSelector"]:
        '''A label query over pods that should match the pod count.

        Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors

        :schema: io.k8s.api.batch.v1.JobSpec#selector
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional["LabelSelector"], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''Suspend specifies whether the Job controller should create Pods or not.

        If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.

        :default: false.

        :schema: io.k8s.api.batch.v1.JobSpec#suspend
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ttl_seconds_after_finished(self) -> typing.Optional[jsii.Number]:
        '''ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.

        :schema: io.k8s.api.batch.v1.JobSpec#ttlSecondsAfterFinished
        '''
        result = self._values.get("ttl_seconds_after_finished")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.JobTemplateSpec",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class JobTemplateSpec:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[JobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''JobTemplateSpec describes the data a Job should have when created from a template.

        :param metadata: Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.JobTemplateSpec
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = JobSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__334a711cc447bffd7487666cefa919e490c03170373b058431da47d10a1f0e5b)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata of the jobs created from this template.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.JobTemplateSpec#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[JobSpec]:
        '''Specification of the desired behavior of the job.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.JobTemplateSpec#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[JobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobTemplateSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.JobTemplateSpecV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class JobTemplateSpecV1Beta1:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[JobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''JobTemplateSpec describes the data a Job should have when created from a template.

        :param metadata: Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1beta1.JobTemplateSpec
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = JobSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6252b2c7412e3965ed6267a27af0451861b1e0bdf0f2d44e240a6ac32f6ca68b)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata of the jobs created from this template.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1beta1.JobTemplateSpec#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[JobSpec]:
        '''Specification of the desired behavior of the job.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1beta1.JobTemplateSpec#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[JobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobTemplateSpecV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.JsonSchemaProps",
    jsii_struct_bases=[],
    name_mapping={
        "additional_items": "additionalItems",
        "additional_properties": "additionalProperties",
        "all_of": "allOf",
        "any_of": "anyOf",
        "default": "default",
        "definitions": "definitions",
        "dependencies": "dependencies",
        "description": "description",
        "enum": "enum",
        "example": "example",
        "exclusive_maximum": "exclusiveMaximum",
        "exclusive_minimum": "exclusiveMinimum",
        "external_docs": "externalDocs",
        "format": "format",
        "id": "id",
        "items": "items",
        "maximum": "maximum",
        "max_items": "maxItems",
        "max_length": "maxLength",
        "max_properties": "maxProperties",
        "minimum": "minimum",
        "min_items": "minItems",
        "min_length": "minLength",
        "min_properties": "minProperties",
        "multiple_of": "multipleOf",
        "not_": "not",
        "nullable": "nullable",
        "one_of": "oneOf",
        "pattern": "pattern",
        "pattern_properties": "patternProperties",
        "properties": "properties",
        "ref": "ref",
        "required": "required",
        "schema": "schema",
        "title": "title",
        "type": "type",
        "unique_items": "uniqueItems",
        "x_kubernetes_embedded_resource": "xKubernetesEmbeddedResource",
        "x_kubernetes_int_or_string": "xKubernetesIntOrString",
        "x_kubernetes_list_map_keys": "xKubernetesListMapKeys",
        "x_kubernetes_list_type": "xKubernetesListType",
        "x_kubernetes_map_type": "xKubernetesMapType",
        "x_kubernetes_preserve_unknown_fields": "xKubernetesPreserveUnknownFields",
        "x_kubernetes_validations": "xKubernetesValidations",
    },
)
class JsonSchemaProps:
    def __init__(
        self,
        *,
        additional_items: typing.Any = None,
        additional_properties: typing.Any = None,
        all_of: typing.Optional[typing.Sequence[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        any_of: typing.Optional[typing.Sequence[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        default: typing.Any = None,
        definitions: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        dependencies: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        description: typing.Optional[builtins.str] = None,
        enum: typing.Optional[typing.Sequence[typing.Any]] = None,
        example: typing.Any = None,
        exclusive_maximum: typing.Optional[builtins.bool] = None,
        exclusive_minimum: typing.Optional[builtins.bool] = None,
        external_docs: typing.Optional[typing.Union[ExternalDocumentation, typing.Dict[builtins.str, typing.Any]]] = None,
        format: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        items: typing.Any = None,
        maximum: typing.Optional[jsii.Number] = None,
        max_items: typing.Optional[jsii.Number] = None,
        max_length: typing.Optional[jsii.Number] = None,
        max_properties: typing.Optional[jsii.Number] = None,
        minimum: typing.Optional[jsii.Number] = None,
        min_items: typing.Optional[jsii.Number] = None,
        min_length: typing.Optional[jsii.Number] = None,
        min_properties: typing.Optional[jsii.Number] = None,
        multiple_of: typing.Optional[jsii.Number] = None,
        not_: typing.Optional[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]] = None,
        nullable: typing.Optional[builtins.bool] = None,
        one_of: typing.Optional[typing.Sequence[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        pattern: typing.Optional[builtins.str] = None,
        pattern_properties: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        properties: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        ref: typing.Optional[builtins.str] = None,
        required: typing.Optional[typing.Sequence[builtins.str]] = None,
        schema: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        unique_items: typing.Optional[builtins.bool] = None,
        x_kubernetes_embedded_resource: typing.Optional[builtins.bool] = None,
        x_kubernetes_int_or_string: typing.Optional[builtins.bool] = None,
        x_kubernetes_list_map_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
        x_kubernetes_list_type: typing.Optional[builtins.str] = None,
        x_kubernetes_map_type: typing.Optional[builtins.str] = None,
        x_kubernetes_preserve_unknown_fields: typing.Optional[builtins.bool] = None,
        x_kubernetes_validations: typing.Optional[typing.Sequence[typing.Union["ValidationRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).

        :param additional_items: 
        :param additional_properties: 
        :param all_of: 
        :param any_of: 
        :param default: default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        :param definitions: 
        :param dependencies: 
        :param description: 
        :param enum: 
        :param example: 
        :param exclusive_maximum: 
        :param exclusive_minimum: 
        :param external_docs: 
        :param format: format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:. - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        :param id: 
        :param items: 
        :param maximum: 
        :param max_items: 
        :param max_length: 
        :param max_properties: 
        :param minimum: 
        :param min_items: 
        :param min_length: 
        :param min_properties: 
        :param multiple_of: 
        :param not_: 
        :param nullable: 
        :param one_of: 
        :param pattern: 
        :param pattern_properties: 
        :param properties: 
        :param ref: 
        :param required: 
        :param schema: 
        :param title: 
        :param type: 
        :param unique_items: 
        :param x_kubernetes_embedded_resource: x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        :param x_kubernetes_int_or_string: x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns: 1. anyOf: - type: integer - type: string 2. allOf: - anyOf: - type: integer - type: string - ... zero or more
        :param x_kubernetes_list_map_keys: x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type ``map`` by specifying the keys used as the index of the map. This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported). The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
        :param x_kubernetes_list_type: x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values: 1. ``atomic``: the list is treated as a single entity, like a scalar. Atomic lists will be entirely replaced when updated. This extension may be used on any type of list (struct, scalar, ...). 2. ``set``: Sets are lists that must not have multiple items with the same value. Each value must be a scalar, an object with x-kubernetes-map-type ``atomic`` or an array with x-kubernetes-list-type ``atomic``. 3. ``map``: These lists are like maps in that their elements have a non-index key used to identify them. Order is preserved upon merge. The map tag must only be used on a list with elements of type object. Defaults to atomic for arrays. Default: atomic for arrays.
        :param x_kubernetes_map_type: x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values: 1. ``granular``: These maps are actual maps (key-value pairs) and each fields are independent from each other (they can each be manipulated by separate actors). This is the default behaviour for all maps. 2. ``atomic``: the list is treated as a single entity, like a scalar. Atomic maps will be entirely replaced when updated.
        :param x_kubernetes_preserve_unknown_fields: x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        :param x_kubernetes_validations: x-kubernetes-validations describes a list of validation rules written in the CEL expression language. This field is an alpha-level. Using this field requires the feature gate ``CustomResourceValidationExpressions`` to be enabled.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps
        '''
        if isinstance(external_docs, dict):
            external_docs = ExternalDocumentation(**external_docs)
        if isinstance(not_, dict):
            not_ = JsonSchemaProps(**not_)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__789de039f59d0fc64595e92657c955e5bf3e579068888375673b1f51cee224c8)
            check_type(argname="argument additional_items", value=additional_items, expected_type=type_hints["additional_items"])
            check_type(argname="argument additional_properties", value=additional_properties, expected_type=type_hints["additional_properties"])
            check_type(argname="argument all_of", value=all_of, expected_type=type_hints["all_of"])
            check_type(argname="argument any_of", value=any_of, expected_type=type_hints["any_of"])
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument definitions", value=definitions, expected_type=type_hints["definitions"])
            check_type(argname="argument dependencies", value=dependencies, expected_type=type_hints["dependencies"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument enum", value=enum, expected_type=type_hints["enum"])
            check_type(argname="argument example", value=example, expected_type=type_hints["example"])
            check_type(argname="argument exclusive_maximum", value=exclusive_maximum, expected_type=type_hints["exclusive_maximum"])
            check_type(argname="argument exclusive_minimum", value=exclusive_minimum, expected_type=type_hints["exclusive_minimum"])
            check_type(argname="argument external_docs", value=external_docs, expected_type=type_hints["external_docs"])
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument maximum", value=maximum, expected_type=type_hints["maximum"])
            check_type(argname="argument max_items", value=max_items, expected_type=type_hints["max_items"])
            check_type(argname="argument max_length", value=max_length, expected_type=type_hints["max_length"])
            check_type(argname="argument max_properties", value=max_properties, expected_type=type_hints["max_properties"])
            check_type(argname="argument minimum", value=minimum, expected_type=type_hints["minimum"])
            check_type(argname="argument min_items", value=min_items, expected_type=type_hints["min_items"])
            check_type(argname="argument min_length", value=min_length, expected_type=type_hints["min_length"])
            check_type(argname="argument min_properties", value=min_properties, expected_type=type_hints["min_properties"])
            check_type(argname="argument multiple_of", value=multiple_of, expected_type=type_hints["multiple_of"])
            check_type(argname="argument not_", value=not_, expected_type=type_hints["not_"])
            check_type(argname="argument nullable", value=nullable, expected_type=type_hints["nullable"])
            check_type(argname="argument one_of", value=one_of, expected_type=type_hints["one_of"])
            check_type(argname="argument pattern", value=pattern, expected_type=type_hints["pattern"])
            check_type(argname="argument pattern_properties", value=pattern_properties, expected_type=type_hints["pattern_properties"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
            check_type(argname="argument ref", value=ref, expected_type=type_hints["ref"])
            check_type(argname="argument required", value=required, expected_type=type_hints["required"])
            check_type(argname="argument schema", value=schema, expected_type=type_hints["schema"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument unique_items", value=unique_items, expected_type=type_hints["unique_items"])
            check_type(argname="argument x_kubernetes_embedded_resource", value=x_kubernetes_embedded_resource, expected_type=type_hints["x_kubernetes_embedded_resource"])
            check_type(argname="argument x_kubernetes_int_or_string", value=x_kubernetes_int_or_string, expected_type=type_hints["x_kubernetes_int_or_string"])
            check_type(argname="argument x_kubernetes_list_map_keys", value=x_kubernetes_list_map_keys, expected_type=type_hints["x_kubernetes_list_map_keys"])
            check_type(argname="argument x_kubernetes_list_type", value=x_kubernetes_list_type, expected_type=type_hints["x_kubernetes_list_type"])
            check_type(argname="argument x_kubernetes_map_type", value=x_kubernetes_map_type, expected_type=type_hints["x_kubernetes_map_type"])
            check_type(argname="argument x_kubernetes_preserve_unknown_fields", value=x_kubernetes_preserve_unknown_fields, expected_type=type_hints["x_kubernetes_preserve_unknown_fields"])
            check_type(argname="argument x_kubernetes_validations", value=x_kubernetes_validations, expected_type=type_hints["x_kubernetes_validations"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if additional_items is not None:
            self._values["additional_items"] = additional_items
        if additional_properties is not None:
            self._values["additional_properties"] = additional_properties
        if all_of is not None:
            self._values["all_of"] = all_of
        if any_of is not None:
            self._values["any_of"] = any_of
        if default is not None:
            self._values["default"] = default
        if definitions is not None:
            self._values["definitions"] = definitions
        if dependencies is not None:
            self._values["dependencies"] = dependencies
        if description is not None:
            self._values["description"] = description
        if enum is not None:
            self._values["enum"] = enum
        if example is not None:
            self._values["example"] = example
        if exclusive_maximum is not None:
            self._values["exclusive_maximum"] = exclusive_maximum
        if exclusive_minimum is not None:
            self._values["exclusive_minimum"] = exclusive_minimum
        if external_docs is not None:
            self._values["external_docs"] = external_docs
        if format is not None:
            self._values["format"] = format
        if id is not None:
            self._values["id"] = id
        if items is not None:
            self._values["items"] = items
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_items is not None:
            self._values["max_items"] = max_items
        if max_length is not None:
            self._values["max_length"] = max_length
        if max_properties is not None:
            self._values["max_properties"] = max_properties
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_items is not None:
            self._values["min_items"] = min_items
        if min_length is not None:
            self._values["min_length"] = min_length
        if min_properties is not None:
            self._values["min_properties"] = min_properties
        if multiple_of is not None:
            self._values["multiple_of"] = multiple_of
        if not_ is not None:
            self._values["not_"] = not_
        if nullable is not None:
            self._values["nullable"] = nullable
        if one_of is not None:
            self._values["one_of"] = one_of
        if pattern is not None:
            self._values["pattern"] = pattern
        if pattern_properties is not None:
            self._values["pattern_properties"] = pattern_properties
        if properties is not None:
            self._values["properties"] = properties
        if ref is not None:
            self._values["ref"] = ref
        if required is not None:
            self._values["required"] = required
        if schema is not None:
            self._values["schema"] = schema
        if title is not None:
            self._values["title"] = title
        if type is not None:
            self._values["type"] = type
        if unique_items is not None:
            self._values["unique_items"] = unique_items
        if x_kubernetes_embedded_resource is not None:
            self._values["x_kubernetes_embedded_resource"] = x_kubernetes_embedded_resource
        if x_kubernetes_int_or_string is not None:
            self._values["x_kubernetes_int_or_string"] = x_kubernetes_int_or_string
        if x_kubernetes_list_map_keys is not None:
            self._values["x_kubernetes_list_map_keys"] = x_kubernetes_list_map_keys
        if x_kubernetes_list_type is not None:
            self._values["x_kubernetes_list_type"] = x_kubernetes_list_type
        if x_kubernetes_map_type is not None:
            self._values["x_kubernetes_map_type"] = x_kubernetes_map_type
        if x_kubernetes_preserve_unknown_fields is not None:
            self._values["x_kubernetes_preserve_unknown_fields"] = x_kubernetes_preserve_unknown_fields
        if x_kubernetes_validations is not None:
            self._values["x_kubernetes_validations"] = x_kubernetes_validations

    @builtins.property
    def additional_items(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#additionalItems
        '''
        result = self._values.get("additional_items")
        return typing.cast(typing.Any, result)

    @builtins.property
    def additional_properties(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#additionalProperties
        '''
        result = self._values.get("additional_properties")
        return typing.cast(typing.Any, result)

    @builtins.property
    def all_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#allOf
        '''
        result = self._values.get("all_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def any_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#anyOf
        '''
        result = self._values.get("any_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def default(self) -> typing.Any:
        '''default is a default value for undefined object fields.

        Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#default
        '''
        result = self._values.get("default")
        return typing.cast(typing.Any, result)

    @builtins.property
    def definitions(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#definitions
        '''
        result = self._values.get("definitions")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def dependencies(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#dependencies
        '''
        result = self._values.get("dependencies")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enum(self) -> typing.Optional[typing.List[typing.Any]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#enum
        '''
        result = self._values.get("enum")
        return typing.cast(typing.Optional[typing.List[typing.Any]], result)

    @builtins.property
    def example(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#example
        '''
        result = self._values.get("example")
        return typing.cast(typing.Any, result)

    @builtins.property
    def exclusive_maximum(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#exclusiveMaximum
        '''
        result = self._values.get("exclusive_maximum")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def exclusive_minimum(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#exclusiveMinimum
        '''
        result = self._values.get("exclusive_minimum")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def external_docs(self) -> typing.Optional[ExternalDocumentation]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#externalDocs
        '''
        result = self._values.get("external_docs")
        return typing.cast(typing.Optional[ExternalDocumentation], result)

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        '''format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:.

        - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#format
        '''
        result = self._values.get("format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#id
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def items(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Any, result)

    @builtins.property
    def maximum(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maximum
        '''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_items(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maxItems
        '''
        result = self._values.get("max_items")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_length(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maxLength
        '''
        result = self._values.get("max_length")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_properties(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maxProperties
        '''
        result = self._values.get("max_properties")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def minimum(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minimum
        '''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_items(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minItems
        '''
        result = self._values.get("min_items")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_length(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minLength
        '''
        result = self._values.get("min_length")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_properties(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minProperties
        '''
        result = self._values.get("min_properties")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def multiple_of(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#multipleOf
        '''
        result = self._values.get("multiple_of")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def not_(self) -> typing.Optional["JsonSchemaProps"]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#not
        '''
        result = self._values.get("not_")
        return typing.cast(typing.Optional["JsonSchemaProps"], result)

    @builtins.property
    def nullable(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#nullable
        '''
        result = self._values.get("nullable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def one_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#oneOf
        '''
        result = self._values.get("one_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def pattern(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#pattern
        '''
        result = self._values.get("pattern")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pattern_properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#patternProperties
        '''
        result = self._values.get("pattern_properties")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#properties
        '''
        result = self._values.get("properties")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def ref(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#$ref
        '''
        result = self._values.get("ref")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def required(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#required
        '''
        result = self._values.get("required")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def schema(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#$schema
        '''
        result = self._values.get("schema")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#title
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unique_items(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#uniqueItems
        '''
        result = self._values.get("unique_items")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_embedded_resource(self) -> typing.Optional[builtins.bool]:
        '''x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-embedded-resource
        '''
        result = self._values.get("x_kubernetes_embedded_resource")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_int_or_string(self) -> typing.Optional[builtins.bool]:
        '''x-kubernetes-int-or-string specifies that this value is either an integer or a string.

        If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

        1. anyOf:

        - type: integer
        - type: string

        1. allOf:

        - anyOf:
        - type: integer
        - type: string
        - ... zero or more

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-int-or-string
        '''
        result = self._values.get("x_kubernetes_int_or_string")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_list_map_keys(self) -> typing.Optional[typing.List[builtins.str]]:
        '''x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type ``map`` by specifying the keys used as the index of the map.

        This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).

        The properties specified must either be required or have a default value, to ensure those properties are present for all list items.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-list-map-keys
        '''
        result = self._values.get("x_kubernetes_list_map_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def x_kubernetes_list_type(self) -> typing.Optional[builtins.str]:
        '''x-kubernetes-list-type annotates an array to further describe its topology.

        This extension must only be used on lists and may have 3 possible values:

        1. ``atomic``: the list is treated as a single entity, like a scalar.
           Atomic lists will be entirely replaced when updated. This extension
           may be used on any type of list (struct, scalar, ...).
        2. ``set``:
           Sets are lists that must not have multiple items with the same value. Each
           value must be a scalar, an object with x-kubernetes-map-type ``atomic`` or an
           array with x-kubernetes-list-type ``atomic``.
        3. ``map``:
           These lists are like maps in that their elements have a non-index key
           used to identify them. Order is preserved upon merge. The map tag
           must only be used on a list with elements of type object.
           Defaults to atomic for arrays.

        :default: atomic for arrays.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-list-type
        '''
        result = self._values.get("x_kubernetes_list_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def x_kubernetes_map_type(self) -> typing.Optional[builtins.str]:
        '''x-kubernetes-map-type annotates an object to further describe its topology.

        This extension must only be used when type is object and may have 2 possible values:

        1. ``granular``:
           These maps are actual maps (key-value pairs) and each fields are independent
           from each other (they can each be manipulated by separate actors). This is
           the default behaviour for all maps.
        2. ``atomic``: the list is treated as a single entity, like a scalar.
           Atomic maps will be entirely replaced when updated.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-map-type
        '''
        result = self._values.get("x_kubernetes_map_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def x_kubernetes_preserve_unknown_fields(self) -> typing.Optional[builtins.bool]:
        '''x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema.

        This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-preserve-unknown-fields
        '''
        result = self._values.get("x_kubernetes_preserve_unknown_fields")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_validations(
        self,
    ) -> typing.Optional[typing.List["ValidationRule"]]:
        '''x-kubernetes-validations describes a list of validation rules written in the CEL expression language.

        This field is an alpha-level. Using this field requires the feature gate ``CustomResourceValidationExpressions`` to be enabled.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-validations
        '''
        result = self._values.get("x_kubernetes_validations")
        return typing.cast(typing.Optional[typing.List["ValidationRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JsonSchemaProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KeyToPath",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "path": "path", "mode": "mode"},
)
class KeyToPath:
    def __init__(
        self,
        *,
        key: builtins.str,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Maps a string key to a path within a volume.

        :param key: key is the key to project.
        :param path: path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param mode: mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.KeyToPath
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57966b77700bb7e1b40ef03e898cfc805e42eff56a5bf3181f40f082f98a47ff)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def key(self) -> builtins.str:
        '''key is the key to project.

        :schema: io.k8s.api.core.v1.KeyToPath#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''path is the relative path of the file to map the key to.

        May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.

        :schema: io.k8s.api.core.v1.KeyToPath#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''mode is Optional: mode bits used to set permissions on this file.

        Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.KeyToPath#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KeyToPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeApiService(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeApiService",
):
    '''APIService represents a server for a particular GroupVersion.

    Name must be "version.group".

    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ApiServiceSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Spec contains information for locating and communicating with a server.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bdc78d511529208275c9f0264aa48d4760d832ce786fc50fe570a83d106f85ad)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeApiServiceProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ApiServiceSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Spec contains information for locating and communicating with a server.
        '''
        props = KubeApiServiceProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeApiServiceList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeApiServiceList",
):
    '''APIServiceList is a list of APIService objects.

    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeApiServiceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of APIService.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f25dad0b70174920491dfd3cca33213208f516846decd0d448e8b625f8c1bcf1)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeApiServiceListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeApiServiceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of APIService.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeApiServiceListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeApiServiceListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeApiServiceListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeApiServiceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''APIServiceList is a list of APIService objects.

        :param items: Items is the list of APIService.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f59fc04af34040b72c47a85a5e67972d0b3bb7de170162a5f214e8f7f3bce0f)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeApiServiceProps"]:
        '''Items is the list of APIService.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeApiServiceProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeApiServiceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeApiServiceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ApiServiceSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''APIService represents a server for a particular GroupVersion.

        Name must be "version.group".

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Spec contains information for locating and communicating with a server.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = ApiServiceSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a18b8336b6c0feab3788c9d38d7b742b9de136ae05324f07bcfa87353fc46331)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[ApiServiceSpec]:
        '''Spec contains information for locating and communicating with a server.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[ApiServiceSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeBinding(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeBinding",
):
    '''Binding ties one object to another;

    for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

    :schema: io.k8s.api.core.v1.Binding
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        target: typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.Binding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param target: The target object that you want to bind to the standard object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a2541842864d44f2b4a1d8e26ca49987df1fc1458ec16354635c8cab0ce4805)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeBindingProps(target=target, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        target: typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param target: The target object that you want to bind to the standard object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeBindingProps(target=target, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeBindingProps",
    jsii_struct_bases=[],
    name_mapping={"target": "target", "metadata": "metadata"},
)
class KubeBindingProps:
    def __init__(
        self,
        *,
        target: typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Binding ties one object to another;

        for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

        :param target: The target object that you want to bind to the standard object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.Binding
        '''
        if isinstance(target, dict):
            target = ObjectReference(**target)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4487b6170ac41dee06403e8a693c41272d489c827a4ed4bf37243ab0d4566072)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "target": target,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def target(self) -> "ObjectReference":
        '''The target object that you want to bind to the standard object.

        :schema: io.k8s.api.core.v1.Binding#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("ObjectReference", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.Binding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCertificateSigningRequest(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCertificateSigningRequest",
):
    '''CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

    Kubelets use this API to obtain:

    1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
    2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

    This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.

    :schema: io.k8s.api.certificates.v1.CertificateSigningRequest
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CertificateSigningRequestSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.certificates.v1.CertificateSigningRequest" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
        :param metadata: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70bbc5806185f03a32524175c6f1dfb6e77b54f827c805c629767d16048c6a14)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCertificateSigningRequestProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CertificateSigningRequestSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequest".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
        :param metadata: 
        '''
        props = KubeCertificateSigningRequestProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequest".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCertificateSigningRequestList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCertificateSigningRequestList",
):
    '''CertificateSigningRequestList is a collection of CertificateSigningRequest objects.

    :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCertificateSigningRequestProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.certificates.v1.CertificateSigningRequestList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is a collection of CertificateSigningRequest objects.
        :param metadata: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__984afbed55c18c62d3777c1fd3c3a7907dd8c625323646eda2925f4fdd78a228)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCertificateSigningRequestListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCertificateSigningRequestProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequestList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is a collection of CertificateSigningRequest objects.
        :param metadata: 
        '''
        props = KubeCertificateSigningRequestListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequestList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCertificateSigningRequestListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCertificateSigningRequestListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCertificateSigningRequestProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CertificateSigningRequestList is a collection of CertificateSigningRequest objects.

        :param items: items is a collection of CertificateSigningRequest objects.
        :param metadata: 

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c90df09a2e5d7ef5fe05719daf2d7b4f76db9e8b16ba5d867834b01a4a9539f)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCertificateSigningRequestProps"]:
        '''items is a collection of CertificateSigningRequest objects.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCertificateSigningRequestProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCertificateSigningRequestListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCertificateSigningRequestProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCertificateSigningRequestProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CertificateSigningRequestSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

        Kubelets use this API to obtain:

        1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
        2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

        This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.

        :param spec: spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
        :param metadata: 

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequest
        '''
        if isinstance(spec, dict):
            spec = CertificateSigningRequestSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7224712ca73bf177fb040702682139bba5aa05d192eb1e6ff2ceb0439a56f036)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CertificateSigningRequestSpec:
        '''spec contains the certificate request, and is immutable after creation.

        Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequest#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CertificateSigningRequestSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :schema: io.k8s.api.certificates.v1.CertificateSigningRequest#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCertificateSigningRequestProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRole(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRole",
):
    '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

    :schema: io.k8s.api.rbac.v1.ClusterRole
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        aggregation_rule: typing.Optional[typing.Union[AggregationRule, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRole" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param aggregation_rule: AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: Standard object's metadata.
        :param rules: Rules holds all the PolicyRules for this ClusterRole.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b7d515a9747c72da48953fcc29873957b864dbb2d6bfc769e0804467cd924be)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleProps(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        aggregation_rule: typing.Optional[typing.Union[AggregationRule, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param aggregation_rule: AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: Standard object's metadata.
        :param rules: Rules holds all the PolicyRules for this ClusterRole.
        '''
        props = KubeClusterRoleProps(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeClusterRoleBinding(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleBinding",
):
    '''ClusterRoleBinding references a ClusterRole, but not contain it.

    It can reference a ClusterRole in the global namespace, and adds who information via Subject.

    :schema: io.k8s.api.rbac.v1.ClusterRoleBinding
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role_ref: typing.Union["RoleRef", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subjects: typing.Optional[typing.Sequence[typing.Union["Subject", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRoleBinding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param role_ref: RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: Standard object's metadata.
        :param subjects: Subjects holds references to the objects the role applies to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__75c7b39b5fcfe44af6fc65741db6e012d8e1bb501990e9c111c81cfbfd5b8547)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleBindingProps(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        role_ref: typing.Union["RoleRef", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subjects: typing.Optional[typing.Sequence[typing.Union["Subject", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param role_ref: RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: Standard object's metadata.
        :param subjects: Subjects holds references to the objects the role applies to.
        '''
        props = KubeClusterRoleBindingProps(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeClusterRoleBindingList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleBindingList",
):
    '''ClusterRoleBindingList is a collection of ClusterRoleBindings.

    :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleBindingProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRoleBindingList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is a list of ClusterRoleBindings.
        :param metadata: Standard object's metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85f2ae6bb4a244597f77f789020d033b315faad9dd84e3347649e0b3ef8d5c1e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleBindingListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleBindingProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is a list of ClusterRoleBindings.
        :param metadata: Standard object's metadata.
        '''
        props = KubeClusterRoleBindingListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleBindingListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleBindingListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleBindingProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterRoleBindingList is a collection of ClusterRoleBindings.

        :param items: Items is a list of ClusterRoleBindings.
        :param metadata: Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9fe8c3ddd7a402baa1f983685d911a1347769438318321eaac16e62d61c020bc)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleBindingProps"]:
        '''Items is a list of ClusterRoleBindings.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleBindingProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleBindingProps",
    jsii_struct_bases=[],
    name_mapping={
        "role_ref": "roleRef",
        "metadata": "metadata",
        "subjects": "subjects",
    },
)
class KubeClusterRoleBindingProps:
    def __init__(
        self,
        *,
        role_ref: typing.Union["RoleRef", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subjects: typing.Optional[typing.Sequence[typing.Union["Subject", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''ClusterRoleBinding references a ClusterRole, but not contain it.

        It can reference a ClusterRole in the global namespace, and adds who information via Subject.

        :param role_ref: RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: Standard object's metadata.
        :param subjects: Subjects holds references to the objects the role applies to.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding
        '''
        if isinstance(role_ref, dict):
            role_ref = RoleRef(**role_ref)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0250eccb1ac0ec393ec35160c114741978b4c14d50ddf3f16e8f78aaf13fc1bb)
            check_type(argname="argument role_ref", value=role_ref, expected_type=type_hints["role_ref"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument subjects", value=subjects, expected_type=type_hints["subjects"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role_ref": role_ref,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if subjects is not None:
            self._values["subjects"] = subjects

    @builtins.property
    def role_ref(self) -> "RoleRef":
        '''RoleRef can only reference a ClusterRole in the global namespace.

        If the RoleRef cannot be resolved, the Authorizer must return an error.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#roleRef
        '''
        result = self._values.get("role_ref")
        assert result is not None, "Required property 'role_ref' is missing"
        return typing.cast("RoleRef", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subjects(self) -> typing.Optional[typing.List["Subject"]]:
        '''Subjects holds references to the objects the role applies to.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#subjects
        '''
        result = self._values.get("subjects")
        return typing.cast(typing.Optional[typing.List["Subject"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleList",
):
    '''ClusterRoleList is a collection of ClusterRoles.

    :schema: io.k8s.api.rbac.v1.ClusterRoleList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRoleList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is a list of ClusterRoles.
        :param metadata: Standard object's metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29ae5c67b0a4122bbbb3e5bdbe39fb1e1821e2cb839cd331cf6aea49fc27ef62)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is a list of ClusterRoles.
        :param metadata: Standard object's metadata.
        '''
        props = KubeClusterRoleListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterRoleList is a collection of ClusterRoles.

        :param items: Items is a list of ClusterRoles.
        :param metadata: Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d0ecfce79c9a050c0cfac98cf4c9bcf6166bae2704e168c9405abeaad168d0f)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleProps"]:
        '''Items is a list of ClusterRoles.

        :schema: io.k8s.api.rbac.v1.ClusterRoleList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeClusterRoleProps",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation_rule": "aggregationRule",
        "metadata": "metadata",
        "rules": "rules",
    },
)
class KubeClusterRoleProps:
    def __init__(
        self,
        *,
        aggregation_rule: typing.Optional[typing.Union[AggregationRule, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

        :param aggregation_rule: AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: Standard object's metadata.
        :param rules: Rules holds all the PolicyRules for this ClusterRole.

        :schema: io.k8s.api.rbac.v1.ClusterRole
        '''
        if isinstance(aggregation_rule, dict):
            aggregation_rule = AggregationRule(**aggregation_rule)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85a7eebd15f92fa8cb6f9abb67cc39c949d6eb25addd81aa0471048439f8726b)
            check_type(argname="argument aggregation_rule", value=aggregation_rule, expected_type=type_hints["aggregation_rule"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if aggregation_rule is not None:
            self._values["aggregation_rule"] = aggregation_rule
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def aggregation_rule(self) -> typing.Optional[AggregationRule]:
        '''AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.

        If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.

        :schema: io.k8s.api.rbac.v1.ClusterRole#aggregationRule
        '''
        result = self._values.get("aggregation_rule")
        return typing.cast(typing.Optional[AggregationRule], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRole#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRule"]]:
        '''Rules holds all the PolicyRules for this ClusterRole.

        :schema: io.k8s.api.rbac.v1.ClusterRole#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeComponentStatus(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeComponentStatus",
):
    '''ComponentStatus (and ComponentStatusList) holds the cluster validation info.

    Deprecated: This API is deprecated in v1.19+

    :schema: io.k8s.api.core.v1.ComponentStatus
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        conditions: typing.Optional[typing.Sequence[typing.Union[ComponentCondition, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ComponentStatus" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param conditions: List of component conditions observed.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70986a8184f954c24592d12a658be4caf4c942cd85bc85fdc04aea7036c8211f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeComponentStatusProps(conditions=conditions, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        conditions: typing.Optional[typing.Sequence[typing.Union[ComponentCondition, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param conditions: List of component conditions observed.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeComponentStatusProps(conditions=conditions, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeComponentStatusList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeComponentStatusList",
):
    '''Status of all the conditions for the component as a list of ComponentStatus objects.

    Deprecated: This API is deprecated in v1.19+

    :schema: io.k8s.api.core.v1.ComponentStatusList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeComponentStatusProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ComponentStatusList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: List of ComponentStatus objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65d365421951329a36bbe619492ee7b89775fda9c5c133b452e1c6866ed12f08)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeComponentStatusListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeComponentStatusProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: List of ComponentStatus objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        props = KubeComponentStatusListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeComponentStatusListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeComponentStatusListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeComponentStatusProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Status of all the conditions for the component as a list of ComponentStatus objects.

        Deprecated: This API is deprecated in v1.19+

        :param items: List of ComponentStatus objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.ComponentStatusList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__611b2341230ff3c30dd5af0688b3696ff30c2eb538e5e29ced4c7bec818f1cdd)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeComponentStatusProps"]:
        '''List of ComponentStatus objects.

        :schema: io.k8s.api.core.v1.ComponentStatusList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeComponentStatusProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.ComponentStatusList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeComponentStatusListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeComponentStatusProps",
    jsii_struct_bases=[],
    name_mapping={"conditions": "conditions", "metadata": "metadata"},
)
class KubeComponentStatusProps:
    def __init__(
        self,
        *,
        conditions: typing.Optional[typing.Sequence[typing.Union[ComponentCondition, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ComponentStatus (and ComponentStatusList) holds the cluster validation info.

        Deprecated: This API is deprecated in v1.19+

        :param conditions: List of component conditions observed.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ComponentStatus
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8b6bff386cdc29f70bee32bc951781c1a46a140fb376bc093e4252307f4f320)
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if conditions is not None:
            self._values["conditions"] = conditions
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def conditions(self) -> typing.Optional[typing.List[ComponentCondition]]:
        '''List of component conditions observed.

        :schema: io.k8s.api.core.v1.ComponentStatus#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional[typing.List[ComponentCondition]], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ComponentStatus#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeComponentStatusProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeConfigMap(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeConfigMap",
):
    '''ConfigMap holds configuration data for pods to consume.

    :schema: io.k8s.api.core.v1.ConfigMap
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ConfigMap" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecb3a22a49a80f7833fd0ac9208c4886e90cd3c07e245fc83f5fd7d1094070d3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeConfigMapList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeConfigMapList",
):
    '''ConfigMapList is a resource containing a list of ConfigMap objects.

    :schema: io.k8s.api.core.v1.ConfigMapList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeConfigMapProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ConfigMapList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of ConfigMaps.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a563dd146695678a67d73357dbb1d5e228da63bdb99563dbf6984595bb6f6914)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeConfigMapListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeConfigMapProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of ConfigMaps.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeConfigMapListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeConfigMapListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeConfigMapListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeConfigMapProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ConfigMapList is a resource containing a list of ConfigMap objects.

        :param items: Items is the list of ConfigMaps.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.core.v1.ConfigMapList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91857626357f9f5b09e6dea93b0a795185d5195ee72eb5bea80e19dfdf4a07be)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeConfigMapProps"]:
        '''Items is the list of ConfigMaps.

        :schema: io.k8s.api.core.v1.ConfigMapList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeConfigMapProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.core.v1.ConfigMapList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeConfigMapListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeConfigMapProps",
    jsii_struct_bases=[],
    name_mapping={
        "binary_data": "binaryData",
        "data": "data",
        "immutable": "immutable",
        "metadata": "metadata",
    },
)
class KubeConfigMapProps:
    def __init__(
        self,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ConfigMap holds configuration data for pods to consume.

        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ConfigMap
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e40ea7e693b2c9e66152bacc1a1b230a123cb99dc80291d850edce395eedacbf)
            check_type(argname="argument binary_data", value=binary_data, expected_type=type_hints["binary_data"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if binary_data is not None:
            self._values["binary_data"] = binary_data
        if data is not None:
            self._values["data"] = data
        if immutable is not None:
            self._values["immutable"] = immutable
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def binary_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''BinaryData contains the binary data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.

        :schema: io.k8s.api.core.v1.ConfigMap#binaryData
        '''
        result = self._values.get("binary_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def data(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Data contains the configuration data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.

        :schema: io.k8s.api.core.v1.ConfigMap#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time. Defaulted to nil.

        :schema: io.k8s.api.core.v1.ConfigMap#immutable
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ConfigMap#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeConfigMapProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevision(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeControllerRevision",
):
    '''ControllerRevision implements an immutable snapshot of state data.

    Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

    :schema: io.k8s.api.apps.v1.ControllerRevision
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        revision: jsii.Number,
        data: typing.Any = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.ControllerRevision" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param revision: Revision indicates the revision of the state represented by Data.
        :param data: Data is the serialized representation of the state.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5f688bac64b8507916922eb4b86d11c7454f8a3fc5550fb4311977f3041753f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeControllerRevisionProps(
            revision=revision, data=data, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        revision: jsii.Number,
        data: typing.Any = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param revision: Revision indicates the revision of the state represented by Data.
        :param data: Data is the serialized representation of the state.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeControllerRevisionProps(
            revision=revision, data=data, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeControllerRevisionList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeControllerRevisionList",
):
    '''ControllerRevisionList is a resource containing a list of ControllerRevision objects.

    :schema: io.k8s.api.apps.v1.ControllerRevisionList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeControllerRevisionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.ControllerRevisionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of ControllerRevisions.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80ec2b9ec6e0d97f03a6c84bb8da86e41c200ed5e89b920acfb826e522320ae2)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeControllerRevisionListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeControllerRevisionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of ControllerRevisions.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeControllerRevisionListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeControllerRevisionListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeControllerRevisionListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeControllerRevisionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ControllerRevisionList is a resource containing a list of ControllerRevision objects.

        :param items: Items is the list of ControllerRevisions.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.apps.v1.ControllerRevisionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e56e57109b73eb9dccc60cfba95649dfec548a91d77f054e2e70892523697184)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeControllerRevisionProps"]:
        '''Items is the list of ControllerRevisions.

        :schema: io.k8s.api.apps.v1.ControllerRevisionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeControllerRevisionProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.apps.v1.ControllerRevisionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeControllerRevisionProps",
    jsii_struct_bases=[],
    name_mapping={"revision": "revision", "data": "data", "metadata": "metadata"},
)
class KubeControllerRevisionProps:
    def __init__(
        self,
        *,
        revision: jsii.Number,
        data: typing.Any = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ControllerRevision implements an immutable snapshot of state data.

        Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

        :param revision: Revision indicates the revision of the state represented by Data.
        :param data: Data is the serialized representation of the state.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.ControllerRevision
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9419908f094a5f69b67226184a3554f5645a6b7e8bc1cc58cd1c178c7d9cbdb2)
            check_type(argname="argument revision", value=revision, expected_type=type_hints["revision"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "revision": revision,
        }
        if data is not None:
            self._values["data"] = data
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def revision(self) -> jsii.Number:
        '''Revision indicates the revision of the state represented by Data.

        :schema: io.k8s.api.apps.v1.ControllerRevision#revision
        '''
        result = self._values.get("revision")
        assert result is not None, "Required property 'revision' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def data(self) -> typing.Any:
        '''Data is the serialized representation of the state.

        :schema: io.k8s.api.apps.v1.ControllerRevision#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Any, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.ControllerRevision#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJob(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCronJob",
):
    '''CronJob represents the configuration of a single cron job.

    :schema: io.k8s.api.batch.v1.CronJob
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.batch.v1.CronJob" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3a83dd9336c4dd932c0e088884375853274b29066795f537311fbb7aaf076b8a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCronJobProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJob".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeCronJobProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJob".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCronJobList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobList",
):
    '''CronJobList is a collection of cron jobs.

    :schema: io.k8s.api.batch.v1.CronJobList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.batch.v1.CronJobList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18fd0dfb0357e6357dcb0f18b5415d0481c79214ecdae03591c2e245c173b73f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCronJobListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJobList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeCronJobListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJobList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCronJobListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CronJobList is a collection of cron jobs.

        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.CronJobList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc9b7b4ec14b40d2108eaf68195fd67cfb142724dfea886bd83876d69cbd2a8a)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCronJobProps"]:
        '''items is the list of CronJobs.

        :schema: io.k8s.api.batch.v1.CronJobList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCronJobProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.CronJobList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJobListV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobListV1Beta1",
):
    '''CronJobList is a collection of cron jobs.

    :schema: io.k8s.api.batch.v1beta1.CronJobList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.batch.v1beta1.CronJobList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e39689c7cb03a62d24fa3245f6a5c2ff47ae2967517d08a723a429650960e89a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCronJobListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJobList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeCronJobListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJobList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCronJobListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CronJobList is a collection of cron jobs.

        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1beta1.CronJobList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5ed4866c2f8261137a8c342aed94c2e81f62a7790ea849ff590a9e940f54a3c)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCronJobV1Beta1Props"]:
        '''items is the list of CronJobs.

        :schema: io.k8s.api.batch.v1beta1.CronJobList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCronJobV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1beta1.CronJobList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeCronJobProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CronJob represents the configuration of a single cron job.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.CronJob
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = CronJobSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d92f0ded41fa90890c665f0617529c91d59e1826e9eb4c65a90d09f5f9ba26bb)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.CronJob#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[CronJobSpec]:
        '''Specification of the desired behavior of a cron job, including the schedule.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.CronJob#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[CronJobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJobV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobV1Beta1",
):
    '''CronJob represents the configuration of a single cron job.

    :schema: io.k8s.api.batch.v1beta1.CronJob
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpecV1Beta1, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.batch.v1beta1.CronJob" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1705434b62fc4691693b66f5c262838a4209f1c63841ced9feebe0f6c7ed7c30)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCronJobV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpecV1Beta1, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJob".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeCronJobV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJob".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCronJobV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeCronJobV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpecV1Beta1, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CronJob represents the configuration of a single cron job.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1beta1.CronJob
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = CronJobSpecV1Beta1(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8127dde7ed24d7a57e29378fbe585173ad29606b6ed5b8020dd413ab20e76e21)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1beta1.CronJob#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[CronJobSpecV1Beta1]:
        '''Specification of the desired behavior of a cron job, including the schedule.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1beta1.CronJob#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[CronJobSpecV1Beta1], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiDriver(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiDriver",
):
    '''CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

    Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

    :schema: io.k8s.api.storage.v1.CSIDriver
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CsiDriverSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIDriver" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: Specification of the CSI Driver.
        :param metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d26b2c91579b641b80f2929144ba79606bfcb3d990badad74a75fb61bb0d490)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiDriverProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CsiDriverSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriver".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: Specification of the CSI Driver.
        :param metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeCsiDriverProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriver".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCsiDriverList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiDriverList",
):
    '''CSIDriverList is a collection of CSIDriver objects.

    :schema: io.k8s.api.storage.v1.CSIDriverList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiDriverProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIDriverList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CSIDriver.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a93046f6bdfe92909b506f2e602be5950d912bc7ea9bc8c36a6fd128c9f5f95)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiDriverListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiDriverProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriverList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CSIDriver.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiDriverListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriverList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiDriverListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiDriverListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiDriverProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIDriverList is a collection of CSIDriver objects.

        :param items: items is the list of CSIDriver.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIDriverList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f9feb8114733224a730ec2df36503cdeb7d36b835841ce543f4622c7a5a5525)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiDriverProps"]:
        '''items is the list of CSIDriver.

        :schema: io.k8s.api.storage.v1.CSIDriverList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiDriverProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIDriverList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiDriverListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiDriverProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCsiDriverProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CsiDriverSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

        Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

        :param spec: Specification of the CSI Driver.
        :param metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1.CSIDriver
        '''
        if isinstance(spec, dict):
            spec = CsiDriverSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__589d0332405c94e64ff66f8e14c37bbe64a88c49a0a838ff00d6147d10a3c0ac)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CsiDriverSpec:
        '''Specification of the CSI Driver.

        :schema: io.k8s.api.storage.v1.CSIDriver#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CsiDriverSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object metadata.

        metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1.CSIDriver#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiDriverProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiNode(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiNode",
):
    '''CSINode holds information about all CSI drivers installed on a node.

    CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

    :schema: io.k8s.api.storage.v1.CSINode
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CsiNodeSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSINode" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec is the specification of CSINode.
        :param metadata: metadata.name must be the Kubernetes node name.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b48a51a4d634982fe0b730f3db5bf2819162b9e5b2de65e94e9cf2f60f3db91)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiNodeProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CsiNodeSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINode".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec is the specification of CSINode.
        :param metadata: metadata.name must be the Kubernetes node name.
        '''
        props = KubeCsiNodeProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINode".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCsiNodeList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiNodeList",
):
    '''CSINodeList is a collection of CSINode objects.

    :schema: io.k8s.api.storage.v1.CSINodeList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiNodeProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSINodeList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CSINode.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83e3de524db24972d952123dfc07f40dc6cd85b3a5bb45c00f1b118de408815e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiNodeListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiNodeProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINodeList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CSINode.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiNodeListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINodeList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiNodeListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiNodeListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiNodeProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSINodeList is a collection of CSINode objects.

        :param items: items is the list of CSINode.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSINodeList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__496b5dadf07a264b6ce03c87acc91f7d2d74010b77de52b4ea0d8b12251dbe6e)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiNodeProps"]:
        '''items is the list of CSINode.

        :schema: io.k8s.api.storage.v1.CSINodeList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiNodeProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSINodeList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiNodeListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiNodeProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCsiNodeProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CsiNodeSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSINode holds information about all CSI drivers installed on a node.

        CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

        :param spec: spec is the specification of CSINode.
        :param metadata: metadata.name must be the Kubernetes node name.

        :schema: io.k8s.api.storage.v1.CSINode
        '''
        if isinstance(spec, dict):
            spec = CsiNodeSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbdce72cab354266d003250707ad02b68ebd8a307b3e5901cc37e5ab7adfbeca)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CsiNodeSpec:
        '''spec is the specification of CSINode.

        :schema: io.k8s.api.storage.v1.CSINode#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CsiNodeSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''metadata.name must be the Kubernetes node name.

        :schema: io.k8s.api.storage.v1.CSINode#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiNodeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiStorageCapacity(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacity",
):
    '''CSIStorageCapacity stores the result of one CSI GetCapacity call.

    For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

    For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

    The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

    The producer of these objects can decide which approach is more suitable.

    They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.

    :schema: io.k8s.api.storage.v1.CSIStorageCapacity
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIStorageCapacity" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param storage_class_name: The name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: NodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bc9fbd83143eba141bdfaaf5f35124b47b609b03c07bafaa4900afa8d82b73f7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiStorageCapacityProps(
            storage_class_name=storage_class_name,
            capacity=capacity,
            maximum_volume_size=maximum_volume_size,
            metadata=metadata,
            node_topology=node_topology,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIStorageCapacity".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param storage_class_name: The name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: NodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        '''
        props = KubeCsiStorageCapacityProps(
            storage_class_name=storage_class_name,
            capacity=capacity,
            maximum_volume_size=maximum_volume_size,
            metadata=metadata,
            node_topology=node_topology,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIStorageCapacity".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCsiStorageCapacityList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityList",
):
    '''CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

    :schema: io.k8s.api.storage.v1.CSIStorageCapacityList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIStorageCapacityList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4434fbd3b0db669f98c7c0fe228d7ea54a6fa725c1ae33a257c6246f48955b8f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiStorageCapacityListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIStorageCapacityList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiStorageCapacityListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIStorageCapacityList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiStorageCapacityListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

        :param items: Items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacityList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70b10ac513f8f6898d4139146aae0baf7162abb043ee24fc88c0c58b7561a59d)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiStorageCapacityProps"]:
        '''Items is the list of CSIStorageCapacity objects.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacityList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiStorageCapacityProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacityList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiStorageCapacityListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiStorageCapacityListV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityListV1Beta1",
):
    '''CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

    :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacityList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1beta1.CSIStorageCapacityList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c732a2df6b39b79326306895f5d64a1344ed0376dc229b9d1c69c7003b4c174)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiStorageCapacityListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiStorageCapacityListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiStorageCapacityListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

        :param items: Items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacityList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0aba53ea99c0c0a4accdd94541607882e01e7eb6d0bdd79964a942a447f1344)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiStorageCapacityV1Beta1Props"]:
        '''Items is the list of CSIStorageCapacity objects.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacityList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiStorageCapacityV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacityList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiStorageCapacityListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityProps",
    jsii_struct_bases=[],
    name_mapping={
        "storage_class_name": "storageClassName",
        "capacity": "capacity",
        "maximum_volume_size": "maximumVolumeSize",
        "metadata": "metadata",
        "node_topology": "nodeTopology",
    },
)
class KubeCsiStorageCapacityProps:
    def __init__(
        self,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIStorageCapacity stores the result of one CSI GetCapacity call.

        For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

        For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

        The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

        The producer of these objects can decide which approach is more suitable.

        They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.

        :param storage_class_name: The name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: NodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(node_topology, dict):
            node_topology = LabelSelector(**node_topology)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4c800fc85a26ee1b61ca92ee085f1e4fe0c2ad33385e80ef5d5e7a5a36fd02d)
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument maximum_volume_size", value=maximum_volume_size, expected_type=type_hints["maximum_volume_size"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument node_topology", value=node_topology, expected_type=type_hints["node_topology"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "storage_class_name": storage_class_name,
        }
        if capacity is not None:
            self._values["capacity"] = capacity
        if maximum_volume_size is not None:
            self._values["maximum_volume_size"] = maximum_volume_size
        if metadata is not None:
            self._values["metadata"] = metadata
        if node_topology is not None:
            self._values["node_topology"] = node_topology

    @builtins.property
    def storage_class_name(self) -> builtins.str:
        '''The name of the StorageClass that the reported capacity applies to.

        It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#storageClassName
        '''
        result = self._values.get("storage_class_name")
        assert result is not None, "Required property 'storage_class_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def capacity(self) -> typing.Optional["Quantity"]:
        '''Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#capacity
        '''
        result = self._values.get("capacity")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def maximum_volume_size(self) -> typing.Optional["Quantity"]:
        '''MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#maximumVolumeSize
        '''
        result = self._values.get("maximum_volume_size")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

        Objects are namespaced.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def node_topology(self) -> typing.Optional["LabelSelector"]:
        '''NodeTopology defines which nodes have access to the storage for which capacity was reported.

        If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#nodeTopology
        '''
        result = self._values.get("node_topology")
        return typing.cast(typing.Optional["LabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiStorageCapacityProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiStorageCapacityV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityV1Beta1",
):
    '''CSIStorageCapacity stores the result of one CSI GetCapacity call.

    For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

    For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

    The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

    The producer of these objects can decide which approach is more suitable.

    They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.

    :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1beta1.CSIStorageCapacity" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param storage_class_name: The name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: NodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__693ed340f8e0d3b00067dae691a10a0950786bb4f54bda9c2fe6b0a96099852a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiStorageCapacityV1Beta1Props(
            storage_class_name=storage_class_name,
            capacity=capacity,
            maximum_volume_size=maximum_volume_size,
            metadata=metadata,
            node_topology=node_topology,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacity".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param storage_class_name: The name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: NodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        '''
        props = KubeCsiStorageCapacityV1Beta1Props(
            storage_class_name=storage_class_name,
            capacity=capacity,
            maximum_volume_size=maximum_volume_size,
            metadata=metadata,
            node_topology=node_topology,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacity".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCsiStorageCapacityV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={
        "storage_class_name": "storageClassName",
        "capacity": "capacity",
        "maximum_volume_size": "maximumVolumeSize",
        "metadata": "metadata",
        "node_topology": "nodeTopology",
    },
)
class KubeCsiStorageCapacityV1Beta1Props:
    def __init__(
        self,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIStorageCapacity stores the result of one CSI GetCapacity call.

        For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

        For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

        The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

        The producer of these objects can decide which approach is more suitable.

        They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.

        :param storage_class_name: The name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: NodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(node_topology, dict):
            node_topology = LabelSelector(**node_topology)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28f5e5e0f1906e643fb50169faa42949d091847ee5285c3014774500d332847a)
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument maximum_volume_size", value=maximum_volume_size, expected_type=type_hints["maximum_volume_size"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument node_topology", value=node_topology, expected_type=type_hints["node_topology"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "storage_class_name": storage_class_name,
        }
        if capacity is not None:
            self._values["capacity"] = capacity
        if maximum_volume_size is not None:
            self._values["maximum_volume_size"] = maximum_volume_size
        if metadata is not None:
            self._values["metadata"] = metadata
        if node_topology is not None:
            self._values["node_topology"] = node_topology

    @builtins.property
    def storage_class_name(self) -> builtins.str:
        '''The name of the StorageClass that the reported capacity applies to.

        It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity#storageClassName
        '''
        result = self._values.get("storage_class_name")
        assert result is not None, "Required property 'storage_class_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def capacity(self) -> typing.Optional["Quantity"]:
        '''Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity#capacity
        '''
        result = self._values.get("capacity")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def maximum_volume_size(self) -> typing.Optional["Quantity"]:
        '''MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity#maximumVolumeSize
        '''
        result = self._values.get("maximum_volume_size")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

        Objects are namespaced.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def node_topology(self) -> typing.Optional["LabelSelector"]:
        '''NodeTopology defines which nodes have access to the storage for which capacity was reported.

        If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.

        :schema: io.k8s.api.storage.v1beta1.CSIStorageCapacity#nodeTopology
        '''
        result = self._values.get("node_topology")
        return typing.cast(typing.Optional["LabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiStorageCapacityV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCustomResourceDefinition(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCustomResourceDefinition",
):
    '''CustomResourceDefinition represents a resource that should be exposed on the API server.

    Its name MUST be in the format <.spec.name>.<.spec.group>.

    :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CustomResourceDefinitionSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec describes how the user wants the resources to appear.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ea980e5c708843483caf96683d36ea6a3543dc0f80c32ab376c7cc640c58b35)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCustomResourceDefinitionProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CustomResourceDefinitionSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec describes how the user wants the resources to appear.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCustomResourceDefinitionProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCustomResourceDefinitionList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeCustomResourceDefinitionList",
):
    '''CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

    :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCustomResourceDefinitionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items list individual CustomResourceDefinition objects.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2036979059d119fb3c123668fb876da0e953358eabdb85dd4f8486062266676)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCustomResourceDefinitionListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCustomResourceDefinitionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items list individual CustomResourceDefinition objects.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCustomResourceDefinitionListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCustomResourceDefinitionListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCustomResourceDefinitionListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCustomResourceDefinitionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

        :param items: items list individual CustomResourceDefinition objects.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__443fbc5363132b03d3735a0776370d830f3cec5a433d4f8c6fe53e731cd23558)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCustomResourceDefinitionProps"]:
        '''items list individual CustomResourceDefinition objects.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCustomResourceDefinitionProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCustomResourceDefinitionListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeCustomResourceDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCustomResourceDefinitionProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CustomResourceDefinitionSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceDefinition represents a resource that should be exposed on the API server.

        Its name MUST be in the format <.spec.name>.<.spec.group>.

        :param spec: spec describes how the user wants the resources to appear.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
        '''
        if isinstance(spec, dict):
            spec = CustomResourceDefinitionSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5be29fc5801e63284f3e17c78fbcbc60db83ae27bec5d732ee21c5fbe13d551e)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CustomResourceDefinitionSpec:
        '''spec describes how the user wants the resources to appear.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CustomResourceDefinitionSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCustomResourceDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSet(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeDaemonSet",
):
    '''DaemonSet represents the configuration of a daemon set.

    :schema: io.k8s.api.apps.v1.DaemonSet
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DaemonSetSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.DaemonSet" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f7225827b7b0b14d57e56131815af649f5d70a0cb2f5e85ef7e5b94974fe7d9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDaemonSetProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DaemonSetSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeDaemonSetProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeDaemonSetList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeDaemonSetList",
):
    '''DaemonSetList is a collection of daemon sets.

    :schema: io.k8s.api.apps.v1.DaemonSetList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeDaemonSetProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.DaemonSetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: A list of daemon sets.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4df7a86dd54ecbed46f32334287da404078d40e045acda986afa201b1aad4b7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDaemonSetListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeDaemonSetProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: A list of daemon sets.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeDaemonSetListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeDaemonSetListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDaemonSetListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeDaemonSetProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DaemonSetList is a collection of daemon sets.

        :param items: A list of daemon sets.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.DaemonSetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__180a380f426210bdc00ae7ec1e319f92b8a37417c7078ac78e323ec27761a383)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDaemonSetProps"]:
        '''A list of daemon sets.

        :schema: io.k8s.api.apps.v1.DaemonSetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDaemonSetProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.DaemonSetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeDaemonSetProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDaemonSetProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DaemonSetSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DaemonSet represents the configuration of a daemon set.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.apps.v1.DaemonSet
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DaemonSetSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b03258b5559a21d903a053bd0729f80fe2e97c8e918813fb89e55954342e910a)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.DaemonSet#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DaemonSetSpec]:
        '''The desired behavior of this daemon set.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.apps.v1.DaemonSet#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DaemonSetSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeployment(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeDeployment",
):
    '''Deployment enables declarative updates for Pods and ReplicaSets.

    :schema: io.k8s.api.apps.v1.Deployment
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DeploymentSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.Deployment" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the Deployment.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73a0111040dac346590a635c8f7999cf794d58a5e8fdd45a034a403b061c92db)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDeploymentProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DeploymentSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the Deployment.
        '''
        props = KubeDeploymentProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeDeploymentList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeDeploymentList",
):
    '''DeploymentList is a list of Deployments.

    :schema: io.k8s.api.apps.v1.DeploymentList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeDeploymentProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.DeploymentList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of Deployments.
        :param metadata: Standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63ef606d81402ee8aac28efe6eb0a07ea0fca18f469cb7766fd54092b94b4827)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDeploymentListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeDeploymentProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of Deployments.
        :param metadata: Standard list metadata.
        '''
        props = KubeDeploymentListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeDeploymentListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDeploymentListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeDeploymentProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DeploymentList is a list of Deployments.

        :param items: Items is the list of Deployments.
        :param metadata: Standard list metadata.

        :schema: io.k8s.api.apps.v1.DeploymentList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbecd113835712da949a3582fe428d4151d6aa28323be1d437c84fbbbebacd1e)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDeploymentProps"]:
        '''Items is the list of Deployments.

        :schema: io.k8s.api.apps.v1.DeploymentList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDeploymentProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        :schema: io.k8s.api.apps.v1.DeploymentList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeDeploymentProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDeploymentProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DeploymentSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Deployment enables declarative updates for Pods and ReplicaSets.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the Deployment.

        :schema: io.k8s.api.apps.v1.Deployment
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DeploymentSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ab16b83869930dfff2a7c9daf52dabe322726d8155d4566c739562c6cc58e26)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.Deployment#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DeploymentSpec]:
        '''Specification of the desired behavior of the Deployment.

        :schema: io.k8s.api.apps.v1.Deployment#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DeploymentSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpointSlice(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSlice",
):
    '''EndpointSlice represents a subset of the endpoints that implement a service.

    For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

    :schema: io.k8s.api.discovery.v1.EndpointSlice
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[Endpoint, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.discovery.v1.EndpointSlice" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d41133bf6cfeac3162297e41258e31f6109a56f930618596df63f7ac65a53da4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointSliceProps(
            address_type=address_type,
            endpoints=endpoints,
            metadata=metadata,
            ports=ports,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[Endpoint, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSlice".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
        '''
        props = KubeEndpointSliceProps(
            address_type=address_type,
            endpoints=endpoints,
            metadata=metadata,
            ports=ports,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSlice".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEndpointSliceList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceList",
):
    '''EndpointSliceList represents a list of endpoint slices.

    :schema: io.k8s.api.discovery.v1.EndpointSliceList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.discovery.v1.EndpointSliceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: List of endpoint slices.
        :param metadata: Standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9e3f302415c341944d63bfd82da1ea46cf699c175dc13609e0d88ac19e102227)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointSliceListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSliceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: List of endpoint slices.
        :param metadata: Standard list metadata.
        '''
        props = KubeEndpointSliceListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSliceList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEndpointSliceListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointSliceList represents a list of endpoint slices.

        :param items: List of endpoint slices.
        :param metadata: Standard list metadata.

        :schema: io.k8s.api.discovery.v1.EndpointSliceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__34cefb9e9ccabba852a26369088f9379c096332ab6248de684924cf5dca4a9f8)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEndpointSliceProps"]:
        '''List of endpoint slices.

        :schema: io.k8s.api.discovery.v1.EndpointSliceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEndpointSliceProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        :schema: io.k8s.api.discovery.v1.EndpointSliceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointSliceListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpointSliceListV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceListV1Beta1",
):
    '''EndpointSliceList represents a list of endpoint slices.

    :schema: io.k8s.api.discovery.v1beta1.EndpointSliceList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.discovery.v1beta1.EndpointSliceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: List of endpoint slices.
        :param metadata: Standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7fa7a365cebcfe773a27bc70da5262e546cb1f7ac5fc6623c4f6fc58dae647f1)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointSliceListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSliceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: List of endpoint slices.
        :param metadata: Standard list metadata.
        '''
        props = KubeEndpointSliceListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSliceList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEndpointSliceListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointSliceList represents a list of endpoint slices.

        :param items: List of endpoint slices.
        :param metadata: Standard list metadata.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSliceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77f5ea468bbefed709a8debb2e3d94117b1fb7eddf6931db946c85f88f1dacee)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEndpointSliceV1Beta1Props"]:
        '''List of endpoint slices.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSliceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEndpointSliceV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSliceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointSliceListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceProps",
    jsii_struct_bases=[],
    name_mapping={
        "address_type": "addressType",
        "endpoints": "endpoints",
        "metadata": "metadata",
        "ports": "ports",
    },
)
class KubeEndpointSliceProps:
    def __init__(
        self,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[Endpoint, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointSlice represents a subset of the endpoints that implement a service.

        For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

        :schema: io.k8s.api.discovery.v1.EndpointSlice
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01399e6ad293631295ec0adf60b557689485f5676b35413a6ec5c999ebbd7567)
            check_type(argname="argument address_type", value=address_type, expected_type=type_hints["address_type"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "address_type": address_type,
            "endpoints": endpoints,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def address_type(self) -> builtins.str:
        '''addressType specifies the type of address carried by this EndpointSlice.

        All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#addressType
        '''
        result = self._values.get("address_type")
        assert result is not None, "Required property 'address_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoints(self) -> typing.List[Endpoint]:
        '''endpoints is a list of unique endpoints in this slice.

        Each slice may include a maximum of 1000 endpoints.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List[Endpoint], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[EndpointPort]]:
        '''ports specifies the list of network ports exposed by each endpoint in this slice.

        Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[EndpointPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointSliceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpointSliceV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceV1Beta1",
):
    '''EndpointSlice represents a subset of the endpoints that implement a service.

    For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

    :schema: io.k8s.api.discovery.v1beta1.EndpointSlice
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[EndpointV1Beta1, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPortV1Beta1, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.discovery.v1beta1.EndpointSlice" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73ecf9bde143aaf60e9bee7907d4487473f38acb3079e029c602f38c3c8c53a0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointSliceV1Beta1Props(
            address_type=address_type,
            endpoints=endpoints,
            metadata=metadata,
            ports=ports,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[EndpointV1Beta1, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPortV1Beta1, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSlice".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
        '''
        props = KubeEndpointSliceV1Beta1Props(
            address_type=address_type,
            endpoints=endpoints,
            metadata=metadata,
            ports=ports,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSlice".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointSliceV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={
        "address_type": "addressType",
        "endpoints": "endpoints",
        "metadata": "metadata",
        "ports": "ports",
    },
)
class KubeEndpointSliceV1Beta1Props:
    def __init__(
        self,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[EndpointV1Beta1, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPortV1Beta1, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointSlice represents a subset of the endpoints that implement a service.

        For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSlice
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f0374509e4018b828c2bd891128f0c9a1d239a37cf7fbf53da0de6130dbcd156)
            check_type(argname="argument address_type", value=address_type, expected_type=type_hints["address_type"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "address_type": address_type,
            "endpoints": endpoints,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def address_type(self) -> builtins.str:
        '''addressType specifies the type of address carried by this EndpointSlice.

        All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSlice#addressType
        '''
        result = self._values.get("address_type")
        assert result is not None, "Required property 'address_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoints(self) -> typing.List[EndpointV1Beta1]:
        '''endpoints is a list of unique endpoints in this slice.

        Each slice may include a maximum of 1000 endpoints.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSlice#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List[EndpointV1Beta1], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSlice#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[EndpointPortV1Beta1]]:
        '''ports specifies the list of network ports exposed by each endpoint in this slice.

        Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

        :schema: io.k8s.api.discovery.v1beta1.EndpointSlice#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[EndpointPortV1Beta1]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointSliceV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpoints(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEndpoints",
):
    '''Endpoints is a collection of endpoints that implement the actual service.

    Example:
    Name: "mysvc",
    Subsets: [
    {
    Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
    },
    {
    Addresses: [{"ip": "10.10.3.3"}],
    Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
    },
    ]

    :schema: io.k8s.api.core.v1.Endpoints
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subsets: typing.Optional[typing.Sequence[typing.Union[EndpointSubset, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.Endpoints" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1139153a8e7be6fc1e85e465c9f18809b7bda99210336759e297d52a675caa94)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointsProps(metadata=metadata, subsets=subsets)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subsets: typing.Optional[typing.Sequence[typing.Union[EndpointSubset, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        '''
        props = KubeEndpointsProps(metadata=metadata, subsets=subsets)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEndpointsList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointsList",
):
    '''EndpointsList is a list of endpoints.

    :schema: io.k8s.api.core.v1.EndpointsList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointsProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.EndpointsList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: List of endpoints.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__698d93d4237257dbedb46703cfdf50af0223f2a96658a11a4c877b3116ae7455)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointsListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointsProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: List of endpoints.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        props = KubeEndpointsListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointsListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEndpointsListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointsProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointsList is a list of endpoints.

        :param items: List of endpoints.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.EndpointsList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ec68b5f42fa42261f68591dbef4a8b7900888a21a7e2582501fbc307b11596e)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEndpointsProps"]:
        '''List of endpoints.

        :schema: io.k8s.api.core.v1.EndpointsList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEndpointsProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.EndpointsList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointsListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEndpointsProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "subsets": "subsets"},
)
class KubeEndpointsProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subsets: typing.Optional[typing.Sequence[typing.Union[EndpointSubset, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Endpoints is a collection of endpoints that implement the actual service.

        Example:
        Name: "mysvc",
        Subsets: [
        {
        Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        },
        {
        Addresses: [{"ip": "10.10.3.3"}],
        Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
        },
        ]

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :schema: io.k8s.api.core.v1.Endpoints
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83b6be1e205de2067a7464cb442725c8791e6ab983ef90c51538c9a19a09e07d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument subsets", value=subsets, expected_type=type_hints["subsets"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if subsets is not None:
            self._values["subsets"] = subsets

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.Endpoints#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subsets(self) -> typing.Optional[typing.List[EndpointSubset]]:
        '''The set of all endpoints is the union of all subsets.

        Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :schema: io.k8s.api.core.v1.Endpoints#subsets
        '''
        result = self._values.get("subsets")
        return typing.cast(typing.Optional[typing.List[EndpointSubset]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEvent(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEvent",
):
    '''Event is a report of an event somewhere in the cluster.

    It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

    :schema: io.k8s.api.events.v1.Event
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[typing.Union[EventSource, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        related: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[typing.Union[EventSeries, typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Defines a "io.k8s.api.events.v1.Event" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param event_time: eventTime is the time when this Event was first observed. It is required.
        :param action: action is what action was taken/failed regarding to the regarding object. It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param deprecated_count: deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param note: note is a human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: reason is why the action was taken. It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param regarding: regarding contains the object this Event is about. In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: related is the optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: reportingController is the name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``. This field cannot be empty for new Events.
        :param reporting_instance: reportingInstance is the ID of the controller instance, e.g. ``kubelet-xyzf``. This field cannot be empty for new Events and it can have at most 128 characters.
        :param series: series is data about the Event series this event represents or nil if it's a singleton Event.
        :param type: type is the type of this event (Normal, Warning), new types could be added in the future. It is machine-readable. This field cannot be empty for new Events.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3ef4f186e49bbd19b8fb56fd11404c94cfb49805915207da89ea05386cbd082)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEventProps(
            event_time=event_time,
            action=action,
            deprecated_count=deprecated_count,
            deprecated_first_timestamp=deprecated_first_timestamp,
            deprecated_last_timestamp=deprecated_last_timestamp,
            deprecated_source=deprecated_source,
            metadata=metadata,
            note=note,
            reason=reason,
            regarding=regarding,
            related=related,
            reporting_controller=reporting_controller,
            reporting_instance=reporting_instance,
            series=series,
            type=type,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[typing.Union[EventSource, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        related: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[typing.Union[EventSeries, typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.events.v1.Event".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param event_time: eventTime is the time when this Event was first observed. It is required.
        :param action: action is what action was taken/failed regarding to the regarding object. It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param deprecated_count: deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param note: note is a human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: reason is why the action was taken. It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param regarding: regarding contains the object this Event is about. In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: related is the optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: reportingController is the name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``. This field cannot be empty for new Events.
        :param reporting_instance: reportingInstance is the ID of the controller instance, e.g. ``kubelet-xyzf``. This field cannot be empty for new Events and it can have at most 128 characters.
        :param series: series is data about the Event series this event represents or nil if it's a singleton Event.
        :param type: type is the type of this event (Normal, Warning), new types could be added in the future. It is machine-readable. This field cannot be empty for new Events.
        '''
        props = KubeEventProps(
            event_time=event_time,
            action=action,
            deprecated_count=deprecated_count,
            deprecated_first_timestamp=deprecated_first_timestamp,
            deprecated_last_timestamp=deprecated_last_timestamp,
            deprecated_source=deprecated_source,
            metadata=metadata,
            note=note,
            reason=reason,
            regarding=regarding,
            related=related,
            reporting_controller=reporting_controller,
            reporting_instance=reporting_instance,
            series=series,
            type=type,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.events.v1.Event".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEventList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEventList",
):
    '''EventList is a list of Event objects.

    :schema: io.k8s.api.events.v1.EventList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEventProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.events.v1.EventList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is a list of schema objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4da6919b3a5f906123edfe83cbfef3df15680b11ce4e2beddb4dd97d71da6f7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEventListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEventProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.events.v1.EventList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is a list of schema objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeEventListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.events.v1.EventList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.k8s.KubeEventListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEventListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEventProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EventList is a list of Event objects.

        :param items: items is a list of schema objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.events.v1.EventList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c7fcd622f20d88be0125f226cf7b34233a02ab04b7ed2f761dc95f895458757)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEventProps"]:
        '''items is a list of schema objects.

        :schema: io.k8s.api.events.v1.EventList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEventProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.events.v1.EventList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEventListV1Beta1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.k8s.KubeEventListV1Beta1",
):
    '''EventList is a list of Event objects.

    :schema: io.k8s.api.events.v1beta1.EventList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEventV1Beta1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.events.v1beta1.EventList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
      