# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateAuthorityArgs', 'CertificateAuthority']

@pulumi.input_type
class CertificateAuthorityArgs:
    def __init__(__self__, *,
                 certificate_authority_configuration: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs'],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 permanent_deletion_time_in_days: Optional[pulumi.Input[int]] = None,
                 revocation_configuration: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 usage_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CertificateAuthority resource.
        :param pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs'] certificate_authority_configuration: Nested argument containing algorithms and certificate subject information. Defined below.
        :param pulumi.Input[bool] enabled: Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        :param pulumi.Input[str] key_storage_security_standard: Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        :param pulumi.Input[int] permanent_deletion_time_in_days: Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        :param pulumi.Input['CertificateAuthorityRevocationConfigurationArgs'] revocation_configuration: Nested argument containing revocation configuration. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] type: Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        :param pulumi.Input[str] usage_mode: Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        pulumi.set(__self__, "certificate_authority_configuration", certificate_authority_configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_storage_security_standard is not None:
            pulumi.set(__self__, "key_storage_security_standard", key_storage_security_standard)
        if permanent_deletion_time_in_days is not None:
            pulumi.set(__self__, "permanent_deletion_time_in_days", permanent_deletion_time_in_days)
        if revocation_configuration is not None:
            pulumi.set(__self__, "revocation_configuration", revocation_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if usage_mode is not None:
            pulumi.set(__self__, "usage_mode", usage_mode)

    @property
    @pulumi.getter(name="certificateAuthorityConfiguration")
    def certificate_authority_configuration(self) -> pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs']:
        """
        Nested argument containing algorithms and certificate subject information. Defined below.
        """
        return pulumi.get(self, "certificate_authority_configuration")

    @certificate_authority_configuration.setter
    def certificate_authority_configuration(self, value: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs']):
        pulumi.set(self, "certificate_authority_configuration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keyStorageSecurityStandard")
    def key_storage_security_standard(self) -> Optional[pulumi.Input[str]]:
        """
        Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        """
        return pulumi.get(self, "key_storage_security_standard")

    @key_storage_security_standard.setter
    def key_storage_security_standard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_storage_security_standard", value)

    @property
    @pulumi.getter(name="permanentDeletionTimeInDays")
    def permanent_deletion_time_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        """
        return pulumi.get(self, "permanent_deletion_time_in_days")

    @permanent_deletion_time_in_days.setter
    def permanent_deletion_time_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "permanent_deletion_time_in_days", value)

    @property
    @pulumi.getter(name="revocationConfiguration")
    def revocation_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']]:
        """
        Nested argument containing revocation configuration. Defined below.
        """
        return pulumi.get(self, "revocation_configuration")

    @revocation_configuration.setter
    def revocation_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']]):
        pulumi.set(self, "revocation_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="usageMode")
    def usage_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        return pulumi.get(self, "usage_mode")

    @usage_mode.setter
    def usage_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usage_mode", value)


@pulumi.input_type
class _CertificateAuthorityState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_authority_configuration: Optional[pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs']] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 certificate_signing_request: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 not_after: Optional[pulumi.Input[str]] = None,
                 not_before: Optional[pulumi.Input[str]] = None,
                 permanent_deletion_time_in_days: Optional[pulumi.Input[int]] = None,
                 revocation_configuration: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 usage_mode: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CertificateAuthority resources.
        :param pulumi.Input[str] arn: ARN of the certificate authority.
        :param pulumi.Input[str] certificate: Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs'] certificate_authority_configuration: Nested argument containing algorithms and certificate subject information. Defined below.
        :param pulumi.Input[str] certificate_chain: Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[str] certificate_signing_request: The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
        :param pulumi.Input[bool] enabled: Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        :param pulumi.Input[str] key_storage_security_standard: Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        :param pulumi.Input[str] not_after: Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[str] not_before: Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[int] permanent_deletion_time_in_days: Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        :param pulumi.Input['CertificateAuthorityRevocationConfigurationArgs'] revocation_configuration: Nested argument containing revocation configuration. Defined below.
        :param pulumi.Input[str] serial: Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        :param pulumi.Input[str] usage_mode: Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_authority_configuration is not None:
            pulumi.set(__self__, "certificate_authority_configuration", certificate_authority_configuration)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if certificate_signing_request is not None:
            pulumi.set(__self__, "certificate_signing_request", certificate_signing_request)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_storage_security_standard is not None:
            pulumi.set(__self__, "key_storage_security_standard", key_storage_security_standard)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if permanent_deletion_time_in_days is not None:
            pulumi.set(__self__, "permanent_deletion_time_in_days", permanent_deletion_time_in_days)
        if revocation_configuration is not None:
            pulumi.set(__self__, "revocation_configuration", revocation_configuration)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if usage_mode is not None:
            pulumi.set(__self__, "usage_mode", usage_mode)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the certificate authority.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateAuthorityConfiguration")
    def certificate_authority_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs']]:
        """
        Nested argument containing algorithms and certificate subject information. Defined below.
        """
        return pulumi.get(self, "certificate_authority_configuration")

    @certificate_authority_configuration.setter
    def certificate_authority_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationArgs']]):
        pulumi.set(self, "certificate_authority_configuration", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[str]]:
        """
        Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
        """
        return pulumi.get(self, "certificate_signing_request")

    @certificate_signing_request.setter
    def certificate_signing_request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_signing_request", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keyStorageSecurityStandard")
    def key_storage_security_standard(self) -> Optional[pulumi.Input[str]]:
        """
        Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        """
        return pulumi.get(self, "key_storage_security_standard")

    @key_storage_security_standard.setter
    def key_storage_security_standard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_storage_security_standard", value)

    @property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_after", value)

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_before", value)

    @property
    @pulumi.getter(name="permanentDeletionTimeInDays")
    def permanent_deletion_time_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        """
        return pulumi.get(self, "permanent_deletion_time_in_days")

    @permanent_deletion_time_in_days.setter
    def permanent_deletion_time_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "permanent_deletion_time_in_days", value)

    @property
    @pulumi.getter(name="revocationConfiguration")
    def revocation_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']]:
        """
        Nested argument containing revocation configuration. Defined below.
        """
        return pulumi.get(self, "revocation_configuration")

    @revocation_configuration.setter
    def revocation_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']]):
        pulumi.set(self, "revocation_configuration", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="usageMode")
    def usage_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        return pulumi.get(self, "usage_mode")

    @usage_mode.setter
    def usage_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usage_mode", value)


class CertificateAuthority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigurationArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 permanent_deletion_time_in_days: Optional[pulumi.Input[int]] = None,
                 revocation_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 usage_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage AWS Certificate Manager Private Certificate Authorities (ACM PCA Certificate Authorities).

        > **NOTE:** Creating this resource will leave the certificate authority in a `PENDING_CERTIFICATE` status, which means it cannot yet issue certificates. To complete this setup, you must fully sign the certificate authority CSR available in the `certificate_signing_request` attribute. The `acmpca.CertificateAuthorityCertificate` resource can be used for this purpose.

        ## Example Usage

        ### Basic

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.acmpca.CertificateAuthority("example",
            certificate_authority_configuration=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs(
                key_algorithm="RSA_4096",
                signing_algorithm="SHA512WITHRSA",
                subject=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
                    common_name="example.com",
                ),
            ),
            permanent_deletion_time_in_days=7)
        ```
        <!--End PulumiCodeChooser -->

        ### Short-lived certificate

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.acmpca.CertificateAuthority("example",
            usage_mode="SHORT_LIVED_CERTIFICATE",
            certificate_authority_configuration=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs(
                key_algorithm="RSA_4096",
                signing_algorithm="SHA512WITHRSA",
                subject=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
                    common_name="example.com",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Enable Certificate Revocation List

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketV2("example",
            bucket="example",
            force_destroy=True)
        acmpca_bucket_access = aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=[
                "s3:GetBucketAcl",
                "s3:GetBucketLocation",
                "s3:PutObject",
                "s3:PutObjectAcl",
            ],
            resources=[
                example.arn,
                example.arn.apply(lambda arn: f"{arn}/*"),
            ],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                identifiers=["acm-pca.amazonaws.com"],
                type="Service",
            )],
        )])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example.id,
            policy=acmpca_bucket_access.json)
        example_certificate_authority = aws.acmpca.CertificateAuthority("example",
            certificate_authority_configuration=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs(
                key_algorithm="RSA_4096",
                signing_algorithm="SHA512WITHRSA",
                subject=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
                    common_name="example.com",
                ),
            ),
            revocation_configuration=aws.acmpca.CertificateAuthorityRevocationConfigurationArgs(
                crl_configuration=aws.acmpca.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs(
                    custom_cname="crl.example.com",
                    enabled=True,
                    expiration_in_days=7,
                    s3_bucket_name=example.id,
                    s3_object_acl="BUCKET_OWNER_FULL_CONTROL",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_acmpca_certificate_authority` using the certificate authority ARN. For example:

        ```sh
        $ pulumi import aws:acmpca/certificateAuthority:CertificateAuthority example arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigurationArgs']] certificate_authority_configuration: Nested argument containing algorithms and certificate subject information. Defined below.
        :param pulumi.Input[bool] enabled: Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        :param pulumi.Input[str] key_storage_security_standard: Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        :param pulumi.Input[int] permanent_deletion_time_in_days: Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']] revocation_configuration: Nested argument containing revocation configuration. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] type: Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        :param pulumi.Input[str] usage_mode: Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateAuthorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage AWS Certificate Manager Private Certificate Authorities (ACM PCA Certificate Authorities).

        > **NOTE:** Creating this resource will leave the certificate authority in a `PENDING_CERTIFICATE` status, which means it cannot yet issue certificates. To complete this setup, you must fully sign the certificate authority CSR available in the `certificate_signing_request` attribute. The `acmpca.CertificateAuthorityCertificate` resource can be used for this purpose.

        ## Example Usage

        ### Basic

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.acmpca.CertificateAuthority("example",
            certificate_authority_configuration=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs(
                key_algorithm="RSA_4096",
                signing_algorithm="SHA512WITHRSA",
                subject=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
                    common_name="example.com",
                ),
            ),
            permanent_deletion_time_in_days=7)
        ```
        <!--End PulumiCodeChooser -->

        ### Short-lived certificate

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.acmpca.CertificateAuthority("example",
            usage_mode="SHORT_LIVED_CERTIFICATE",
            certificate_authority_configuration=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs(
                key_algorithm="RSA_4096",
                signing_algorithm="SHA512WITHRSA",
                subject=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
                    common_name="example.com",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Enable Certificate Revocation List

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketV2("example",
            bucket="example",
            force_destroy=True)
        acmpca_bucket_access = aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=[
                "s3:GetBucketAcl",
                "s3:GetBucketLocation",
                "s3:PutObject",
                "s3:PutObjectAcl",
            ],
            resources=[
                example.arn,
                example.arn.apply(lambda arn: f"{arn}/*"),
            ],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                identifiers=["acm-pca.amazonaws.com"],
                type="Service",
            )],
        )])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example.id,
            policy=acmpca_bucket_access.json)
        example_certificate_authority = aws.acmpca.CertificateAuthority("example",
            certificate_authority_configuration=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs(
                key_algorithm="RSA_4096",
                signing_algorithm="SHA512WITHRSA",
                subject=aws.acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
                    common_name="example.com",
                ),
            ),
            revocation_configuration=aws.acmpca.CertificateAuthorityRevocationConfigurationArgs(
                crl_configuration=aws.acmpca.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs(
                    custom_cname="crl.example.com",
                    enabled=True,
                    expiration_in_days=7,
                    s3_bucket_name=example.id,
                    s3_object_acl="BUCKET_OWNER_FULL_CONTROL",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_acmpca_certificate_authority` using the certificate authority ARN. For example:

        ```sh
        $ pulumi import aws:acmpca/certificateAuthority:CertificateAuthority example arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012
        ```

        :param str resource_name: The name of the resource.
        :param CertificateAuthorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateAuthorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigurationArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 permanent_deletion_time_in_days: Optional[pulumi.Input[int]] = None,
                 revocation_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 usage_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateAuthorityArgs.__new__(CertificateAuthorityArgs)

            if certificate_authority_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_configuration'")
            __props__.__dict__["certificate_authority_configuration"] = certificate_authority_configuration
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["key_storage_security_standard"] = key_storage_security_standard
            __props__.__dict__["permanent_deletion_time_in_days"] = permanent_deletion_time_in_days
            __props__.__dict__["revocation_configuration"] = revocation_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["usage_mode"] = usage_mode
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["certificate_chain"] = None
            __props__.__dict__["certificate_signing_request"] = None
            __props__.__dict__["not_after"] = None
            __props__.__dict__["not_before"] = None
            __props__.__dict__["serial"] = None
            __props__.__dict__["tags_all"] = None
        super(CertificateAuthority, __self__).__init__(
            'aws:acmpca/certificateAuthority:CertificateAuthority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            certificate_authority_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigurationArgs']]] = None,
            certificate_chain: Optional[pulumi.Input[str]] = None,
            certificate_signing_request: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            key_storage_security_standard: Optional[pulumi.Input[str]] = None,
            not_after: Optional[pulumi.Input[str]] = None,
            not_before: Optional[pulumi.Input[str]] = None,
            permanent_deletion_time_in_days: Optional[pulumi.Input[int]] = None,
            revocation_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            usage_mode: Optional[pulumi.Input[str]] = None) -> 'CertificateAuthority':
        """
        Get an existing CertificateAuthority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the certificate authority.
        :param pulumi.Input[str] certificate: Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigurationArgs']] certificate_authority_configuration: Nested argument containing algorithms and certificate subject information. Defined below.
        :param pulumi.Input[str] certificate_chain: Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[str] certificate_signing_request: The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
        :param pulumi.Input[bool] enabled: Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        :param pulumi.Input[str] key_storage_security_standard: Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        :param pulumi.Input[str] not_after: Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[str] not_before: Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[int] permanent_deletion_time_in_days: Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']] revocation_configuration: Nested argument containing revocation configuration. Defined below.
        :param pulumi.Input[str] serial: Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        :param pulumi.Input[str] usage_mode: Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateAuthorityState.__new__(_CertificateAuthorityState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_authority_configuration"] = certificate_authority_configuration
        __props__.__dict__["certificate_chain"] = certificate_chain
        __props__.__dict__["certificate_signing_request"] = certificate_signing_request
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["key_storage_security_standard"] = key_storage_security_standard
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["not_before"] = not_before
        __props__.__dict__["permanent_deletion_time_in_days"] = permanent_deletion_time_in_days
        __props__.__dict__["revocation_configuration"] = revocation_configuration
        __props__.__dict__["serial"] = serial
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["usage_mode"] = usage_mode
        return CertificateAuthority(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the certificate authority.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateAuthorityConfiguration")
    def certificate_authority_configuration(self) -> pulumi.Output['outputs.CertificateAuthorityCertificateAuthorityConfiguration']:
        """
        Nested argument containing algorithms and certificate subject information. Defined below.
        """
        return pulumi.get(self, "certificate_authority_configuration")

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[str]:
        """
        Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "certificate_chain")

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> pulumi.Output[str]:
        """
        The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
        """
        return pulumi.get(self, "certificate_signing_request")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyStorageSecurityStandard")
    def key_storage_security_standard(self) -> pulumi.Output[str]:
        """
        Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
        """
        return pulumi.get(self, "key_storage_security_standard")

    @property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[str]:
        """
        Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "not_after")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> pulumi.Output[str]:
        """
        Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter(name="permanentDeletionTimeInDays")
    def permanent_deletion_time_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        """
        return pulumi.get(self, "permanent_deletion_time_in_days")

    @property
    @pulumi.getter(name="revocationConfiguration")
    def revocation_configuration(self) -> pulumi.Output[Optional['outputs.CertificateAuthorityRevocationConfiguration']]:
        """
        Nested argument containing revocation configuration. Defined below.
        """
        return pulumi.get(self, "revocation_configuration")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usageMode")
    def usage_mode(self) -> pulumi.Output[str]:
        """
        Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
        """
        return pulumi.get(self, "usage_mode")

