# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScraperArgs', 'Scraper']

@pulumi.input_type
class ScraperArgs:
    def __init__(__self__, *,
                 scrape_configuration: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input['ScraperDestinationArgs']] = None,
                 source: Optional[pulumi.Input['ScraperSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['ScraperTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Scraper resource.
        :param pulumi.Input[str] scrape_configuration: The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        :param pulumi.Input[str] alias: a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        :param pulumi.Input['ScraperDestinationArgs'] destination: Configuration block for the managed scraper to send metrics to. See `destination`.
        :param pulumi.Input['ScraperSourceArgs'] source: Configuration block to specify where the managed scraper will collect metrics from. See `source`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "scrape_configuration", scrape_configuration)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="scrapeConfiguration")
    def scrape_configuration(self) -> pulumi.Input[str]:
        """
        The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        """
        return pulumi.get(self, "scrape_configuration")

    @scrape_configuration.setter
    def scrape_configuration(self, value: pulumi.Input[str]):
        pulumi.set(self, "scrape_configuration", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['ScraperDestinationArgs']]:
        """
        Configuration block for the managed scraper to send metrics to. See `destination`.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['ScraperDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ScraperSourceArgs']]:
        """
        Configuration block to specify where the managed scraper will collect metrics from. See `source`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ScraperSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ScraperTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ScraperTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ScraperState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input['ScraperDestinationArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 scrape_configuration: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['ScraperSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['ScraperTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Scraper resources.
        :param pulumi.Input[str] alias: a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the new scraper.
        :param pulumi.Input['ScraperDestinationArgs'] destination: Configuration block for the managed scraper to send metrics to. See `destination`.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover, collect, and produce metrics
        :param pulumi.Input[str] scrape_configuration: The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        :param pulumi.Input['ScraperSourceArgs'] source: Configuration block to specify where the managed scraper will collect metrics from. See `source`.
               
               The following arguments are optional:
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if scrape_configuration is not None:
            pulumi.set(__self__, "scrape_configuration", scrape_configuration)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the new scraper.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['ScraperDestinationArgs']]:
        """
        Configuration block for the managed scraper to send metrics to. See `destination`.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['ScraperDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover, collect, and produce metrics
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="scrapeConfiguration")
    def scrape_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        """
        return pulumi.get(self, "scrape_configuration")

    @scrape_configuration.setter
    def scrape_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scrape_configuration", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ScraperSourceArgs']]:
        """
        Configuration block to specify where the managed scraper will collect metrics from. See `source`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ScraperSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ScraperTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ScraperTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class Scraper(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['ScraperDestinationArgs']]] = None,
                 scrape_configuration: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['ScraperSourceArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[pulumi.InputType['ScraperTimeoutsArgs']]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import the Managed Scraper using its identifier.
        For example:

        ```sh
        $ pulumi import aws:amp/scraper:Scraper example s-0123abc-0000-0123-a000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        :param pulumi.Input[pulumi.InputType['ScraperDestinationArgs']] destination: Configuration block for the managed scraper to send metrics to. See `destination`.
        :param pulumi.Input[str] scrape_configuration: The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        :param pulumi.Input[pulumi.InputType['ScraperSourceArgs']] source: Configuration block to specify where the managed scraper will collect metrics from. See `source`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScraperArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import the Managed Scraper using its identifier.
        For example:

        ```sh
        $ pulumi import aws:amp/scraper:Scraper example s-0123abc-0000-0123-a000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ScraperArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScraperArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['ScraperDestinationArgs']]] = None,
                 scrape_configuration: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['ScraperSourceArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[pulumi.InputType['ScraperTimeoutsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScraperArgs.__new__(ScraperArgs)

            __props__.__dict__["alias"] = alias
            __props__.__dict__["destination"] = destination
            if scrape_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'scrape_configuration'")
            __props__.__dict__["scrape_configuration"] = scrape_configuration
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["role_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Scraper, __self__).__init__(
            'aws:amp/scraper:Scraper',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[pulumi.InputType['ScraperDestinationArgs']]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            scrape_configuration: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[pulumi.InputType['ScraperSourceArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[pulumi.InputType['ScraperTimeoutsArgs']]] = None) -> 'Scraper':
        """
        Get an existing Scraper resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the new scraper.
        :param pulumi.Input[pulumi.InputType['ScraperDestinationArgs']] destination: Configuration block for the managed scraper to send metrics to. See `destination`.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover, collect, and produce metrics
        :param pulumi.Input[str] scrape_configuration: The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        :param pulumi.Input[pulumi.InputType['ScraperSourceArgs']] source: Configuration block to specify where the managed scraper will collect metrics from. See `source`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScraperState.__new__(_ScraperState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["arn"] = arn
        __props__.__dict__["destination"] = destination
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["scrape_configuration"] = scrape_configuration
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return Scraper(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[str]]:
        """
        a name to associate with the managed scraper. This is for your use, and does not need to be unique.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the new scraper.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional['outputs.ScraperDestination']]:
        """
        Configuration block for the managed scraper to send metrics to. See `destination`.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover, collect, and produce metrics
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="scrapeConfiguration")
    def scrape_configuration(self) -> pulumi.Output[str]:
        """
        The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
        """
        return pulumi.get(self, "scrape_configuration")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional['outputs.ScraperSource']]:
        """
        Configuration block to specify where the managed scraper will collect metrics from. See `source`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ScraperTimeouts']]:
        return pulumi.get(self, "timeouts")

