# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BranchArgs', 'Branch']

@pulumi.input_type
class BranchArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 branch_name: pulumi.Input[str],
                 backend_environment_arn: Optional[pulumi.Input[str]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_notification: Optional[pulumi.Input[bool]] = None,
                 enable_performance_mode: Optional[pulumi.Input[bool]] = None,
                 enable_pull_request_preview: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 pull_request_environment_name: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Branch resource.
        :param pulumi.Input[str] app_id: Unique ID for an Amplify app.
        :param pulumi.Input[str] branch_name: Name for the branch.
        :param pulumi.Input[str] backend_environment_arn: ARN for a backend environment that is part of an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: Basic authorization credentials for the branch.
        :param pulumi.Input[str] description: Description for the branch.
        :param pulumi.Input[str] display_name: Display name for a branch. This is used as the default domain prefix.
        :param pulumi.Input[bool] enable_auto_build: Enables auto building for the branch.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for the branch.
        :param pulumi.Input[bool] enable_notification: Enables notifications for the branch.
        :param pulumi.Input[bool] enable_performance_mode: Enables performance mode for the branch.
        :param pulumi.Input[bool] enable_pull_request_preview: Enables pull request previews for this branch.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables for the branch.
        :param pulumi.Input[str] framework: Framework for the branch.
        :param pulumi.Input[str] pull_request_environment_name: Amplify environment name for the pull request.
        :param pulumi.Input[str] stage: Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] ttl: Content Time To Live (TTL) for the website in seconds.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "branch_name", branch_name)
        if backend_environment_arn is not None:
            pulumi.set(__self__, "backend_environment_arn", backend_environment_arn)
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_auto_build is not None:
            pulumi.set(__self__, "enable_auto_build", enable_auto_build)
        if enable_basic_auth is not None:
            pulumi.set(__self__, "enable_basic_auth", enable_basic_auth)
        if enable_notification is not None:
            pulumi.set(__self__, "enable_notification", enable_notification)
        if enable_performance_mode is not None:
            pulumi.set(__self__, "enable_performance_mode", enable_performance_mode)
        if enable_pull_request_preview is not None:
            pulumi.set(__self__, "enable_pull_request_preview", enable_pull_request_preview)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if pull_request_environment_name is not None:
            pulumi.set(__self__, "pull_request_environment_name", pull_request_environment_name)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        Unique ID for an Amplify app.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> pulumi.Input[str]:
        """
        Name for the branch.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="backendEnvironmentArn")
    def backend_environment_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for a backend environment that is part of an Amplify app.
        """
        return pulumi.get(self, "backend_environment_arn")

    @backend_environment_arn.setter
    def backend_environment_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_environment_arn", value)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        Basic authorization credentials for the branch.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @basic_auth_credentials.setter
    def basic_auth_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_credentials", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the branch.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for a branch. This is used as the default domain prefix.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableAutoBuild")
    def enable_auto_build(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables auto building for the branch.
        """
        return pulumi.get(self, "enable_auto_build")

    @enable_auto_build.setter
    def enable_auto_build(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_build", value)

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables basic authorization for the branch.
        """
        return pulumi.get(self, "enable_basic_auth")

    @enable_basic_auth.setter
    def enable_basic_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_basic_auth", value)

    @property
    @pulumi.getter(name="enableNotification")
    def enable_notification(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables notifications for the branch.
        """
        return pulumi.get(self, "enable_notification")

    @enable_notification.setter
    def enable_notification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_notification", value)

    @property
    @pulumi.getter(name="enablePerformanceMode")
    def enable_performance_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables performance mode for the branch.
        """
        return pulumi.get(self, "enable_performance_mode")

    @enable_performance_mode.setter
    def enable_performance_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_performance_mode", value)

    @property
    @pulumi.getter(name="enablePullRequestPreview")
    def enable_pull_request_preview(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables pull request previews for this branch.
        """
        return pulumi.get(self, "enable_pull_request_preview")

    @enable_pull_request_preview.setter
    def enable_pull_request_preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_pull_request_preview", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables for the branch.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def framework(self) -> Optional[pulumi.Input[str]]:
        """
        Framework for the branch.
        """
        return pulumi.get(self, "framework")

    @framework.setter
    def framework(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework", value)

    @property
    @pulumi.getter(name="pullRequestEnvironmentName")
    def pull_request_environment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Amplify environment name for the pull request.
        """
        return pulumi.get(self, "pull_request_environment_name")

    @pull_request_environment_name.setter
    def pull_request_environment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pull_request_environment_name", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Content Time To Live (TTL) for the website in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _BranchState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 associated_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend_environment_arn: Optional[pulumi.Input[str]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_branch: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_notification: Optional[pulumi.Input[bool]] = None,
                 enable_performance_mode: Optional[pulumi.Input[bool]] = None,
                 enable_pull_request_preview: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 pull_request_environment_name: Optional[pulumi.Input[str]] = None,
                 source_branch: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Branch resources.
        :param pulumi.Input[str] app_id: Unique ID for an Amplify app.
        :param pulumi.Input[str] arn: ARN for the branch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_resources: A list of custom resources that are linked to this branch.
        :param pulumi.Input[str] backend_environment_arn: ARN for a backend environment that is part of an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: Basic authorization credentials for the branch.
        :param pulumi.Input[str] branch_name: Name for the branch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_domains: Custom domains for the branch.
        :param pulumi.Input[str] description: Description for the branch.
        :param pulumi.Input[str] destination_branch: Destination branch if the branch is a pull request branch.
        :param pulumi.Input[str] display_name: Display name for a branch. This is used as the default domain prefix.
        :param pulumi.Input[bool] enable_auto_build: Enables auto building for the branch.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for the branch.
        :param pulumi.Input[bool] enable_notification: Enables notifications for the branch.
        :param pulumi.Input[bool] enable_performance_mode: Enables performance mode for the branch.
        :param pulumi.Input[bool] enable_pull_request_preview: Enables pull request previews for this branch.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables for the branch.
        :param pulumi.Input[str] framework: Framework for the branch.
        :param pulumi.Input[str] pull_request_environment_name: Amplify environment name for the pull request.
        :param pulumi.Input[str] source_branch: Source branch if the branch is a pull request branch.
        :param pulumi.Input[str] stage: Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] ttl: Content Time To Live (TTL) for the website in seconds.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if associated_resources is not None:
            pulumi.set(__self__, "associated_resources", associated_resources)
        if backend_environment_arn is not None:
            pulumi.set(__self__, "backend_environment_arn", backend_environment_arn)
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_branch is not None:
            pulumi.set(__self__, "destination_branch", destination_branch)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_auto_build is not None:
            pulumi.set(__self__, "enable_auto_build", enable_auto_build)
        if enable_basic_auth is not None:
            pulumi.set(__self__, "enable_basic_auth", enable_basic_auth)
        if enable_notification is not None:
            pulumi.set(__self__, "enable_notification", enable_notification)
        if enable_performance_mode is not None:
            pulumi.set(__self__, "enable_performance_mode", enable_performance_mode)
        if enable_pull_request_preview is not None:
            pulumi.set(__self__, "enable_pull_request_preview", enable_pull_request_preview)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if pull_request_environment_name is not None:
            pulumi.set(__self__, "pull_request_environment_name", pull_request_environment_name)
        if source_branch is not None:
            pulumi.set(__self__, "source_branch", source_branch)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ID for an Amplify app.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the branch.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="associatedResources")
    def associated_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of custom resources that are linked to this branch.
        """
        return pulumi.get(self, "associated_resources")

    @associated_resources.setter
    def associated_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "associated_resources", value)

    @property
    @pulumi.getter(name="backendEnvironmentArn")
    def backend_environment_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for a backend environment that is part of an Amplify app.
        """
        return pulumi.get(self, "backend_environment_arn")

    @backend_environment_arn.setter
    def backend_environment_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_environment_arn", value)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        Basic authorization credentials for the branch.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @basic_auth_credentials.setter
    def basic_auth_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_credentials", value)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the branch.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Custom domains for the branch.
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_domains", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the branch.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationBranch")
    def destination_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Destination branch if the branch is a pull request branch.
        """
        return pulumi.get(self, "destination_branch")

    @destination_branch.setter
    def destination_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_branch", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for a branch. This is used as the default domain prefix.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableAutoBuild")
    def enable_auto_build(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables auto building for the branch.
        """
        return pulumi.get(self, "enable_auto_build")

    @enable_auto_build.setter
    def enable_auto_build(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_build", value)

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables basic authorization for the branch.
        """
        return pulumi.get(self, "enable_basic_auth")

    @enable_basic_auth.setter
    def enable_basic_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_basic_auth", value)

    @property
    @pulumi.getter(name="enableNotification")
    def enable_notification(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables notifications for the branch.
        """
        return pulumi.get(self, "enable_notification")

    @enable_notification.setter
    def enable_notification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_notification", value)

    @property
    @pulumi.getter(name="enablePerformanceMode")
    def enable_performance_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables performance mode for the branch.
        """
        return pulumi.get(self, "enable_performance_mode")

    @enable_performance_mode.setter
    def enable_performance_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_performance_mode", value)

    @property
    @pulumi.getter(name="enablePullRequestPreview")
    def enable_pull_request_preview(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables pull request previews for this branch.
        """
        return pulumi.get(self, "enable_pull_request_preview")

    @enable_pull_request_preview.setter
    def enable_pull_request_preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_pull_request_preview", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables for the branch.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def framework(self) -> Optional[pulumi.Input[str]]:
        """
        Framework for the branch.
        """
        return pulumi.get(self, "framework")

    @framework.setter
    def framework(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework", value)

    @property
    @pulumi.getter(name="pullRequestEnvironmentName")
    def pull_request_environment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Amplify environment name for the pull request.
        """
        return pulumi.get(self, "pull_request_environment_name")

    @pull_request_environment_name.setter
    def pull_request_environment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pull_request_environment_name", value)

    @property
    @pulumi.getter(name="sourceBranch")
    def source_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Source branch if the branch is a pull request branch.
        """
        return pulumi.get(self, "source_branch")

    @source_branch.setter
    def source_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_branch", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Content Time To Live (TTL) for the website in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


class Branch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 backend_environment_arn: Optional[pulumi.Input[str]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_notification: Optional[pulumi.Input[bool]] = None,
                 enable_performance_mode: Optional[pulumi.Input[bool]] = None,
                 enable_pull_request_preview: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 pull_request_environment_name: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Amplify Branch resource.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example", name="app")
        master = aws.amplify.Branch("master",
            app_id=example.id,
            branch_name="master",
            framework="React",
            stage="PRODUCTION",
            environment_variables={
                "REACT_APP_API_SERVER": "https://api.example.com",
            })
        ```
        <!--End PulumiCodeChooser -->

        ### Basic Authentication

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.amplify.App("example", name="app")
        master = aws.amplify.Branch("master",
            app_id=example.id,
            branch_name="master",
            enable_basic_auth=True,
            basic_auth_credentials=std.base64encode(input="username:password").result)
        ```
        <!--End PulumiCodeChooser -->

        ### Notifications

        Amplify Console uses EventBridge (formerly known as CloudWatch Events) and SNS for email notifications.  To implement the same functionality, you need to set `enable_notification` in a `amplify.Branch` resource, as well as creating an EventBridge Rule, an SNS topic, and SNS subscriptions.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.amplify.App("example", name="app")
        master = aws.amplify.Branch("master",
            app_id=example.id,
            branch_name="master",
            enable_notification=True)
        # EventBridge Rule for Amplify notifications
        amplify_app_master_event_rule = aws.cloudwatch.EventRule("amplify_app_master",
            name=master.branch_name.apply(lambda branch_name: f"amplify-{app['id']}-{branch_name}-branch-notification"),
            description=master.branch_name.apply(lambda branch_name: f"AWS Amplify build notifications for :  App: {app['id']} Branch: {branch_name}"),
            event_pattern=pulumi.Output.json_dumps({
                "detail": {
                    "appId": [example.id],
                    "branchName": [master.branch_name],
                    "jobStatus": [
                        "SUCCEED",
                        "FAILED",
                        "STARTED",
                    ],
                },
                "detail-type": ["Amplify Deployment Status Change"],
                "source": ["aws.amplify"],
            }))
        # SNS Topic for Amplify notifications
        amplify_app_master_topic = aws.sns.Topic("amplify_app_master", name=master.branch_name.apply(lambda branch_name: f"amplify-{app['id']}_{branch_name}"))
        amplify_app_master_event_target = aws.cloudwatch.EventTarget("amplify_app_master",
            rule=amplify_app_master_event_rule.name,
            target_id=master.branch_name,
            arn=amplify_app_master_topic.arn,
            input_transformer=aws.cloudwatch.EventTargetInputTransformerArgs(
                input_paths={
                    "jobId": "$.detail.jobId",
                    "appId": "$.detail.appId",
                    "region": "$.region",
                    "branch": "$.detail.branchName",
                    "status": "$.detail.jobStatus",
                },
                input_template="\\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \\"",
            ))
        amplify_app_master = pulumi.Output.all(master.arn, amplify_app_master_topic.arn).apply(lambda masterArn, amplifyAppMasterTopicArn: aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            sid=f"Allow_Publish_Events {master_arn}",
            effect="Allow",
            actions=["SNS:Publish"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
            resources=[amplify_app_master_topic_arn],
        )]))
        amplify_app_master_topic_policy = aws.sns.TopicPolicy("amplify_app_master",
            arn=amplify_app_master_topic.arn,
            policy=amplify_app_master.json)
        this = aws.sns.TopicSubscription("this",
            topic=amplify_app_master_topic.arn,
            protocol="email",
            endpoint="user@acme.com")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Amplify branch using `app_id` and `branch_name`. For example:

        ```sh
        $ pulumi import aws:amplify/branch:Branch master d2ypk4k47z8u6/master
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: Unique ID for an Amplify app.
        :param pulumi.Input[str] backend_environment_arn: ARN for a backend environment that is part of an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: Basic authorization credentials for the branch.
        :param pulumi.Input[str] branch_name: Name for the branch.
        :param pulumi.Input[str] description: Description for the branch.
        :param pulumi.Input[str] display_name: Display name for a branch. This is used as the default domain prefix.
        :param pulumi.Input[bool] enable_auto_build: Enables auto building for the branch.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for the branch.
        :param pulumi.Input[bool] enable_notification: Enables notifications for the branch.
        :param pulumi.Input[bool] enable_performance_mode: Enables performance mode for the branch.
        :param pulumi.Input[bool] enable_pull_request_preview: Enables pull request previews for this branch.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables for the branch.
        :param pulumi.Input[str] framework: Framework for the branch.
        :param pulumi.Input[str] pull_request_environment_name: Amplify environment name for the pull request.
        :param pulumi.Input[str] stage: Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] ttl: Content Time To Live (TTL) for the website in seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BranchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amplify Branch resource.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example", name="app")
        master = aws.amplify.Branch("master",
            app_id=example.id,
            branch_name="master",
            framework="React",
            stage="PRODUCTION",
            environment_variables={
                "REACT_APP_API_SERVER": "https://api.example.com",
            })
        ```
        <!--End PulumiCodeChooser -->

        ### Basic Authentication

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.amplify.App("example", name="app")
        master = aws.amplify.Branch("master",
            app_id=example.id,
            branch_name="master",
            enable_basic_auth=True,
            basic_auth_credentials=std.base64encode(input="username:password").result)
        ```
        <!--End PulumiCodeChooser -->

        ### Notifications

        Amplify Console uses EventBridge (formerly known as CloudWatch Events) and SNS for email notifications.  To implement the same functionality, you need to set `enable_notification` in a `amplify.Branch` resource, as well as creating an EventBridge Rule, an SNS topic, and SNS subscriptions.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.amplify.App("example", name="app")
        master = aws.amplify.Branch("master",
            app_id=example.id,
            branch_name="master",
            enable_notification=True)
        # EventBridge Rule for Amplify notifications
        amplify_app_master_event_rule = aws.cloudwatch.EventRule("amplify_app_master",
            name=master.branch_name.apply(lambda branch_name: f"amplify-{app['id']}-{branch_name}-branch-notification"),
            description=master.branch_name.apply(lambda branch_name: f"AWS Amplify build notifications for :  App: {app['id']} Branch: {branch_name}"),
            event_pattern=pulumi.Output.json_dumps({
                "detail": {
                    "appId": [example.id],
                    "branchName": [master.branch_name],
                    "jobStatus": [
                        "SUCCEED",
                        "FAILED",
                        "STARTED",
                    ],
                },
                "detail-type": ["Amplify Deployment Status Change"],
                "source": ["aws.amplify"],
            }))
        # SNS Topic for Amplify notifications
        amplify_app_master_topic = aws.sns.Topic("amplify_app_master", name=master.branch_name.apply(lambda branch_name: f"amplify-{app['id']}_{branch_name}"))
        amplify_app_master_event_target = aws.cloudwatch.EventTarget("amplify_app_master",
            rule=amplify_app_master_event_rule.name,
            target_id=master.branch_name,
            arn=amplify_app_master_topic.arn,
            input_transformer=aws.cloudwatch.EventTargetInputTransformerArgs(
                input_paths={
                    "jobId": "$.detail.jobId",
                    "appId": "$.detail.appId",
                    "region": "$.region",
                    "branch": "$.detail.branchName",
                    "status": "$.detail.jobStatus",
                },
                input_template="\\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \\"",
            ))
        amplify_app_master = pulumi.Output.all(master.arn, amplify_app_master_topic.arn).apply(lambda masterArn, amplifyAppMasterTopicArn: aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            sid=f"Allow_Publish_Events {master_arn}",
            effect="Allow",
            actions=["SNS:Publish"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
            resources=[amplify_app_master_topic_arn],
        )]))
        amplify_app_master_topic_policy = aws.sns.TopicPolicy("amplify_app_master",
            arn=amplify_app_master_topic.arn,
            policy=amplify_app_master.json)
        this = aws.sns.TopicSubscription("this",
            topic=amplify_app_master_topic.arn,
            protocol="email",
            endpoint="user@acme.com")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Amplify branch using `app_id` and `branch_name`. For example:

        ```sh
        $ pulumi import aws:amplify/branch:Branch master d2ypk4k47z8u6/master
        ```

        :param str resource_name: The name of the resource.
        :param BranchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BranchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 backend_environment_arn: Optional[pulumi.Input[str]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_notification: Optional[pulumi.Input[bool]] = None,
                 enable_performance_mode: Optional[pulumi.Input[bool]] = None,
                 enable_pull_request_preview: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 pull_request_environment_name: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BranchArgs.__new__(BranchArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["backend_environment_arn"] = backend_environment_arn
            __props__.__dict__["basic_auth_credentials"] = None if basic_auth_credentials is None else pulumi.Output.secret(basic_auth_credentials)
            if branch_name is None and not opts.urn:
                raise TypeError("Missing required property 'branch_name'")
            __props__.__dict__["branch_name"] = branch_name
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_auto_build"] = enable_auto_build
            __props__.__dict__["enable_basic_auth"] = enable_basic_auth
            __props__.__dict__["enable_notification"] = enable_notification
            __props__.__dict__["enable_performance_mode"] = enable_performance_mode
            __props__.__dict__["enable_pull_request_preview"] = enable_pull_request_preview
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["framework"] = framework
            __props__.__dict__["pull_request_environment_name"] = pull_request_environment_name
            __props__.__dict__["stage"] = stage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["arn"] = None
            __props__.__dict__["associated_resources"] = None
            __props__.__dict__["custom_domains"] = None
            __props__.__dict__["destination_branch"] = None
            __props__.__dict__["source_branch"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["basicAuthCredentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Branch, __self__).__init__(
            'aws:amplify/branch:Branch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            associated_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backend_environment_arn: Optional[pulumi.Input[str]] = None,
            basic_auth_credentials: Optional[pulumi.Input[str]] = None,
            branch_name: Optional[pulumi.Input[str]] = None,
            custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_branch: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enable_auto_build: Optional[pulumi.Input[bool]] = None,
            enable_basic_auth: Optional[pulumi.Input[bool]] = None,
            enable_notification: Optional[pulumi.Input[bool]] = None,
            enable_performance_mode: Optional[pulumi.Input[bool]] = None,
            enable_pull_request_preview: Optional[pulumi.Input[bool]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            framework: Optional[pulumi.Input[str]] = None,
            pull_request_environment_name: Optional[pulumi.Input[str]] = None,
            source_branch: Optional[pulumi.Input[str]] = None,
            stage: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ttl: Optional[pulumi.Input[str]] = None) -> 'Branch':
        """
        Get an existing Branch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: Unique ID for an Amplify app.
        :param pulumi.Input[str] arn: ARN for the branch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_resources: A list of custom resources that are linked to this branch.
        :param pulumi.Input[str] backend_environment_arn: ARN for a backend environment that is part of an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: Basic authorization credentials for the branch.
        :param pulumi.Input[str] branch_name: Name for the branch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_domains: Custom domains for the branch.
        :param pulumi.Input[str] description: Description for the branch.
        :param pulumi.Input[str] destination_branch: Destination branch if the branch is a pull request branch.
        :param pulumi.Input[str] display_name: Display name for a branch. This is used as the default domain prefix.
        :param pulumi.Input[bool] enable_auto_build: Enables auto building for the branch.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for the branch.
        :param pulumi.Input[bool] enable_notification: Enables notifications for the branch.
        :param pulumi.Input[bool] enable_performance_mode: Enables performance mode for the branch.
        :param pulumi.Input[bool] enable_pull_request_preview: Enables pull request previews for this branch.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables for the branch.
        :param pulumi.Input[str] framework: Framework for the branch.
        :param pulumi.Input[str] pull_request_environment_name: Amplify environment name for the pull request.
        :param pulumi.Input[str] source_branch: Source branch if the branch is a pull request branch.
        :param pulumi.Input[str] stage: Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] ttl: Content Time To Live (TTL) for the website in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BranchState.__new__(_BranchState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["associated_resources"] = associated_resources
        __props__.__dict__["backend_environment_arn"] = backend_environment_arn
        __props__.__dict__["basic_auth_credentials"] = basic_auth_credentials
        __props__.__dict__["branch_name"] = branch_name
        __props__.__dict__["custom_domains"] = custom_domains
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_branch"] = destination_branch
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_auto_build"] = enable_auto_build
        __props__.__dict__["enable_basic_auth"] = enable_basic_auth
        __props__.__dict__["enable_notification"] = enable_notification
        __props__.__dict__["enable_performance_mode"] = enable_performance_mode
        __props__.__dict__["enable_pull_request_preview"] = enable_pull_request_preview
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["framework"] = framework
        __props__.__dict__["pull_request_environment_name"] = pull_request_environment_name
        __props__.__dict__["source_branch"] = source_branch
        __props__.__dict__["stage"] = stage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["ttl"] = ttl
        return Branch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        Unique ID for an Amplify app.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN for the branch.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associatedResources")
    def associated_resources(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of custom resources that are linked to this branch.
        """
        return pulumi.get(self, "associated_resources")

    @property
    @pulumi.getter(name="backendEnvironmentArn")
    def backend_environment_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN for a backend environment that is part of an Amplify app.
        """
        return pulumi.get(self, "backend_environment_arn")

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> pulumi.Output[Optional[str]]:
        """
        Basic authorization credentials for the branch.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> pulumi.Output[str]:
        """
        Name for the branch.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        Custom domains for the branch.
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description for the branch.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationBranch")
    def destination_branch(self) -> pulumi.Output[str]:
        """
        Destination branch if the branch is a pull request branch.
        """
        return pulumi.get(self, "destination_branch")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name for a branch. This is used as the default domain prefix.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableAutoBuild")
    def enable_auto_build(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables auto building for the branch.
        """
        return pulumi.get(self, "enable_auto_build")

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables basic authorization for the branch.
        """
        return pulumi.get(self, "enable_basic_auth")

    @property
    @pulumi.getter(name="enableNotification")
    def enable_notification(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables notifications for the branch.
        """
        return pulumi.get(self, "enable_notification")

    @property
    @pulumi.getter(name="enablePerformanceMode")
    def enable_performance_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables performance mode for the branch.
        """
        return pulumi.get(self, "enable_performance_mode")

    @property
    @pulumi.getter(name="enablePullRequestPreview")
    def enable_pull_request_preview(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables pull request previews for this branch.
        """
        return pulumi.get(self, "enable_pull_request_preview")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Environment variables for the branch.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def framework(self) -> pulumi.Output[Optional[str]]:
        """
        Framework for the branch.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter(name="pullRequestEnvironmentName")
    def pull_request_environment_name(self) -> pulumi.Output[Optional[str]]:
        """
        Amplify environment name for the pull request.
        """
        return pulumi.get(self, "pull_request_environment_name")

    @property
    @pulumi.getter(name="sourceBranch")
    def source_branch(self) -> pulumi.Output[str]:
        """
        Source branch if the branch is a pull request branch.
        """
        return pulumi.get(self, "source_branch")

    @property
    @pulumi.getter
    def stage(self) -> pulumi.Output[Optional[str]]:
        """
        Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Content Time To Live (TTL) for the website in seconds.
        """
        return pulumi.get(self, "ttl")

