# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainNameArgs', 'DomainName']

@pulumi.input_type
class DomainNameArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 certificate_private_key: Optional[pulumi.Input[str]] = None,
                 endpoint_configuration: Optional[pulumi.Input['DomainNameEndpointConfigurationArgs']] = None,
                 mutual_tls_authentication: Optional[pulumi.Input['DomainNameMutualTlsAuthenticationArgs']] = None,
                 ownership_verification_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_name: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DomainName resource.
        :param pulumi.Input[str] domain_name: Fully-qualified domain name to register.
        :param pulumi.Input[str] certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_body: Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_chain: Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_name: Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        :param pulumi.Input[str] certificate_private_key: Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input['DomainNameEndpointConfigurationArgs'] endpoint_configuration: Configuration block defining API endpoint information including type. See below.
        :param pulumi.Input['DomainNameMutualTlsAuthenticationArgs'] mutual_tls_authentication: Mutual TLS authentication configuration for the domain name. See below.
        :param pulumi.Input[str] ownership_verification_certificate_arn: ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        :param pulumi.Input[str] regional_certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
               
               When uploading a certificate, the following arguments are supported:
        :param pulumi.Input[str] regional_certificate_name: User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        :param pulumi.Input[str] security_policy: Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               When referencing an AWS-managed certificate, the following arguments are supported:
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if certificate_private_key is not None:
            pulumi.set(__self__, "certificate_private_key", certificate_private_key)
        if endpoint_configuration is not None:
            pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        if mutual_tls_authentication is not None:
            pulumi.set(__self__, "mutual_tls_authentication", mutual_tls_authentication)
        if ownership_verification_certificate_arn is not None:
            pulumi.set(__self__, "ownership_verification_certificate_arn", ownership_verification_certificate_arn)
        if regional_certificate_arn is not None:
            pulumi.set(__self__, "regional_certificate_arn", regional_certificate_arn)
        if regional_certificate_name is not None:
            pulumi.set(__self__, "regional_certificate_name", regional_certificate_name)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Fully-qualified domain name to register.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="certificatePrivateKey")
    def certificate_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_private_key")

    @certificate_private_key.setter
    def certificate_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_private_key", value)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> Optional[pulumi.Input['DomainNameEndpointConfigurationArgs']]:
        """
        Configuration block defining API endpoint information including type. See below.
        """
        return pulumi.get(self, "endpoint_configuration")

    @endpoint_configuration.setter
    def endpoint_configuration(self, value: Optional[pulumi.Input['DomainNameEndpointConfigurationArgs']]):
        pulumi.set(self, "endpoint_configuration", value)

    @property
    @pulumi.getter(name="mutualTlsAuthentication")
    def mutual_tls_authentication(self) -> Optional[pulumi.Input['DomainNameMutualTlsAuthenticationArgs']]:
        """
        Mutual TLS authentication configuration for the domain name. See below.
        """
        return pulumi.get(self, "mutual_tls_authentication")

    @mutual_tls_authentication.setter
    def mutual_tls_authentication(self, value: Optional[pulumi.Input['DomainNameMutualTlsAuthenticationArgs']]):
        pulumi.set(self, "mutual_tls_authentication", value)

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @ownership_verification_certificate_arn.setter
    def ownership_verification_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_verification_certificate_arn", value)

    @property
    @pulumi.getter(name="regionalCertificateArn")
    def regional_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.

        When uploading a certificate, the following arguments are supported:
        """
        return pulumi.get(self, "regional_certificate_arn")

    @regional_certificate_arn.setter
    def regional_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regional_certificate_arn", value)

    @property
    @pulumi.getter(name="regionalCertificateName")
    def regional_certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        """
        return pulumi.get(self, "regional_certificate_name")

    @regional_certificate_name.setter
    def regional_certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regional_certificate_name", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        When referencing an AWS-managed certificate, the following arguments are supported:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainNameState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 certificate_private_key: Optional[pulumi.Input[str]] = None,
                 certificate_upload_date: Optional[pulumi.Input[str]] = None,
                 cloudfront_domain_name: Optional[pulumi.Input[str]] = None,
                 cloudfront_zone_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoint_configuration: Optional[pulumi.Input['DomainNameEndpointConfigurationArgs']] = None,
                 mutual_tls_authentication: Optional[pulumi.Input['DomainNameMutualTlsAuthenticationArgs']] = None,
                 ownership_verification_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_name: Optional[pulumi.Input[str]] = None,
                 regional_domain_name: Optional[pulumi.Input[str]] = None,
                 regional_zone_id: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering DomainName resources.
        :param pulumi.Input[str] arn: ARN of domain name.
        :param pulumi.Input[str] certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_body: Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_chain: Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_name: Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        :param pulumi.Input[str] certificate_private_key: Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_upload_date: Upload date associated with the domain certificate.
        :param pulumi.Input[str] cloudfront_domain_name: Hostname created by Cloudfront to represent the distribution that implements this domain name mapping.
        :param pulumi.Input[str] cloudfront_zone_id: For convenience, the hosted zone ID (`Z2FDTNDATAQYW2`) that can be used to create a Route53 alias record for the distribution.
        :param pulumi.Input[str] domain_name: Fully-qualified domain name to register.
        :param pulumi.Input['DomainNameEndpointConfigurationArgs'] endpoint_configuration: Configuration block defining API endpoint information including type. See below.
        :param pulumi.Input['DomainNameMutualTlsAuthenticationArgs'] mutual_tls_authentication: Mutual TLS authentication configuration for the domain name. See below.
        :param pulumi.Input[str] ownership_verification_certificate_arn: ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        :param pulumi.Input[str] regional_certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
               
               When uploading a certificate, the following arguments are supported:
        :param pulumi.Input[str] regional_certificate_name: User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        :param pulumi.Input[str] regional_domain_name: Hostname for the custom domain's regional endpoint.
        :param pulumi.Input[str] regional_zone_id: Hosted zone ID that can be used to create a Route53 alias record for the regional endpoint.
        :param pulumi.Input[str] security_policy: Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               When referencing an AWS-managed certificate, the following arguments are supported:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if certificate_private_key is not None:
            pulumi.set(__self__, "certificate_private_key", certificate_private_key)
        if certificate_upload_date is not None:
            pulumi.set(__self__, "certificate_upload_date", certificate_upload_date)
        if cloudfront_domain_name is not None:
            pulumi.set(__self__, "cloudfront_domain_name", cloudfront_domain_name)
        if cloudfront_zone_id is not None:
            pulumi.set(__self__, "cloudfront_zone_id", cloudfront_zone_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if endpoint_configuration is not None:
            pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        if mutual_tls_authentication is not None:
            pulumi.set(__self__, "mutual_tls_authentication", mutual_tls_authentication)
        if ownership_verification_certificate_arn is not None:
            pulumi.set(__self__, "ownership_verification_certificate_arn", ownership_verification_certificate_arn)
        if regional_certificate_arn is not None:
            pulumi.set(__self__, "regional_certificate_arn", regional_certificate_arn)
        if regional_certificate_name is not None:
            pulumi.set(__self__, "regional_certificate_name", regional_certificate_name)
        if regional_domain_name is not None:
            pulumi.set(__self__, "regional_domain_name", regional_domain_name)
        if regional_zone_id is not None:
            pulumi.set(__self__, "regional_zone_id", regional_zone_id)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of domain name.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="certificatePrivateKey")
    def certificate_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_private_key")

    @certificate_private_key.setter
    def certificate_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_private_key", value)

    @property
    @pulumi.getter(name="certificateUploadDate")
    def certificate_upload_date(self) -> Optional[pulumi.Input[str]]:
        """
        Upload date associated with the domain certificate.
        """
        return pulumi.get(self, "certificate_upload_date")

    @certificate_upload_date.setter
    def certificate_upload_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_upload_date", value)

    @property
    @pulumi.getter(name="cloudfrontDomainName")
    def cloudfront_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname created by Cloudfront to represent the distribution that implements this domain name mapping.
        """
        return pulumi.get(self, "cloudfront_domain_name")

    @cloudfront_domain_name.setter
    def cloudfront_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudfront_domain_name", value)

    @property
    @pulumi.getter(name="cloudfrontZoneId")
    def cloudfront_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        For convenience, the hosted zone ID (`Z2FDTNDATAQYW2`) that can be used to create a Route53 alias record for the distribution.
        """
        return pulumi.get(self, "cloudfront_zone_id")

    @cloudfront_zone_id.setter
    def cloudfront_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudfront_zone_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Fully-qualified domain name to register.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> Optional[pulumi.Input['DomainNameEndpointConfigurationArgs']]:
        """
        Configuration block defining API endpoint information including type. See below.
        """
        return pulumi.get(self, "endpoint_configuration")

    @endpoint_configuration.setter
    def endpoint_configuration(self, value: Optional[pulumi.Input['DomainNameEndpointConfigurationArgs']]):
        pulumi.set(self, "endpoint_configuration", value)

    @property
    @pulumi.getter(name="mutualTlsAuthentication")
    def mutual_tls_authentication(self) -> Optional[pulumi.Input['DomainNameMutualTlsAuthenticationArgs']]:
        """
        Mutual TLS authentication configuration for the domain name. See below.
        """
        return pulumi.get(self, "mutual_tls_authentication")

    @mutual_tls_authentication.setter
    def mutual_tls_authentication(self, value: Optional[pulumi.Input['DomainNameMutualTlsAuthenticationArgs']]):
        pulumi.set(self, "mutual_tls_authentication", value)

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @ownership_verification_certificate_arn.setter
    def ownership_verification_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_verification_certificate_arn", value)

    @property
    @pulumi.getter(name="regionalCertificateArn")
    def regional_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.

        When uploading a certificate, the following arguments are supported:
        """
        return pulumi.get(self, "regional_certificate_arn")

    @regional_certificate_arn.setter
    def regional_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regional_certificate_arn", value)

    @property
    @pulumi.getter(name="regionalCertificateName")
    def regional_certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        """
        return pulumi.get(self, "regional_certificate_name")

    @regional_certificate_name.setter
    def regional_certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regional_certificate_name", value)

    @property
    @pulumi.getter(name="regionalDomainName")
    def regional_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname for the custom domain's regional endpoint.
        """
        return pulumi.get(self, "regional_domain_name")

    @regional_domain_name.setter
    def regional_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regional_domain_name", value)

    @property
    @pulumi.getter(name="regionalZoneId")
    def regional_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Hosted zone ID that can be used to create a Route53 alias record for the regional endpoint.
        """
        return pulumi.get(self, "regional_zone_id")

    @regional_zone_id.setter
    def regional_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regional_zone_id", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        When referencing an AWS-managed certificate, the following arguments are supported:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class DomainName(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 certificate_private_key: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoint_configuration: Optional[pulumi.Input[pulumi.InputType['DomainNameEndpointConfigurationArgs']]] = None,
                 mutual_tls_authentication: Optional[pulumi.Input[pulumi.InputType['DomainNameMutualTlsAuthenticationArgs']]] = None,
                 ownership_verification_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_name: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Registers a custom domain name for use with AWS API Gateway. Additional information about this functionality
        can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).

        This resource just establishes ownership of and the TLS settings for
        a particular domain name. An API can be attached to a particular path
        under the registered domain name using
        the `apigateway.BasePathMapping` resource.

        API Gateway domains can be defined as either 'edge-optimized' or 'regional'.  In an edge-optimized configuration,
        API Gateway internally creates and manages a CloudFront distribution to route requests on the given hostname. In
        addition to this resource it's necessary to create a DNS record corresponding to the given domain name which is an alias
        (either Route53 alias or traditional CNAME) to the Cloudfront domain name exported in the `cloudfront_domain_name`
        attribute.

        In a regional configuration, API Gateway does not create a CloudFront distribution to route requests to the API, though
        a distribution can be created if needed. In either case, it is necessary to create a DNS record corresponding to the
        given domain name which is an alias (either Route53 alias or traditional CNAME) to the regional domain name exported in
        the `regional_domain_name` attribute.

        > **Note:** API Gateway requires the use of AWS Certificate Manager (ACM) certificates instead of Identity and Access Management (IAM) certificates in regions that support ACM. Regions that support ACM can be found in the [Regions and Endpoints Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#acm_region). To import an existing private key and certificate into ACM or request an ACM certificate, see the `acm.Certificate` resource.

        > **Note:** The `apigateway.DomainName` resource expects dependency on the `acm.CertificateValidation` as
        only verified certificates can be used. This can be made either explicitly by adding the
        `depends_on = [aws_acm_certificate_validation.cert]` attribute. Or implicitly by referring certificate ARN
        from the validation resource where it will be available after the resource creation:
        `regional_certificate_arn = aws_acm_certificate_validation.cert.certificate_arn`.

        ## Example Usage

        ### Edge Optimized (ACM Certificate)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigateway.DomainName("example",
            certificate_arn=example_aws_acm_certificate_validation["certificateArn"],
            domain_name="api.example.com")
        # Example DNS record using Route53.
        # Route53 is not specifically required; any DNS host can be used.
        example_record = aws.route53.Record("example",
            name=example.domain_name,
            type=aws.route53.RecordType.A,
            zone_id=example_aws_route53_zone["id"],
            aliases=[aws.route53.RecordAliasArgs(
                evaluate_target_health=True,
                name=example.cloudfront_domain_name,
                zone_id=example.cloudfront_zone_id,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### Regional (ACM Certificate)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigateway.DomainName("example",
            domain_name="api.example.com",
            regional_certificate_arn=example_aws_acm_certificate_validation["certificateArn"],
            endpoint_configuration=aws.apigateway.DomainNameEndpointConfigurationArgs(
                types="REGIONAL",
            ))
        # Example DNS record using Route53.
        # Route53 is not specifically required; any DNS host can be used.
        example_record = aws.route53.Record("example",
            name=example.domain_name,
            type=aws.route53.RecordType.A,
            zone_id=example_aws_route53_zone["id"],
            aliases=[aws.route53.RecordAliasArgs(
                evaluate_target_health=True,
                name=example.regional_domain_name,
                zone_id=example.regional_zone_id,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import API Gateway domain names using their `name`. For example:

        ```sh
        $ pulumi import aws:apigateway/domainName:DomainName example dev.example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_body: Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_chain: Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_name: Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        :param pulumi.Input[str] certificate_private_key: Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] domain_name: Fully-qualified domain name to register.
        :param pulumi.Input[pulumi.InputType['DomainNameEndpointConfigurationArgs']] endpoint_configuration: Configuration block defining API endpoint information including type. See below.
        :param pulumi.Input[pulumi.InputType['DomainNameMutualTlsAuthenticationArgs']] mutual_tls_authentication: Mutual TLS authentication configuration for the domain name. See below.
        :param pulumi.Input[str] ownership_verification_certificate_arn: ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        :param pulumi.Input[str] regional_certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
               
               When uploading a certificate, the following arguments are supported:
        :param pulumi.Input[str] regional_certificate_name: User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        :param pulumi.Input[str] security_policy: Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               When referencing an AWS-managed certificate, the following arguments are supported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainNameArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Registers a custom domain name for use with AWS API Gateway. Additional information about this functionality
        can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).

        This resource just establishes ownership of and the TLS settings for
        a particular domain name. An API can be attached to a particular path
        under the registered domain name using
        the `apigateway.BasePathMapping` resource.

        API Gateway domains can be defined as either 'edge-optimized' or 'regional'.  In an edge-optimized configuration,
        API Gateway internally creates and manages a CloudFront distribution to route requests on the given hostname. In
        addition to this resource it's necessary to create a DNS record corresponding to the given domain name which is an alias
        (either Route53 alias or traditional CNAME) to the Cloudfront domain name exported in the `cloudfront_domain_name`
        attribute.

        In a regional configuration, API Gateway does not create a CloudFront distribution to route requests to the API, though
        a distribution can be created if needed. In either case, it is necessary to create a DNS record corresponding to the
        given domain name which is an alias (either Route53 alias or traditional CNAME) to the regional domain name exported in
        the `regional_domain_name` attribute.

        > **Note:** API Gateway requires the use of AWS Certificate Manager (ACM) certificates instead of Identity and Access Management (IAM) certificates in regions that support ACM. Regions that support ACM can be found in the [Regions and Endpoints Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#acm_region). To import an existing private key and certificate into ACM or request an ACM certificate, see the `acm.Certificate` resource.

        > **Note:** The `apigateway.DomainName` resource expects dependency on the `acm.CertificateValidation` as
        only verified certificates can be used. This can be made either explicitly by adding the
        `depends_on = [aws_acm_certificate_validation.cert]` attribute. Or implicitly by referring certificate ARN
        from the validation resource where it will be available after the resource creation:
        `regional_certificate_arn = aws_acm_certificate_validation.cert.certificate_arn`.

        ## Example Usage

        ### Edge Optimized (ACM Certificate)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigateway.DomainName("example",
            certificate_arn=example_aws_acm_certificate_validation["certificateArn"],
            domain_name="api.example.com")
        # Example DNS record using Route53.
        # Route53 is not specifically required; any DNS host can be used.
        example_record = aws.route53.Record("example",
            name=example.domain_name,
            type=aws.route53.RecordType.A,
            zone_id=example_aws_route53_zone["id"],
            aliases=[aws.route53.RecordAliasArgs(
                evaluate_target_health=True,
                name=example.cloudfront_domain_name,
                zone_id=example.cloudfront_zone_id,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### Regional (ACM Certificate)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigateway.DomainName("example",
            domain_name="api.example.com",
            regional_certificate_arn=example_aws_acm_certificate_validation["certificateArn"],
            endpoint_configuration=aws.apigateway.DomainNameEndpointConfigurationArgs(
                types="REGIONAL",
            ))
        # Example DNS record using Route53.
        # Route53 is not specifically required; any DNS host can be used.
        example_record = aws.route53.Record("example",
            name=example.domain_name,
            type=aws.route53.RecordType.A,
            zone_id=example_aws_route53_zone["id"],
            aliases=[aws.route53.RecordAliasArgs(
                evaluate_target_health=True,
                name=example.regional_domain_name,
                zone_id=example.regional_zone_id,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import API Gateway domain names using their `name`. For example:

        ```sh
        $ pulumi import aws:apigateway/domainName:DomainName example dev.example.com
        ```

        :param str resource_name: The name of the resource.
        :param DomainNameArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainNameArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 certificate_private_key: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoint_configuration: Optional[pulumi.Input[pulumi.InputType['DomainNameEndpointConfigurationArgs']]] = None,
                 mutual_tls_authentication: Optional[pulumi.Input[pulumi.InputType['DomainNameMutualTlsAuthenticationArgs']]] = None,
                 ownership_verification_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_arn: Optional[pulumi.Input[str]] = None,
                 regional_certificate_name: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainNameArgs.__new__(DomainNameArgs)

            __props__.__dict__["certificate_arn"] = certificate_arn
            __props__.__dict__["certificate_body"] = certificate_body
            __props__.__dict__["certificate_chain"] = certificate_chain
            __props__.__dict__["certificate_name"] = certificate_name
            __props__.__dict__["certificate_private_key"] = None if certificate_private_key is None else pulumi.Output.secret(certificate_private_key)
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["endpoint_configuration"] = endpoint_configuration
            __props__.__dict__["mutual_tls_authentication"] = mutual_tls_authentication
            __props__.__dict__["ownership_verification_certificate_arn"] = ownership_verification_certificate_arn
            __props__.__dict__["regional_certificate_arn"] = regional_certificate_arn
            __props__.__dict__["regional_certificate_name"] = regional_certificate_name
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate_upload_date"] = None
            __props__.__dict__["cloudfront_domain_name"] = None
            __props__.__dict__["cloudfront_zone_id"] = None
            __props__.__dict__["regional_domain_name"] = None
            __props__.__dict__["regional_zone_id"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificatePrivateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DomainName, __self__).__init__(
            'aws:apigateway/domainName:DomainName',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            certificate_arn: Optional[pulumi.Input[str]] = None,
            certificate_body: Optional[pulumi.Input[str]] = None,
            certificate_chain: Optional[pulumi.Input[str]] = None,
            certificate_name: Optional[pulumi.Input[str]] = None,
            certificate_private_key: Optional[pulumi.Input[str]] = None,
            certificate_upload_date: Optional[pulumi.Input[str]] = None,
            cloudfront_domain_name: Optional[pulumi.Input[str]] = None,
            cloudfront_zone_id: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            endpoint_configuration: Optional[pulumi.Input[pulumi.InputType['DomainNameEndpointConfigurationArgs']]] = None,
            mutual_tls_authentication: Optional[pulumi.Input[pulumi.InputType['DomainNameMutualTlsAuthenticationArgs']]] = None,
            ownership_verification_certificate_arn: Optional[pulumi.Input[str]] = None,
            regional_certificate_arn: Optional[pulumi.Input[str]] = None,
            regional_certificate_name: Optional[pulumi.Input[str]] = None,
            regional_domain_name: Optional[pulumi.Input[str]] = None,
            regional_zone_id: Optional[pulumi.Input[str]] = None,
            security_policy: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'DomainName':
        """
        Get an existing DomainName resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of domain name.
        :param pulumi.Input[str] certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_body: Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_chain: Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_name: Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        :param pulumi.Input[str] certificate_private_key: Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        :param pulumi.Input[str] certificate_upload_date: Upload date associated with the domain certificate.
        :param pulumi.Input[str] cloudfront_domain_name: Hostname created by Cloudfront to represent the distribution that implements this domain name mapping.
        :param pulumi.Input[str] cloudfront_zone_id: For convenience, the hosted zone ID (`Z2FDTNDATAQYW2`) that can be used to create a Route53 alias record for the distribution.
        :param pulumi.Input[str] domain_name: Fully-qualified domain name to register.
        :param pulumi.Input[pulumi.InputType['DomainNameEndpointConfigurationArgs']] endpoint_configuration: Configuration block defining API endpoint information including type. See below.
        :param pulumi.Input[pulumi.InputType['DomainNameMutualTlsAuthenticationArgs']] mutual_tls_authentication: Mutual TLS authentication configuration for the domain name. See below.
        :param pulumi.Input[str] ownership_verification_certificate_arn: ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        :param pulumi.Input[str] regional_certificate_arn: ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
               
               When uploading a certificate, the following arguments are supported:
        :param pulumi.Input[str] regional_certificate_name: User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        :param pulumi.Input[str] regional_domain_name: Hostname for the custom domain's regional endpoint.
        :param pulumi.Input[str] regional_zone_id: Hosted zone ID that can be used to create a Route53 alias record for the regional endpoint.
        :param pulumi.Input[str] security_policy: Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               When referencing an AWS-managed certificate, the following arguments are supported:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainNameState.__new__(_DomainNameState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_arn"] = certificate_arn
        __props__.__dict__["certificate_body"] = certificate_body
        __props__.__dict__["certificate_chain"] = certificate_chain
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["certificate_private_key"] = certificate_private_key
        __props__.__dict__["certificate_upload_date"] = certificate_upload_date
        __props__.__dict__["cloudfront_domain_name"] = cloudfront_domain_name
        __props__.__dict__["cloudfront_zone_id"] = cloudfront_zone_id
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["endpoint_configuration"] = endpoint_configuration
        __props__.__dict__["mutual_tls_authentication"] = mutual_tls_authentication
        __props__.__dict__["ownership_verification_certificate_arn"] = ownership_verification_certificate_arn
        __props__.__dict__["regional_certificate_arn"] = regional_certificate_arn
        __props__.__dict__["regional_certificate_name"] = regional_certificate_name
        __props__.__dict__["regional_domain_name"] = regional_domain_name
        __props__.__dict__["regional_zone_id"] = regional_zone_id
        __props__.__dict__["security_policy"] = security_policy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return DomainName(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of domain name.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_body")

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_chain")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[Optional[str]]:
        """
        Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="certificatePrivateKey")
    def certificate_private_key(self) -> pulumi.Output[Optional[str]]:
        """
        Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
        """
        return pulumi.get(self, "certificate_private_key")

    @property
    @pulumi.getter(name="certificateUploadDate")
    def certificate_upload_date(self) -> pulumi.Output[str]:
        """
        Upload date associated with the domain certificate.
        """
        return pulumi.get(self, "certificate_upload_date")

    @property
    @pulumi.getter(name="cloudfrontDomainName")
    def cloudfront_domain_name(self) -> pulumi.Output[str]:
        """
        Hostname created by Cloudfront to represent the distribution that implements this domain name mapping.
        """
        return pulumi.get(self, "cloudfront_domain_name")

    @property
    @pulumi.getter(name="cloudfrontZoneId")
    def cloudfront_zone_id(self) -> pulumi.Output[str]:
        """
        For convenience, the hosted zone ID (`Z2FDTNDATAQYW2`) that can be used to create a Route53 alias record for the distribution.
        """
        return pulumi.get(self, "cloudfront_zone_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Fully-qualified domain name to register.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> pulumi.Output['outputs.DomainNameEndpointConfiguration']:
        """
        Configuration block defining API endpoint information including type. See below.
        """
        return pulumi.get(self, "endpoint_configuration")

    @property
    @pulumi.getter(name="mutualTlsAuthentication")
    def mutual_tls_authentication(self) -> pulumi.Output[Optional['outputs.DomainNameMutualTlsAuthentication']]:
        """
        Mutual TLS authentication configuration for the domain name. See below.
        """
        return pulumi.get(self, "mutual_tls_authentication")

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> pulumi.Output[str]:
        """
        ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @property
    @pulumi.getter(name="regionalCertificateArn")
    def regional_certificate_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.

        When uploading a certificate, the following arguments are supported:
        """
        return pulumi.get(self, "regional_certificate_arn")

    @property
    @pulumi.getter(name="regionalCertificateName")
    def regional_certificate_name(self) -> pulumi.Output[Optional[str]]:
        """
        User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
        """
        return pulumi.get(self, "regional_certificate_name")

    @property
    @pulumi.getter(name="regionalDomainName")
    def regional_domain_name(self) -> pulumi.Output[str]:
        """
        Hostname for the custom domain's regional endpoint.
        """
        return pulumi.get(self, "regional_domain_name")

    @property
    @pulumi.getter(name="regionalZoneId")
    def regional_zone_id(self) -> pulumi.Output[str]:
        """
        Hosted zone ID that can be used to create a Route53 alias record for the regional endpoint.
        """
        return pulumi.get(self, "regional_zone_id")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[str]:
        """
        Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
        """
        return pulumi.get(self, "security_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        When referencing an AWS-managed certificate, the following arguments are supported:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

