# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAuthorizersResult',
    'AwaitableGetAuthorizersResult',
    'get_authorizers',
    'get_authorizers_output',
]

@pulumi.output_type
class GetAuthorizersResult:
    """
    A collection of values returned by getAuthorizers.
    """
    def __init__(__self__, id=None, ids=None, rest_api_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if rest_api_id and not isinstance(rest_api_id, str):
            raise TypeError("Expected argument 'rest_api_id' to be a str")
        pulumi.set(__self__, "rest_api_id", rest_api_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        List of Authorizer identifiers.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> str:
        return pulumi.get(self, "rest_api_id")


class AwaitableGetAuthorizersResult(GetAuthorizersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizersResult(
            id=self.id,
            ids=self.ids,
            rest_api_id=self.rest_api_id)


def get_authorizers(rest_api_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizersResult:
    """
    Provides details about multiple API Gateway Authorizers.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_authorizers(rest_api_id=example_aws_api_gateway_rest_api["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str rest_api_id: ID of the associated REST API.
    """
    __args__ = dict()
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apigateway/getAuthorizers:getAuthorizers', __args__, opts=opts, typ=GetAuthorizersResult).value

    return AwaitableGetAuthorizersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        rest_api_id=pulumi.get(__ret__, 'rest_api_id'))


@_utilities.lift_output_func(get_authorizers)
def get_authorizers_output(rest_api_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthorizersResult]:
    """
    Provides details about multiple API Gateway Authorizers.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_authorizers(rest_api_id=example_aws_api_gateway_rest_api["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str rest_api_id: ID of the associated REST API.
    """
    ...
