# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEnvironmentsResult',
    'AwaitableGetEnvironmentsResult',
    'get_environments',
    'get_environments_output',
]

@pulumi.output_type
class GetEnvironmentsResult:
    """
    A collection of values returned by getEnvironments.
    """
    def __init__(__self__, application_id=None, environment_ids=None, id=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if environment_ids and not isinstance(environment_ids, list):
            raise TypeError("Expected argument 'environment_ids' to be a list")
        pulumi.set(__self__, "environment_ids", environment_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentIds")
    def environment_ids(self) -> Sequence[str]:
        """
        Set of Environment IDs associated with this AppConfig Application.
        """
        return pulumi.get(self, "environment_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetEnvironmentsResult(GetEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentsResult(
            application_id=self.application_id,
            environment_ids=self.environment_ids,
            id=self.id)


def get_environments(application_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentsResult:
    """
    Provides access to all Environments for an AppConfig Application. This will allow you to pass Environment IDs to another
    resource.

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.appconfig.get_environments(application_id="a1d3rpe")
    ```
    <!--End PulumiCodeChooser -->


    :param str application_id: ID of the AppConfig Application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:appconfig/getEnvironments:getEnvironments', __args__, opts=opts, typ=GetEnvironmentsResult).value

    return AwaitableGetEnvironmentsResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        environment_ids=pulumi.get(__ret__, 'environment_ids'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_environments)
def get_environments_output(application_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentsResult]:
    """
    Provides access to all Environments for an AppConfig Application. This will allow you to pass Environment IDs to another
    resource.

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.appconfig.get_environments(application_id="a1d3rpe")
    ```
    <!--End PulumiCodeChooser -->


    :param str application_id: ID of the AppConfig Application.
    """
    ...
