# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayRouteResult',
    'AwaitableGetGatewayRouteResult',
    'get_gateway_route',
    'get_gateway_route_output',
]

@pulumi.output_type
class GetGatewayRouteResult:
    """
    A collection of values returned by getGatewayRoute.
    """
    def __init__(__self__, arn=None, created_date=None, id=None, last_updated_date=None, mesh_name=None, mesh_owner=None, name=None, resource_owner=None, specs=None, tags=None, virtual_gateway_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if mesh_name and not isinstance(mesh_name, str):
            raise TypeError("Expected argument 'mesh_name' to be a str")
        pulumi.set(__self__, "mesh_name", mesh_name)
        if mesh_owner and not isinstance(mesh_owner, str):
            raise TypeError("Expected argument 'mesh_owner' to be a str")
        pulumi.set(__self__, "mesh_owner", mesh_owner)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_owner and not isinstance(resource_owner, str):
            raise TypeError("Expected argument 'resource_owner' to be a str")
        pulumi.set(__self__, "resource_owner", resource_owner)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_gateway_name and not isinstance(virtual_gateway_name, str):
            raise TypeError("Expected argument 'virtual_gateway_name' to be a str")
        pulumi.set(__self__, "virtual_gateway_name", virtual_gateway_name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the gateway route.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        Creation date of the gateway route.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        """
        Last update date of the gateway route.
        """
        return pulumi.get(self, "last_updated_date")

    @property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> str:
        return pulumi.get(self, "mesh_name")

    @property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> str:
        return pulumi.get(self, "mesh_owner")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> str:
        """
        Resource owner's AWS account ID.
        """
        return pulumi.get(self, "resource_owner")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetGatewayRouteSpecResult']:
        """
        Gateway route specification. See the `appmesh.GatewayRoute` resource for details.
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualGatewayName")
    def virtual_gateway_name(self) -> str:
        return pulumi.get(self, "virtual_gateway_name")


class AwaitableGetGatewayRouteResult(GetGatewayRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayRouteResult(
            arn=self.arn,
            created_date=self.created_date,
            id=self.id,
            last_updated_date=self.last_updated_date,
            mesh_name=self.mesh_name,
            mesh_owner=self.mesh_owner,
            name=self.name,
            resource_owner=self.resource_owner,
            specs=self.specs,
            tags=self.tags,
            virtual_gateway_name=self.virtual_gateway_name)


def get_gateway_route(mesh_name: Optional[str] = None,
                      mesh_owner: Optional[str] = None,
                      name: Optional[str] = None,
                      tags: Optional[Mapping[str, str]] = None,
                      virtual_gateway_name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayRouteResult:
    """
    The App Mesh Gateway Route data source allows details of an App Mesh Gateway Route to be retrieved by its name, mesh_name, virtual_gateway_name, and optionally the mesh_owner.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.appmesh.get_gateway_route(name="test-route",
        mesh_name="test-mesh",
        virtual_gateway_name="test-gateway")
    ```
    <!--End PulumiCodeChooser -->


    :param str mesh_name: Name of the service mesh in which the virtual gateway exists.
    :param str mesh_owner: AWS account ID of the service mesh's owner.
    :param str name: Name of the gateway route.
    :param Mapping[str, str] tags: Map of tags.
    :param str virtual_gateway_name: Name of the virtual gateway in which the route exists.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['meshOwner'] = mesh_owner
    __args__['name'] = name
    __args__['tags'] = tags
    __args__['virtualGatewayName'] = virtual_gateway_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:appmesh/getGatewayRoute:getGatewayRoute', __args__, opts=opts, typ=GetGatewayRouteResult).value

    return AwaitableGetGatewayRouteResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        mesh_name=pulumi.get(__ret__, 'mesh_name'),
        mesh_owner=pulumi.get(__ret__, 'mesh_owner'),
        name=pulumi.get(__ret__, 'name'),
        resource_owner=pulumi.get(__ret__, 'resource_owner'),
        specs=pulumi.get(__ret__, 'specs'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_gateway_name=pulumi.get(__ret__, 'virtual_gateway_name'))


@_utilities.lift_output_func(get_gateway_route)
def get_gateway_route_output(mesh_name: Optional[pulumi.Input[str]] = None,
                             mesh_owner: Optional[pulumi.Input[Optional[str]]] = None,
                             name: Optional[pulumi.Input[str]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                             virtual_gateway_name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayRouteResult]:
    """
    The App Mesh Gateway Route data source allows details of an App Mesh Gateway Route to be retrieved by its name, mesh_name, virtual_gateway_name, and optionally the mesh_owner.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.appmesh.get_gateway_route(name="test-route",
        mesh_name="test-mesh",
        virtual_gateway_name="test-gateway")
    ```
    <!--End PulumiCodeChooser -->


    :param str mesh_name: Name of the service mesh in which the virtual gateway exists.
    :param str mesh_owner: AWS account ID of the service mesh's owner.
    :param str name: Name of the gateway route.
    :param Mapping[str, str] tags: Map of tags.
    :param str virtual_gateway_name: Name of the virtual gateway in which the route exists.
    """
    ...
